/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.entries;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import org.xcsp.parser.entries.XDomains;
import org.xcsp.parser.entries.XVariables;

public class XValues {

    public static final class RealInterval {
        public final SimpleValue inf;
        public final SimpleValue sup;
        public final boolean infClosed;
        public final boolean supClosed;

        public static RealInterval parse(String s) {
            boolean infClosed = s.charAt(0) == '[';
            boolean supClosed = s.charAt(s.length() - 1) == '[';
            String[] t = s.split(",");
            SimpleValue inf = SimpleValue.parse(t[0].substring(1), true);
            SimpleValue sup = SimpleValue.parse(t[1].substring(0, t[1].length() - 1), true);
            return new RealInterval(inf, sup, infClosed, supClosed);
        }

        public static RealInterval[] parseSeq(String seq) {
            return (RealInterval[])Stream.of(seq.split("\\s+")).map(tok -> RealInterval.parse(tok)).toArray(RealInterval[]::new);
        }

        protected RealInterval(SimpleValue inf, SimpleValue sup, boolean infClosed, boolean supClosed) {
            this.inf = inf;
            this.sup = sup;
            this.infClosed = infClosed;
            this.supClosed = supClosed;
        }

        public String toString() {
            return (this.infClosed ? "[" : "]") + this.inf + "," + this.sup + (this.supClosed ? "[" : "]");
        }
    }

    public static final class Decimal
    implements SimpleValue {
        public final long integerPart;
        public final long decimalPart;

        public Decimal(long integerPart, long decimalPart) {
            this.integerPart = integerPart;
            this.decimalPart = decimalPart;
        }

        public String toString() {
            return this.integerPart + "." + this.decimalPart;
        }
    }

    public static final class Rational
    implements SimpleValue {
        public final long numerator;
        public final long denominator;

        public Rational(long num, long den) {
            this.numerator = num;
            this.denominator = den;
            assert (den != 0L) : "Pb with rational " + this;
        }

        public String toString() {
            return this.numerator + "/" + this.denominator;
        }
    }

    public static final class IntegerInterval
    implements IntegerEntity {
        public final long inf;
        public final long sup;
        private final long width;

        public IntegerInterval(long inf, long sup) {
            this.inf = inf;
            this.sup = sup;
            Utilities.control(inf <= sup, "Interval problem " + this);
            this.width = inf == Long.MIN_VALUE || sup == Long.MAX_VALUE || !Utilities.checkSafeArithmeticOperation(() -> Math.subtractExact(sup + 1L, inf)) ? -1L : sup + 1L - inf;
        }

        @Override
        public boolean isSingleton() {
            return this.inf == this.sup;
        }

        @Override
        public long smallest() {
            return this.inf;
        }

        @Override
        public long greatest() {
            return this.sup;
        }

        @Override
        public long width() {
            return this.width;
        }

        @Override
        public int compareContains(long l) {
            return this.sup < l ? -1 : (this.inf > l ? 1 : 0);
        }

        public String toString() {
            return this.inf + ".." + this.sup;
        }
    }

    public static final class IntegerValue
    implements IntegerEntity,
    SimpleValue {
        public final long v;

        public IntegerValue(long v) {
            this.v = v;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }

        @Override
        public long smallest() {
            return this.v;
        }

        @Override
        public long greatest() {
            return this.v;
        }

        @Override
        public long width() {
            return 1L;
        }

        @Override
        public int compareContains(long l) {
            return Long.compare(this.v, l);
        }

        public String toString() {
            return this.v + "";
        }
    }

    public static interface IntegerEntity
    extends Comparable<IntegerEntity> {
        public static IntegerEntity parse(String s) {
            String[] t = s.split("\\.\\.");
            return t.length == 1 ? new IntegerValue(Utilities.safeLong(t[0])) : new IntegerInterval(Utilities.safeLong(t[0], true), Utilities.safeLong(t[1], true));
        }

        public static IntegerEntity[] parseSeq(String seq) {
            return (IntegerEntity[])Stream.of(seq.split("\\s+")).map(tok -> IntegerEntity.parse(tok)).toArray(IntegerEntity[]::new);
        }

        public static long nValues(IntegerEntity[] pieces) {
            if (!1.$assertionsDisabled && !IntStream.range(0, pieces.length - 1).noneMatch(i -> pieces[i].greatest() >= pieces[i + 1].smallest())) {
                throw new AssertionError();
            }
            if (Stream.of(pieces).anyMatch(p -> p.width() == -1L)) {
                return -1L;
            }
            long cnt = 0L;
            try {
                for (IntegerEntity piece : pieces) {
                    cnt = Math.addExact(cnt, piece.width());
                }
            }
            catch (ArithmeticException e) {
                return -1L;
            }
            return cnt;
        }

        public static int[] toIntArray(IntegerEntity[] pieces, int limit) {
            long l = IntegerEntity.nValues(pieces);
            if (l == -1L || l > (long)limit) {
                return null;
            }
            int[] values = new int[(int)l];
            int i = 0;
            for (IntegerEntity piece : pieces) {
                if (piece instanceof IntegerValue) {
                    values[i++] = Utilities.safeLong2Int(((IntegerValue)piece).v, true);
                    continue;
                }
                int min = Utilities.safeLong2Int(((IntegerInterval)piece).inf, true);
                int max = Utilities.safeLong2Int(((IntegerInterval)piece).sup, true);
                int v = min;
                while (v <= max) {
                    values[i++] = v++;
                }
            }
            return values;
        }

        @Override
        default public int compareTo(IntegerEntity p) {
            long l2;
            long l1 = this instanceof IntegerValue ? ((IntegerValue)this).v : ((IntegerInterval)this).inf;
            long l = l2 = p instanceof IntegerValue ? ((IntegerValue)p).v : ((IntegerInterval)p).inf;
            return l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        }

        public boolean isSingleton();

        public long smallest();

        public long greatest();

        public long width();

        public int compareContains(long var1);

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }

    public static interface SimpleValue {
        public static SimpleValue parse(String s, boolean checkSpecialValues) {
            String[] t = s.split("/");
            if (t.length == 2) {
                return new Rational(Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
            }
            t = s.split("\\.");
            if (t.length == 2) {
                return new Decimal(Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
            }
            return new IntegerValue(Utilities.safeLong(s, checkSpecialValues));
        }

        public static SimpleValue parse(String s) {
            return SimpleValue.parse(s, false);
        }

        public static SimpleValue[] parseSeq(String seq) {
            return (SimpleValue[])Stream.of(seq.split("\\s+")).map(s -> SimpleValue.parse(s)).toArray(SimpleValue[]::new);
        }
    }

    public static final class TypePrimitive
    extends Enum<TypePrimitive> {
        public static final /* enum */ TypePrimitive BYTE = new TypePrimitive();
        public static final /* enum */ TypePrimitive SHORT = new TypePrimitive();
        public static final /* enum */ TypePrimitive INT = new TypePrimitive();
        public static final /* enum */ TypePrimitive LONG = new TypePrimitive();
        private static final /* synthetic */ TypePrimitive[] $VALUES;

        public static TypePrimitive[] values() {
            return (TypePrimitive[])$VALUES.clone();
        }

        public static TypePrimitive valueOf(String name) {
            return Enum.valueOf(TypePrimitive.class, name);
        }

        public static TypePrimitive whichPrimitiveFor(long inf, long sup) {
            if (-118L <= inf && sup <= 117L) {
                return BYTE;
            }
            if (-32758L <= inf && sup <= 32757L) {
                return SHORT;
            }
            if (-2147483638L <= inf && sup <= 0x7FFFFFF5L) {
                return INT;
            }
            return LONG;
        }

        public static TypePrimitive whichPrimitiveFor(long val) {
            return TypePrimitive.whichPrimitiveFor(val, val);
        }

        public static TypePrimitive whichPrimitiveFor(XVariables.XVar[] vars) {
            if (Stream.of(vars).anyMatch(x -> x.type != XVariables.TypeVar.integer)) {
                return null;
            }
            return TypePrimitive.values()[Stream.of(vars).mapToInt(x -> ((XDomains.XDomInteger)x.dom).whichPrimitive().ordinal()).max().orElse(LONG.ordinal())];
        }

        public static TypePrimitive whichPrimitiveFor(XVariables.XVar[][] varss) {
            if (TypePrimitive.whichPrimitiveFor(varss[0]) == null) {
                return null;
            }
            return TypePrimitive.values()[Stream.of(varss).mapToInt(t -> TypePrimitive.whichPrimitiveFor(t).ordinal()).max().orElse(LONG.ordinal())];
        }

        private boolean canRepresent(long val) {
            return this.ordinal() >= TypePrimitive.whichPrimitiveFor(val).ordinal();
        }

        public Object parseSeq(String s, XDomains.XDomInteger dom) {
            if (s.indexOf("..") != -1) {
                return IntegerEntity.parseSeq(s);
            }
            int nbDiscarded = 0;
            ArrayList<Long> list = new ArrayList<Long>();
            for (String tok : s.split("\\s+")) {
                assert (!tok.equals("*")) : "STAR not handled in unary lists";
                long l = Utilities.safeLong(tok);
                if (this.canRepresent(l) && (dom == null || dom.contains(l))) {
                    list.add(l);
                    continue;
                }
                ++nbDiscarded;
            }
            if (nbDiscarded > 0) {
                System.out.println(nbDiscarded + " discarded values in the unary list " + s);
            }
            if (this == LONG) {
                return list.stream().mapToLong(i -> i).toArray();
            }
            return list.stream().mapToInt(i -> i.intValue()).toArray();
        }

        public boolean parseTuple(String s, long[] t, XDomains.XDomBasic[] doms, AtomicBoolean ab) {
            String[] toks = s.split("\\s*,\\s*");
            assert (toks.length == t.length) : toks.length + " " + t.length;
            boolean starred = false;
            for (int i = 0; i < toks.length; ++i) {
                if (toks[i].equals("*")) {
                    t[i] = this == BYTE ? 126L : (this == SHORT ? 32766L : (this == INT ? 0x7FFFFFFEL : 0x7FFFFFFFFFFFFFFEL));
                    starred = true;
                    continue;
                }
                long l = Utilities.safeLong(toks[i]);
                if (this.canRepresent(l) && (doms == null || ((XDomains.XDomInteger)doms[i]).contains(l))) {
                    t[i] = l;
                    continue;
                }
                return false;
            }
            if (starred) {
                ab.set(true);
            }
            return true;
        }

        static {
            $VALUES = new TypePrimitive[]{BYTE, SHORT, INT, LONG};
        }
    }
}

