/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xcsp.common.Condition;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.entries.AnyEntry;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XDomains;
import org.xcsp.parser.entries.XObjectives;
import org.xcsp.parser.entries.XValues;
import org.xcsp.parser.entries.XVariables;
import org.xcsp.parser.exceptions.UnknownIdException;
import org.xcsp.parser.exceptions.WrongTypeException;

public class XParser {
    private Document document;
    private XPath xpath = XPathFactory.newInstance().newXPath();
    public Map<String, XVariables.XVar> mapForVars = new HashMap<String, XVariables.XVar>();
    private Map<String, XVariables.XArray> mapForArrays = new HashMap<String, XVariables.XArray>();
    private Map<String, XDomains.XDom> cacheForContentToDomain = new HashMap<String, XDomains.XDom>();
    public List<AnyEntry.VEntry> vEntries = new ArrayList<AnyEntry.VEntry>();
    public List<AnyEntry.CEntry> cEntries = new ArrayList<AnyEntry.CEntry>();
    public List<AnyEntry.OEntry> oEntries = new ArrayList<AnyEntry.OEntry>();
    public Map<String, Object> aEntries = new HashMap<String, Object>();
    public Types.TypeFramework typeFramework;
    public Types.TypeCombination typeCombination;
    public Types.TypeClass[] discardedClasses;
    private List<XConstraints.CChild> leafs;

    private <T extends Enum<T>> T giveAttributeValue(Element elt, String attName, Class<T> clazz, T defaultValue) {
        String s = elt.getAttribute(attName);
        return s.length() == 0 ? defaultValue : Types.valueOf(clazz, s.replaceFirst("\\s+", "_"));
    }

    private XDomains.XDomBasic parseDomBasic(Element elt, XVariables.TypeVar type) {
        String content = elt.getTextContent().trim();
        XDomains.XDomBasic dom = (XDomains.XDomBasic)this.cacheForContentToDomain.get(content);
        if (dom == null) {
            dom = XDomains.XDomBasic.parse(content, type);
            this.cacheForContentToDomain.put(content, dom);
        }
        return dom;
    }

    private XDomains.XDomSet parseDomSet(Element elt, XVariables.TypeVar type) {
        Element[] childs = Utilities.childElementsOf(elt);
        String req = childs[0].getTextContent().trim();
        String pos = childs[1].getTextContent().trim();
        String content = req + " | " + pos;
        XDomains.XDomSet dom = (XDomains.XDomSet)this.cacheForContentToDomain.get(content);
        if (dom == null) {
            dom = XDomains.XDomSet.parse(req, pos, type);
            this.cacheForContentToDomain.put(content, dom);
        }
        return dom;
    }

    private XDomains.XDomGraph parseDomGraph(Element elt, XVariables.TypeVar type) {
        Element[] childs = Utilities.childElementsOf(elt);
        Element[] req = Utilities.childElementsOf(childs[0]);
        Element[] pos = Utilities.childElementsOf(childs[1]);
        String reqV = req[0].getTextContent().trim();
        String reqE = req[1].getTextContent().trim();
        String posV = pos[0].getTextContent().trim();
        String posE = pos[1].getTextContent().trim();
        String content = reqV + " | " + reqE + " | " + posV + " | " + posE;
        XDomains.XDomGraph dom = (XDomains.XDomGraph)this.cacheForContentToDomain.get(content);
        if (dom == null) {
            dom = XDomains.XDomGraph.parse(reqV, reqE, posV, posE, type);
            this.cacheForContentToDomain.put(content, dom);
        }
        return dom;
    }

    private XDomains.XDom parseDomain(Element elt, XVariables.TypeVar type) {
        return type.isBasic() ? this.parseDomBasic(elt, type) : (type.isSet() ? this.parseDomSet(elt, type) : this.parseDomGraph(elt, type));
    }

    private int[] giveArraySize(Element elt) {
        StringTokenizer st = new StringTokenizer(elt.getAttribute(Types.TypeAtt.size.name()), "[]");
        return IntStream.range(0, st.countTokens()).map(i -> Integer.parseInt(st.nextToken())).toArray();
    }

    private Element getActualElementToAnalyse(Element elt) {
        try {
            String id = elt.getAttribute(Types.TypeAtt.as.name());
            return id.length() == 0 ? elt : (Element)this.xpath.evaluate("//*[@id='" + id + "']", this.document, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return (Element)Utilities.control(false, "Bad use of 'as'" + elt.getTagName());
        }
    }

    public void parseVariables() {
        HashMap<String, XDomains.XDom> cacheForId2Domain = new HashMap<String, XDomains.XDom>();
        for (Element elt : Utilities.childElementsOf((Element)this.document.getElementsByTagName("variables").item(0))) {
            AnyEntry.VEntry entry = null;
            String id = elt.getAttribute(Types.TypeAtt.id.name());
            XVariables.TypeVar type = elt.getAttribute(Types.TypeAtt.type.name()).length() == 0 ? XVariables.TypeVar.integer : XVariables.TypeVar.valueOf(elt.getAttribute(Types.TypeAtt.type.name()));
            Element actualForElt = this.getActualElementToAnalyse(elt);
            if (actualForElt == null) {
                throw new UnknownIdException(elt.getAttribute("as"), "in attribute \"as\" of variable with id \"" + id + "\"");
            }
            XDomains.XDom dom = (XDomains.XDom)cacheForId2Domain.get(actualForElt.getAttribute(Types.TypeAtt.id.name()));
            if (elt.getTagName().equals("var")) {
                if (dom == null && !type.isQualitative()) {
                    try {
                        dom = this.parseDomain(actualForElt, type);
                        cacheForId2Domain.put(id, dom);
                    }
                    catch (WrongTypeException e) {
                        throw new WrongTypeException("for variable with id \"" + id + "\": " + e.getMessage());
                    }
                }
                entry = XVariables.XVar.build(id, type, dom);
            } else {
                int[] size = this.giveArraySize(elt);
                if (dom == null && !type.isQualitative()) {
                    Element[] childs = Utilities.childElementsOf(actualForElt);
                    if (childs.length > 0 && childs[0].getTagName().equals("domain")) {
                        XVariables.XArray array = new XVariables.XArray(id, type, size);
                        Stream.of(childs).forEach(child -> {
                            Element actualForChild = this.getActualElementToAnalyse((Element)child);
                            XDomains.XDom domChild = (XDomains.XDom)cacheForId2Domain.get(actualForChild.getAttribute(Types.TypeAtt.id.name()));
                            if (domChild == null) {
                                domChild = this.parseDomain(actualForChild, type);
                                String idChild = child.getAttribute(Types.TypeAtt.id.name());
                                if (idChild.length() > 0) {
                                    cacheForId2Domain.put(idChild, domChild);
                                }
                            }
                            array.setDom(child.getAttribute("for"), domChild);
                        });
                        entry = array;
                    } else {
                        dom = this.parseDomain(actualForElt, type);
                        cacheForId2Domain.put(id, dom);
                        entry = new XVariables.XArray(id, type, size, dom);
                    }
                } else {
                    entry = new XVariables.XArray(id, type, size, dom);
                }
            }
            entry.copyAttributesOf(elt);
            if (Types.TypeClass.intersect(entry.classes, this.discardedClasses)) continue;
            this.vEntries.add(entry);
        }
        for (AnyEntry.VEntry entry : this.vEntries) {
            if (entry instanceof XVariables.XVar) {
                this.mapForVars.put(entry.id, (XVariables.XVar)entry);
                continue;
            }
            Stream.of(((XVariables.XArray)entry).vars).forEach(var -> {
                if (var != null) {
                    this.mapForVars.put(var.id, (XVariables.XVar)var);
                }
            });
            this.mapForArrays.put(entry.id, (XVariables.XArray)entry);
        }
    }

    private Object parseData(String tok) {
        if (this.mapForVars.get(tok) != null) {
            return this.mapForVars.get(tok);
        }
        if (Character.isDigit(tok.charAt(0)) || tok.charAt(0) == '+' || tok.charAt(0) == '-') {
            String[] t = tok.split("\\.\\.");
            if (t.length == 2) {
                return new XValues.IntegerInterval(Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
            }
            t = tok.split("/");
            if (t.length == 2) {
                return new XValues.Rational(Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
            }
            t = tok.split("\\.");
            if (t.length == 2) {
                return new XValues.Decimal(Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
            }
            return Utilities.safeLong(tok);
        }
        if (tok.charAt(0) == '{') {
            String sub = tok.substring(1, tok.length() - 1);
            return sub.length() == 0 ? new Object[]{} : (Object[])Stream.of(sub.split("\\s*,\\s*")).mapToLong(s -> Utilities.safeLong(s)).toArray();
        }
        if (tok.charAt(0) == '(') {
            return this.parseCondition(tok);
        }
        if (tok.charAt(0) == '%') {
            return new XConstraints.XParameter(tok.equals("%...") ? -1 : Integer.parseInt(tok.substring(1)));
        }
        if (tok.indexOf("(") != -1) {
            return this.parseExpression(tok);
        }
        return tok;
    }

    private Object parseData(Element elt) {
        return this.parseData(elt.getTextContent().trim());
    }

    private Condition parseCondition(String tok) {
        int pos = tok.indexOf(44);
        String left = tok.substring(tok.charAt(0) != '(' ? 0 : 1, pos);
        String right = tok.substring(pos + 1, tok.length() - (tok.charAt(tok.length() - 1) == ')' ? 1 : 0));
        Types.TypeConditionOperator op = Types.TypeConditionOperator.valueOf(left.trim().toUpperCase());
        Object o = this.parseData(right);
        if (o instanceof Long) {
            return new Condition.ConditionVal(op.toRel(), (Long)o);
        }
        if (o instanceof XVariables.XVar) {
            return new Condition.ConditionVar(op.toRel(), (XVariables.XVarInteger)o);
        }
        if (o instanceof XValues.IntegerInterval) {
            return new Condition.ConditionIntvl(op.toSet(), ((XValues.IntegerInterval)o).inf, ((XValues.IntegerInterval)o).sup);
        }
        return new Condition.ConditionIntset(op.toSet(), LongStream.of((long[])o).mapToInt(l -> Utilities.safeLong2Int(l, true)).toArray());
    }

    private Condition parseCondition(Element elt) {
        return this.parseCondition(elt.getTextContent().trim());
    }

    private Condition[] parseConditions(Element elt) {
        return (Condition[])Stream.of(elt.getTextContent().trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> this.parseCondition((String)tok)).toArray(Condition[]::new);
    }

    public Object[] parseSequence(String seq, String delimiter) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String tok : seq.split(delimiter)) {
            int pos = tok.indexOf("[");
            XVariables.XArray array = pos == -1 ? null : this.mapForArrays.get(tok.substring(0, pos));
            try {
                if (array != null) {
                    list.addAll(array.getVarsFor(tok));
                    continue;
                }
                list.add(this.parseData(tok));
            }
            catch (WrongTypeException e) {
                throw new WrongTypeException("in sequence \"" + seq + "\": " + e.getMessage());
            }
        }
        return Utilities.specificArrayFrom(list);
    }

    public Object[] parseSequence(Element elt) {
        return this.parseSequence(elt.getTextContent().trim(), "\\s+");
    }

    private Object[][] parseDoubleSequence(Element elt, String delimiter) {
        String content = elt.getTextContent().trim();
        List<Object[]> list = Stream.of(content.split(delimiter)).skip(1L).map(tok -> this.parseSequence((String)tok, "\\s*,\\s*")).collect(Collectors.toList());
        return Utilities.specificArray2DFrom(list);
    }

    private Object[][] parseDoubleSequenceOfVars(Element elt) {
        int i;
        String content = elt.getTextContent().trim();
        Utilities.control(content.charAt(0) != '%', "It is currently not possible to make abstraction of double sequences of variables");
        if (content.charAt(0) == '(') {
            List<Object[]> list = Stream.of(content.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> this.parseSequence((String)tok, "\\s*,\\s*")).collect(Collectors.toList());
            return Utilities.specificArray2DFrom(list);
        }
        XVariables.XArray array = this.mapForArrays.get(content.substring(0, content.indexOf("[")));
        XValues.IntegerEntity[] indexRanges = array.buildIndexRanges(content);
        int first = -1;
        int second = -1;
        for (i = 0; first == -1 && i < indexRanges.length; ++i) {
            if (indexRanges[i].isSingleton()) continue;
            first = i;
        }
        for (i = indexRanges.length - 1; second == -1 && i >= 0; --i) {
            if (indexRanges[i].isSingleton()) continue;
            second = i;
        }
        int length1 = Math.toIntExact(indexRanges[first].width());
        int length2 = Math.toIntExact(indexRanges[second].width());
        Utilities.control(length1 != -1 && length2 != -1, "");
        ArrayList<Object[]> list2D = new ArrayList<Object[]>();
        int[] indexes = Stream.of(indexRanges).mapToInt(it -> (int)it.smallest()).toArray();
        for (int i2 = 0; i2 < length1; ++i2) {
            ArrayList<Object> list = new ArrayList<Object>();
            indexes[first] = i2 + (int)indexRanges[first].smallest();
            for (int j = 0; j < length2; ++j) {
                indexes[second] = j + (int)indexRanges[second].smallest();
                list.add(array.varAt(indexes));
            }
            list2D.add(Utilities.specificArrayFrom(list));
        }
        return Utilities.specificArray2DFrom(list2D);
    }

    private boolean parseSymbolicTuple(String[] t, XDomains.XDomBasic[] doms, AtomicBoolean ab) {
        boolean starred = false;
        for (int i = 0; i < t.length; ++i) {
            if (t[i].equals("*")) {
                starred = true;
                continue;
            }
            if (doms == null || (!(doms[i] instanceof XDomains.XDomSymbolic) ? ((XDomains.XDomInteger)doms[i]).contains(Integer.parseInt(t[i])) : ((XDomains.XDomSymbolic)doms[i]).contains(t[i]))) continue;
            return false;
        }
        if (starred) {
            ab.set(true);
        }
        return true;
    }

    private Object parseTuples(Element elt, XValues.TypePrimitive primitive, XDomains.XDomBasic[] doms, AtomicBoolean ab) {
        String s = elt.getTextContent().trim();
        if (s.length() == 0) {
            return null;
        }
        if (s.charAt(0) != '(') {
            if (primitive == null) {
                return Stream.of(s.split("\\s+")).filter(tok -> doms == null || ((XDomains.XDomSymbolic)doms[0]).contains((String)tok)).toArray(String[]::new);
            }
            return primitive.parseSeq(s, doms == null ? null : (XDomains.XDomInteger)doms[0]);
        }
        if (primitive == null) {
            return Stream.of(s.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> tok.split("\\s*,\\s*")).filter(t -> this.parseSymbolicTuple((String[])t, doms, ab)).toArray(x$0 -> new String[x$0][]);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int leftParenthesis = 0;
        int rightParenthesis = leftParenthesis + 1;
        while (s.charAt(rightParenthesis) != ')') {
            ++rightParenthesis;
        }
        String tok2 = s.substring(leftParenthesis + 1, rightParenthesis).trim();
        long[] tmp = new long[tok2.split("\\s*,\\s*").length];
        while (tok2 != null) {
            if (primitive.parseTuple(tok2, tmp, doms, ab)) {
                int i;
                Object[] t2;
                if (primitive == XValues.TypePrimitive.BYTE) {
                    t2 = new byte[tmp.length];
                    for (i = 0; i < t2.length; ++i) {
                        t2[i] = (byte)tmp[i];
                    }
                    list.add(t2);
                } else if (primitive == XValues.TypePrimitive.SHORT) {
                    t2 = new short[tmp.length];
                    for (i = 0; i < t2.length; ++i) {
                        t2[i] = (short)tmp[i];
                    }
                    list.add(t2);
                } else if (primitive == XValues.TypePrimitive.INT) {
                    t2 = new int[tmp.length];
                    for (i = 0; i < t2.length; ++i) {
                        t2[i] = (int)tmp[i];
                    }
                    list.add(t2);
                } else {
                    list.add(tmp.clone());
                }
            }
            for (leftParenthesis = rightParenthesis + 1; leftParenthesis < s.length() && s.charAt(leftParenthesis) != '('; ++leftParenthesis) {
            }
            if (leftParenthesis == s.length()) {
                tok2 = null;
                continue;
            }
            rightParenthesis = leftParenthesis + 1;
            while (s.charAt(rightParenthesis) != ')') {
                ++rightParenthesis;
            }
            tok2 = s.substring(leftParenthesis + 1, rightParenthesis).trim();
        }
        return list.size() == 0 ? new long[][]{} : (long[][])list.toArray((Object[])Array.newInstance(list.get(0).getClass(), list.size()));
    }

    private void parseExtension(Element elt, Element[] sons, Object[][] args) {
        XValues.TypePrimitive primitive;
        XVariables.XVar[] vars;
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        XVariables.XVar[] xVarArray = vars = this.leafs.get((int)0).value instanceof XVariables.XVar[] ? (XVariables.XVar[])this.leafs.get((int)0).value : null;
        XValues.TypePrimitive typePrimitive = args != null ? XValues.TypePrimitive.whichPrimitiveFor((XVariables.XVar[][])args) : (primitive = vars != null ? XValues.TypePrimitive.whichPrimitiveFor(vars) : null);
        XDomains.XDomBasic[] doms = args != null ? XDomains.XDomBasic.domainsFor((XVariables.XVar[][])args) : (vars != null ? XDomains.XDomBasic.domainsFor(vars) : null);
        AtomicBoolean ab = new AtomicBoolean();
        this.leafs.add(new XConstraints.CChild(Utilities.isTag(sons[1], Types.TypeChild.supports) ? Types.TypeChild.supports : Types.TypeChild.conflicts, this.parseTuples(sons[1], primitive, doms, ab)));
        if (doms == null || this.leafs.get((int)1).value instanceof XValues.IntegerEntity[]) {
            this.leafs.get((int)1).flags.add(Types.TypeFlag.UNCLEAN_TUPLES);
        }
        if (ab.get()) {
            this.leafs.get((int)1).flags.add(Types.TypeFlag.STARRED_TUPLES);
        }
    }

    private XNode<XVariables.XVar> parseExpression(String s) {
        int leftParenthesisPosition = s.indexOf(40);
        if (leftParenthesisPosition == -1) {
            XVariables.XVar var = this.mapForVars.get(s);
            if (var != null) {
                return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.VAR, var);
            }
            if (s.charAt(0) == '%') {
                long l = Utilities.safeLong(s.substring(1));
                Utilities.control(Utilities.isSafeInt(l), "Bad value (index) for the parameter");
                return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.PAR, l);
            }
            String[] t = s.split("\\.");
            if (t.length == 2) {
                return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.DECIMAL, new XValues.Decimal(Utilities.safeLong(t[0]), Utilities.safeLong(t[1])));
            }
            if (Character.isDigit(s.charAt(0)) || s.charAt(0) == '+' || s.charAt(0) == '-') {
                return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.LONG, Utilities.safeLong(s));
            }
            return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.SYMBOL, s);
        }
        int rightParenthesisPosition = s.lastIndexOf(")");
        Types.TypeExpr operator = Types.TypeExpr.valueOf(s.substring(0, leftParenthesisPosition).toUpperCase());
        if (leftParenthesisPosition == rightParenthesisPosition - 1) {
            Utilities.control(operator == Types.TypeExpr.SET, " Erreur");
            return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.SET, (Object)null);
        }
        String content = s.substring(leftParenthesisPosition + 1, rightParenthesisPosition);
        ArrayList nodes = new ArrayList();
        for (int right = 0; right < content.length(); ++right) {
            int left = right;
            int nbOpens = 0;
            while (right < content.length()) {
                if (content.charAt(right) == '(') {
                    ++nbOpens;
                } else if (content.charAt(right) == ')') {
                    --nbOpens;
                } else if (content.charAt(right) == ',' && nbOpens == 0) break;
                ++right;
            }
            nodes.add(this.parseExpression(content.substring(left, right).trim()));
        }
        return new XNodeParent<XVariables.XVar>(operator, nodes);
    }

    private void parseIntension(Element elt, Element[] sons) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.function, this.parseExpression((sons.length == 0 ? elt : sons[0]).getTextContent().trim())));
    }

    private void parseSmart(Element elt, Element[] sons) {
        for (Element son : sons) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(son)));
        }
    }

    private void parseRegular(Element elt, Element[] sons) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        Object[][] trans = (Object[][])Stream.of(sons[1].getTextContent().trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(t -> {
            String[] tr = t.split("\\s*,\\s*");
            Long value = Character.isDigit(tr[1].charAt(0)) || tr[1].charAt(0) == '+' || tr[1].charAt(0) == '-' ? Utilities.safeLong(tr[1]) : tr[1];
            return new Object[]{tr[0], value, tr[2]};
        }).toArray(x$0 -> new Object[x$0][]);
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.transitions, trans));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.start, sons[2].getTextContent().trim()));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.FINAL, sons[3].getTextContent().trim().split("\\s+")));
    }

    private void parseGrammar(Element elt, Element[] sons) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.terminal, sons[1].getTextContent().trim().split("\\s+")));
        String[][][] rules = (String[][][])Stream.of(sons[2].getTextContent().trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(t -> {
            String[] stringArray;
            String[] sp = t.split("\\s*,\\s*");
            String[] leftWord = sp[0].split("\\s+");
            if (sp.length == 1) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            } else {
                stringArray = sp[1].split("\\s+");
            }
            String[] rightWord = stringArray;
            return new String[][]{leftWord, rightWord};
        }).toArray(x$0 -> new String[x$0][][]);
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.rules, rules));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.start, sons[3].getTextContent().trim()));
    }

    private void parseMDD(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        Object[][] trans = (Object[][])Stream.of(sons[1].getTextContent().trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(t -> {
            String[] tr = t.split("\\s*,\\s*");
            Long value = Character.isDigit(tr[1].charAt(0)) || tr[1].charAt(0) == '+' || tr[1].charAt(0) == '-' ? Utilities.safeLong(tr[1]) : tr[1];
            return new Object[]{tr[0], value, tr[2]};
        }).toArray(x$0 -> new Object[x$0][]);
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.transitions, trans));
    }

    private void parseAllDifferent(Element elt, Element[] sons, int lastSon) {
        if (sons.length == 0) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(elt)));
        } else {
            Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
            if (type == Types.TypeChild.matrix) {
                this.leafs.add(new XConstraints.CChild(type, this.parseDoubleSequenceOfVars(sons[0])));
            } else {
                Element except = Utilities.isTag(sons[lastSon], Types.TypeChild.except) ? sons[lastSon] : null;
                int limit = lastSon - (except != null ? 1 : 0);
                for (int i = 0; i <= limit; ++i) {
                    this.leafs.add(new XConstraints.CChild(type, this.parseSequence(sons[i])));
                }
                if (except != null) {
                    if (lastSon == 1) {
                        this.leafs.add(new XConstraints.CChild(Types.TypeChild.except, this.leafs.get(0).setVariableInvolved() ? this.parseDoubleSequence(except, "\\s*\\}\\s*\\{\\s*|\\s*\\{\\s*|\\s*\\}\\s*") : this.parseSequence(except)));
                    } else {
                        this.leafs.add(new XConstraints.CChild(Types.TypeChild.except, this.parseDoubleSequence(except, type == Types.TypeChild.list ? "\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*" : (type == Types.TypeChild.set ? "\\s*\\}\\s*\\{\\s*|\\s*\\{\\s*|\\s*\\}\\s*" : "\\s*\\}\\}\\s*\\{\\{\\s*|\\s*\\{\\{\\s*|\\s*\\}\\}\\s*"))));
                    }
                }
            }
        }
    }

    private void parseAllEqual(Element elt, Element[] sons, int lastSon) {
        if (sons.length == 0) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(elt)));
        } else {
            Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
            for (int i = 0; i <= lastSon; ++i) {
                this.leafs.add(new XConstraints.CChild(type, this.parseSequence(sons[i])));
            }
        }
    }

    private void parseAllDistant(Element elt, Element[] sons, int lastSon) {
        Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
        for (int i = 0; i < lastSon; ++i) {
            this.leafs.add(new XConstraints.CChild(type, this.parseSequence(sons[i])));
        }
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[lastSon])));
    }

    private void parseOrdered(Element elt, Element[] sons, int lastSon) {
        Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
        if (type == Types.TypeChild.matrix) {
            this.leafs.add(new XConstraints.CChild(type, this.parseDoubleSequenceOfVars(sons[0])));
        } else {
            for (int i = 0; i < lastSon; ++i) {
                this.leafs.add(new XConstraints.CChild(Types.TypeChild.valueOf(sons[i].getTagName()), this.parseSequence(sons[i])));
            }
        }
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.operator, (Object)Types.TypeOperator.valOf(sons[lastSon].getTextContent())));
    }

    private void parseLex(Element elt, Element[] sons, int lastSon) {
        this.parseOrdered(elt, sons, lastSon);
    }

    private void parseAllIncomparable(Element elt, Element[] sons, int lastSon) {
        Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
        for (int i = 0; i <= lastSon; ++i) {
            this.leafs.add(new XConstraints.CChild(type, this.parseSequence(sons[i])));
        }
    }

    private void parseSum(Element elt, Element[] sons, int lastSon) {
        if (Utilities.isTag(sons[0], Types.TypeChild.list)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        } else {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.index, this.parseData(sons[0])));
        }
        if (Utilities.isTag(sons[1], Types.TypeChild.coeffs)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.coeffs, this.parseSequence(sons[1])));
        }
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[lastSon])));
    }

    private void parseCount(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.values, this.parseSequence(sons[1])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[lastSon])));
    }

    private void parseNValues(Element elt, Element[] sons, int lastSon) {
        Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
        Element except = Utilities.isTag(sons[lastSon - 1], Types.TypeChild.except) ? sons[lastSon - 1] : null;
        int limit = lastSon - (except != null ? 2 : 1);
        for (int i = 0; i <= limit; ++i) {
            this.leafs.add(new XConstraints.CChild(type, this.parseSequence(sons[i])));
        }
        if (except != null) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.except, lastSon == 2 ? this.parseSequence(except) : this.parseDoubleSequence(except, type == Types.TypeChild.list ? "\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*" : (type == Types.TypeChild.set ? "\\s*\\}\\s*\\{\\s*|\\s*\\{\\s*|\\s*\\}\\s*" : "\\s*\\}\\}\\s*\\{\\{\\s*|\\s*\\{\\{\\s*|\\s*\\}\\}\\s*"))));
        }
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[lastSon])));
    }

    private void parseCardinality(Element elt, Element[] sons, int lastSon) {
        if (Utilities.isTag(sons[0], Types.TypeChild.matrix)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.matrix, this.parseDoubleSequenceOfVars(sons[0])));
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.values, this.parseSequence(sons[1])));
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.rowOccurs, this.parseDoubleSequenceOfVars(sons[2])));
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.colOccurs, this.parseDoubleSequenceOfVars(sons[3])));
        } else {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.values, this.parseSequence(sons[1])));
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.occurs, this.parseSequence(sons[2])));
        }
    }

    private void parseBalance(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        if (Utilities.isTag(sons[1], Types.TypeChild.values)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.values, this.parseSequence(sons[1])));
        }
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[lastSon])));
    }

    private void parseSpread(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        if (Utilities.isTag(sons[1], Types.TypeChild.total)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.total, this.parseData(sons[1])));
        }
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[lastSon])));
    }

    private void parseDeviation(Element elt, Element[] sons, int lastSon) {
        this.parseSpread(elt, sons, lastSon);
    }

    private void parseMaximum(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        if (Utilities.isTag(sons[1], Types.TypeChild.index)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.index, this.parseData(sons[1])));
        }
        if (Utilities.isTag(sons[lastSon], Types.TypeChild.condition)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[lastSon])));
        }
    }

    private void parseMinimum(Element elt, Element[] sons, int lastSon) {
        this.parseMaximum(elt, sons, lastSon);
    }

    private void parseElement(Element elt, Element[] sons, int lastSon) {
        if (Utilities.isTag(sons[0], Types.TypeChild.matrix)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.matrix, this.parseDoubleSequenceOfVars(sons[0])));
            if (Utilities.isTag(sons[1], Types.TypeChild.index)) {
                this.leafs.add(new XConstraints.CChild(Types.TypeChild.index, this.parseSequence(sons[1])));
            }
        } else {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
            if (Utilities.isTag(sons[1], Types.TypeChild.index)) {
                this.leafs.add(new XConstraints.CChild(Types.TypeChild.index, this.parseData(sons[1])));
            }
        }
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.value, this.parseData(sons[lastSon])));
    }

    private void parseChannel(Element elt, Element[] sons, int lastSon) {
        if (sons.length == 0) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(elt)));
        } else {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
            if (lastSon == 1) {
                if (Utilities.isTag(sons[1], Types.TypeChild.list)) {
                    this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[1])));
                } else {
                    this.leafs.add(new XConstraints.CChild(Types.TypeChild.value, this.parseData(sons[1])));
                }
            }
        }
    }

    private void parsePermutation(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[1])));
        if (lastSon == 2) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.mapping, this.parseSequence(sons[2])));
        }
    }

    private void parsePrecedence(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.values, this.parseSequence(sons[1])));
        if (lastSon == 2) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.operator, (Object)Types.TypeOperator.valOf(sons[lastSon].getTextContent())));
        }
    }

    private void parseStretch(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.values, this.parseSequence(sons[1])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.widths, this.parseSequence(sons[2])));
        if (lastSon == 3) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.patterns, this.parseDoubleSequence(sons[3], "\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")));
        }
    }

    private void parseNoOverlap(Element elt, Element[] sons) {
        boolean multiDimensional = sons[1].getTextContent().trim().charAt(0) == '(';
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.origins, multiDimensional ? this.parseDoubleSequenceOfVars(sons[0]) : this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.lengths, multiDimensional ? this.parseDoubleSequence(sons[1], "\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*") : this.parseSequence(sons[1])));
    }

    private void parseCumulative(Element elt, Element[] sons) {
        int cnt = 0;
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.origins, this.parseSequence(sons[cnt++])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.lengths, this.parseSequence(sons[cnt++])));
        if (Utilities.isTag(sons[cnt], Types.TypeChild.ends)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.ends, this.parseSequence(sons[cnt++])));
        }
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.heights, this.parseSequence(sons[cnt++])));
        if (Utilities.isTag(sons[cnt], Types.TypeChild.machines)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.machines, this.parseSequence(sons[cnt++])));
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.conditions, this.parseConditions(sons[cnt++])));
        } else {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[cnt++])));
        }
    }

    private void parseBinPacking(Element elt, Element[] sons) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.sizes, this.parseSequence(sons[1])));
        if (Utilities.isTag(sons[2], Types.TypeChild.condition)) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[2])));
        } else {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.conditions, this.parseConditions(sons[2])));
        }
    }

    private void parseKnapsack(Element elt, Element[] sons) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.weights, this.parseSequence(sons[1])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.profits, this.parseSequence(sons[2])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.limit, this.parseData(sons[3])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[4])));
    }

    private XConstraints.CChild listOrGraph(Element elt) {
        return Utilities.isTag(elt, Types.TypeChild.list) ? new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(elt)) : new XConstraints.CChild(Types.TypeChild.graph, this.parseData(elt));
    }

    private void parseCircuit(Element elt, Element[] sons, int lastSon) {
        if (sons.length == 0) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(elt)));
        } else {
            this.leafs.add(this.listOrGraph(sons[0]));
            if (lastSon == 1) {
                this.leafs.add(new XConstraints.CChild(Types.TypeChild.size, this.parseData(sons[1])));
            }
        }
    }

    private void parseNCircuits(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(this.listOrGraph(sons[0]));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[1])));
    }

    private void parsePath(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(this.listOrGraph(sons[0]));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.start, this.parseData(sons[1])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.FINAL, this.parseData(sons[2])));
        if (lastSon == 3) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.size, this.parseData(sons[3])));
        }
    }

    private void parseNPaths(Element elt, Element[] sons, int lastSon) {
        this.parseNCircuits(elt, sons, lastSon);
    }

    private void parseTree(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(this.listOrGraph(sons[0]));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.root, this.parseData(sons[1])));
        if (lastSon == 2) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.size, this.parseData(sons[2])));
        }
    }

    private void parseArbo(Element elt, Element[] sons, int lastSon) {
        this.parseTree(elt, sons, lastSon);
    }

    private void parseNTrees(Element elt, Element[] sons, int lastSon) {
        this.parseNCircuits(elt, sons, lastSon);
    }

    private void parseNArbos(Element elt, Element[] sons, int lastSon) {
        this.parseNCircuits(elt, sons, lastSon);
    }

    private void parseNCliques(Element elt, Element[] sons, int lastSon) {
        this.parseNCircuits(elt, sons, lastSon);
    }

    private void parseClause(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons.length == 0 ? elt : sons[0])));
    }

    private void parseInstantiation(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.values, this.parseSequence(sons[1])));
    }

    private void parseAllIntersecting(Element elt, Element[] sons) {
        if (sons.length == 0) {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(elt)));
        } else {
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
            this.leafs.add(new XConstraints.CChild(Types.TypeChild.condition, this.parseCondition(sons[1])));
        }
    }

    private void parseRange(Element elt, Element[] sons) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.index, this.parseData(sons[1])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.image, this.parseData(sons[2])));
    }

    private void parseRoots(Element elt, Element[] sons) {
        this.parseRange(elt, sons);
    }

    private void parsePartition(Element elt, Element[] sons) {
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0])));
        this.leafs.add(new XConstraints.CChild(Types.TypeChild.value, this.parseData(sons[1])));
    }

    private int getIntValueOf(Element element, String attName, int defaultValue) {
        return element.getAttribute(attName).length() > 0 ? Integer.parseInt(element.getAttribute(attName)) : defaultValue;
    }

    private AnyEntry.CEntry parseCEntry(Element elt, Object[][] args, Element[] sons, int lastSon) {
        if (elt.getTagName().equals("group")) {
            List l = IntStream.range(1, lastSon + 1).mapToObj(i -> this.parseSequence(sons[i])).collect(Collectors.toList());
            Object[][] groupArgs = l.stream().noneMatch(o -> !(o instanceof XVariables.XVar[])) ? (Object[][])l.toArray((T[])new XVariables.XVar[0][]) : (Object[][])l.toArray((T[])new Object[0][]);
            return new XConstraints.XGroup((XConstraints.CEntryReifiable)this.parseCEntryOuter(sons[0], groupArgs), groupArgs);
        }
        Types.TypeCtr type = Types.TypeCtr.valueOf(elt.getTagName());
        if (type == Types.TypeCtr.slide) {
            XConstraints.CChild[] lists = (XConstraints.CChild[])IntStream.range(0, lastSon).mapToObj(i -> new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[i]))).toArray(XConstraints.CChild[]::new);
            int[] offset = Stream.of(sons).limit(lists.length).mapToInt(s -> this.getIntValueOf((Element)s, Types.TypeAtt.offset.name(), 1)).toArray();
            int[] collect = Stream.of(sons).limit(lists.length).mapToInt(s -> this.getIntValueOf((Element)s, Types.TypeAtt.collect.name(), 1)).toArray();
            if (lists.length == 1) {
                XConstraints.XCtr ctr = (XConstraints.XCtr)this.parseCEntryOuter(sons[lastSon], null);
                Utilities.control(ctr.abstraction.abstractChilds.length == 1, "Other cases must be implemented");
                if (ctr.getType() == Types.TypeCtr.intension) {
                    collect[0] = ((XNode)ctr.childs[0].value).maxParameterNumber() + 1;
                } else {
                    XConstraints.XParameter[] pars = (XConstraints.XParameter[])ctr.abstraction.abstractChilds[0].value;
                    Utilities.control(Stream.of(pars).noneMatch(p -> p.number == -1), "One parameter is %..., which is forbidden in slide");
                    collect[0] = Stream.of(pars).mapToInt(p -> p.number + 1).max().orElseThrow(() -> new RuntimeException());
                }
            }
            Object[][] scopes = XConstraints.XSlide.buildScopes((XVariables.XVar[][])Stream.of(lists).map(ls -> (XVariables.XVar[])ls.value).toArray(x$0 -> new XVariables.XVar[x$0][]), offset, collect, elt.getAttribute(Types.TypeAtt.circular.name()).equals(Boolean.TRUE.toString()));
            return new XConstraints.XSlide(lists, offset, collect, (XConstraints.XCtr)this.parseCEntryOuter(sons[lastSon], scopes), (XVariables.XVar[][])scopes);
        }
        if (type == Types.TypeCtr.seqbin) {
            XConstraints.CChild list = new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0]));
            XVariables.XVar[] t = (XVariables.XVar[])list.value;
            Object[][] scopes = (XVariables.XVar[][])IntStream.range(0, t.length - 1).mapToObj(i -> new XVariables.XVar[]{t[i], t[i + 1]}).toArray(x$0 -> new XVariables.XVar[x$0][]);
            XConstraints.CChild number = new XConstraints.CChild(Types.TypeChild.number, this.parseData(sons[3]));
            return new XConstraints.XSeqbin(list, (XConstraints.XCtr)this.parseCEntryOuter(sons[1], scopes), (XConstraints.XCtr)this.parseCEntryOuter(sons[2], scopes), number, (XVariables.XVar[][])scopes);
        }
        if (type.isLogical() || type.isControl()) {
            return new XConstraints.XLogic(type, (XConstraints.CEntryReifiable[])IntStream.range(0, lastSon + 1).mapToObj(i -> this.parseCEntryOuter(sons[i], args)).toArray(XConstraints.CEntryReifiable[]::new));
        }
        this.leafs = new ArrayList<XConstraints.CChild>();
        if (type == Types.TypeCtr.extension) {
            this.parseExtension(elt, sons, args);
        } else if (type == Types.TypeCtr.intension) {
            this.parseIntension(elt, sons);
        } else if (type == Types.TypeCtr.regular) {
            this.parseRegular(elt, sons);
        } else if (type == Types.TypeCtr.grammar) {
            this.parseGrammar(elt, sons);
        } else if (type == Types.TypeCtr.mdd) {
            this.parseMDD(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.allDifferent) {
            this.parseAllDifferent(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.allEqual) {
            this.parseAllEqual(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.allDistant) {
            this.parseAllDistant(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.ordered) {
            this.parseOrdered(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.lex) {
            this.parseLex(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.allIncomparable) {
            this.parseAllIncomparable(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.sum) {
            this.parseSum(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.count) {
            this.parseCount(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nValues) {
            this.parseNValues(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.cardinality) {
            this.parseCardinality(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.balance) {
            this.parseBalance(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.spread) {
            this.parseSpread(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.deviation) {
            this.parseDeviation(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.maximum) {
            this.parseMaximum(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.minimum) {
            this.parseMinimum(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.element) {
            this.parseElement(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.channel) {
            this.parseChannel(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.permutation) {
            this.parsePermutation(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.precedence) {
            this.parsePrecedence(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.stretch) {
            this.parseStretch(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.noOverlap) {
            this.parseNoOverlap(elt, sons);
        } else if (type == Types.TypeCtr.cumulative) {
            this.parseCumulative(elt, sons);
        } else if (type == Types.TypeCtr.binPacking) {
            this.parseBinPacking(elt, sons);
        } else if (type == Types.TypeCtr.knapsack) {
            this.parseKnapsack(elt, sons);
        } else if (type == Types.TypeCtr.circuit) {
            this.parseCircuit(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nCircuits) {
            this.parseNCircuits(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.path) {
            this.parsePath(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nPaths) {
            this.parseNPaths(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.tree) {
            this.parseTree(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nTrees) {
            this.parseNTrees(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.arbo) {
            this.parseArbo(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nArbos) {
            this.parseNArbos(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nCliques) {
            this.parseNCliques(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.clause) {
            this.parseClause(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.instantiation) {
            this.parseInstantiation(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.allIntersecting) {
            this.parseAllIntersecting(elt, sons);
        } else if (type == Types.TypeCtr.range) {
            this.parseRange(elt, sons);
        } else if (type == Types.TypeCtr.roots) {
            this.parseRoots(elt, sons);
        } else if (type == Types.TypeCtr.partition) {
            this.parsePartition(elt, sons);
        } else if (type == Types.TypeCtr.smart) {
            this.parseSmart(elt, sons);
        }
        return new XConstraints.XCtr(type, this.leafs.toArray(new XConstraints.CChild[this.leafs.size()]));
    }

    private XConstraints.XSoftening buildSoftening(Element elt, Map<Types.TypeAtt, String> attributes, Condition cost) {
        if (attributes.containsKey((Object)Types.TypeAtt.violationCost)) {
            int violationCost = Utilities.safeLong2Int(Utilities.safeLong(attributes.get((Object)Types.TypeAtt.violationCost)), true);
            return cost == null ? new XConstraints.XSoftening.XSofteningSimple(violationCost) : new XConstraints.XSoftening.XSofteningSimple(cost, violationCost);
        }
        Types.TypeCtr type = Types.TypeCtr.valueOf(elt.getTagName());
        if (type == Types.TypeCtr.intension) {
            return cost == null ? new XConstraints.XSoftening.XSofteningIntension() : new XConstraints.XSoftening.XSofteningIntension(cost);
        }
        if (type == Types.TypeCtr.extension) {
            int defaultCost = attributes.containsKey((Object)Types.TypeAtt.defaultCost) ? Utilities.safeLong2Int(Utilities.safeLong(attributes.get((Object)Types.TypeAtt.defaultCost)), true) : -1;
            return cost == null ? new XConstraints.XSoftening.XSofteningExtension(defaultCost) : new XConstraints.XSoftening.XSofteningExtension(cost, defaultCost);
        }
        Types.TypeMeasure typeMeasure = attributes.containsKey((Object)Types.TypeAtt.violationMeasure) ? Types.valueOf(Types.TypeMeasure.class, attributes.get((Object)Types.TypeAtt.violationMeasure)) : null;
        String parameters = attributes.get((Object)Types.TypeAtt.violationParameters);
        return cost == null ? new XConstraints.XSoftening.XSofteningGlobal(typeMeasure, parameters) : new XConstraints.XSoftening.XSofteningGlobal(cost, typeMeasure, parameters);
    }

    private AnyEntry.CEntry parseCEntryOuter(Element elt, Object[][] args) {
        int i;
        Element[] sons = Utilities.childElementsOf(elt);
        boolean soft = elt.getAttribute(Types.TypeAtt.type.name()).equals("soft");
        int lastSon = sons.length - 1 - (sons.length > 1 && Utilities.isTag(sons[sons.length - 1], Types.TypeChild.cost) ? 1 : 0);
        AnyEntry.CEntry entry = this.parseCEntry(elt, args, sons, lastSon);
        entry.copyAttributesOf(elt);
        if (entry instanceof XConstraints.XCtr) {
            for (i = 0; i <= lastSon; ++i) {
                ((XConstraints.XCtr)entry).childs[i].copyAttributesOf(sons[i]);
            }
        } else if (entry instanceof XConstraints.XSlide) {
            for (i = 0; i < lastSon; ++i) {
                ((XConstraints.XSlide)entry).lists[i].copyAttributesOf(sons[i]);
            }
        }
        if (entry instanceof XConstraints.CEntryReifiable) {
            XConstraints.CEntryReifiable entryReifiable = (XConstraints.CEntryReifiable)entry;
            Map attributes = entryReifiable.attributes;
            if (soft) {
                Condition cost = lastSon == sons.length - 1 ? null : this.parseCondition(sons[sons.length - 1]);
                entryReifiable.softening = this.buildSoftening(elt, attributes, cost);
            }
            if (attributes.containsKey((Object)Types.TypeAtt.reifiedBy)) {
                entryReifiable.reification = new XConstraints.XReification(Types.TypeReification.FULL, this.mapForVars.get(attributes.get((Object)Types.TypeAtt.reifiedBy)));
            } else if (attributes.containsKey((Object)Types.TypeAtt.hreifiedFrom)) {
                entryReifiable.reification = new XConstraints.XReification(Types.TypeReification.HALF_FROM, this.mapForVars.get(attributes.get((Object)Types.TypeAtt.hreifiedFrom)));
            } else if (attributes.containsKey((Object)Types.TypeAtt.hreifiedTo)) {
                entryReifiable.reification = new XConstraints.XReification(Types.TypeReification.HALF_TO, this.mapForVars.get(attributes.get((Object)Types.TypeAtt.hreifiedTo)));
            }
        }
        return entry;
    }

    private void recursiveParsingOfConstraints(Element elt, List<AnyEntry.CEntry> list) {
        if (elt.getTagName().equals("block")) {
            ArrayList<AnyEntry.CEntry> blockEntries = new ArrayList<AnyEntry.CEntry>();
            Stream.of(Utilities.childElementsOf(elt)).forEach(child -> this.recursiveParsingOfConstraints((Element)child, (List<AnyEntry.CEntry>)blockEntries));
            XConstraints.XBlock ctrBlock = new XConstraints.XBlock(blockEntries);
            ctrBlock.copyAttributesOf(elt);
            if (!Types.TypeClass.intersect(ctrBlock.classes, this.discardedClasses)) {
                list.add(ctrBlock);
            }
        } else {
            AnyEntry.CEntry entry = this.parseCEntryOuter(elt, null);
            if (!Types.TypeClass.intersect(entry.classes, this.discardedClasses)) {
                list.add(entry);
            }
        }
    }

    private void parseConstraints() {
        Stream.of(Utilities.childElementsOf((Element)this.document.getElementsByTagName("constraints").item(0))).forEach(elt -> this.recursiveParsingOfConstraints((Element)elt, this.cEntries));
    }

    private void parseObjectives() {
        NodeList nl = this.document.getDocumentElement().getElementsByTagName("objectives");
        if (nl.getLength() == 1) {
            Element objectives = (Element)nl.item(0);
            this.typeCombination = this.giveAttributeValue(objectives, Types.TypeAtt.combination.name(), Types.TypeCombination.class, Types.TypeCombination.PARETO);
            for (Element elt : Utilities.childElementsOf(objectives)) {
                XObjectives.XObj entry = null;
                boolean minimize = elt.getTagName().equals("minimize");
                Types.TypeObjective type = this.giveAttributeValue(elt, Types.TypeAtt.type.name(), Types.TypeObjective.class, Types.TypeObjective.EXPRESSION);
                if (type == Types.TypeObjective.EXPRESSION) {
                    entry = new XObjectives.OObjectiveExpr(minimize, type, this.parseExpression(elt.getTextContent().trim()));
                } else {
                    Element[] sons = Utilities.childElementsOf(elt);
                    XVariables.XVar[] vars = (XVariables.XVar[])this.parseSequence(sons.length == 0 ? elt : sons[0]);
                    XValues.SimpleValue[] coeffs = sons.length != 2 ? null : XValues.SimpleValue.parseSeq(sons[1].getTextContent().trim());
                    entry = new XObjectives.OObjectiveSpecial(minimize, type, vars, coeffs);
                }
                entry.copyAttributesOf(elt);
                if (Types.TypeClass.intersect(entry.classes, this.discardedClasses)) continue;
                this.oEntries.add(entry);
            }
        }
    }

    private void parseAnnotations() {
        NodeList nl = this.document.getDocumentElement().getElementsByTagName("annotations");
        if (nl.getLength() == 1) {
            Element annotations = (Element)nl.item(0);
            for (Element elt : Utilities.childElementsOf(annotations)) {
                if (!elt.getTagName().equals("decision")) continue;
                XVariables.XVar[] vars = (XVariables.XVar[])this.parseSequence(elt);
                this.aEntries.put("decision", vars);
            }
        }
    }

    private void updateVarDegreesWith(List<AnyEntry.CEntry> list) {
        for (AnyEntry.CEntry entry : list) {
            if (entry instanceof XConstraints.XBlock) {
                this.updateVarDegreesWith(((XConstraints.XBlock)entry).subentries);
                continue;
            }
            if (entry instanceof XConstraints.XGroup) {
                XConstraints.XGroup group = (XConstraints.XGroup)entry;
                for (int i = 0; i < group.argss.length; ++i) {
                    for (XVariables.XVar var : group.getScope(i)) {
                        ++var.degree;
                    }
                }
                continue;
            }
            for (XVariables.XVar var : entry.vars()) {
                ++var.degree;
            }
        }
    }

    private void computeVarDegrees() {
        this.updateVarDegreesWith(this.cEntries);
        for (AnyEntry.OEntry entry : this.oEntries) {
            if (entry instanceof XObjectives.OObjectiveExpr) {
                for (XVariables.XVar xVar : ((XObjectives.OObjectiveExpr)entry).rootNode.listOfVars()) {
                    ++xVar.degree;
                }
                continue;
            }
            for (XVariables.XVar x : ((XObjectives.OObjectiveSpecial)entry).vars) {
                ++x.degree;
            }
        }
    }

    public XParser(Document document, Types.TypeClass[] discardedClasses) throws Exception {
        this.document = document;
        this.discardedClasses = discardedClasses;
        this.typeFramework = this.giveAttributeValue(document.getDocumentElement(), Types.TypeAtt.type.name(), Types.TypeFramework.class, Types.TypeFramework.CSP);
        this.parseVariables();
        this.parseConstraints();
        this.parseObjectives();
        this.parseAnnotations();
        this.computeVarDegrees();
    }

    public XParser(Document document, String ... discardedClasses) throws Exception {
        this(document, Types.TypeClass.classesFor(discardedClasses));
    }

    public XParser(InputStream inpuStream, Types.TypeClass[] discardedClasses) throws Exception {
        this(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inpuStream), discardedClasses);
    }

    public XParser(InputStream inputStream, String ... discardedClasses) throws Exception {
        this(inputStream, Types.TypeClass.classesFor(discardedClasses));
    }
}

