/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.xcsp.common.Condition;
import org.xcsp.common.Constants;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.XParser;
import org.xcsp.parser.entries.AnyEntry;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XDomains;
import org.xcsp.parser.entries.XObjectives;
import org.xcsp.parser.entries.XValues;
import org.xcsp.parser.entries.XVariables;
import org.xcsp.parser.exceptions.DuplicateIdException;
import org.xcsp.parser.exceptions.WrongTypeException;
import org.xcsp.parser.loaders.CtrLoaderInteger;
import org.xcsp.parser.loaders.CtrLoaderSymbolic;

public interface XCallbacks {
    public Implem implem();

    default public void repost(String constraintId) {
        this.implem().postedRecognizedCtrs.remove(constraintId);
    }

    default public Object unimplementedCase(Object ... objects) {
        throw new RuntimeException("Unimplemented case " + Stream.of(objects).map(o -> o.toString()).collect(Collectors.joining("\n")));
    }

    default public Document loadDocument(String fileName) throws Exception {
        return Utilities.loadDocument(fileName);
    }

    default public void loadInstance(Document document, String ... discardedClasses) throws Exception {
        this.implem().resetStructures();
        XParser parser = new XParser(document, discardedClasses);
        this.beginInstance(parser.typeFramework);
        this.beginVariables(parser.vEntries);
        this.loadVariables(parser);
        this.endVariables();
        this.beginConstraints(parser.cEntries);
        this.loadConstraints(parser);
        this.endConstraints();
        this.beginObjectives(parser.oEntries, parser.typeCombination);
        this.loadObjectives(parser);
        this.endObjectives();
        this.beginAnnotations(parser.aEntries);
        this.loadAnnotations(parser);
        this.endAnnotations();
        this.endInstance();
    }

    default public void loadInstance(String fileName, String ... discardedClasses) throws Exception {
        this.loadInstance(this.loadDocument(fileName), discardedClasses);
    }

    default public void loadVariables(XParser parser) {
        for (AnyEntry.VEntry entry : parser.vEntries) {
            try {
                if (entry instanceof XVariables.XVar) {
                    this.loadVar((XVariables.XVar)entry);
                    continue;
                }
                this.beginArray((XVariables.XArray)entry);
                this.loadArray((XVariables.XArray)entry);
                this.endArray((XVariables.XArray)entry);
            }
            catch (ClassCastException e) {
                throw new WrongTypeException("in declaration of variable with id \"" + entry.id + "\": does domain correspond to the declared type ?");
            }
        }
    }

    default public void loadVar(XVariables.XVar v) {
        this.implem().manageIdFor(v);
        if (v.degree == 0) {
            return;
        }
        Object domObject = this.implem().cache4DomObject.get(v.dom);
        if (domObject == null) {
            if (v.dom instanceof XDomains.XDomInteger) {
                XValues.IntegerEntity[] pieces = (XValues.IntegerEntity[])((XDomains.XDomInteger)v.dom).values;
                if (pieces.length == 1 && pieces[0] instanceof XValues.IntegerInterval) {
                    domObject = pieces[0];
                } else {
                    int[] values = XValues.IntegerEntity.toIntArray(pieces, 10000000);
                    Utilities.control(values != null, "Too many values. You have to extend the parser.");
                    domObject = values;
                }
            } else if (v.dom instanceof XDomains.XDomSymbolic) {
                domObject = ((XDomains.XDomSymbolic)v.dom).values;
            } else {
                this.unimplementedCase(v.dom);
            }
            this.implem().cache4DomObject.put(v.dom, domObject);
        }
        if (domObject instanceof XValues.IntegerInterval) {
            XValues.IntegerInterval ii = (XValues.IntegerInterval)domObject;
            int min = Utilities.safeLong2IntWhileHandlingInfinity(ii.inf, true);
            int max = Utilities.safeLong2IntWhileHandlingInfinity(ii.sup, true);
            this.buildVarInteger((XVariables.XVarInteger)v, min, max);
        } else if (domObject instanceof int[]) {
            this.buildVarInteger((XVariables.XVarInteger)v, (int[])domObject);
        } else if (domObject instanceof String[]) {
            this.buildVarSymbolic((XVariables.XVarSymbolic)v, (String[])domObject);
        } else {
            this.unimplementedCase(v);
        }
    }

    default public void loadArray(XVariables.XArray va) {
        this.implem().manageIdFor(va);
        Stream.of(va.vars).filter(v -> v != null).forEach(v -> this.loadVar((XVariables.XVar)v));
    }

    default public void loadConstraints(XParser parser) {
        this.loadConstraints(parser.cEntries);
    }

    default public void loadConstraints(List<AnyEntry.CEntry> list) {
        for (AnyEntry.CEntry entry : list) {
            if (entry instanceof XConstraints.XBlock) {
                this.loadBlock((XConstraints.XBlock)entry);
                continue;
            }
            if (entry instanceof XConstraints.XGroup) {
                this.loadGroup((XConstraints.XGroup)entry);
                continue;
            }
            if (entry instanceof XConstraints.XSlide) {
                this.loadSlide((XConstraints.XSlide)entry);
                continue;
            }
            if (entry instanceof XConstraints.XLogic) {
                this.loadLogic((XConstraints.XLogic)entry);
                continue;
            }
            if (entry instanceof XConstraints.XCtr) {
                try {
                    this.loadCtr((XConstraints.XCtr)entry);
                    continue;
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                    throw new WrongTypeException("Wrong parameter type in constraint:\n" + entry + "\n" + e);
                }
            }
            this.unimplementedCase(entry);
        }
    }

    default public void loadBlock(XConstraints.XBlock b) {
        this.implem().manageIdFor(b);
        this.beginBlock(b);
        this.loadConstraints(b.subentries);
        this.endBlock(b);
    }

    default public void loadGroup(XConstraints.XGroup g) {
        this.implem().manageIdFor(g);
        this.beginGroup(g);
        if (g.template instanceof XConstraints.XCtr) {
            this.loadCtrs((XConstraints.XCtr)g.template, g.argss, g);
        } else {
            this.unimplementedCase(g);
        }
        this.endGroup(g);
    }

    default public void loadSlide(XConstraints.XSlide s) {
        this.implem().manageIdFor(s);
        this.beginSlide(s);
        this.loadCtrs((XConstraints.XCtr)s.template, s.scopes, s);
        this.endSlide(s);
    }

    default public void loadLogic(XConstraints.XLogic l) {
        this.implem().manageIdFor(l);
        this.beginLogic(l);
        this.loadConstraints(Arrays.asList(l.components));
        this.endLogic(l);
    }

    default public void loadCtrs(XConstraints.XCtr template, Object[][] argss, AnyEntry.CEntry entry) {
        Stream.of(argss).forEach(args -> {
            template.id = null;
            template.abstraction.concretize((Object[])args);
            this.loadCtr(template);
        });
    }

    default public void loadCtr(XConstraints.XCtr c) {
        this.implem().manageIdFor(c);
        XConstraints.CChild[] childs = c.childs;
        Utilities.control(Stream.of(Types.TypeChild.cost, Types.TypeChild.set, Types.TypeChild.mset).noneMatch(t -> t == childs[childs.length - 1].type), "soft, set and mset currently not implemented");
        if (Stream.of(c.vars()).allMatch(x -> x instanceof XVariables.XVarInteger)) {
            this.implem().ctrLoaderInteger.load(c);
        } else if (Stream.of(c.vars()).allMatch(x -> x instanceof XVariables.XVarSymbolic)) {
            this.implem().ctrLoaderSymbolic.load(c);
        } else {
            this.unimplementedCase(c);
        }
    }

    default public void loadObjectives(XParser parser) {
        parser.oEntries.stream().forEach(entry -> this.loadObj((XObjectives.XObj)entry));
    }

    default public void loadObj(XObjectives.XObj o) {
        this.implem().manageIdFor(o);
        if (o.type == Types.TypeObjective.EXPRESSION) {
            XNode<? extends XVariables.XVar> node = ((XObjectives.OObjectiveExpr)o).rootNode;
            if (node.getType() == Types.TypeExpr.VAR) {
                if (o.minimize) {
                    this.buildObjToMinimize(o.id, (XVariables.XVarInteger)((XNodeLeaf)node).value);
                } else {
                    this.buildObjToMaximize(o.id, (XVariables.XVarInteger)((XNodeLeaf)node).value);
                }
            } else if (o.minimize) {
                this.buildObjToMinimize(o.id, (XNodeParent)node);
            } else {
                this.buildObjToMaximize(o.id, (XNodeParent)node);
            }
        } else {
            int[] coeffs;
            XVariables.XVarInteger[] vars = (XVariables.XVarInteger[])((XObjectives.OObjectiveSpecial)o).vars;
            XValues.SimpleValue[] vals = ((XObjectives.OObjectiveSpecial)o).coeffs;
            int[] nArray = coeffs = vals == null ? null : Stream.of(vals).mapToInt(val -> Utilities.safeLong2Int(((XValues.IntegerValue)val).v, true)).toArray();
            if (coeffs == null) {
                if (o.minimize) {
                    this.buildObjToMinimize(o.id, o.type, vars);
                } else {
                    this.buildObjToMaximize(o.id, o.type, vars);
                }
            } else if (o.minimize) {
                this.buildObjToMinimize(o.id, o.type, vars, coeffs);
            } else {
                this.buildObjToMaximize(o.id, o.type, vars, coeffs);
            }
        }
    }

    default public void loadAnnotations(XParser parser) {
        Object obj = parser.aEntries.get("decision");
        if (obj != null) {
            this.buildAnnotationDecision((XVariables.XVarInteger[])obj);
        }
    }

    public void beginInstance(Types.TypeFramework var1);

    public void endInstance();

    public void beginVariables(List<AnyEntry.VEntry> var1);

    public void endVariables();

    public void beginArray(XVariables.XArray var1);

    public void endArray(XVariables.XArray var1);

    public void beginConstraints(List<AnyEntry.CEntry> var1);

    public void endConstraints();

    public void beginBlock(XConstraints.XBlock var1);

    public void endBlock(XConstraints.XBlock var1);

    public void beginGroup(XConstraints.XGroup var1);

    public void endGroup(XConstraints.XGroup var1);

    public void beginSlide(XConstraints.XSlide var1);

    public void endSlide(XConstraints.XSlide var1);

    public void beginLogic(XConstraints.XLogic var1);

    public void endLogic(XConstraints.XLogic var1);

    public void beginObjectives(List<AnyEntry.OEntry> var1, Types.TypeCombination var2);

    public void endObjectives();

    public void beginAnnotations(Map<String, Object> var1);

    public void endAnnotations();

    public void buildVarInteger(XVariables.XVarInteger var1, int var2, int var3);

    public void buildVarInteger(XVariables.XVarInteger var1, int[] var2);

    default public void buildCtrTrue(String id, XVariables.XVar[] list) {
    }

    default public void buildCtrFalse(String id, XVariables.XVar[] list) {
        throw new RuntimeException("Constraint with only conflicts");
    }

    public void buildCtrIntension(String var1, XVariables.XVarInteger[] var2, XNodeParent<XVariables.XVarInteger> var3);

    public void buildCtrPrimitive(String var1, XVariables.XVarInteger var2, Types.TypeConditionOperatorRel var3, int var4);

    public void buildCtrPrimitive(String var1, XVariables.XVarInteger var2, Types.TypeConditionOperatorSet var3, int[] var4);

    public void buildCtrPrimitive(String var1, XVariables.XVarInteger var2, Types.TypeConditionOperatorSet var3, int var4, int var5);

    public void buildCtrPrimitive(String var1, XVariables.XVarInteger var2, Types.TypeArithmeticOperator var3, int var4, Types.TypeConditionOperatorRel var5, int var6);

    public void buildCtrPrimitive(String var1, XVariables.XVarInteger var2, Types.TypeUnaryArithmeticOperator var3, XVariables.XVarInteger var4);

    public void buildCtrPrimitive(String var1, XVariables.XVarInteger var2, Types.TypeArithmeticOperator var3, XVariables.XVarInteger var4, Types.TypeConditionOperatorRel var5, int var6);

    public void buildCtrPrimitive(String var1, XVariables.XVarInteger var2, Types.TypeArithmeticOperator var3, int var4, Types.TypeConditionOperatorRel var5, XVariables.XVarInteger var6);

    public void buildCtrPrimitive(String var1, XVariables.XVarInteger var2, Types.TypeArithmeticOperator var3, XVariables.XVarInteger var4, Types.TypeConditionOperatorRel var5, XVariables.XVarInteger var6);

    public void buildCtrLogic(String var1, Types.TypeLogicalOperator var2, XVariables.XVarInteger[] var3);

    public void buildCtrLogic(String var1, XVariables.XVarInteger var2, Types.TypeEqNeOperator var3, Types.TypeLogicalOperator var4, XVariables.XVarInteger[] var5);

    public void buildCtrExtension(String var1, XVariables.XVarInteger var2, int[] var3, boolean var4, Set<Types.TypeFlag> var5);

    public void buildCtrExtension(String var1, XVariables.XVarInteger[] var2, int[][] var3, boolean var4, Set<Types.TypeFlag> var5);

    public void buildCtrRegular(String var1, XVariables.XVarInteger[] var2, Object[][] var3, String var4, String[] var5);

    public void buildCtrMDD(String var1, XVariables.XVarInteger[] var2, Object[][] var3);

    public void buildCtrAllDifferent(String var1, XVariables.XVarInteger[] var2);

    public void buildCtrAllDifferentExcept(String var1, XVariables.XVarInteger[] var2, int[] var3);

    public void buildCtrAllDifferentList(String var1, XVariables.XVarInteger[][] var2);

    public void buildCtrAllDifferentMatrix(String var1, XVariables.XVarInteger[][] var2);

    public void buildCtrAllDifferent(String var1, XNodeParent<XVariables.XVarInteger>[] var2);

    public void buildCtrAllEqual(String var1, XVariables.XVarInteger[] var2);

    public void buildCtrOrdered(String var1, XVariables.XVarInteger[] var2, Types.TypeOperatorRel var3);

    public void buildCtrOrdered(String var1, XVariables.XVarInteger[] var2, int[] var3, Types.TypeOperatorRel var4);

    public void buildCtrOrdered(String var1, XVariables.XVarInteger[] var2, XVariables.XVarInteger[] var3, Types.TypeOperatorRel var4);

    public void buildCtrLex(String var1, XVariables.XVarInteger[][] var2, Types.TypeOperatorRel var3);

    public void buildCtrLexMatrix(String var1, XVariables.XVarInteger[][] var2, Types.TypeOperatorRel var3);

    public void buildCtrSum(String var1, XVariables.XVarInteger[] var2, Condition var3);

    public void buildCtrSum(String var1, XVariables.XVarInteger[] var2, int[] var3, Condition var4);

    public void buildCtrSum(String var1, XVariables.XVarInteger[] var2, XVariables.XVarInteger[] var3, Condition var4);

    public void buildCtrSum(String var1, XNodeParent<XVariables.XVarInteger>[] var2, int[] var3, Condition var4);

    public void buildCtrCount(String var1, XVariables.XVarInteger[] var2, int[] var3, Condition var4);

    public void buildCtrCount(String var1, XVariables.XVarInteger[] var2, XVariables.XVarInteger[] var3, Condition var4);

    public void buildCtrAtLeast(String var1, XVariables.XVarInteger[] var2, int var3, int var4);

    public void buildCtrAtMost(String var1, XVariables.XVarInteger[] var2, int var3, int var4);

    public void buildCtrExactly(String var1, XVariables.XVarInteger[] var2, int var3, int var4);

    public void buildCtrExactly(String var1, XVariables.XVarInteger[] var2, int var3, XVariables.XVarInteger var4);

    public void buildCtrAmong(String var1, XVariables.XVarInteger[] var2, int[] var3, int var4);

    public void buildCtrAmong(String var1, XVariables.XVarInteger[] var2, int[] var3, XVariables.XVarInteger var4);

    public void buildCtrNValues(String var1, XVariables.XVarInteger[] var2, Condition var3);

    public void buildCtrNValuesExcept(String var1, XVariables.XVarInteger[] var2, int[] var3, Condition var4);

    public void buildCtrNotAllEqual(String var1, XVariables.XVarInteger[] var2);

    public void buildCtrCardinality(String var1, XVariables.XVarInteger[] var2, boolean var3, int[] var4, XVariables.XVarInteger[] var5);

    public void buildCtrCardinality(String var1, XVariables.XVarInteger[] var2, boolean var3, int[] var4, int[] var5);

    public void buildCtrCardinality(String var1, XVariables.XVarInteger[] var2, boolean var3, int[] var4, int[] var5, int[] var6);

    public void buildCtrCardinality(String var1, XVariables.XVarInteger[] var2, boolean var3, XVariables.XVarInteger[] var4, XVariables.XVarInteger[] var5);

    public void buildCtrCardinality(String var1, XVariables.XVarInteger[] var2, boolean var3, XVariables.XVarInteger[] var4, int[] var5);

    public void buildCtrCardinality(String var1, XVariables.XVarInteger[] var2, boolean var3, XVariables.XVarInteger[] var4, int[] var5, int[] var6);

    public void buildCtrMaximum(String var1, XVariables.XVarInteger[] var2, Condition var3);

    public void buildCtrMaximum(String var1, XVariables.XVarInteger[] var2, int var3, XVariables.XVarInteger var4, Types.TypeRank var5, Condition var6);

    public void buildCtrMinimum(String var1, XVariables.XVarInteger[] var2, Condition var3);

    public void buildCtrMinimum(String var1, XVariables.XVarInteger[] var2, int var3, XVariables.XVarInteger var4, Types.TypeRank var5, Condition var6);

    public void buildCtrElement(String var1, XVariables.XVarInteger[] var2, XVariables.XVarInteger var3);

    public void buildCtrElement(String var1, XVariables.XVarInteger[] var2, int var3);

    public void buildCtrElement(String var1, XVariables.XVarInteger[] var2, int var3, XVariables.XVarInteger var4, Types.TypeRank var5, XVariables.XVarInteger var6);

    public void buildCtrElement(String var1, XVariables.XVarInteger[] var2, int var3, XVariables.XVarInteger var4, Types.TypeRank var5, int var6);

    public void buildCtrElement(String var1, int[] var2, int var3, XVariables.XVarInteger var4, Types.TypeRank var5, XVariables.XVarInteger var6);

    public void buildCtrChannel(String var1, XVariables.XVarInteger[] var2, int var3);

    public void buildCtrChannel(String var1, XVariables.XVarInteger[] var2, int var3, XVariables.XVarInteger[] var4, int var5);

    public void buildCtrChannel(String var1, XVariables.XVarInteger[] var2, int var3, XVariables.XVarInteger var4);

    public void buildCtrStretch(String var1, XVariables.XVarInteger[] var2, int[] var3, int[] var4, int[] var5);

    public void buildCtrStretch(String var1, XVariables.XVarInteger[] var2, int[] var3, int[] var4, int[] var5, int[][] var6);

    public void buildCtrNoOverlap(String var1, XVariables.XVarInteger[] var2, int[] var3, boolean var4);

    public void buildCtrNoOverlap(String var1, XVariables.XVarInteger[] var2, XVariables.XVarInteger[] var3, boolean var4);

    public void buildCtrNoOverlap(String var1, XVariables.XVarInteger[][] var2, int[][] var3, boolean var4);

    public void buildCtrNoOverlap(String var1, XVariables.XVarInteger[][] var2, XVariables.XVarInteger[][] var3, boolean var4);

    public void buildCtrCumulative(String var1, XVariables.XVarInteger[] var2, int[] var3, int[] var4, Condition var5);

    public void buildCtrCumulative(String var1, XVariables.XVarInteger[] var2, int[] var3, XVariables.XVarInteger[] var4, Condition var5);

    public void buildCtrCumulative(String var1, XVariables.XVarInteger[] var2, XVariables.XVarInteger[] var3, int[] var4, Condition var5);

    public void buildCtrCumulative(String var1, XVariables.XVarInteger[] var2, XVariables.XVarInteger[] var3, XVariables.XVarInteger[] var4, Condition var5);

    public void buildCtrCumulative(String var1, XVariables.XVarInteger[] var2, int[] var3, XVariables.XVarInteger[] var4, int[] var5, Condition var6);

    public void buildCtrCumulative(String var1, XVariables.XVarInteger[] var2, int[] var3, XVariables.XVarInteger[] var4, XVariables.XVarInteger[] var5, Condition var6);

    public void buildCtrCumulative(String var1, XVariables.XVarInteger[] var2, XVariables.XVarInteger[] var3, XVariables.XVarInteger[] var4, int[] var5, Condition var6);

    public void buildCtrCumulative(String var1, XVariables.XVarInteger[] var2, XVariables.XVarInteger[] var3, XVariables.XVarInteger[] var4, XVariables.XVarInteger[] var5, Condition var6);

    public void buildCtrInstantiation(String var1, XVariables.XVarInteger[] var2, int[] var3);

    public void buildCtrClause(String var1, XVariables.XVarInteger[] var2, XVariables.XVarInteger[] var3);

    public void buildCtrCircuit(String var1, XVariables.XVarInteger[] var2, int var3);

    public void buildCtrCircuit(String var1, XVariables.XVarInteger[] var2, int var3, int var4);

    public void buildCtrCircuit(String var1, XVariables.XVarInteger[] var2, int var3, XVariables.XVarInteger var4);

    public void buildBinPacking(String var1, XVariables.XVarInteger[] var2, int[] var3, Condition var4);

    public void buildBinPacking(String var1, XVariables.XVarInteger[] var2, int[] var3, Condition[] var4, int var5);

    public void buildObjToMinimize(String var1, XVariables.XVarInteger var2);

    public void buildObjToMaximize(String var1, XVariables.XVarInteger var2);

    public void buildObjToMinimize(String var1, XNodeParent<XVariables.XVarInteger> var2);

    public void buildObjToMaximize(String var1, XNodeParent<XVariables.XVarInteger> var2);

    public void buildObjToMinimize(String var1, Types.TypeObjective var2, XVariables.XVarInteger[] var3);

    public void buildObjToMaximize(String var1, Types.TypeObjective var2, XVariables.XVarInteger[] var3);

    public void buildObjToMinimize(String var1, Types.TypeObjective var2, XVariables.XVarInteger[] var3, int[] var4);

    public void buildObjToMaximize(String var1, Types.TypeObjective var2, XVariables.XVarInteger[] var3, int[] var4);

    public void buildVarSymbolic(XVariables.XVarSymbolic var1, String[] var2);

    public void buildCtrIntension(String var1, XVariables.XVarSymbolic[] var2, XNodeParent<XVariables.XVarSymbolic> var3);

    public void buildCtrExtension(String var1, XVariables.XVarSymbolic var2, String[] var3, boolean var4, Set<Types.TypeFlag> var5);

    public void buildCtrExtension(String var1, XVariables.XVarSymbolic[] var2, String[][] var3, boolean var4, Set<Types.TypeFlag> var5);

    public void buildCtrAllDifferent(String var1, XVariables.XVarSymbolic[] var2);

    public void buildAnnotationDecision(XVariables.XVarInteger[] var1);

    public static class Implem {
        public final CtrLoaderInteger ctrLoaderInteger;
        public final CtrLoaderSymbolic ctrLoaderSymbolic;
        public Map<XDomains.XDom, Object> cache4DomObject;
        public Map<Object, int[][]> cache4Tuples;
        public final Map<XCallbacksParameters, Object> currParameters;
        public Set<String> allIds;
        public Set<String> postedRecognizedCtrs;
        public static final Long CONVERSION_SPACE_LIMIT = new Long(1000000L);
        private int nextCtrId;
        private int nextLogId;

        public void rawParameters() {
            this.currParameters.clear();
            this.currParameters.put(XCallbacksParameters.CONVERT_INTENSION_TO_EXTENSION_ARITY_LIMIT, 0);
            this.currParameters.put(XCallbacksParameters.CONVERT_INTENSION_TO_EXTENSION_SPACE_LIMIT, CONVERSION_SPACE_LIMIT);
            this.currParameters.put(XCallbacksParameters.RECOGNIZING_BEFORE_CONVERTING, Boolean.TRUE);
        }

        private Map<XCallbacksParameters, Object> defaultParameters() {
            Object dummy = new Object();
            HashMap<XCallbacksParameters, Object> map = new HashMap<XCallbacksParameters, Object>();
            map.put(XCallbacksParameters.RECOGNIZE_UNARY_PRIMITIVES, dummy);
            map.put(XCallbacksParameters.RECOGNIZE_BINARY_PRIMITIVES, dummy);
            map.put(XCallbacksParameters.RECOGNIZE_TERNARY_PRIMITIVES, dummy);
            map.put(XCallbacksParameters.RECOGNIZE_LOGIC_CASES, dummy);
            map.put(XCallbacksParameters.RECOGNIZE_SUM_CASES, dummy);
            map.put(XCallbacksParameters.RECOGNIZE_EXTREMUM_CASES, dummy);
            map.put(XCallbacksParameters.RECOGNIZE_COUNT_CASES, dummy);
            map.put(XCallbacksParameters.RECOGNIZE_NVALUES_CASES, dummy);
            map.put(XCallbacksParameters.CONVERT_INTENSION_TO_EXTENSION_ARITY_LIMIT, 0);
            map.put(XCallbacksParameters.CONVERT_INTENSION_TO_EXTENSION_SPACE_LIMIT, CONVERSION_SPACE_LIMIT);
            map.put(XCallbacksParameters.RECOGNIZING_BEFORE_CONVERTING, Boolean.TRUE);
            return map;
        }

        public void resetStructures() {
            this.cache4DomObject = new HashMap<XDomains.XDom, Object>();
            this.cache4Tuples = new HashMap<Object, int[][]>();
            this.allIds = new HashSet<String>();
            this.postedRecognizedCtrs = new HashSet<String>();
        }

        public Implem(XCallbacks xc) {
            this.ctrLoaderInteger = new CtrLoaderInteger(xc);
            this.ctrLoaderSymbolic = new CtrLoaderSymbolic(xc);
            this.currParameters = this.defaultParameters();
            this.resetStructures();
        }

        private String manageIdFor(AnyEntry ae) {
            if (ae.id != null) {
                if (this.allIds.contains(ae.id)) {
                    throw new DuplicateIdException(ae.id);
                }
                if (Stream.of(Constants.KEYWORDS).anyMatch(k -> k.equals(ae.id))) {
                    throw new RuntimeException("The id " + ae.id + " is a keyword, and so cannot be used.");
                }
            }
            if (ae.id != null) {
                this.allIds.add(ae.id);
            } else {
                if (ae instanceof XConstraints.XCtr) {
                    while (this.allIds.contains("c_" + this.nextCtrId)) {
                        ++this.nextCtrId;
                    }
                    ae.id = "c_" + this.nextCtrId;
                    this.allIds.add(ae.id);
                    ++this.nextCtrId;
                }
                if (ae instanceof XConstraints.XLogic) {
                    while (this.allIds.contains("m_" + this.nextLogId)) {
                        ++this.nextLogId;
                    }
                    ae.id = "m_" + this.nextLogId;
                    this.allIds.add(ae.id);
                    ++this.nextLogId;
                }
            }
            return ae.id;
        }
    }

    public static enum XCallbacksParameters {
        RECOGNIZE_UNARY_PRIMITIVES,
        RECOGNIZE_BINARY_PRIMITIVES,
        RECOGNIZE_TERNARY_PRIMITIVES,
        RECOGNIZE_LOGIC_CASES,
        RECOGNIZE_EXTREMUM_CASES,
        RECOGNIZE_SUM_CASES,
        RECOGNIZE_COUNT_CASES,
        RECOGNIZE_NVALUES_CASES,
        CONVERT_INTENSION_TO_EXTENSION_ARITY_LIMIT,
        CONVERT_INTENSION_TO_EXTENSION_SPACE_LIMIT,
        RECOGNIZING_BEFORE_CONVERTING;

    }
}

