/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.problems;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.ProblemAPI;

public class Rack2
implements ProblemAPI {
    int nRacks;
    RackModel[] rackModels;
    CardType[] cardTypes;

    @Override
    public void model() {
        this.rackModels = this.addObject(this.rackModels, new RackModel(), 0);
        int nModels = this.rackModels.length;
        int nTypes = this.cardTypes.length;
        int[] powers = Stream.of(this.rackModels).mapToInt(r -> r.power).toArray();
        int[] connectors = Stream.of(this.rackModels).mapToInt(r -> r.nConnectors).toArray();
        int[] prices = Stream.of(this.rackModels).mapToInt(r -> r.price).toArray();
        int[] cardPowers = Stream.of(this.cardTypes).mapToInt(r -> r.power).toArray();
        int maxCapacity = IntStream.of(connectors).max().getAsInt();
        IVar.Var[] r2 = this.array("r", this.size(this.nRacks), this.dom(this.range(nModels)), "r[i] is the model used for the ith rack", new Types.TypeClass[0]);
        IVar.Var[][] c = this.array("c", this.size(this.nRacks, nTypes), (int i, int j) -> this.dom(this.range(0, Math.min(maxCapacity, this.cardTypes[j].demand))), "c[i][j] is the number of cards of type j put in the ith rack", new Types.TypeClass[0]);
        IVar.Var[] rpw = this.array("rpw", this.size(this.nRacks), this.dom(powers), "rpw[i] is the power of the ith rack", new Types.TypeClass[0]);
        IVar.Var[] rcn = this.array("rcn", this.size(this.nRacks), this.dom(connectors), "rcn[i] is the number of connectors of the ith rack", new Types.TypeClass[0]);
        IVar[] rpr = this.array("rpr", this.size(this.nRacks), this.dom(prices), "rpr[i] is the price of the ith rack", new Types.TypeClass[0]);
        this.forall(this.range(this.nRacks), (int i) -> this.extension((IVar.Var[])this.vars(r2[i], rpw[i]), this.number(powers))).note("linking the ith rack with its power");
        this.forall(this.range(this.nRacks), (int i) -> this.extension((IVar.Var[])this.vars(r2[i], rcn[i]), this.number(connectors))).note("linking the ith rack with its number of connectors");
        this.forall(this.range(this.nRacks), arg_0 -> this.lambda$model$7(r2, (IVar.Var[])rpr, prices, arg_0)).note("linking the ith rack with its price");
        this.forall(this.range(this.nRacks), (int i) -> this.sum(c[i], LE, rcn[i])).note("connector-capacity constraints");
        this.forall(this.range(this.nRacks), (int i) -> this.sum(c[i], cardPowers, LE, rpw[i])).note("power-capacity constraints");
        this.forall(this.range(nTypes), (int i) -> this.sum((IVar.Var[])this.columnOf(c, i), EQ, (long)this.cardTypes[i].demand)).note("demand constraints");
        this.block(() -> {
            this.decreasing(r2);
            this.intension(this.or(this.ne(r2[0], r2[1]), this.ge(c[0][0], c[1][0])));
        }).tag(SYMMETRY_BREAKING);
        this.minimize(SUM, rpr);
    }

    private /* synthetic */ void lambda$model$7(IVar.Var[] r, IVar.Var[] rpr, int[] prices, int i) {
        this.extension((IVar.Var[])this.vars(r[i], rpr[i]), this.number(prices));
    }

    class CardType {
        int power;
        int demand;

        CardType() {
        }
    }

    class RackModel {
        int power;
        int nConnectors;
        int price;

        RackModel() {
        }
    }
}

