/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.entities;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.parser.entries.AnyEntry;

public abstract class ModelingEntity {
    public String id;
    public String note;
    public Set<Types.TypeClass> classes;

    protected ModelingEntity(String id, String note, Types.TypeClass ... classes) {
        this.id = id;
        this.note = note;
        this.classes = new HashSet<Types.TypeClass>();
        if (classes != null) {
            Stream.of(classes).forEach(c -> this.classes.add((Types.TypeClass)c));
        }
    }

    protected ModelingEntity(Types.TypeClass ... classes) {
        this((String)null, (String)null, classes);
    }

    public ModelingEntity id(String id) {
        Utilities.control(this.id == null && id != null, "Pb with the id");
        this.id = id;
        return this;
    }

    public ModelingEntity note(String note) {
        this.note = this.note == null ? note : this.note + " " + note;
        return this;
    }

    public ModelingEntity tag(Types.TypeClass ... classes) {
        Stream.of(classes).forEach(c -> this.classes.add((Types.TypeClass)c));
        return this;
    }

    public ModelingEntity tag(String ... classes) {
        return this.tag(Types.TypeClass.classesFor(classes));
    }

    public ModelingEntity setBasicAttributes(AnyEntry entry) {
        if (entry.id != null) {
            Utilities.control(this.id == null, "Two different ids for the same entity");
            this.id = entry.id;
        }
        if (entry.note != null) {
            String string = this.note = this.note == null ? entry.note : this.note + " " + entry.note;
        }
        if (entry.classes != null) {
            Stream.of(entry.classes).forEach(c -> this.classes.add((Types.TypeClass)c));
        }
        return this;
    }

    public boolean nullBasicAttributes() {
        return !(this.id != null && this.id.length() != 0 || this.note != null && this.note.length() != 0 || this.classes.size() != 0);
    }

    public static interface TagDummy {
    }
}

