/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.definitions;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.definitions.ICtr;

public class DefXCSP {
    public String name;
    public List<AbstractMap.SimpleEntry<String, Object>> attributes = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
    public List<Son> sons = new ArrayList<Son>();
    public boolean possibleSimplification;
    public Map<String, Object> map;

    private String print(List<AbstractMap.SimpleEntry<String, Object>> list) {
        return list.size() == 0 ? "" : " (" + list.stream().map(a -> (String)a.getKey() + "='" + a.getValue() + "'").collect(Collectors.joining(" ")) + ")";
    }

    private boolean same(List<AbstractMap.SimpleEntry<String, Object>> list1, List<AbstractMap.SimpleEntry<String, Object>> list2) {
        return list1.size() == list2.size() && IntStream.range(0, list1.size()).allMatch(i -> ((String)((AbstractMap.SimpleEntry)list1.get(i)).getKey()).equals(((AbstractMap.SimpleEntry)list2.get(i)).getKey()) && ((AbstractMap.SimpleEntry)list1.get(i)).getValue().equals(((AbstractMap.SimpleEntry)list2.get(i)).getValue()));
    }

    public DefXCSP(String name, boolean possibleSimplification, Map<String, Object> map) {
        this.name = name;
        this.possibleSimplification = possibleSimplification;
        this.map = map;
    }

    public DefXCSP(String name, Map<String, Object> map) {
        this(name, true, map);
    }

    public DefXCSP(String name) {
        this(name, true, null);
    }

    public DefXCSP addChild(String name, Object content) {
        Utilities.control(content != null, "Pb");
        this.sons.add(new Son(name, content));
        return this;
    }

    public DefXCSP addChild(String name, Object content, String attName, Object attValue) {
        Utilities.control(content != null && attValue != null, "Pb");
        this.sons.add(new Son(name, content, attName, attValue));
        return this;
    }

    public DefXCSP add(String ... params) {
        Stream.of(params).filter(param -> this.map.get(param) != null).forEach(param -> this.sons.add(new Son((String)param, this.map.get(param))));
        return this;
    }

    public DefXCSP addConditional(String param) {
        return this.map.containsKey(param) ? this.add(param) : this;
    }

    public DefXCSP addListOrLifted() {
        String lifted;
        if (this.map.containsKey(ICtr.MATRIX)) {
            this.possibleSimplification = false;
            return this.add(ICtr.MATRIX);
        }
        String string = this.map.containsKey("lists") ? ICtr.LIST : (this.map.containsKey("sets") ? ICtr.SET : (lifted = this.map.containsKey("msets") ? ICtr.MSET : null));
        if (lifted == null) {
            return this.add(ICtr.LIST);
        }
        Stream.of((Object[])this.map.get(lifted + "s")).forEach(o -> this.addChild(lifted, o));
        return this;
    }

    public int[] differencesWith(DefXCSP def) {
        if (!this.name.equals(def.name) || this.attributes.size() != def.attributes.size() || this.sons.size() != def.sons.size() || this.possibleSimplification != def.possibleSimplification) {
            return null;
        }
        if (!this.same(this.attributes, def.attributes)) {
            return null;
        }
        if (IntStream.range(0, this.sons.size()).anyMatch(i -> !this.sons.get((int)i).name.equals(def.sons.get((int)i).name) || !this.same(this.sons.get((int)i).attributes, def.sons.get((int)i).attributes))) {
            return null;
        }
        return IntStream.range(0, this.sons.size()).filter(i -> !this.sons.get((int)i).content.toString().equals(def.sons.get((int)i).content.toString())).toArray();
    }

    public String toString() {
        return this.name + " : " + this.sons.stream().map(c -> c.toString()).collect(Collectors.joining(" ")) + this.print(this.attributes);
    }

    public class Son {
        public String name;
        public Object content;
        public List<AbstractMap.SimpleEntry<String, Object>> attributes = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();

        public Son(String name, Object content) {
            this.name = name;
            this.content = content;
        }

        public Son(String name, Object content, String attName, Object attValue) {
            this(name, content);
            this.addAttribute(attName, attValue);
        }

        public void addAttribute(String attName, Object attValue) {
            this.attributes.add(new AbstractMap.SimpleEntry<String, Object>(attName, attValue));
        }

        public String toString() {
            return this.name + " : " + this.content.toString() + DefXCSP.this.print(this.attributes);
        }
    }
}

