/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.structures;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Range;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Transition;

public class Transitions {
    private List<Transition> list = new ArrayList<Transition>();

    public static Transitions parse(String transitions) {
        Stream<String> st = Stream.of(transitions.trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L);
        Transitions ts = new Transitions();
        st.forEach(tok -> {
            String[] t = tok.split("\\s*,\\s*");
            Utilities.control(t.length == 3, "Pb with a transition, which is not formed of 3 pieces");
            ts.add(t[0], Utilities.isInteger(t[1]) ? Integer.valueOf(Integer.parseInt(t[1])) : t[1], t[2]);
        });
        return ts;
    }

    public Transitions add(Transition transition) {
        this.list.add(transition);
        return this;
    }

    public Transitions add(Stream<Transition> transitions) {
        transitions.forEach(t -> this.add((Transition)t));
        return this;
    }

    public Transitions add(String firstState, Object symbol, String secondState) {
        return this.add(new Transition(firstState, symbol, secondState));
    }

    public Transitions add(String firstState, int[] symbols, String secondState) {
        IntStream.of(symbols).forEach(v -> this.add(new Transition(firstState, v, secondState)));
        return this;
    }

    public Transitions add(String firstState, Range range, String secondState) {
        this.add(firstState, range.toArray(), secondState);
        return this;
    }

    public Transition[] toArray() {
        return (Transition[])this.list.stream().toArray(Transition[]::new);
    }
}

