/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.structures;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.common.structures.Table;

public class TableInteger
extends Table {
    private List<int[]> list = new ArrayList<int[]>();

    public static int[][] toOrdinaryTable(int[][] shortTable, int[][] values) {
        ArrayList<int[]> tuples = new ArrayList<int[]>();
        for (int[] t : shortTable) {
            int[] pos = IntStream.range(0, t.length).filter(i -> t[i] == 0x7FFFFFFE).toArray();
            if (pos.length == 0) {
                tuples.add((int[])t.clone());
                continue;
            }
            EnumerationCartesian ec = new EnumerationCartesian((int[][])IntStream.range(0, t.length).mapToObj(i -> {
                int[] nArray;
                if (t[i] == 0x7FFFFFFE) {
                    nArray = values[i];
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = t[i];
                }
                return nArray;
            }).toArray(x$0 -> new int[x$0][]));
            while (ec.hasNext()) {
                tuples.add((int[])ec.next().clone());
            }
        }
        return (int[][])tuples.stream().sorted(Utilities.lexComparatorInt).distinct().toArray(x$0 -> new int[x$0][]);
    }

    public static int[][] toOrdinaryTable(int[][] shortTable, int ... nValues) {
        return TableInteger.toOrdinaryTable(shortTable, (int[][])IntStream.of(nValues).mapToObj(i -> IntStream.range(0, i).toArray()).toArray(x$0 -> new int[x$0][]));
    }

    @Override
    public TableInteger positive(Boolean positive) {
        this.positive = positive;
        return this;
    }

    public TableInteger add(int ... tuple) {
        Utilities.control(tuple.length > 0, "A tuple of length 0 has been encoutered during parsing.\nThe syntax used for listing tuples is not correct.\nFor example, this should be (1,2)(2,1)(2,3) for an integer table and (a,b)(b,b)(c,a) for a symbolic table");
        Utilities.control(this.list.size() == 0 || this.list.get(0).length == tuple.length, "The tuple has a different length from those already recorded");
        this.list.add(tuple);
        return this;
    }

    public TableInteger add(int[] ... tuples) {
        Stream.of(tuples).forEach(t -> this.add((int)t));
        return this;
    }

    public TableInteger add(Stream<int[]> stream) {
        stream.forEach(t -> this.add((int)t));
        return this;
    }

    public TableInteger add(String s) {
        boolean b = this.controlStringRepresentationOfTuples(s);
        Utilities.control(b, "The specified string is not correct, as it does not correspond to a sequence of integer tuples");
        int[][] tuples = (int[][])Stream.of(s.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> Stream.of(tok.split("\\s*,\\s*")).mapToInt(v -> v.equals("*") ? 0x7FFFFFFE : Integer.parseInt(v)).toArray()).toArray(x$0 -> new int[x$0][]);
        Stream.of(tuples).forEach(tuple -> this.add((int)tuple));
        return this;
    }

    public int[][] toArray() {
        return (int[][])this.list.stream().sorted(Utilities.lexComparatorInt).distinct().toArray(x$0 -> new int[x$0][]);
    }

    public int[][] toOrdinaryTableArray(int[][] values) {
        return TableInteger.toOrdinaryTable(this.toArray(), values);
    }

    public int[][] toOrdinaryTableArray(int ... nValues) {
        return TableInteger.toOrdinaryTable(this.toArray(), nValues);
    }

    public String toString() {
        return this.list.stream().map(t -> Utilities.join(t)).collect(Collectors.joining("\n"));
    }
}

