/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.predicates;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.MatcherInterface;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParentSpecial;

public class XNodeParent<V extends IVar>
extends XNode<V> {
    private static Canonizer<?> canonizer;

    public boolean equals(Object obj) {
        if (!(obj instanceof XNodeParent)) {
            return false;
        }
        XNodeParent node = (XNodeParent)obj;
        return this.type == node.type && this.sons.length == node.sons.length && IntStream.range(0, this.sons.length).allMatch(i -> this.sons[i].equals(node.sons[i]));
    }

    @Override
    public int compareTo(XNode<V> obj) {
        if (this.type != obj.type) {
            return Integer.compare(this.type.ordinal(), obj.type.ordinal());
        }
        XNodeParent node = (XNodeParent)obj;
        if (this.sons.length < node.sons.length) {
            return -1;
        }
        if (this.sons.length > node.sons.length) {
            return 1;
        }
        return IntStream.range(0, this.sons.length).map(i -> this.sons[i].compareTo(node.sons[i])).filter(v -> v != 0).findFirst().orElse(0);
    }

    public XNodeParent(Types.TypeExpr type, XNode<V>[] sons) {
        super(type, sons);
        Utilities.control(sons.length > 0, "Pb with this node that should be a parent");
    }

    public XNodeParent(Types.TypeExpr type, List<XNode<V>> sons) {
        this(type, sons.toArray(new XNode[sons.size()]));
    }

    public XNodeParent(Types.TypeExpr type, XNode<V> son) {
        this(type, Arrays.asList(son));
    }

    public XNodeParent(Types.TypeExpr type, XNode<V> son1, XNode<V> son2) {
        this(type, Arrays.asList(son1, son2));
    }

    @Override
    public int size() {
        return 1 + Stream.of(this.sons).mapToInt(c -> c.size()).sum();
    }

    @Override
    public int maxParameterNumber() {
        return Stream.of(this.sons).mapToInt(c -> c.maxParameterNumber()).max().orElse(-1);
    }

    private Canonizer<V> canonizer() {
        if (canonizer != null) {
            return canonizer;
        }
        Canonizer can = new Canonizer();
        canonizer = can;
        return can;
    }

    @Override
    public XNode<V> canonization() {
        Types.TypeExpr type = this.type;
        Object[] sons = (XNode[])this.sons.clone();
        IntStream.range(0, sons.length).forEach(arg_0 -> XNodeParent.lambda$canonization$5((XNode[])sons, arg_0));
        if (type.isSymmetricOperator()) {
            Arrays.sort(sons);
        }
        if (sons.length == 2 && type.isUnsymmetricRelationalOperator() && (type.arithmeticInversion().ordinal() < type.ordinal() || type.arithmeticInversion().ordinal() == type.ordinal() && sons[0].compareTo(sons[1]) > 0)) {
            type = type.arithmeticInversion();
            Utilities.swap(sons, 0, 1);
        }
        if (sons.length == 1 && type.isIdentityWhenOneOperand()) {
            return sons[0];
        }
        XNodeParent node = XNodeParent.node(type, sons);
        Map.Entry rule = ((Canonizer)this.canonizer()).rules.entrySet().stream().filter(e -> ((MatcherInterface.Matcher)e.getKey()).matches(node)).findFirst().orElse(null);
        return rule != null ? ((XNode)((Function)rule.getValue()).apply(node)).canonization() : node;
    }

    private XNode<V> buildNewTreeUsing(Function<XNode<V>, XNode<V>> f) {
        return new XNodeParent<V>(this.type, Stream.of(this.sons).map(f).collect(Collectors.toList()));
    }

    @Override
    public XNode<V> abstraction(List<Object> args, boolean abstractIntegers, boolean multiOccurrences) {
        return this.buildNewTreeUsing(s -> s.abstraction(args, abstractIntegers, multiOccurrences));
    }

    @Override
    public XNode<V> concretization(Object[] args) {
        return this.buildNewTreeUsing(s -> s.concretization(args));
    }

    @Override
    public XNode<V> replaceSymbols(Map<String, Integer> mapOfSymbols) {
        return this.buildNewTreeUsing(s -> s.replaceSymbols(mapOfSymbols));
    }

    @Override
    public XNode<V> replaceLeafValues(Function<Object, Object> f) {
        return new XNodeParent<V>(this.type, Stream.of(this.sons).map(s -> s.replaceLeafValues(f)).collect(Collectors.toList()));
    }

    @Override
    public XNode<V> firstNodeSuchThat(Predicate<XNode<V>> p) {
        return p.test(this) ? this : (XNode)Stream.of(this.sons).map(son -> son.firstNodeSuchThat(p)).filter(o -> o != null).findFirst().orElse(null);
    }

    @Override
    public LinkedList<XNode<V>> allNodesSuchThat(Predicate<XNode<V>> p, LinkedList<XNode<V>> list) {
        if (p.test(this)) {
            list.add(this);
        }
        Stream.of(this.sons).forEach(s -> s.allNodesSuchThat(p, list));
        return list;
    }

    @Override
    public String toPostfixExpression(IVar[] scopeForAbstraction) {
        String s = Stream.of(this.sons).map(c -> c.toPostfixExpression(scopeForAbstraction)).collect(Collectors.joining(" "));
        return s + " " + (this.type == Types.TypeExpr.SET || this.sons.length > 2 && this.type != Types.TypeExpr.IF ? Integer.valueOf(this.sons.length) : "") + this.type.toString().toLowerCase();
    }

    @Override
    public String toFunctionalExpression(Object[] argsForConcretization) {
        String s = this instanceof XNodeParentSpecial ? ((XNodeParentSpecial)this).specialName : this.type.toString().toLowerCase();
        return s + "(" + Stream.of(this.sons).map(c -> c.toFunctionalExpression(argsForConcretization)).collect(Collectors.joining(",")) + ")";
    }

    private static /* synthetic */ void lambda$canonization$5(XNode[] sons, int i) {
        sons[i] = sons[i].canonization();
    }

    private static class Canonizer<W extends IVar> {
        private MatcherInterface.Matcher abs_sub = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.ABS, XNode.node(Types.TypeExpr.SUB, MatcherInterface.any, MatcherInterface.any)));
        private MatcherInterface.Matcher not_not = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.NOT, XNode.node(Types.TypeExpr.NOT, MatcherInterface.any)));
        private MatcherInterface.Matcher neg_neg = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.NEG, XNode.node(Types.TypeExpr.NEG, MatcherInterface.any)));
        private MatcherInterface.Matcher any_lt_k = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.LT, MatcherInterface.any, MatcherInterface.val));
        private MatcherInterface.Matcher k_lt_any = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.LT, MatcherInterface.val, MatcherInterface.any));
        private MatcherInterface.Matcher not_logop = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.NOT, MatcherInterface.anyc), (node, level) -> level == 1 && node.type.isLogicallyInvertible());
        private MatcherInterface.Matcher not_symrel_any = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.symop, MatcherInterface.not, MatcherInterface.any), (node, level) -> level == 0 && node.type.oneOf(Types.TypeExpr.EQ, Types.TypeExpr.NE));
        private MatcherInterface.Matcher any_symrel_not = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.symop, MatcherInterface.any, MatcherInterface.not), (node, level) -> level == 0 && node.type.oneOf(Types.TypeExpr.EQ, Types.TypeExpr.NE));
        private MatcherInterface.Matcher x_mul_k__eq_l = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, XNode.node(Types.TypeExpr.MUL, MatcherInterface.var, MatcherInterface.val), MatcherInterface.val));
        private MatcherInterface.Matcher flattenable = new MatcherInterface.Matcher(MatcherInterface.anyc, (node, level) -> level == 0 && node.type.oneOf(Types.TypeExpr.ADD, Types.TypeExpr.MUL, Types.TypeExpr.MIN, Types.TypeExpr.MAX, Types.TypeExpr.AND, Types.TypeExpr.OR) && Stream.of(node.sons).anyMatch(s -> s.type == node.type));
        private MatcherInterface.Matcher mergeable = new MatcherInterface.Matcher(MatcherInterface.anyc, (node, level) -> level == 0 && node.type.oneOf(Types.TypeExpr.ADD, Types.TypeExpr.MUL, Types.TypeExpr.MIN, Types.TypeExpr.MAX, Types.TypeExpr.AND, Types.TypeExpr.OR) && node.sons.length >= 2 && node.sons[node.sons.length - 1].type == Types.TypeExpr.LONG && node.sons[node.sons.length - 2].type == Types.TypeExpr.LONG);
        private MatcherInterface.Matcher sub_relop_sub = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.sub, MatcherInterface.sub));
        private MatcherInterface.Matcher any_relop_sub = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.any, MatcherInterface.sub));
        private MatcherInterface.Matcher sub_relop_any = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.sub, MatcherInterface.any));
        private MatcherInterface.Matcher any_add_val__relop__any_add_val = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.any_add_val, MatcherInterface.any_add_val));
        private MatcherInterface.Matcher var_add_val__relop__val = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var_add_val, MatcherInterface.val));
        private MatcherInterface.Matcher val__relop__var_add_val = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.val, MatcherInterface.var_add_val));
        private Map<MatcherInterface.Matcher, Function<XNodeParent<W>, XNode<W>>> rules = new LinkedHashMap<MatcherInterface.Matcher, Function<XNodeParent<W>, XNode<W>>>();

        private Canonizer() {
            this.rules.put(this.abs_sub, r -> XNode.node(Types.TypeExpr.DIST, r.sons[0].sons));
            this.rules.put(this.not_not, r -> r.sons[0].sons[0]);
            this.rules.put(this.neg_neg, r -> r.sons[0].sons[0]);
            this.rules.put(this.any_lt_k, r -> XNode.node(Types.TypeExpr.LE, r.sons[0], this.augment(r.sons[1], -1)));
            this.rules.put(this.k_lt_any, r -> XNode.node(Types.TypeExpr.LE, this.augment(r.sons[0], 1), r.sons[1]));
            this.rules.put(this.not_logop, r -> XNode.node(r.sons[0].type.logicalInversion(), r.sons[0].sons));
            this.rules.put(this.not_symrel_any, r -> XNode.node(r.type.logicalInversion(), r.sons[0].sons[0], r.sons[1]));
            this.rules.put(this.any_symrel_not, r -> XNode.node(r.type.logicalInversion(), r.sons[0], r.sons[1].sons[0]));
            this.rules.put(this.x_mul_k__eq_l, r -> r.val(1) % r.val(0) == 0 ? XNode.node(Types.TypeExpr.EQ, r.sons[0].sons[0], XNode.longLeaf(r.val(1) / r.val(0))) : XNode.longLeaf(0L));
            this.rules.put(this.flattenable, r -> {
                int l1 = r.sons.length;
                int pos = IntStream.range(0, l1).filter(i -> r.sons[i].type == r.type).findFirst().getAsInt();
                int l2 = r.sons[pos].sons.length;
                Stream list = IntStream.range(0, l1 - 1 + l2).mapToObj(j -> j < pos ? r.sons[j] : (j < pos + l2 ? r.sons[pos].sons[j - pos] : r.sons[j - l2 + 1]));
                return XNode.node(r.type, list);
            });
            this.rules.put(this.mergeable, r -> {
                XNode[] t = Arrays.copyOf(r.sons, r.arity() - 1);
                long v1 = r.sons[r.arity() - 1].val(0).intValue();
                long v2 = r.sons[r.arity() - 2].val(0).intValue();
                t[r.arity() - 2] = XNode.longLeaf(r.type == Types.TypeExpr.ADD ? v1 + v2 : (r.type == Types.TypeExpr.MUL ? v1 * v2 : (r.type.oneOf(Types.TypeExpr.MIN, Types.TypeExpr.AND) ? Math.min(v1, v2) : Math.max(v1, v2))));
                return XNode.node(r.type, t);
            });
            this.rules.put(this.sub_relop_sub, r -> XNode.node(r.type, XNode.node(Types.TypeExpr.ADD, r.sons[0].sons[0], r.sons[1].sons[1]), XNode.node(Types.TypeExpr.ADD, r.sons[1].sons[0], r.sons[0].sons[1])));
            this.rules.put(this.any_relop_sub, r -> XNode.node(r.type, XNode.node(Types.TypeExpr.ADD, r.sons[0], r.sons[1].sons[1]), r.sons[1].sons[0]));
            this.rules.put(this.sub_relop_any, r -> XNode.node(r.type, r.sons[0].sons[0], XNode.node(Types.TypeExpr.ADD, r.sons[1], r.sons[0].sons[1])));
            this.rules.put(this.any_add_val__relop__any_add_val, r -> XNode.node(r.type, XNode.node(Types.TypeExpr.ADD, r.sons[0].sons[0], XNode.longLeaf(r.sons[0].sons[1].val(0) - r.sons[1].sons[1].val(0))), r.sons[1].sons[0]));
            this.rules.put(this.var_add_val__relop__val, r -> XNode.node(r.type, r.sons[0].sons[0], XNode.longLeaf(r.sons[1].val(0) - r.sons[0].sons[1].val(0))));
            this.rules.put(this.val__relop__var_add_val, r -> XNode.node(r.type, XNode.longLeaf(r.sons[0].val(0) - r.sons[1].sons[1].val(0)), r.sons[1].sons[0]));
        }

        private XNode<W> augment(XNode<W> n, int offset) {
            ((XNodeLeaf)n).value = (long)n.val(0).intValue() + (long)offset;
            return n;
        }
    }
}

