/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.predicates;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.XNode;
import org.xcsp.parser.entries.XValues;

public final class XNodeLeaf<V extends IVar>
extends XNode<V> {
    public Object value;

    public boolean equals(Object obj) {
        if (!(obj instanceof XNodeLeaf)) {
            return false;
        }
        return this.type == ((XNodeLeaf)obj).type && this.value.equals(((XNodeLeaf)obj).value);
    }

    @Override
    public int compareTo(XNode<V> obj) {
        if (this.type != obj.type) {
            return Integer.compare(this.type.ordinal(), obj.type.ordinal());
        }
        XNodeLeaf leaf = (XNodeLeaf)obj;
        if (this.type == Types.TypeExpr.VAR) {
            return ((IVar)this.value).id().compareTo(((IVar)leaf.value).id());
        }
        if (this.type == Types.TypeExpr.PAR || this.type == Types.TypeExpr.LONG) {
            return Long.compare((Long)this.value, (Long)leaf.value);
        }
        if (this.type == Types.TypeExpr.SYMBOL) {
            return ((String)this.value).compareTo((String)leaf.value);
        }
        if (this.type == Types.TypeExpr.SET) {
            return 0;
        }
        throw new RuntimeException("Currently, this statement should not be reached.");
    }

    public XNodeLeaf(Types.TypeExpr type, Object value) {
        super(type, null);
        this.value = value;
        Utilities.control(type.arityMin == 0 && type.arityMax == 0 || type == Types.TypeExpr.SET || type == Types.TypeExpr.SPECIAL, "Pb with this node " + (Object)((Object)type));
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int maxParameterNumber() {
        return this.type == Types.TypeExpr.PAR ? ((Long)this.value).intValue() : -1;
    }

    @Override
    public XNode<V> canonization() {
        return new XNodeLeaf<V>(this.type, this.value);
    }

    @Override
    public XNode<V> abstraction(List<Object> args, boolean abstractIntegers, boolean multiOccurrences) {
        if (this.type == Types.TypeExpr.VAR) {
            int pos;
            int n = pos = multiOccurrences ? IntStream.range(0, args.size()).filter(i -> args.get(i) == this.value).findFirst().orElse(-1) : -1;
            if (pos != -1) {
                return new XNodeLeaf<V>(Types.TypeExpr.PAR, pos);
            }
            args.add(this.value);
            return new XNodeLeaf<V>(Types.TypeExpr.PAR, args.size() - 1);
        }
        if (this.type == Types.TypeExpr.LONG && abstractIntegers) {
            args.add(this.value);
            return new XNodeLeaf<V>(Types.TypeExpr.PAR, args.size() - 1);
        }
        return new XNodeLeaf<V>(this.type, this.value);
    }

    @Override
    public XNode<V> concretization(Object[] args) {
        if (this.type != Types.TypeExpr.PAR) {
            return new XNodeLeaf<V>(this.type, this.value);
        }
        Object arg = args[((Long)this.value).intValue()];
        if (arg instanceof Long) {
            return new XNodeLeaf<V>(Types.TypeExpr.LONG, arg);
        }
        if (arg instanceof XValues.Decimal) {
            return new XNodeLeaf<V>(Types.TypeExpr.DECIMAL, arg);
        }
        if (arg instanceof String) {
            return new XNodeLeaf<V>(Types.TypeExpr.SYMBOL, arg);
        }
        if (arg instanceof XNode) {
            return (XNode)arg;
        }
        return new XNodeLeaf<V>(Types.TypeExpr.VAR, arg);
    }

    @Override
    public XNode<V> replaceSymbols(Map<String, Integer> mapOfSymbols) {
        return this.type != Types.TypeExpr.SYMBOL ? new XNodeLeaf<V>(this.type, this.value) : new XNodeLeaf<V>(Types.TypeExpr.LONG, mapOfSymbols.get(this.value));
    }

    @Override
    public XNode<V> replaceLeafValues(Function<Object, Object> f) {
        return new XNodeLeaf<V>(this.type, f.apply(this.value));
    }

    @Override
    public XNode<V> firstNodeSuchThat(Predicate<XNode<V>> p) {
        return p.test(this) ? this : null;
    }

    @Override
    public LinkedList<XNode<V>> allNodesSuchThat(Predicate<XNode<V>> p, LinkedList<XNode<V>> list) {
        if (p.test(this)) {
            list.add(this);
        }
        return list;
    }

    @Override
    public String toPostfixExpression(IVar[] scopeForAbstraction) {
        if (this.type == Types.TypeExpr.VAR && scopeForAbstraction != null) {
            return "%" + IntStream.range(0, scopeForAbstraction.length).filter(i -> scopeForAbstraction[i] == this.value).findFirst().getAsInt();
        }
        return this.type == Types.TypeExpr.SET ? "0set" : this.value.toString();
    }

    @Override
    public String toFunctionalExpression(Object[] argsForConcretization) {
        if (this.type == Types.TypeExpr.PAR) {
            return argsForConcretization == null ? "%" + this.value.toString() : argsForConcretization[((Long)this.value).intValue()].toString();
        }
        return this.type == Types.TypeExpr.SET ? "set()" : this.value.toString();
    }
}

