/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.predicates;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.XNodeParent;

public class EvaluationManager {
    private static final Map<String, Class<?>> classMap = new HashMap();
    private static final Map<String, Integer> arityMap = new HashMap<String, Integer>();
    private static final Set<String> symmetricEvaluators = new HashSet<String>();
    private static final Set<String> associativeEvaluators = new HashSet<String>();
    public static final int SAMPLING_LIMIT = 1000;
    private XNodeParent<? extends IVar> tree;
    public Evaluator[] evaluators;
    private int top = -1;
    private long[] stack;
    private int[] shortCircuits;
    private int[] values;
    private int[] tmp = new int[1];
    Integer arity;

    public static Class<?> classOf(String tok) {
        return classMap.get(tok);
    }

    public static int arityOf(String tok) {
        Integer a = arityMap.get(tok);
        if (a != null) {
            return a;
        }
        int pos = IntStream.range(0, tok.length()).filter(i -> !Character.isDigit(tok.charAt(i))).findFirst().orElse(tok.length()) - 1;
        return pos == -1 || pos == tok.length() - 1 ? -1 : Integer.parseInt(tok.substring(0, pos + 1));
    }

    public static boolean isSymmetric(String tok) {
        return symmetricEvaluators.contains(tok);
    }

    public static boolean isAssociative(String tok) {
        return associativeEvaluators.contains(tok);
    }

    private Evaluator buildEvaluator(String tok, List<String> varNames) {
        try {
            if (tok.matches("^(-?)\\d+$")) {
                return new LongEvaluator(Long.parseLong(tok));
            }
            if (tok.startsWith("%")) {
                return new VariableEvaluator(Integer.parseInt(tok.substring(1)));
            }
            if (EvaluationManager.classOf(tok) != null) {
                return (Evaluator)EvaluationManager.classOf(tok).getDeclaredConstructor(EvaluationManager.class).newInstance(this);
            }
            int pos = IntStream.range(0, tok.length()).filter(i -> !Character.isDigit(tok.charAt(i))).findFirst().orElse(tok.length()) - 1;
            if (pos == -1) {
                int varPos = varNames.indexOf(tok);
                if (varPos == -1) {
                    varPos = varNames.size();
                    varNames.add(tok);
                }
                return new VariableEvaluator(varPos);
            }
            Evaluator evaluator = (Evaluator)EvaluationManager.classOf(tok.substring(pos + 1) + "x").getDeclaredConstructor(EvaluationManager.class).newInstance(this);
            evaluator.arity = Integer.parseInt(tok.substring(0, pos + 1));
            return evaluator;
        }
        catch (Exception e) {
            (e.getCause() == null ? e : e.getCause()).printStackTrace();
            return null;
        }
    }

    private void dealWithShortCircuits() {
        boolean useShortCircuits = true;
        if (!useShortCircuits) {
            return;
        }
        this.shortCircuits = new int[this.evaluators.length];
        useShortCircuits = false;
        for (int i = 0; i < this.evaluators.length - 1; ++i) {
            int j;
            if (this.evaluators[i] instanceof TagInteger) continue;
            int nbStackedElements = 1;
            for (j = i + 1; j < this.evaluators.length && (nbStackedElements += 1 - this.evaluators[j].arity) > 1; ++j) {
            }
            if (j == i + 1) continue;
            if (this.evaluators[j] instanceof OrEvaluator) {
                this.shortCircuits[i] = j + 1;
                useShortCircuits = true;
                continue;
            }
            if (!(this.evaluators[j] instanceof AndEvaluator)) continue;
            this.shortCircuits[i] = -j - 1;
            useShortCircuits = true;
        }
        if (!useShortCircuits) {
            this.shortCircuits = null;
        }
    }

    private void buildEvaluators() {
        ArrayList varNames = new ArrayList();
        this.evaluators = (Evaluator[])Stream.of(this.tree.toPostfixExpression(this.tree.vars()).split("\\s+")).map(s -> this.buildEvaluator((String)s, varNames)).peek(e -> e.fixArity()).toArray(Evaluator[]::new);
        this.dealWithShortCircuits();
        this.stack = new long[this.evaluators.length];
        assert (this.evaluators.length > 0);
        int[] allPositions = Stream.of(this.evaluators).filter(e -> e instanceof VariableEvaluator).mapToInt(e -> ((VariableEvaluator)e).position).distinct().sorted().toArray();
        Utilities.control(IntStream.range(0, allPositions.length).allMatch(i -> i == allPositions[i]), "");
        this.arity = allPositions.length;
    }

    public EvaluationManager(XNodeParent<? extends IVar> tree) {
        this.tree = tree;
        this.buildEvaluators();
    }

    public EvaluationManager(XNodeParent<? extends IVar> tree, Map<String, Integer> mapOfSymbols) {
        this(mapOfSymbols == null ? tree : (XNodeParent)tree.replaceSymbols(mapOfSymbols));
    }

    public final long evaluate(int[] values) {
        this.values = values;
        this.top = -1;
        if (this.shortCircuits == null) {
            for (Evaluator evaluator : this.evaluators) {
                evaluator.evaluate();
            }
        } else {
            int i = 0;
            while (i < this.evaluators.length) {
                this.evaluators[i].evaluate();
                if (this.shortCircuits[i] == 0) {
                    ++i;
                    continue;
                }
                if (this.shortCircuits[i] > 0) {
                    i = this.stack[this.top] == 1L ? this.shortCircuits[i] : i + 1;
                    continue;
                }
                i = this.stack[this.top] == 0L ? -this.shortCircuits[i] : i + 1;
            }
        }
        assert (this.top == 0) : "" + this.top;
        return this.stack[this.top];
    }

    public final int[][] generateTuples(int[][] domValues, Utilities.ModifiableBoolean positive, int limit) {
        ArrayList<int[]> supports = new ArrayList<int[]>();
        ArrayList<int[]> conflicts = new ArrayList<int[]>();
        int[] tupleIdx = new int[domValues.length];
        int[] tupleVal = new int[domValues.length];
        int cnt = 0;
        boolean hasNext = true;
        while (hasNext) {
            boolean consistent;
            for (int i = 0; i < tupleVal.length; ++i) {
                tupleVal[i] = domValues[i][tupleIdx[i]];
            }
            boolean bl = consistent = this.evaluate(tupleVal) == 1L;
            if (consistent && positive.value != Boolean.FALSE) {
                supports.add((int[])tupleVal.clone());
            }
            if (!consistent && positive.value != Boolean.TRUE) {
                conflicts.add((int[])tupleVal.clone());
            }
            if (positive.value == null && ++cnt > limit) {
                positive.value = supports.size() <= conflicts.size() ? Boolean.TRUE : Boolean.FALSE;
            }
            hasNext = false;
            for (int i = 0; !hasNext && i < tupleIdx.length; ++i) {
                if (tupleIdx[i] + 1 < domValues[i].length) {
                    int n = i;
                    tupleIdx[n] = tupleIdx[n] + 1;
                    hasNext = true;
                    continue;
                }
                tupleIdx[i] = 0;
            }
        }
        if (positive.value == null) {
            positive.value = supports.size() <= conflicts.size() ? Boolean.TRUE : Boolean.FALSE;
        }
        return positive.value != false ? (int[][])supports.toArray((T[])new int[0][]) : (int[][])conflicts.toArray((T[])new int[0][]);
    }

    public final int[][] generateTuples(int[][] domValues, Utilities.ModifiableBoolean positive) {
        return this.generateTuples(domValues, positive, 1000);
    }

    public final int[][] generateSupports(int[][] domValues) {
        return this.generateTuples(domValues, new Utilities.ModifiableBoolean(true));
    }

    public final int[][] generateConflicts(int[][] domValues) {
        return this.generateTuples(domValues, new Utilities.ModifiableBoolean(false));
    }

    public final long evaluate(int value) {
        this.tmp[0] = value;
        return this.evaluate(this.tmp);
    }

    public boolean controlArityOfEvaluators() {
        return Stream.of(this.evaluators).mapToInt(e -> 1 - e.arity).sum() == 1;
    }

    public boolean controlTypeOfEvaluators(boolean booleanType) {
        if (booleanType && !(this.evaluators[this.evaluators.length - 1] instanceof TagBoolean)) {
            return false;
        }
        if (!booleanType && !(this.evaluators[this.evaluators.length - 1] instanceof TagInteger)) {
            return false;
        }
        boolean[] booleanTypes = new boolean[this.evaluators.length];
        int top = -1;
        for (Evaluator evaluator : this.evaluators) {
            int j;
            if (evaluator instanceof TagArithmetic) {
                if (evaluator instanceof IfEvaluator) {
                    if (!booleanTypes[top] || booleanTypes[top - 1] || booleanTypes[top - 2]) {
                        return false;
                    }
                    top -= 3;
                } else {
                    for (j = 0; j < evaluator.arity; ++j) {
                        if (booleanTypes[top]) {
                            return false;
                        }
                        --top;
                    }
                }
            } else if (evaluator instanceof TagLogical) {
                for (j = 0; j < evaluator.arity; ++j) {
                    if (!booleanTypes[top]) {
                        return false;
                    }
                    --top;
                }
            } else if (evaluator instanceof TagRelational) {
                for (j = 0; j < evaluator.arity; ++j) {
                    if (booleanTypes[top]) {
                        return false;
                    }
                    --top;
                }
            }
            booleanTypes[++top] = evaluator instanceof TagBoolean;
        }
        return true;
    }

    static {
        for (Class cl : (Class[])Stream.of(EvaluationManager.class.getDeclaredClasses()).filter(c -> Evaluator.class.isAssignableFrom((Class<?>)c) && !Modifier.isAbstract(c.getModifiers())).toArray(Class[]::new)) {
            String evaluatorToken = cl.getSimpleName().substring(0, 1).toLowerCase() + cl.getSimpleName().substring(1, cl.getSimpleName().lastIndexOf(Evaluator.class.getSimpleName()));
            classMap.put(evaluatorToken, cl);
            int arity = -1;
            try {
                if (TagArity0.class.isAssignableFrom(cl)) {
                    arity = 0;
                }
                if (TagArity1.class.isAssignableFrom(cl)) {
                    arity = 1;
                }
                if (TagArity2.class.isAssignableFrom(cl)) {
                    arity = 2;
                }
                if (TagArity3.class.isAssignableFrom(cl)) {
                    arity = 3;
                }
                if (TagArityX.class.isAssignableFrom(cl)) {
                    arity = Integer.MAX_VALUE;
                }
                if (TagSymmetric.class.isAssignableFrom(cl)) {
                    symmetricEvaluators.add(evaluatorToken);
                }
                if (TagAssociative.class.isAssignableFrom(cl)) {
                    associativeEvaluators.add(evaluatorToken);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            Utilities.control(arity != -1, "Pb with arity");
            arityMap.put(evaluatorToken, arity);
        }
    }

    public class VariableEvaluator
    extends Evaluator
    implements TagArity0,
    TagTerminal,
    TagInteger {
        public final int position;

        public VariableEvaluator(int position) {
            this.position = position;
        }

        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[++((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.values[this.position];
        }
    }

    public class LongEvaluator
    extends Evaluator
    implements TagArity0,
    TagTerminal,
    TagInteger {
        public final long value;

        public LongEvaluator(long value) {
            this.value = value;
        }

        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[++((EvaluationManager)EvaluationManager.this).top] = this.value;
        }

        @Override
        public String toString() {
            return super.toString() + "(" + this.value + ")";
        }
    }

    public class TrueEvaluator
    extends Evaluator
    implements TagArity0,
    TagTerminal,
    TagBoolean {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[++((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class FalseEvaluator
    extends Evaluator
    implements TagArity0,
    TagTerminal,
    TagBoolean {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[++((EvaluationManager)EvaluationManager.this).top] = 0L;
        }
    }

    public class IfEvaluator
    extends Evaluator
    implements TagArity3,
    TagArithmetic {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= 2;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] == 1L ? EvaluationManager.this.stack[EvaluationManager.this.top + 1] : EvaluationManager.this.stack[EvaluationManager.this.top + 2];
        }
    }

    public class ImpEvaluator
    extends Evaluator
    implements TagArity2,
    TagLogical {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] == 0L || EvaluationManager.this.stack[EvaluationManager.this.top + 1] == 1L ? 1 : 0;
        }
    }

    public class IffxEvaluator
    extends Evaluator
    implements TagArityX,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            long value = EvaluationManager.this.stack[EvaluationManager.this.top];
            for (int i = 1; i < this.arity; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] == value) continue;
                ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                return;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class IffEvaluator
    extends Evaluator
    implements TagArity2,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] == EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class XorxEvaluator
    extends Evaluator
    implements TagArityX,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            int cnt = 0;
            for (int i = 0; i < this.arity; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] != 1L) continue;
                ++cnt;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = cnt % 2;
        }
    }

    public class XorEvaluator
    extends Evaluator
    implements TagArity2,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] + EvaluationManager.this.stack[EvaluationManager.this.top + 1] == 1L ? 1 : 0;
        }
    }

    public class OrxEvaluator
    extends Evaluator
    implements TagArityX,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            for (int i = 0; i < this.arity; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] != 1L) continue;
                ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
                return;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
        }
    }

    public class OrEvaluator
    extends Evaluator
    implements TagArity2,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.max(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class AndxEvaluator
    extends Evaluator
    implements TagArityX,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            for (int i = 0; i < this.arity; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] != 0L) continue;
                ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                return;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class AndEvaluator
    extends Evaluator
    implements TagArity2,
    TagLogical,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.min(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class NotEvaluator
    extends Evaluator
    implements TagArity1 {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L - EvaluationManager.this.stack[EvaluationManager.this.top];
        }
    }

    public class NotinEvaluator
    extends Evaluator
    implements TagArity2,
    TagSet,
    TagBoolean {
        @Override
        public void evaluate() {
            int arity = (int)EvaluationManager.this.stack[EvaluationManager.this.top--];
            EvaluationManager.this.top -= arity;
            long value = EvaluationManager.this.stack[EvaluationManager.this.top];
            for (int i = 1; i < arity + 1; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] != value) continue;
                ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                return;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class InEvaluator
    extends Evaluator
    implements TagArity2,
    TagSet,
    TagBoolean {
        @Override
        public void evaluate() {
            int arity = (int)EvaluationManager.this.stack[EvaluationManager.this.top--];
            EvaluationManager.this.top -= arity;
            long value = EvaluationManager.this.stack[EvaluationManager.this.top];
            for (int i = 1; i < arity + 1; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] != value) continue;
                ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
                return;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
        }
    }

    public class SetxEvaluator
    extends Evaluator
    implements TagArityX,
    TagSet {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[++((EvaluationManager)EvaluationManager.this).top] = this.arity;
        }
    }

    public class EqxEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            long value = EvaluationManager.this.stack[EvaluationManager.this.top];
            for (int i = 1; i < this.arity; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i] == value) continue;
                ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                return;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class EqEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] == EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class NexEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            for (int i = this.arity - 1; i > 0; --i) {
                for (int j = i - 1; j >= 0; --j) {
                    if (EvaluationManager.this.stack[EvaluationManager.this.top + i] != EvaluationManager.this.stack[EvaluationManager.this.top + j]) continue;
                    ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                    return;
                }
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class NeEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] != EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class GtxEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            for (int i = 1; i < this.arity; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i - 1] > EvaluationManager.this.stack[EvaluationManager.this.top + i]) continue;
                ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                return;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class GtEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] > EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class GexEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            for (int i = 1; i < this.arity; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i - 1] >= EvaluationManager.this.stack[EvaluationManager.this.top + i]) continue;
                ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                return;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class GeEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] >= EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class LexEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            for (int i = 1; i < this.arity; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i - 1] <= EvaluationManager.this.stack[EvaluationManager.this.top + i]) continue;
                ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                return;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class LeEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] <= EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class LtxEvaluator
    extends Evaluator
    implements TagArityX,
    TagRelational,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            for (int i = 1; i < this.arity; ++i) {
                if (EvaluationManager.this.stack[EvaluationManager.this.top + i - 1] < EvaluationManager.this.stack[EvaluationManager.this.top + i]) continue;
                ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 0L;
                return;
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = 1L;
        }
    }

    public class LtEvaluator
    extends Evaluator
    implements TagArity2,
    TagRelational {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] < EvaluationManager.this.stack[EvaluationManager.this.top + 1] ? 1 : 0;
        }
    }

    public class F2Evaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic {
        public ExternFunctionArity2 function;

        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = this.function.evaluate(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class F1Evaluator
    extends Evaluator
    implements TagArity1,
    TagArithmetic {
        public ExternFunctionArity1 function;

        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = this.function.evaluate(EvaluationManager.this.stack[EvaluationManager.this.top]);
        }
    }

    public static interface ExternFunctionArity2 {
        public long evaluate(long var1, long var3);
    }

    public static interface ExternFunctionArity1 {
        public long evaluate(long var1);
    }

    public class DistEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic,
    TagSymmetric {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.abs(EvaluationManager.this.stack[EvaluationManager.this.top] - EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class MaxxEvaluator
    extends Evaluator
    implements TagArityX,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            long max = EvaluationManager.this.stack[EvaluationManager.this.top];
            for (int i = 1; i < this.arity; ++i) {
                max = Math.max(max, EvaluationManager.this.stack[EvaluationManager.this.top + i]);
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = max;
        }
    }

    public class MaxEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.max(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class MinxEvaluator
    extends Evaluator
    implements TagArityX,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            long min = EvaluationManager.this.stack[EvaluationManager.this.top];
            for (int i = 1; i < this.arity; ++i) {
                min = Math.min(min, EvaluationManager.this.stack[EvaluationManager.this.top + i]);
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = min;
        }
    }

    public class MinEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.min(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class PowEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = (long)Math.pow(EvaluationManager.this.stack[EvaluationManager.this.top], EvaluationManager.this.stack[EvaluationManager.this.top + 1]);
        }
    }

    public class SqrEvaluator
    extends Evaluator
    implements TagArity1,
    TagArithmetic {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] * EvaluationManager.this.stack[EvaluationManager.this.top];
        }
    }

    public class ModEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] % EvaluationManager.this.stack[EvaluationManager.this.top + 1];
        }
    }

    public class DivEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] / EvaluationManager.this.stack[EvaluationManager.this.top + 1];
        }
    }

    public class MulxEvaluator
    extends Evaluator
    implements TagArityX,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            long product = EvaluationManager.this.stack[EvaluationManager.this.top];
            for (int i = 1; i < this.arity; ++i) {
                product *= EvaluationManager.this.stack[EvaluationManager.this.top + i];
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = product;
        }
    }

    public class MulEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] * EvaluationManager.this.stack[EvaluationManager.this.top + 1];
        }
    }

    public class SubEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] - EvaluationManager.this.stack[EvaluationManager.this.top + 1];
        }
    }

    public class AddxEvaluator
    extends Evaluator
    implements TagArityX,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top -= this.arity - 1;
            long sum = EvaluationManager.this.stack[EvaluationManager.this.top];
            for (int i = 1; i < this.arity; ++i) {
                sum += EvaluationManager.this.stack[EvaluationManager.this.top + i];
            }
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = sum;
        }
    }

    public class AddEvaluator
    extends Evaluator
    implements TagArity2,
    TagArithmetic,
    TagSymmetric,
    TagAssociative {
        @Override
        public void evaluate() {
            EvaluationManager.this.top--;
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = EvaluationManager.this.stack[EvaluationManager.this.top] + EvaluationManager.this.stack[EvaluationManager.this.top + 1];
        }
    }

    public class AbsEvaluator
    extends Evaluator
    implements TagArity1,
    TagArithmetic {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = Math.abs(EvaluationManager.this.stack[EvaluationManager.this.top]);
        }
    }

    public class NegEvaluator
    extends Evaluator
    implements TagArity1,
    TagArithmetic {
        @Override
        public void evaluate() {
            ((EvaluationManager)EvaluationManager.this).stack[((EvaluationManager)EvaluationManager.this).top] = -EvaluationManager.this.stack[EvaluationManager.this.top];
        }
    }

    public abstract class Evaluator {
        public int arity = -1;

        public void fixArity() {
            Utilities.control(this.arity == -1 || this instanceof TagArityX, "Pb with arity");
            if (this.arity == -1) {
                this.arity = this instanceof TagArity0 ? 0 : (this instanceof TagArity1 ? 1 : (this instanceof TagArity2 ? 2 : (this instanceof TagArity3 ? 3 : -1)));
            }
        }

        public abstract void evaluate();

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static interface TagArityX {
    }

    public static interface TagArity3 {
    }

    public static interface TagArity2 {
    }

    public static interface TagArity1 {
    }

    public static interface TagArity0 {
    }

    public static interface TagAssociative {
    }

    public static interface TagSymmetric {
    }

    public static interface TagTerminal {
    }

    public static interface TagSet {
    }

    public static interface TagRelational
    extends TagBoolean {
    }

    public static interface TagLogical
    extends TagBoolean {
    }

    public static interface TagArithmetic
    extends TagInteger {
    }

    public static interface TagInteger {
    }

    public static interface TagBoolean {
    }
}

