/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common;

import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;

public class Types {
    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name) {
        try {
            return Enum.valueOf(enumType, enumType == TypeCtr.class || enumType == TypeChild.class || enumType == TypeAtt.class ? name : name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static class SpecialClass
    implements TypeClass {
        private final String ccname;

        public SpecialClass(String name) {
            this.ccname = name;
        }

        @Override
        public String ccname() {
            return this.ccname;
        }

        public boolean equals(Object o) {
            return o instanceof SpecialClass && ((SpecialClass)o).ccname.equals(this.ccname);
        }

        public int hashCode() {
            return this.ccname.hashCode();
        }
    }

    public static enum StandardClass implements TypeClass
    {
        CHANNELING,
        CLUES,
        ROWS,
        COLUMNS,
        BLOCKS,
        DIAGONALS,
        SYMMETRY_BREAKING,
        REDUNDANT_CONSTRAINTS,
        NOGOODS;

        private final String ccname = Utilities.toCamelCase(super.name());

        @Override
        public String ccname() {
            return this.ccname;
        }
    }

    public static interface TypeClass {
        public String ccname();

        public static TypeClass[] classesFor(String ... classes) {
            return (TypeClass[])Stream.of(classes).map(s -> Stream.of(StandardClass.values()).map(c -> c).filter(c -> c.ccname().equals(s)).findFirst().orElse(new SpecialClass((String)s))).toArray(TypeClass[]::new);
        }

        public static boolean intersect(TypeClass[] t1, TypeClass[] t2) {
            return t1 != null && t2 != null && Stream.of(t1).anyMatch(c1 -> Stream.of(t2).anyMatch(c2 -> c1.ccname().equals(c2.ccname())));
        }

        public static boolean equivalent(Set<TypeClass> s1, Set<TypeClass> s2) {
            return s1 == null && s2 == null || s1 != null && s2 != null && s1.size() == s2.size() && s1.stream().allMatch(c1 -> s2.stream().anyMatch(c2 -> c1.ccname().equals(c2.ccname())));
        }
    }

    public static enum TypeOptimization {
        MIN,
        MAX;

    }

    public static enum TypeRank {
        FIRST,
        LAST,
        ANY;

    }

    public static enum TypeUpDown {
        UP,
        DOWN;

    }

    public static enum TypeCombination {
        LEXICO,
        PARETO;

    }

    public static enum TypeObjective {
        EXPRESSION,
        SUM,
        PRODUCT,
        MINIMUM,
        MAXIMUM,
        NVALUES,
        LEX;

    }

    public static enum TypeMeasure {
        VAR,
        DEC,
        VAL,
        EDIT;

    }

    public static enum TypeExpr {
        NEG(1),
        ABS(1),
        SQR(1),
        ADD(2, Integer.MAX_VALUE),
        SUB(2),
        MUL(2, Integer.MAX_VALUE),
        DIV(2),
        MOD(2),
        POW(2),
        DIST(2),
        MIN(2, Integer.MAX_VALUE),
        MAX(2, Integer.MAX_VALUE),
        LT(2),
        LE(2),
        GE(2),
        GT(2),
        NE(2, Integer.MAX_VALUE),
        EQ(2, Integer.MAX_VALUE),
        SET(0, Integer.MAX_VALUE),
        IN(2),
        NOTIN(2),
        NOT(1),
        AND(2, Integer.MAX_VALUE),
        OR(2, Integer.MAX_VALUE),
        XOR(2, Integer.MAX_VALUE),
        IFF(2, Integer.MAX_VALUE),
        IMP(2),
        IF(3),
        CARD(1),
        UNION(2, Integer.MAX_VALUE),
        INTER(2, Integer.MAX_VALUE),
        DIFF(2),
        SDIFF(2, Integer.MAX_VALUE),
        HULL(1),
        DJOINT(2),
        SUBSET(2),
        SUBSEQ(2),
        SUPSEQ(2),
        SUPSET(2),
        CONVEX(1),
        FDIV(2),
        FMOD(2),
        SQRT(1),
        NROOT(2),
        EXP(1),
        LN(1),
        LOG(2),
        SIN(1),
        COS(1),
        TAN(1),
        ASIN(1),
        ACOS(1),
        ATAN(1),
        SINH(1),
        COSH(1),
        TANH(1),
        VAR(0),
        PAR(0),
        LONG(0),
        RATIONAL(0),
        DECIMAL(0),
        SYMBOL(0),
        SPECIAL(0, Integer.MAX_VALUE);

        public final String lcname;
        public final int arityMin;
        public final int arityMax;

        private TypeExpr(int arityMin, int arityMax) {
            this.arityMin = arityMin;
            this.arityMax = arityMax;
            this.lcname = this.name().toLowerCase();
        }

        private TypeExpr(int arity) {
            this(arity, arity);
        }

        public boolean oneOf(TypeExpr ... types) {
            return Stream.of(types).anyMatch(t -> t == this);
        }

        public boolean notOneOf(TypeExpr ... types) {
            return Stream.of(types).noneMatch(t -> t == this);
        }

        public boolean isSymmetricOperator() {
            return this.oneOf(ADD, MUL, MIN, MAX, DIST, NE, EQ, SET, AND, OR, XOR, IFF, UNION, INTER, DJOINT);
        }

        public boolean isUnsymmetricRelationalOperator() {
            return this.oneOf(LT, LE, GE, GT);
        }

        public boolean isRelationalOperator() {
            return this.isUnsymmetricRelationalOperator() || this.oneOf(NE, EQ);
        }

        public boolean isArithmeticOperator() {
            return this.oneOf(ADD, SUB, MUL, DIV, MOD, POW, DIST);
        }

        public boolean isLogicalOperator() {
            return this.oneOf(AND, OR, XOR, IFF, IMP);
        }

        public boolean isIdentityWhenOneOperand() {
            return this.oneOf(ADD, MUL, MIN, MAX, EQ, AND, OR, XOR, IFF);
        }

        public TypeExpr arithmeticInversion() {
            return this == LT ? GT : (this == LE ? GE : (this == GE ? LE : (this == GT ? LT : (this == NE ? NE : (this == EQ ? EQ : null)))));
        }

        public TypeExpr logicalInversion() {
            return this == LT ? GE : (this == LE ? GT : (this == GE ? LT : (this == GT ? LE : (this == NE ? EQ : (this == EQ ? NE : (this == IN ? NOTIN : (this == NOTIN ? IN : (this == SUBSET ? SUPSEQ : (this == SUBSEQ ? SUPSET : (this == SUPSEQ ? SUBSET : (this == SUPSET ? SUBSEQ : null)))))))))));
        }

        public boolean isLogicallyInvertible() {
            return this.logicalInversion() != null;
        }

        public TypeConditionOperatorRel toRelop() {
            return this == LT ? TypeConditionOperatorRel.LT : (this == LE ? TypeConditionOperatorRel.LE : (this == GE ? TypeConditionOperatorRel.GE : (this == GT ? TypeConditionOperatorRel.GT : (this == EQ ? TypeConditionOperatorRel.EQ : (this == NE ? TypeConditionOperatorRel.NE : null)))));
        }

        public TypeConditionOperatorSet toSetop() {
            return this == IN ? TypeConditionOperatorSet.IN : (this == NOTIN ? TypeConditionOperatorSet.NOTIN : null);
        }

        public TypeArithmeticOperator toAriop() {
            return this == ADD ? TypeArithmeticOperator.ADD : (this == SUB ? TypeArithmeticOperator.SUB : (this == MUL ? TypeArithmeticOperator.MUL : (this == DIV ? TypeArithmeticOperator.DIV : (this == MOD ? TypeArithmeticOperator.MOD : (this == POW ? TypeArithmeticOperator.POW : (this == DIST ? TypeArithmeticOperator.DIST : null))))));
        }

        public TypeUnaryArithmeticOperator toUnaryAriop() {
            return this == ABS ? TypeUnaryArithmeticOperator.ABS : (this == NEG ? TypeUnaryArithmeticOperator.NEG : (this == SQR ? TypeUnaryArithmeticOperator.SQR : (this == NOT ? TypeUnaryArithmeticOperator.NOT : null)));
        }

        public TypeLogicalOperator toLogop() {
            return this == AND ? TypeLogicalOperator.AND : (this == OR ? TypeLogicalOperator.OR : (this == XOR ? TypeLogicalOperator.XOR : (this == IFF ? TypeLogicalOperator.IFF : (this == IMP ? TypeLogicalOperator.IMP : null))));
        }
    }

    public static enum TypeEqNeOperator {
        EQ,
        NE;

    }

    public static enum TypeLogicalOperator {
        AND,
        OR,
        XOR,
        IFF,
        IMP;

    }

    public static enum TypeUnaryArithmeticOperator {
        ABS,
        NEG,
        SQR,
        NOT;

    }

    public static enum TypeArithmeticOperator {
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        POW,
        DIST;

    }

    public static enum TypeOperatorSet {
        SUBSET,
        SUBSEQ,
        SUPSEQ,
        SUPSET;

    }

    public static enum TypeOperatorRel {
        LT,
        LE,
        GE,
        GT;


        public TypeOperatorRel arithmeticInversion() {
            return this == LT ? GT : (this == LE ? GE : (this == GE ? LE : LT));
        }

        public boolean isValidFor(long v1, long v2) {
            return this == LT ? v1 < v2 : (this == LE ? v1 <= v2 : (this == GE ? v1 >= v2 : v1 > v2));
        }

        public TypeExpr toTypeExpr() {
            return this == LT ? TypeExpr.LT : (this == LE ? TypeExpr.LE : (this == GE ? TypeExpr.GE : TypeExpr.GT));
        }
    }

    public static enum TypeOperator {
        LT,
        LE,
        GE,
        GT,
        SUBSET,
        SUBSEQ,
        SUPSEQ,
        SUPSET;


        public static TypeOperator valOf(String s) {
            return TypeOperator.valueOf(s.trim().toUpperCase());
        }

        public TypeOperatorRel toRel() {
            return this.isSet() ? null : (this == LT ? TypeOperatorRel.LT : (this == LE ? TypeOperatorRel.LE : (this == GE ? TypeOperatorRel.GE : TypeOperatorRel.GT)));
        }

        public boolean isSet() {
            return this == SUBSET || this == SUBSEQ || this == SUPSEQ || this == SUPSET;
        }
    }

    public static enum TypeConditionOperatorSet {
        IN,
        NOTIN;


        public boolean isValidFor(int v, long min, long max) {
            return this == IN ? min <= (long)v && (long)v <= max : (long)v < min || (long)v > max;
        }

        public boolean isValidFor(int v, int[] t) {
            return this == IN == IntStream.of(t).anyMatch(w -> v == w);
        }
    }

    public static enum TypeConditionOperatorRel {
        LT,
        LE,
        GE,
        GT,
        NE,
        EQ;


        public TypeConditionOperatorRel arithmeticInversion() {
            return this == LT ? GT : (this == LE ? GE : (this == GE ? LE : (this == GT ? LT : this)));
        }

        public boolean isValidFor(long v1, long v2) {
            return this == LT ? v1 < v2 : (this == LE ? v1 <= v2 : (this == GE ? v1 >= v2 : (this == GT ? v1 > v2 : (this == NE ? v1 != v2 : v1 == v2))));
        }

        public static TypeConditionOperatorRel valueFor(String s) {
            Utilities.control(s.equals("<") || s.equals("<=") || s.equals(">") || s.equals(">=") || s.equals("=") || s.equals("!="), "bad argument");
            return s.equals("<") ? LT : (s.equals("<=") ? LE : (s.equals(">") ? GT : (s.equals(">=") ? GE : (s.equals("=") ? EQ : NE))));
        }

        public boolean oneOf(TypeConditionOperatorRel ... types) {
            return Stream.of(types).anyMatch(t -> t == this);
        }
    }

    public static enum TypeConditionOperator {
        LT,
        LE,
        GE,
        GT,
        NE,
        EQ,
        IN,
        NOTIN;


        public TypeConditionOperatorRel toRel() {
            return this.isSet() ? null : (this == LT ? TypeConditionOperatorRel.LT : (this == LE ? TypeConditionOperatorRel.LE : (this == GE ? TypeConditionOperatorRel.GE : (this == GT ? TypeConditionOperatorRel.GT : (this == NE ? TypeConditionOperatorRel.NE : TypeConditionOperatorRel.EQ)))));
        }

        public TypeConditionOperatorSet toSet() {
            return !this.isSet() ? null : (this == IN ? TypeConditionOperatorSet.IN : TypeConditionOperatorSet.NOTIN);
        }

        public boolean isSet() {
            return this == IN || this == NOTIN;
        }
    }

    public static enum TypeLifting {
        LIST,
        SET,
        MSET;

    }

    public static enum TypeReification {
        FULL,
        HALF_FROM,
        HALF_TO;

    }

    public static enum TypeFlag {
        STARRED_TUPLES,
        UNCLEAN_TUPLES;

    }

    public static enum TypeAtt {
        format,
        type,
        id,
        CLASS,
        note,
        as,
        size,
        violationMeasure,
        violationParameters,
        defaultCost,
        violationCost,
        cost,
        reifiedBy,
        hreifiedFrom,
        hreifiedTo,
        closed,
        FOR,
        restriction,
        rank,
        startIndex,
        zeroIgnored,
        CASE,
        order,
        circular,
        offset,
        collect,
        violable,
        lb,
        ub,
        combination;


        public boolean isReifying() {
            return this == reifiedBy || this == hreifiedFrom || this == hreifiedTo;
        }

        public static TypeAtt valOf(String s) {
            return s.equals("class") ? CLASS : (s.equals("for") ? FOR : (s.equals("case") ? CASE : TypeAtt.valueOf(s)));
        }
    }

    public static enum TypeChild {
        list,
        set,
        mset,
        matrix,
        function,
        supports,
        conflicts,
        except,
        value,
        values,
        total,
        coeffs,
        condition,
        cost,
        operator,
        number,
        transitions,
        start,
        FINAL,
        terminal,
        rules,
        index,
        mapping,
        occurs,
        rowOccurs,
        colOccurs,
        widths,
        patterns,
        origins,
        lengths,
        ends,
        heights,
        machines,
        conditions,
        sizes,
        weights,
        profits,
        limit,
        size,
        root,
        image,
        graph,
        row;

    }

    public static enum TypeCtr {
        extension,
        intension,
        regular,
        grammar,
        mdd,
        allDifferent,
        allEqual,
        allDistant,
        ordered,
        lex,
        allIncomparable,
        sum,
        count,
        nValues,
        cardinality,
        balance,
        spread,
        deviation,
        sumCosts,
        stretch,
        noOverlap,
        cumulative,
        binPacking,
        knapsack,
        networkFlow,
        circuit,
        nCircuits,
        path,
        nPaths,
        tree,
        nTrees,
        arbo,
        nArbos,
        nCliques,
        clause,
        instantiation,
        allIntersecting,
        range,
        roots,
        partition,
        minimum,
        maximum,
        element,
        channel,
        permutation,
        precedence,
        and,
        or,
        not,
        iff,
        ifThen,
        ifThenElse,
        slide,
        seqbin,
        smart;


        public boolean isSliding() {
            return this == slide || this == seqbin;
        }

        public boolean isLogical() {
            return this == and || this == or || this == not || this == iff;
        }

        public boolean isControl() {
            return this == ifThen || this == ifThenElse;
        }

        public boolean isMeta() {
            return this.isSliding() || this.isLogical() || this.isControl();
        }

        public boolean oneOf(TypeCtr ... types) {
            return Stream.of(types).anyMatch(t -> t == this);
        }
    }

    public static enum TypeFramework {
        CSP,
        MAXCSP,
        COP,
        WCSP,
        FCSP,
        QCSP,
        QCSP_PLUS,
        QCOP,
        QCOP_PLUS,
        SCSP,
        SCOP,
        QSTR,
        TCSP,
        NCSP,
        NCOP,
        DisCSP,
        DisWCSP;

    }
}

