/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import org.xcsp.common.FunctionalInterfaces;
import org.xcsp.common.IVar;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.implementation.ProblemIMP;

public class Range
implements Iterable<Integer> {
    public final int minIncluded;
    public final int maxIncluded;
    public final int step;
    private ProblemIMP imp;

    public Range(int minIncluded, int maxIncluded, int step) {
        this.minIncluded = minIncluded;
        this.maxIncluded = maxIncluded;
        this.step = step;
        Utilities.control(step > 0, "Bad values of step : " + step);
    }

    public Range(int minIncluded, int maxIncluded) {
        this(minIncluded, maxIncluded, 1);
    }

    public Range(int length) {
        this(0, length - 1, 1);
    }

    public Rangesx2 range(int minIncluded, int maxIncluded, int step) {
        return new Rangesx2(this, new Range(minIncluded, maxIncluded, step));
    }

    public Rangesx2 range(int minIncluded, int maxIncluded) {
        return new Rangesx2(this, new Range(minIncluded, maxIncluded));
    }

    public Rangesx2 range(int length) {
        return new Rangesx2(this, new Range(length));
    }

    public boolean isBasic() {
        return this.minIncluded == 0 && this.step == 1;
    }

    public boolean contains(int i) {
        return this.minIncluded <= i && i <= this.maxIncluded && (i - this.minIncluded) % this.step == 0;
    }

    public int length() {
        return (this.maxIncluded - this.minIncluded + 1) / this.step;
    }

    public IntStream stream() {
        return IntStream.of(this.toArray());
    }

    public Range setImp(ProblemIMP imp) {
        this.imp = imp;
        return this;
    }

    public CtrEntities.CtrArray forall(IntConsumer c) {
        return this.imp.manageLoop(() -> this.execute(c));
    }

    public int[] select(FunctionalInterfaces.Intx1Predicate p) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 : this) {
            if (!p.test(i2)) continue;
            list.add(i2);
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    private <T> List<T> provideObjects(IntFunction<T> op, List<T> list) {
        for (int i : this) {
            T x = op.apply(i);
            if (x == null) continue;
            list.add(x);
        }
        return list;
    }

    public <T> T[] provideObjects(IntFunction<T> f) {
        return Utilities.convert(this.provideObjects(f, new ArrayList()));
    }

    public <T extends IVar> T[] provideVars(IntFunction<T> f) {
        return (IVar[])Utilities.convert(this.provideObjects(f, new ArrayList()));
    }

    public int[] provideVals(IntFunction<Integer> f) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 : this) {
            Integer v = f.apply(i2);
            if (v == null) continue;
            list.add(v);
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    public int[][] provideTuples(IntFunction<int[]> f) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int i : this) {
            int[] v = f.apply(i);
            if (v == null) continue;
            list.add(v);
        }
        return (int[][])list.stream().toArray(x$0 -> new int[x$0][]);
    }

    public int[] map(IntUnaryOperator op) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 : this) {
            list.add(op.applyAsInt(i2));
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    public int[] toArray() {
        return this.map(i -> i);
    }

    public void execute(IntConsumer c) {
        for (int i : this) {
            c.accept(i);
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int cursor;
            {
                this.cursor = Range.this.minIncluded;
            }

            @Override
            public boolean hasNext() {
                return this.cursor <= Range.this.maxIncluded;
            }

            @Override
            public Integer next() {
                assert (this.hasNext());
                int v = this.cursor;
                this.cursor += Range.this.step;
                return v;
            }
        };
    }

    public static class Rangesx5
    extends Ranges {
        private Rangesx5(Range range1, Range range2, Range range3, Range range4, Range range5) {
            super(new Range[]{range1, range2, range3, range4, range5});
        }

        private <T extends IVar> List<T> provideVars(FunctionalInterfaces.Intx5Function<T> op, List<T> list) {
            for (int i : this.items[0]) {
                new Rangesx4(this.items[1], this.items[2], this.items[3], this.items[4]).provideVars((j, k, l, m) -> (IVar)op.apply(i, j, k, l, m), list);
            }
            return list;
        }

        public <T extends IVar> T[] provideVars(FunctionalInterfaces.Intx5Function<T> f) {
            return (IVar[])Utilities.convert(this.provideVars(f, new ArrayList()));
        }

        public void execute(FunctionalInterfaces.Intx5Consumer c5) {
            for (int i : this.items[0]) {
                new Rangesx4(this.items[1], this.items[2], this.items[3], this.items[4]).execute((int j, int k, int l, int m) -> c5.accept(i, j, k, l, m));
            }
        }
    }

    public static class Rangesx4
    extends Ranges {
        private Rangesx4(Range range1, Range range2, Range range3, Range range4) {
            super(new Range[]{range1, range2, range3, range4});
        }

        public Rangesx5 range(int minIncluded, int maxIncluded, int step) {
            return new Rangesx5(this.items[0], this.items[1], this.items[2], this.items[3], new Range(minIncluded, maxIncluded, step));
        }

        public Rangesx5 range(int minIncluded, int maxIncluded) {
            return new Rangesx5(this.items[0], this.items[1], this.items[2], this.items[3], new Range(minIncluded, maxIncluded));
        }

        public Rangesx5 range(int length) {
            return new Rangesx5(this.items[0], this.items[1], this.items[2], this.items[3], new Range(length));
        }

        private <T extends IVar> List<T> provideVars(FunctionalInterfaces.Intx4Function<T> op, List<T> list) {
            for (int i : this.items[0]) {
                new Rangesx3(this.items[1], this.items[2], this.items[3]).provideVars((j, k, l) -> (IVar)op.apply(i, j, k, l), list);
            }
            return list;
        }

        public <T extends IVar> T[] provideVars(FunctionalInterfaces.Intx4Function<T> f) {
            return (IVar[])Utilities.convert(this.provideVars(f, new ArrayList()));
        }

        public void execute(FunctionalInterfaces.Intx4Consumer c4) {
            for (int i : this.items[0]) {
                new Rangesx3(this.items[1], this.items[2], this.items[3]).execute((int j, int k, int l) -> c4.accept(i, j, k, l));
            }
        }
    }

    public static class Rangesx3
    extends Ranges {
        private Rangesx3(Range range1, Range range2, Range range3) {
            super(new Range[]{range1, range2, range3});
        }

        public Rangesx4 range(int minIncluded, int maxIncluded, int step) {
            return new Rangesx4(this.items[0], this.items[1], this.items[2], new Range(minIncluded, maxIncluded, step));
        }

        public Rangesx4 range(int minIncluded, int maxIncluded) {
            return new Rangesx4(this.items[0], this.items[1], this.items[2], new Range(minIncluded, maxIncluded));
        }

        public Rangesx4 range(int length) {
            return new Rangesx4(this.items[0], this.items[1], this.items[2], new Range(length));
        }

        private <T> List<T> provideVars(FunctionalInterfaces.Intx3Function<T> f, List<T> list) {
            for (int i : this.items[0]) {
                new Rangesx2(this.items[1], this.items[2]).provideVars((j, k) -> f.apply(i, j, k), list);
            }
            return list;
        }

        public <T extends IVar> T[] provideVars(FunctionalInterfaces.Intx3Function<T> f) {
            return (IVar[])Utilities.convert(this.provideVars(f, new ArrayList()));
        }

        public void execute(FunctionalInterfaces.Intx3Consumer c3) {
            for (int i : this.items[0]) {
                new Rangesx2(this.items[1], this.items[2]).execute((int j, int k) -> c3.accept(i, j, k));
            }
        }
    }

    public static class Rangesx2
    extends Ranges {
        private Rangesx2(Range range1, Range range2) {
            super(new Range[]{range1, range2});
        }

        public Rangesx3 range(int minIncluded, int maxIncluded, int step) {
            return new Rangesx3(this.items[0], this.items[1], new Range(minIncluded, maxIncluded, step));
        }

        public Rangesx3 range(int minIncluded, int maxIncluded) {
            return new Rangesx3(this.items[0], this.items[1], new Range(minIncluded, maxIncluded));
        }

        public Rangesx3 range(int length) {
            return new Rangesx3(this.items[0], this.items[1], new Range(length));
        }

        public int[][] select(FunctionalInterfaces.Intx2Predicate p) {
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int i : this.items[0]) {
                for (int j : this.items[1]) {
                    if (!p.test(i, j)) continue;
                    list.add(new int[]{i, j});
                }
            }
            return (int[][])list.stream().toArray(x$0 -> new int[x$0][]);
        }

        private <T> List<T> provideVars(FunctionalInterfaces.Intx2Function<T> f, List<T> list) {
            for (int i : this.items[0]) {
                this.items[1].provideObjects(j -> f.apply(i, j), list);
            }
            return list;
        }

        public <T> T[] provideObjects(FunctionalInterfaces.Intx2Function<T> f) {
            return Utilities.convert(this.provideVars(f, new ArrayList()));
        }

        public <T extends IVar> T[] provideVars(FunctionalInterfaces.Intx2Function<T> f) {
            return (IVar[])Utilities.convert(this.provideVars(f, new ArrayList()));
        }

        public int[] provideVals(FunctionalInterfaces.Intx2Function<Integer> f) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i2 : this.items[0]) {
                for (int j : this.items[1]) {
                    Integer t = f.apply(i2, j);
                    if (t == null) continue;
                    list.add(t);
                }
            }
            return list.stream().mapToInt(i -> i).toArray();
        }

        public int[][] provideTuples(FunctionalInterfaces.Intx2Function<int[]> f) {
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int i : this.items[0]) {
                for (int j : this.items[1]) {
                    int[] t = f.apply(i, j);
                    if (t == null) continue;
                    list.add(t);
                }
            }
            return (int[][])list.stream().toArray(x$0 -> new int[x$0][]);
        }

        public int[][] map(IntBinaryOperator op) {
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int i : this.items[0]) {
                list.add(this.items[1].map((int j) -> op.applyAsInt(i, j)));
            }
            return (int[][])list.stream().toArray(x$0 -> new int[x$0][]);
        }

        public <T extends IVar> T[][] mapToVars(FunctionalInterfaces.Intx2Function<T> op) {
            ArrayList<IVar> list = new ArrayList<IVar>();
            for (int i2 : this.items[0]) {
                for (int j : this.items[1]) {
                    list.add((IVar)op.apply(i2, j));
                }
            }
            IVar first = list.stream().filter(o -> o != null).findFirst().orElse(null);
            Utilities.control(first != null, "At least one variable should have been generated");
            int n = this.items[0].length();
            int m = this.items[1].length();
            IVar[][] t = (IVar[][])Array.newInstance(first.getClass(), n, m);
            IntStream.range(0, n).forEach(i -> IntStream.range(0, m).forEach(j -> {
                t[i][j] = (IVar)list.get(i * m + j);
            }));
            return t;
        }

        public void execute(FunctionalInterfaces.Intx2Consumer c2) {
            for (int i : this.items[0]) {
                this.items[1].execute((int j) -> c2.accept(i, j));
            }
        }
    }

    private static abstract class Ranges {
        protected Range[] items;

        protected Ranges(Range[] items) {
            this.items = items;
        }

        public boolean contains(int ... tuple) {
            Utilities.control(tuple.length == this.items.length, "bad number of indexes");
            return IntStream.range(0, tuple.length).allMatch(i -> this.items[i].contains(tuple[i]));
        }
    }
}

