/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.checker;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.XCallbacks;
import org.xcsp.parser.XCallbacks2;
import org.xcsp.parser.XParser;
import org.xcsp.parser.entries.AnyEntry;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XVariables;

public class CompetitionScope
implements XCallbacks2 {
    private static final String INVALID = "invalid";
    private XCallbacks.Implem implem = new XCallbacks.Implem(this);
    private Boolean miniTrack;
    private boolean exceptionsVisible;
    private int nChecks;
    private List<String> errorFiles = new ArrayList<String>();
    private boolean currTestIsMiniTrack;
    private final String[] largeValidInstances = new String[]{"Nonogram-069-table.xml.lzma", "Nonogram-122-table.xml.lzma", "KnightTour-12-ext07.xml.lzma", "MagicSquare-6-table.xml.lzma"};
    private final String[] largeValidSeries = new String[]{"pigeonsPlus"};
    private boolean usePredefined = true;

    public static void main(String[] args) throws Exception {
        Boolean miniTrack = args.length > 0 && args[0].equals("-mini") ? Boolean.TRUE : (args.length > 0 && args[0].equals("-main") ? Boolean.FALSE : null);
        args = miniTrack != null ? Arrays.copyOfRange(args, 1, args.length) : args;
        boolean exceptionsVisible = args.length > 0 && args[args.length - 1].equals("-ev");
        String[] stringArray = args = exceptionsVisible ? Arrays.copyOfRange(args, 0, args.length - 1) : args;
        if (args.length != 1) {
            System.out.println("Usage: " + CompetitionScope.class.getName() + " [-mini | -main]  <instanceFilename | directoryName> [-ev]");
            System.out.println("  if -mini, then only instances that are valid for the mini track are checkes");
            System.out.println("  if -main, then only instances that are valid for the main track are checked");
            System.out.println("  if -ev, then exceptions are made visible");
            System.out.println("  if neither -mini nor -main, then all instances are displayed followed by two boolean values (the first one for the main track)");
        } else {
            new CompetitionScope(miniTrack, exceptionsVisible, args[0]);
        }
    }

    @Override
    public XCallbacks.Implem implem() {
        return this.implem;
    }

    private Boolean check(File f, boolean currTestIsMiniTrack) {
        assert (f.isFile() && (f.getName().endsWith(".xml") || f.getName().endsWith(".lzma")));
        this.currTestIsMiniTrack = currTestIsMiniTrack;
        ++this.nChecks;
        try {
            this.loadInstance(f.getAbsolutePath(), new String[0]);
        }
        catch (Throwable e) {
            this.errorFiles.add(f.getName());
            if (this.exceptionsVisible) {
                e.printStackTrace();
            }
            return e.getMessage().equals(INVALID) ? Boolean.FALSE : null;
        }
        return Boolean.TRUE;
    }

    private void checking(File f, boolean predefinelyValid) {
        if (this.exceptionsVisible) {
            System.out.println("Checking " + f + " " + this.miniTrack);
        }
        if (this.miniTrack == Boolean.TRUE && (predefinelyValid || this.check(f, true) == Boolean.TRUE)) {
            System.out.println(f.getAbsolutePath());
        } else if (this.miniTrack == Boolean.FALSE && (predefinelyValid || this.check(f, false) == Boolean.TRUE)) {
            System.out.println(f.getAbsolutePath());
        } else if (this.miniTrack == null) {
            System.out.println(f.getAbsolutePath() + "\t" + (predefinelyValid || this.check(f, false) == Boolean.TRUE) + "\t" + (predefinelyValid || this.check(f, true) == Boolean.TRUE));
        }
    }

    private void recursiveChecking(File file) {
        assert (file.isDirectory());
        Object[] files = file.listFiles();
        Arrays.sort(files);
        for (Object f : files) {
            if (((File)f).isDirectory()) {
                this.recursiveChecking((File)f);
                continue;
            }
            if (!((File)f).getName().endsWith(".xml") && !((File)f).getName().endsWith(".lzma")) continue;
            boolean b = this.usePredefined && (Stream.of(this.largeValidInstances).anyMatch(arg_0 -> CompetitionScope.lambda$recursiveChecking$0((File)f, arg_0)) || Stream.of(this.largeValidSeries).anyMatch(arg_0 -> CompetitionScope.lambda$recursiveChecking$1((File)f, arg_0)));
            this.checking((File)f, b);
        }
    }

    public CompetitionScope(Boolean miniTrack, boolean exceptionsVisible, String name) throws Exception {
        this.implem().rawParameters();
        File file = new File(name);
        if (!file.exists()) {
            System.out.println("File (or directory) not found : " + name);
        } else {
            this.miniTrack = miniTrack;
            this.exceptionsVisible = exceptionsVisible;
            if (file.isFile()) {
                this.checking(file, false);
            } else {
                this.recursiveChecking(file);
            }
        }
        System.out.println("  => The number of checks is " + this.nChecks);
        System.out.println("  => The number of errors is " + this.errorFiles.size());
        if (this.errorFiles.size() > 0) {
            this.errorFiles.stream().forEach(s -> System.out.println("    " + s));
        }
    }

    @Override
    public Object unimplementedCase(Object ... objects) {
        if (this.exceptionsVisible) {
            System.out.println("NOT VALID (wrt the competition)");
            System.out.println("\n\n**********************");
            StackTraceElement[] t = Thread.currentThread().getStackTrace();
            System.out.println("  Method " + t[2].getMethodName());
            System.out.println("  Class " + t[2].getClassName());
            System.out.println("  Line " + t[2].getLineNumber());
            System.out.println("**********************");
            System.out.println(Stream.of(objects).filter(o -> o != null).map(o -> o.toString()).collect(Collectors.joining("\n")));
        }
        throw new RuntimeException(INVALID);
    }

    private void unimplementedCaseIf(boolean test, Object ... objects) {
        if (test) {
            this.unimplementedCase(objects);
        }
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger x, int minValue, int maxValue) {
        this.unimplementedCaseIf((long)minValue < -2147483638L || (long)maxValue > 0x7FFFFFF5L, x.id);
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger x, int[] values) {
    }

    @Override
    public void loadVariables(XParser parser) {
        XCallbacks2.super.loadVariables(parser);
        for (AnyEntry.VEntry entry : parser.vEntries) {
            if (!(entry instanceof XVariables.XArray)) continue;
            this.unimplementedCaseIf(Stream.of(((XVariables.XArray)entry).vars).anyMatch(x -> x == null), "Undefined variables", entry);
        }
    }

    private boolean basicOperandsForMini(XNode<XVariables.XVarInteger>[] sons) {
        assert (sons.length == 2);
        return sons[0].type == Types.TypeExpr.VAR && sons[1].type == Types.TypeExpr.LONG || sons[0].type == Types.TypeExpr.LONG && sons[1].type == Types.TypeExpr.VAR || sons[0].type == Types.TypeExpr.VAR && sons[1].type == Types.TypeExpr.VAR;
    }

    private boolean complexOperandForMini(XNode<XVariables.XVarInteger> node) {
        return node.type.isArithmeticOperator() && node.type != Types.TypeExpr.POW && this.basicOperandsForMini(((XNodeParent)node).sons);
    }

    private boolean checkIntensionForMini(XNodeParent<XVariables.XVarInteger> tree) {
        return tree.type.isRelationalOperator() && tree.sons.length == 2 && (this.basicOperandsForMini(tree.sons) || this.complexOperandForMini(tree.sons[0]) && tree.sons[1].type == Types.TypeExpr.VAR || this.complexOperandForMini(tree.sons[1]) && tree.sons[0].type == Types.TypeExpr.VAR);
    }

    @Override
    public void buildCtrIntension(String id, XVariables.XVarInteger[] scope, XNodeParent<XVariables.XVarInteger> tree) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack && !this.checkIntensionForMini(tree), id, tree);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger x, int[] values, boolean positive, Set<Types.TypeFlag> flags) {
        this.unimplementedCaseIf(values.length == 0 || flags.contains((Object)Types.TypeFlag.STARRED_TUPLES), id);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger[] list, int[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        this.unimplementedCaseIf(tuples.length == 0 || this.currTestIsMiniTrack && !positive && flags.contains((Object)Types.TypeFlag.STARRED_TUPLES), id);
    }

    @Override
    public void buildCtrRegular(String id, XVariables.XVarInteger[] list, Object[][] transitions, String startState, String[] finalStates) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrMDD(String id, XVariables.XVarInteger[] list, Object[][] transitions) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrAllDifferent(String id, XVariables.XVarInteger[] list) {
    }

    @Override
    public void buildCtrAllDifferentExcept(String id, XVariables.XVarInteger[] list, int[] except) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || except.length != 1, id);
    }

    @Override
    public void buildCtrAllDifferentList(String id, XVariables.XVarInteger[][] lists) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrAllDifferentMatrix(String id, XVariables.XVarInteger[][] matrix) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrAllDifferent(String id, XNodeParent<XVariables.XVarInteger>[] trees) {
        assert (trees != null && trees.length > 0 && Stream.of(trees).anyMatch(t -> t == null)) : "bad formed trees";
        this.unimplementedCaseIf(this.currTestIsMiniTrack || Stream.of(trees).anyMatch(t -> t.type == Types.TypeExpr.VAR), id);
    }

    @Override
    public void buildCtrAllEqual(String id, XVariables.XVarInteger[] list) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, Types.TypeOperatorRel operator) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, int[] lengths, Types.TypeOperatorRel operator) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] lengths, Types.TypeOperatorRel operator) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrLex(String id, XVariables.XVarInteger[][] lists, Types.TypeOperatorRel operator) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrLexMatrix(String id, XVariables.XVarInteger[][] matrix, Types.TypeOperatorRel operator) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    private void checkCondition(String id, Condition condition) {
        if (condition instanceof Condition.ConditionSet) {
            this.unimplementedCaseIf(this.currTestIsMiniTrack || !(condition instanceof Condition.ConditionIntvl) || ((Condition.ConditionIntvl)condition).operator != Types.TypeConditionOperatorSet.IN, id);
        }
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.checkCondition(id, condition);
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, int[] coeffs, Condition condition) {
        this.checkCondition(id, condition);
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] coeffs, Condition condition) {
        this.checkCondition(id, condition);
    }

    @Override
    public void buildCtrSum(String id, XNodeParent<XVariables.XVarInteger>[] trees, int[] coeffs, Condition condition) {
        assert (trees != null && trees.length > 0 && Stream.of(trees).anyMatch(t -> t == null)) : "bad formed trees";
        this.unimplementedCaseIf(this.currTestIsMiniTrack || Stream.of(trees).anyMatch(t -> t.type == Types.TypeExpr.VAR), id);
        this.checkCondition(id, condition);
    }

    @Override
    public void buildCtrCount(String id, XVariables.XVarInteger[] list, int[] values, Condition condition) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
        this.checkCondition(id, condition);
    }

    @Override
    public void buildCtrCount(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] values, Condition condition) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrNValues(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || condition instanceof Condition.ConditionSet, id);
        Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
        boolean notAllEqual = op == Types.TypeConditionOperatorRel.GT && condition instanceof Condition.ConditionVal && ((Condition.ConditionVal)condition).k == 1L;
        this.unimplementedCaseIf(op != Types.TypeConditionOperatorRel.EQ && !notAllEqual, id);
    }

    @Override
    public void buildCtrNValuesExcept(String id, XVariables.XVarInteger[] list, int[] except, Condition condition) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || condition instanceof Condition.ConditionSet || except.length != 1, id);
        this.unimplementedCaseIf(((Condition.ConditionRel)condition).operator != Types.TypeConditionOperatorRel.EQ, id);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, XVariables.XVarInteger[] occurs) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occurs) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occursMin, int[] occursMax) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, XVariables.XVarInteger[] occurs) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occurs) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occursMin, int[] occursMax) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || condition instanceof Condition.ConditionSet, id);
        this.unimplementedCaseIf(((Condition.ConditionRel)condition).operator != Types.TypeConditionOperatorRel.EQ, id);
    }

    @Override
    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || condition instanceof Condition.ConditionSet, id);
        this.unimplementedCaseIf(((Condition.ConditionRel)condition).operator != Types.TypeConditionOperatorRel.EQ, id);
    }

    @Override
    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger value) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int value) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        this.unimplementedCaseIf(startIndex != 0 || rank != Types.TypeRank.ANY, id);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, int value) {
        this.unimplementedCaseIf(startIndex != 0 || rank != Types.TypeRank.ANY, id);
    }

    @Override
    public void buildCtrElement(String id, int[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        this.unimplementedCaseIf(startIndex != 0 || rank != Types.TypeRank.ANY, id);
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || startIndex != 0, id);
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list1, int startIndex1, XVariables.XVarInteger[] list2, int startIndex2) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || startIndex1 != 0 || startIndex2 != 0, id);
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger value) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || startIndex != 0, id);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, int[] lengths, boolean zeroIgnored) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || IntStream.of(lengths).anyMatch(v -> v == 0), id);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, boolean zeroIgnored) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, int[][] lengths, boolean zeroIgnored) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || Stream.of(lengths).anyMatch(t -> IntStream.of(t).anyMatch(v -> v == 0)), id);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, XVariables.XVarInteger[][] lengths, boolean zeroIgnored) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, int[] heights, Condition condition) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, int[] heights, Condition condition) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrInstantiation(String id, XVariables.XVarInteger[] list, int[] values) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack, id);
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex) {
        this.unimplementedCaseIf(this.currTestIsMiniTrack || startIndex != 0, id);
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex, int size) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger size) {
        this.unimplementedCase(id);
    }

    @Override
    public void beginSlide(XConstraints.XSlide s) {
        boolean simpleSlide = s.template instanceof XConstraints.XCtr && (((XConstraints.XCtr)s.template).type == Types.TypeCtr.intension || ((XConstraints.XCtr)s.template).type == Types.TypeCtr.extension);
        this.unimplementedCaseIf(this.currTestIsMiniTrack || s.lists.length != 1 || !simpleSlide, s);
    }

    @Override
    public void buildObjToMinimize(String id, XVariables.XVarInteger x) {
    }

    @Override
    public void buildObjToMaximize(String id, XVariables.XVarInteger x) {
    }

    @Override
    public void buildObjToMinimize(String id, XNodeParent<XVariables.XVarInteger> tree) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildObjToMaximize(String id, XNodeParent<XVariables.XVarInteger> tree) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.unimplementedCaseIf(type == Types.TypeObjective.PRODUCT || type == Types.TypeObjective.LEX, id);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.unimplementedCaseIf(type == Types.TypeObjective.PRODUCT || type == Types.TypeObjective.LEX, id);
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list, int[] coeffs) {
        this.unimplementedCaseIf(type == Types.TypeObjective.PRODUCT || type == Types.TypeObjective.LEX, id);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list, int[] coeffs) {
        this.unimplementedCaseIf(type == Types.TypeObjective.PRODUCT || type == Types.TypeObjective.LEX, id);
    }

    private static /* synthetic */ boolean lambda$recursiveChecking$1(File f, String s) {
        return f.getAbsolutePath().contains(s);
    }

    private static /* synthetic */ boolean lambda$recursiveChecking$0(File f, String s) {
        return f.getAbsolutePath().endsWith(s);
    }
}

