/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class XMLCommentPrintWriter
extends PrintWriter {
    private static final String BEGIN_COMMENT = "<!-- ";
    private static final String END_COMMENT = " -->";
    private boolean inComment = false;
    private boolean lastWasEOL = true;
    private List<String> dncPrefixes = new ArrayList<String>();

    public XMLCommentPrintWriter(Writer decorated) {
        super(decorated);
    }

    public void addDncPrefix(String prefix) {
        this.dncPrefixes.add(prefix);
    }

    @Override
    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        this.write(csq.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        this.write(csq.toString());
        return this;
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        String string = String.format(l, format, args);
        this.write(string);
        return this;
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        String string = String.format(format, args);
        this.write(string);
        return this;
    }

    @Override
    public void print(boolean b) {
        this.write(String.valueOf(b));
    }

    @Override
    public void print(char c) {
        this.write(String.valueOf(c));
    }

    @Override
    public void print(char[] s) {
        char[] cArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.write(c);
            ++n2;
        }
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void print(String s) {
        this.write(s);
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        String string = String.format(l, format, args);
        this.write(string);
        return this;
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        String string = String.format(format, args);
        this.write(string);
        return this;
    }

    @Override
    public void println() {
        this.endLine();
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.endLine();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.endLine();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.endLine();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.endLine();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.endLine();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.endLine();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.endLine();
    }

    @Override
    public void println(Object x) {
        this.print(x);
        this.endLine();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.endLine();
    }

    @Override
    public void write(char[] buf, int off, int len) {
        char[] buf2 = new char[len - off];
        System.arraycopy(buf, off, buf2, 0, len - off);
        this.write(buf2);
    }

    @Override
    public void write(char[] buf) {
        char[] cArray = buf;
        int n = buf.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.write(c);
            ++n2;
        }
    }

    @Override
    public void write(int c) {
        if ((char)c == '\n') {
            this.endLine();
            return;
        }
        if (this.manageNewlineCase(c) != null) {
            super.write(c);
        }
    }

    @Override
    public void write(String s, int off, int len) {
        this.write(s.substring(off, off + len));
    }

    @Override
    public void write(String s) {
        if (s.isEmpty()) {
            return;
        }
        int lfIndex = s.indexOf(10);
        while (lfIndex != -1) {
            this.println(s.substring(0, lfIndex));
            if (lfIndex == s.length() - 1) break;
            s = s.substring(lfIndex + 1);
            lfIndex = s.indexOf(10);
        }
        String dncPrefix = this.manageNewlineCase(s);
        if (dncPrefix != null) {
            s = s.substring(dncPrefix.length());
        }
        super.write(s, 0, s.length());
    }

    private String manageNewlineCase(int c) {
        return this.manageNewlineCase(Character.toString((char)c));
    }

    private String manageNewlineCase(String s) {
        if (!this.lastWasEOL) {
            return null;
        }
        this.lastWasEOL = false;
        for (String dncp : this.dncPrefixes) {
            if (!s.startsWith(dncp)) continue;
            return dncp;
        }
        super.write(BEGIN_COMMENT, 0, BEGIN_COMMENT.length());
        this.inComment = true;
        return null;
    }

    private void endLine() {
        if (this.inComment) {
            super.write(END_COMMENT, 0, END_COMMENT.length());
        }
        this.inComment = false;
        super.write(10);
        this.lastWasEOL = true;
    }
}

