/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import org.sat4j.AbstractLauncher;
import org.sat4j.csp.constraints3.ComparisonCtrBuilder;
import org.sat4j.csp.constraints3.ConnectionCtrBuilder;
import org.sat4j.csp.constraints3.CountingCtrBuilder;
import org.sat4j.csp.constraints3.ElementaryCtrBuilder;
import org.sat4j.csp.constraints3.GenericCtrBuilder;
import org.sat4j.csp.constraints3.LanguageCtrBuilder;
import org.sat4j.csp.constraints3.ObjBuilder;
import org.sat4j.csp.constraints3.SchedulingCtrBuilder;
import org.sat4j.csp.intension.CspToPBSolverDecorator;
import org.sat4j.csp.intension.ICspToSatEncoder;
import org.sat4j.csp.intension.IIntensionCtrEncoder;
import org.sat4j.csp.intension.IntensionCtrEncoderFactory;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.w3c.dom.Document;
import org.xcsp.common.Condition;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.XCallbacks;
import org.xcsp.parser.XCallbacks2;
import org.xcsp.parser.XParser;
import org.xcsp.parser.entries.AnyEntry;
import org.xcsp.parser.entries.XDomains;
import org.xcsp.parser.entries.XVariables;

public class XMLCSP3Reader
extends Reader
implements XCallbacks2 {
    private IPBSolver solver;
    private final ICspToSatEncoder cspToSatEncoder;
    private List<XVariables.XVar> allVars = new ArrayList<XVariables.XVar>();
    private boolean contradictionFound = false;
    private final IIntensionCtrEncoder intensionEnc;
    private ElementaryCtrBuilder elementaryCtrBuilder;
    private ComparisonCtrBuilder comparisonCtrBuilder;
    private ConnectionCtrBuilder connectionCtrBuilder;
    private SchedulingCtrBuilder schedulingCtrBuilder;
    private GenericCtrBuilder genericCtrBuilder;
    private CountingCtrBuilder countingCtrBuilder;
    private LanguageCtrBuilder languageCtrBuilder;
    private ObjBuilder objBuilder;
    private final AbstractLauncher launcher;
    private XCallbacks.Implem dataStructureImplementor = new XCallbacks.Implem(this);

    public XMLCSP3Reader(ISolver aSolver, AbstractLauncher launcher) {
        if (!(aSolver instanceof IPBSolver)) {
            throw new IllegalArgumentException("provided solver must have PB capabilities");
        }
        this.launcher = launcher;
        this.solver = new PseudoOptDecorator((IPBSolver)aSolver);
        this.solver.setVerbose(true);
        this.cspToSatEncoder = new CspToPBSolverDecorator(this.solver);
        this.intensionEnc = IntensionCtrEncoderFactory.getInstance().newDefault(this.cspToSatEncoder);
        this.elementaryCtrBuilder = new ElementaryCtrBuilder(this.intensionEnc);
        this.comparisonCtrBuilder = new ComparisonCtrBuilder(this.intensionEnc);
        this.connectionCtrBuilder = new ConnectionCtrBuilder(this.intensionEnc);
        this.schedulingCtrBuilder = new SchedulingCtrBuilder(this.intensionEnc);
        this.genericCtrBuilder = new GenericCtrBuilder(this.intensionEnc);
        this.countingCtrBuilder = new CountingCtrBuilder(this.intensionEnc);
        this.languageCtrBuilder = new LanguageCtrBuilder(this.cspToSatEncoder);
        this.objBuilder = new ObjBuilder(this.solver, this.intensionEnc);
    }

    public XMLCSP3Reader(ISolver aSolver) {
        this(aSolver, null);
    }

    @Override
    public void decode(int[] model, PrintWriter out) {
        out.print(this.decode(model));
    }

    @Override
    public String decode(int[] model) {
        if (this.launcher == null) {
            throw new IllegalStateException("decoding a model needs to know the solver state");
        }
        if (model.length == 0) {
            return "";
        }
        StringBuilder strModelBuffer = new StringBuilder();
        switch (this.launcher.getExitCode()) {
            case OPTIMUM_FOUND: {
                ObjectiveFunction obj = this.solver.getObjectiveFunction();
                BigInteger degree = obj.calculateDegree(this.solver);
                BigInteger offset = obj.getCorrectionOffset();
                BigInteger factor = obj.getCorrectionFactor();
                degree = degree.multiply(factor).add(offset);
                strModelBuffer.append("<instantiation type=\"optimum\" cost=\"").append(degree.toString()).append("\">\n");
                this.appendModel(strModelBuffer, model);
                strModelBuffer.append("v </instantiation>\n");
                break;
            }
            case UPPER_BOUND: 
            case SATISFIABLE: {
                strModelBuffer.append("<instantiation type=\"solution\">\n");
                this.appendModel(strModelBuffer, model);
                strModelBuffer.append("v </instantiation>\n");
                break;
            }
            case UNSATISFIABLE: {
                strModelBuffer.append("c ").append(" no model\n");
                break;
            }
            default: {
                strModelBuffer.append("c ").append(" unknown state\n");
            }
        }
        return strModelBuffer.toString();
    }

    private void appendModel(StringBuilder strModelBuffer, int[] model) {
        StringBuilder sbufList = new StringBuilder();
        sbufList.append("v \t<list> ");
        StringBuilder sbufValues = new StringBuilder();
        sbufValues.append("v \t<values> ");
        this.decodeModel(sbufList, sbufValues);
        sbufValues.append(" </values>\n");
        sbufList.append(" </list>\n");
        strModelBuffer.append((CharSequence)sbufList);
        strModelBuffer.append((CharSequence)sbufValues);
    }

    public String decodeModelAsValueSequence(int[] model) {
        StringBuilder sbufValues = new StringBuilder();
        int i = 0;
        while (i < this.allVars.size()) {
            if (i > 0) {
                sbufValues.append(' ');
            }
            XVariables.XVar xvar = this.allVars.get(i);
            this.appendVarValue(sbufValues, xvar, model);
            ++i;
        }
        return sbufValues.toString();
    }

    public boolean discardModel(int[] model) {
        ArrayList<Integer> cl = new ArrayList<Integer>();
        for (XVariables.XVar xvar : this.allVars) {
            int[] domain = this.cspToSatEncoder.getCspVarDomain(xvar.id);
            int i = 0;
            while (i < domain.length) {
                int solverVar = this.cspToSatEncoder.getSolverVar(xvar.id, domain[i]);
                if (model[solverVar - 1] > 0) {
                    cl.add(-solverVar);
                }
                ++i;
            }
        }
        int[] clArray = new int[cl.size()];
        int i = 0;
        while (i < clArray.length) {
            clArray[i] = (Integer)cl.get(i);
            ++i;
        }
        return this.cspToSatEncoder.addClause(clArray);
    }

    public Map<String, String> decodeTerm(int[] term) {
        Map<Integer, String> litMapping = this.getMapping();
        String[] instantiations = (String[])Arrays.stream(term).filter(i -> i > 0).sorted().mapToObj(litMapping::get).filter(Objects::nonNull).toArray(String[]::new);
        return Arrays.stream(instantiations).map(s -> s.split("=")).collect(Collectors.toMap(t -> t[0], t -> t[1]));
    }

    public int getSolverVar(String str, Integer value) {
        return this.cspToSatEncoder.getSolverVar(str, value);
    }

    private void decodeModel(StringBuilder sbufList, StringBuilder sbufValues) {
        int[] model = this.solver.model();
        int i = 0;
        while (i < this.allVars.size()) {
            if (i > 0) {
                sbufList.append(' ');
                sbufValues.append(' ');
            }
            XVariables.XVar xvar = this.allVars.get(i);
            sbufList.append(xvar.id());
            this.appendVarValue(sbufValues, xvar, model);
            ++i;
        }
    }

    private void appendVarValue(StringBuilder buffer, XVariables.XVar xvar, int[] model) {
        int[] domain = this.cspToSatEncoder.getCspVarDomain(xvar.id);
        if (domain == null) {
            buffer.append(((XDomains.XDomInteger)xvar.dom).firstValue());
        } else {
            int j = 0;
            while (j < domain.length) {
                if (model[this.cspToSatEncoder.getSolverVar(xvar.id, domain[j]) - 1] > 0) {
                    buffer.append(domain[j]);
                    break;
                }
                ++j;
            }
        }
    }

    @Override
    public boolean hasAMapping() {
        return true;
    }

    @Override
    public Map<Integer, String> getMapping() {
        return this.cspToSatEncoder.getMapping();
    }

    @Override
    public boolean isUsingMapping() {
        return true;
    }

    @Override
    public IProblem parseInstance(InputStream in) throws ParseFormatException, ContradictionException, IOException {
        this.implem().currParameters.remove((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_UNARY_PRIMITIVES);
        this.implem().currParameters.remove((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_BINARY_PRIMITIVES);
        this.implem().currParameters.remove((Object)XCallbacks.XCallbacksParameters.RECOGNIZE_TERNARY_PRIMITIVES);
        try {
            this.loadInstance(in);
            if (System.getProperty("justRead") != null) {
                System.out.println("c the solver has been set to exit after reading. Exiting now with \"SUCCESS\" status code.");
                System.exit(0);
            }
        }
        catch (IOException | ParseFormatException | ContradictionException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Logger.getLogger("org.sat4j.csp").log(Level.INFO, "Runtime exception", e);
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger("org.sat4j.csp").log(Level.INFO, "Exception", e);
        }
        if (this.contradictionFound) {
            throw new ContradictionException();
        }
        return this.solver;
    }

    public void loadInstance(InputStream in) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        XParser parser = new XParser(document, new String[0]);
        this.beginInstance(parser.typeFramework);
        this.beginVariables(parser.vEntries);
        this.loadVariables(parser);
        this.endVariables();
        this.beginConstraints(parser.cEntries);
        this.loadConstraints(parser);
        this.endConstraints();
        this.beginObjectives(parser.oEntries, parser.typeCombination);
        this.loadObjectives(parser);
        this.endObjectives();
        this.endInstance();
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger var, int minValue, int maxValue) {
        this.cspToSatEncoder.newCspVar(var, minValue, maxValue);
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger var, int[] values) {
        this.cspToSatEncoder.newCspVar(var, values);
    }

    @Override
    public void beginVariables(List<AnyEntry.VEntry> vEntries) {
        for (AnyEntry.VEntry entry : vEntries) {
            this.manageEntry(entry);
        }
    }

    @Override
    public void beginObjectives(List<AnyEntry.OEntry> oEntries, Types.TypeCombination objCombination) {
        XCallbacks2.super.beginObjectives(oEntries, objCombination);
        this.objBuilder.setCombination(objCombination);
    }

    @Override
    public void endObjectives() {
        XCallbacks2.super.endObjectives();
        this.solver = new PseudoOptDecorator(this.objBuilder.composeObjectives());
    }

    private void manageEntry(AnyEntry.VEntry entry) {
        if (entry instanceof XVariables.XArray) {
            XVariables.XArray array = (XVariables.XArray)entry;
            XVariables.XVar[] xVarArray = array.vars;
            int n = array.vars.length;
            int n2 = 0;
            while (n2 < n) {
                XVariables.XVar subEntry = xVarArray[n2];
                this.manageEntry(subEntry);
                ++n2;
            }
        } else {
            this.allVars.add((XVariables.XVar)entry);
        }
    }

    @Override
    public void buildCtrFalse(String id, XVariables.XVar[] list) {
        this.contradictionFound = true;
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger x, int[] values, boolean positive, Set<Types.TypeFlag> flags) {
        this.contradictionFound |= this.genericCtrBuilder.buildCtrExtension(id, x, values, positive, flags);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger[] list, int[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        this.contradictionFound |= this.genericCtrBuilder.buildCtrExtension(id, list, tuples, positive, flags);
    }

    @Override
    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeConditionOperatorRel op, int k) {
    }

    @Override
    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeArithmeticOperator opa, XVariables.XVarInteger y, Types.TypeConditionOperatorRel op, int k) {
    }

    @Override
    public void buildCtrIntension(String id, XVariables.XVarInteger[] xscope, XNodeParent<XVariables.XVarInteger> syntaxTreeRoot) {
        this.contradictionFound |= this.genericCtrBuilder.buildCtrIntension(id, xscope, syntaxTreeRoot);
    }

    @Override
    public void buildCtrAllDifferent(String id, XVariables.XVarInteger[] list) {
        this.contradictionFound |= this.comparisonCtrBuilder.buildCtrAllDifferent(list);
    }

    @Override
    public void buildCtrAllDifferentList(String id, XVariables.XVarInteger[][] lists) {
        this.contradictionFound |= this.comparisonCtrBuilder.buildCtrAllDifferentList(id, lists);
    }

    @Override
    public void buildCtrAllDifferentExcept(String id, XVariables.XVarInteger[] list, int[] except) {
        this.contradictionFound |= this.comparisonCtrBuilder.buildCtrAllDifferentExcept(id, list, except);
    }

    @Override
    public void buildCtrAllDifferentMatrix(String id, XVariables.XVarInteger[][] matrix) {
        this.contradictionFound |= this.comparisonCtrBuilder.buildCtrAllDifferentMatrix(id, matrix);
    }

    @Override
    public void buildObjToMinimize(String id, XVariables.XVarInteger x) {
        this.objBuilder.buildObjToMinimize(id, x);
    }

    @Override
    public void buildObjToMaximize(String id, XVariables.XVarInteger x) {
        this.objBuilder.buildObjToMaximize(id, x);
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] xlist, int[] xcoeffs) {
        this.objBuilder.buildObjToMinimize(id, type, xlist, xcoeffs);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] xlist, int[] xcoeffs) {
        this.objBuilder.buildObjToMaximize(id, type, xlist, xcoeffs);
    }

    @Override
    public void buildObjToMinimize(String id, XNodeParent<XVariables.XVarInteger> syntaxTreeRoot) {
        this.objBuilder.buildObjToMinimize(id, syntaxTreeRoot);
    }

    @Override
    public void buildObjToMaximize(String id, XNodeParent<XVariables.XVarInteger> syntaxTreeRoot) {
        this.objBuilder.buildObjToMaximize(id, syntaxTreeRoot);
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.objBuilder.buildObjToMinimize(id, type, list);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.objBuilder.buildObjToMaximize(id, type, list);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, int[] lengths, boolean zeroIgnored) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrNoOverlap(id, origins, lengths, zeroIgnored);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, int[][] lengths, boolean zeroIgnored) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrNoOverlap(id, origins, lengths, zeroIgnored);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, boolean zeroIgnored) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrNoOverlap(id, origins, lengths, zeroIgnored);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, XVariables.XVarInteger[][] lengths, boolean zeroIgnored) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrNoOverlap(id, origins, lengths, zeroIgnored);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, Types.TypeOperatorRel operator) {
        this.contradictionFound |= this.comparisonCtrBuilder.buildCtrOrdered(id, list, operator);
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrSum(id, list, condition);
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, int[] coeffs, Condition condition) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrSum(id, list, coeffs, condition);
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] coeffs, Condition condition) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrSum(id, list, coeffs, condition);
    }

    @Override
    public void buildCtrLex(String id, XVariables.XVarInteger[][] lists, Types.TypeOperatorRel operator) {
        this.contradictionFound |= this.comparisonCtrBuilder.buildCtrLex(id, lists, operator);
    }

    @Override
    public void buildCtrLexMatrix(String id, XVariables.XVarInteger[][] matrix, Types.TypeOperatorRel operator) {
        this.contradictionFound |= this.comparisonCtrBuilder.buildCtrLexMatrix(id, matrix, operator);
    }

    @Override
    public void buildCtrAllEqual(String id, XVariables.XVarInteger[] list) {
        this.contradictionFound |= this.comparisonCtrBuilder.buildCtrAllEqual(id, list);
    }

    @Override
    public void buildCtrRegular(String id, XVariables.XVarInteger[] list, Object[][] transitions, String startState, String[] finalStates) {
        this.contradictionFound |= this.languageCtrBuilder.buildCtrRegular(id, list, transitions, startState, finalStates);
    }

    @Override
    public void buildCtrMDD(String id, XVariables.XVarInteger[] list, Object[][] transitions) {
        this.contradictionFound |= this.languageCtrBuilder.buildCtrMDD(id, list, transitions);
    }

    @Override
    public void buildCtrCount(String id, XVariables.XVarInteger[] list, int[] values, Condition condition) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrCount(id, list, values, condition);
    }

    @Override
    public void buildCtrCount(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] values, Condition condition) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrCount(id, list, values, condition);
    }

    @Override
    public void buildCtrAtLeast(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrAtLeast(id, list, value, k);
    }

    @Override
    public void buildCtrAtMost(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrAtMost(id, list, value, k);
    }

    @Override
    public void buildCtrExactly(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrExactly(id, list, value, k);
    }

    @Override
    public void buildCtrExactly(String id, XVariables.XVarInteger[] list, int value, XVariables.XVarInteger k) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrExactly(id, list, value, k);
    }

    @Override
    public void buildCtrAmong(String id, XVariables.XVarInteger[] list, int[] values, int k) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrAmong(id, list, values, k);
    }

    @Override
    public void buildCtrAmong(String id, XVariables.XVarInteger[] list, int[] values, XVariables.XVarInteger k) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrAmong(id, list, values, k);
    }

    @Override
    public void buildCtrNValues(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrNValues(id, list, condition);
    }

    @Override
    public void buildCtrNValuesExcept(String id, XVariables.XVarInteger[] list, int[] except, Condition condition) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrNValuesExcept(id, list, except, condition);
    }

    @Override
    public void buildCtrNotAllEqual(String id, XVariables.XVarInteger[] list) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrNotAllEqual(id, list);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, XVariables.XVarInteger[] occurs) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrCardinality(id, list, closed, values, occurs);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occurs) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrCardinality(id, list, closed, values, occurs);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occursMin, int[] occursMax) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrCardinality(id, list, closed, values, occursMin, occursMax);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, XVariables.XVarInteger[] occurs) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrCardinality(id, list, closed, values, occurs);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occurs) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrCardinality(id, list, closed, values, occurs);
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occursMin, int[] occursMax) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrCardinality(id, list, closed, values, occursMin, occursMax);
    }

    @Override
    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.contradictionFound |= this.connectionCtrBuilder.buildCtrMaximum(id, list, condition);
    }

    @Override
    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        this.contradictionFound |= this.connectionCtrBuilder.buildCtrMaximum(id, list, startIndex, index, rank, condition);
    }

    @Override
    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.contradictionFound |= this.connectionCtrBuilder.buildCtrMinimum(id, list, condition);
    }

    @Override
    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        this.contradictionFound |= this.connectionCtrBuilder.buildCtrMinimum(id, list, startIndex, index, rank, condition);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int value) {
        this.contradictionFound |= this.connectionCtrBuilder.buildCtrElement(id, list, value);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, int value) {
        this.contradictionFound |= this.connectionCtrBuilder.buildCtrElement(id, list, startIndex, index, rank, value);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger value) {
        this.contradictionFound |= this.connectionCtrBuilder.buildCtrElement(id, list, value);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        this.contradictionFound |= this.connectionCtrBuilder.buildCtrElement(id, list, startIndex, index, rank, value);
    }

    @Override
    public void buildCtrElement(String id, int[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        this.contradictionFound |= this.connectionCtrBuilder.buildCtrElement(id, list, startIndex, index, rank, value);
    }

    @Override
    public void buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrStretch(id, list, values, widthsMin, widthsMax);
    }

    @Override
    public void buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrStretch(id, list, values, widthsMin, widthsMax, patterns);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, int[] heights, Condition condition) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrCumulative(id, origins, lengths, heights, condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrCumulative(id, origins, lengths, heights, condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, int[] heights, Condition condition) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrCumulative(id, origins, lengths, heights, condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrCumulative(id, origins, lengths, heights, condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrCumulative(id, origins, lengths, ends, heights, condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrCumulative(id, origins, lengths, ends, heights, condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrCumulative(id, origins, lengths, ends, heights, condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrCumulative(id, origins, lengths, ends, heights, condition);
    }

    @Override
    public void buildCtrInstantiation(String id, XVariables.XVarInteger[] list, int[] values) {
        this.contradictionFound |= this.elementaryCtrBuilder.buildCtrInstantiation(id, list, values);
    }

    @Override
    public void buildCtrClause(String id, XVariables.XVarInteger[] pos, XVariables.XVarInteger[] neg) {
        this.contradictionFound |= this.elementaryCtrBuilder.buildCtrClause(id, pos, neg);
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex, int size) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger size) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex) {
        this.contradictionFound |= this.schedulingCtrBuilder.buildCtrCircuit(id, list, startIndex);
    }

    @Override
    public void buildVarSymbolic(XVariables.XVarSymbolic x, String[] values) {
        this.unimplementedCase(x.id);
    }

    @Override
    public void buildCtrIntension(String id, XVariables.XVarSymbolic[] scope, XNodeParent<XVariables.XVarSymbolic> syntaxTreeRoot) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarSymbolic x, String[] values, boolean positive, Set<Types.TypeFlag> flags) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarSymbolic[] list, String[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrAllDifferent(String id, XVariables.XVarSymbolic[] list) {
        this.unimplementedCase(id);
    }

    @Override
    public void buildCtrLogic(String id, Types.TypeLogicalOperator op, XVariables.XVarInteger[] vars) {
        XCallbacks2.super.buildCtrLogic(id, op, vars);
    }

    @Override
    public void buildCtrLogic(String id, XVariables.XVarInteger x, Types.TypeEqNeOperator op, Types.TypeLogicalOperator lop, XVariables.XVarInteger[] vars) {
        XCallbacks2.super.buildCtrLogic(id, x, op, lop, vars);
    }

    @Override
    public void buildCtrAllDifferent(String id, XNodeParent<XVariables.XVarInteger>[] trees) {
        XCallbacks2.super.buildCtrAllDifferent(id, trees);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, int[] lengths, Types.TypeOperatorRel operator) {
        XCallbacks2.super.buildCtrOrdered(id, list, lengths, operator);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] lengths, Types.TypeOperatorRel operator) {
        XCallbacks2.super.buildCtrOrdered(id, list, lengths, operator);
    }

    @Override
    public void buildCtrSum(String id, XNodeParent<XVariables.XVarInteger>[] trees, int[] coeffs, Condition condition) {
        this.contradictionFound |= this.countingCtrBuilder.buildCtrSum(id, trees, coeffs, condition);
    }

    @Override
    public XCallbacks.Implem implem() {
        return this.dataStructureImplementor;
    }
}

