/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sat4j.AbstractLauncher;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.Reader;
import org.sat4j.reader.XMLCSP3Reader;
import org.sat4j.reader.XMLCSPReader;
import org.sat4j.reader.XMLCommentPrintWriter;
import org.sat4j.specs.ISolver;

public enum ECSPFormat {
    TXT(false){

        @Override
        public Reader getReader(AbstractLauncher launcher, ISolver solver) {
            boolean allDiffCards = System.getProperty("allDiffCards") != null;
            return new CSPExtSupportReader(solver, allDiffCards);
        }

        @Override
        public PrintWriter decoratePrintWriter(boolean shouldOnlyDisplayEncoding, PrintWriter pw) {
            return pw;
        }
    }
    ,
    XCSP2(false){

        @Override
        public Reader getReader(AbstractLauncher launcher, ISolver solver) {
            boolean allDiffCards = System.getProperty("allDiffCards") != null;
            return new XMLCSPReader(solver, allDiffCards);
        }

        @Override
        public PrintWriter decoratePrintWriter(boolean shouldOnlyDisplayEncoding, PrintWriter pw) {
            return pw;
        }
    }
    ,
    XCSP3(true){

        @Override
        public Reader getReader(AbstractLauncher launcher, ISolver solver) {
            return new XMLCSP3Reader(solver, launcher);
        }

        @Override
        public PrintWriter decoratePrintWriter(boolean shouldOnlyDisplayEncoding, PrintWriter pw) {
            if (shouldOnlyDisplayEncoding) {
                return pw;
            }
            if (System.getProperty("CompetitionOutput") != null) {
                return pw;
            }
            XMLCommentPrintWriter commentPrintWriter = new XMLCommentPrintWriter(pw);
            commentPrintWriter.addDncPrefix("v ");
            return commentPrintWriter;
        }
    }
    ,
    UNKNOWN(false){

        @Override
        public Reader getReader(AbstractLauncher launcher, ISolver solver) {
            throw new IllegalArgumentException("unable to determine instance type");
        }

        @Override
        public PrintWriter decoratePrintWriter(boolean shouldOnlyDisplayEncoding, PrintWriter pw) {
            return pw;
        }
    };

    private final boolean optimizationModeRequired;

    private ECSPFormat(boolean optimizationModeRequired) {
        this.optimizationModeRequired = optimizationModeRequired;
    }

    public boolean isOptimizationModeRequired() {
        return this.optimizationModeRequired;
    }

    public Reader getReader(AbstractLauncher launcher, ISolver solver) {
        throw new IllegalStateException("This code should never be called");
    }

    public PrintWriter decoratePrintWriter(boolean shouldOnlyDisplayEncoding, PrintWriter pw) {
        throw new IllegalStateException("This code should never be called");
    }

    public static ECSPFormat inferInstanceType(String filename) {
        if (filename.endsWith(".txt")) {
            return TXT;
        }
        ECSPFormat xmlType = ECSPFormat.tryToInferXmlType(filename);
        if (xmlType != UNKNOWN) {
            return xmlType;
        }
        return UNKNOWN;
    }

    private static ECSPFormat tryToInferXmlType(String filename) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = Reader.getInputStreamFromFilename(filename);){
                return ECSPFormat.tryToInferXmlType(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static ECSPFormat tryToInferXmlType(InputStream is) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).startsWith("<instance")) continue;
                    return ECSPFormat.tryToInferXmlTypeFromRootMarkup(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.getLogger("org.sat4j.csp").log(Level.INFO, "IO issue", e);
            return UNKNOWN;
        }
        return UNKNOWN;
    }

    private static ECSPFormat tryToInferXmlTypeFromRootMarkup(String line) {
        String format;
        Pattern pattern = Pattern.compile("<instance .*format=\"([^\"]*)\".*>");
        Matcher matcher = pattern.matcher(line);
        if (!matcher.matches()) {
            return XCSP2;
        }
        switch (format = matcher.group(1)) {
            case "XCSP2": {
                return XCSP2;
            }
            case "XCSP3": {
                return XCSP3;
            }
        }
        return UNKNOWN;
    }

    /* synthetic */ ECSPFormat(String string, int n, boolean bl, ECSPFormat eCSPFormat) {
        this(bl);
    }
}

