/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.util.BitSet;
import java.util.HashSet;
import org.sat4j.core.VecInt;
import org.sat4j.pb.tools.AtMostCard;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

public class AtLeastCard {
    private final IVecInt lits;
    private final int degree;

    public AtLeastCard(IVecInt atLeastLits, int degree) {
        this.lits = new VecInt(atLeastLits.size());
        atLeastLits.copyTo(this.lits);
        this.degree = degree;
    }

    public AtLeastCard(BitSet atLeastLits, int degree, int offset) {
        int cur;
        this.lits = new VecInt(atLeastLits.cardinality());
        int from = 0;
        while ((cur = atLeastLits.nextSetBit(from)) != -1) {
            this.lits.push(cur + offset);
            from = cur + 1;
        }
        this.degree = degree;
    }

    public IVecInt getLits() {
        return this.lits;
    }

    public int getDegree() {
        return this.degree;
    }

    public AtMostCard toAtMost() {
        VecInt atMostLits = new VecInt(this.lits.size());
        IteratorInt it = this.lits.iterator();
        while (it.hasNext()) {
            atMostLits.push(-it.next());
        }
        int atMostDegree = this.lits.size() - this.degree;
        return new AtMostCard(atMostLits, atMostDegree);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        IteratorInt it = this.lits.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(" + ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(">= ");
        sb.append(this.degree);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.degree;
        HashSet<Integer> litsSet = new HashSet<Integer>();
        IteratorInt it = this.lits.iterator();
        while (it.hasNext()) {
            litsSet.add(it.next());
        }
        result = 31 * result + litsSet.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtLeastCard other = (AtLeastCard)obj;
        if (this.degree != other.degree) {
            return false;
        }
        if (this.lits == null) {
            return other.lits == null;
        }
        HashSet<Integer> litsSet1 = new HashSet<Integer>();
        IteratorInt it = this.lits.iterator();
        while (it.hasNext()) {
            litsSet1.add(it.next());
        }
        HashSet<Integer> litsSet2 = new HashSet<Integer>();
        IteratorInt it2 = other.lits.iterator();
        while (it2.hasNext()) {
            litsSet2.add(it2.next());
        }
        return litsSet1.equals(litsSet2);
    }
}

