/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.multiobjective;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IIntegerPBSolver;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.core.IntegerVariable;
import org.sat4j.pb.multiobjective.AbstractLinMultiObjOptimizer;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

public class MinSumOWAOptimizer
extends AbstractLinMultiObjOptimizer {
    private static final long serialVersionUID = 1L;
    private final BigInteger[] weights;
    private IntegerVariable objBoundVar;

    public MinSumOWAOptimizer(IIntegerPBSolver solver, int[] weights) {
        super(solver);
        this.weights = new BigInteger[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            this.weights[i] = BigInteger.valueOf(weights[i]);
        }
    }

    public MinSumOWAOptimizer(IIntegerPBSolver solver, BigInteger[] weights) {
        super(solver);
        this.weights = weights;
    }

    @Override
    protected void setInitConstraints() {
        try {
            this.objBoundVar = this.integerSolver.newIntegerVar(this.globalObjBound());
            for (List<Integer> permutation : new PermutationComputer(this.objs.size())) {
                this.addConstraint(this.objBoundVar, permutation);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addConstraint(IntegerVariable boundVar, List<Integer> permutation) {
        VecInt vars = new VecInt();
        Vec<BigInteger> weights = new Vec<BigInteger>();
        for (int i = 0; i < this.objs.size(); ++i) {
            ObjectiveFunction currentObj = this.objs.get(permutation.get(i));
            BigInteger curWeight = this.weights[i];
            currentObj.getVars().copyTo(vars);
            Iterator<BigInteger> coeffIt = currentObj.getCoeffs().iterator();
            while (coeffIt.hasNext()) {
                weights.push(coeffIt.next().multiply(curWeight));
            }
        }
        BigInteger fact = BigInteger.ONE;
        IteratorInt litsIt = boundVar.getVars().iterator();
        while (litsIt.hasNext()) {
            int nextLit = litsIt.next() * -1;
            vars.push(nextLit);
            weights.push(fact);
            fact = fact.shiftLeft(1);
        }
        try {
            ((IPBSolver)this.decorated()).addAtMost((IVecInt)vars, weights, fact.subtract(BigInteger.ONE));
        }
        catch (ContradictionException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private BigInteger globalObjBound() {
        BigInteger bound = BigInteger.ONE;
        for (ObjectiveFunction obj : this.objs) {
            Iterator<BigInteger> coeffIt = obj.getCoeffs().iterator();
            while (coeffIt.hasNext()) {
                bound = bound.add(coeffIt.next());
            }
        }
        return bound;
    }

    @Override
    protected void setGlobalObj() {
        ((IPBSolver)this.decorated()).setObjectiveFunction(new ObjectiveFunction(new VecInt(), new Vec<BigInteger>()));
        this.integerSolver.addIntegerVariableToObjectiveFunction(this.objBoundVar, BigInteger.ONE);
    }

    @Override
    public Number calculateObjective() {
        this.objectiveValue = BigInteger.ZERO;
        BigInteger[] objValues = this.getObjectiveValues();
        for (int i = 0; i < objValues.length; ++i) {
            this.objectiveValue = this.objectiveValue.add(objValues[i].multiply(this.weights[i]));
        }
        return this.getObjectiveValue();
    }

    protected BigInteger minObjValuesBound() {
        BigInteger maxValue = BigInteger.ZERO;
        for (ObjectiveFunction nextObj : this.objs) {
            BigInteger maxObjValue = this.maxObjValue(nextObj);
            if (maxValue.compareTo(maxObjValue) >= 0) continue;
            maxValue = maxObjValue;
        }
        return maxValue.add(BigInteger.ONE);
    }

    private BigInteger maxObjValue(ObjectiveFunction obj) {
        IVec<BigInteger> objCoeffs = obj.getCoeffs();
        BigInteger coeffsSum = BigInteger.ZERO;
        Iterator<BigInteger> objCoeffsIt = objCoeffs.iterator();
        while (objCoeffsIt.hasNext()) {
            coeffsSum = coeffsSum.add(objCoeffsIt.next());
        }
        return coeffsSum;
    }

    static class PermutationComputer
    implements Iterator<List<Integer>>,
    Iterable<List<Integer>> {
        private int currentElement;
        private final SortedSet<Integer> elements;
        private PermutationComputer end = null;
        private boolean soleIntegerReturned = false;

        public PermutationComputer(int nbElem) {
            this.elements = new TreeSet<Integer>();
            for (int i = 0; i < nbElem; ++i) {
                this.elements.add(i);
            }
        }

        public PermutationComputer(Set<Integer> elements) {
            this.elements = new TreeSet<Integer>(elements);
        }

        @Override
        public Iterator<List<Integer>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return !this.soleIntegerReturned && (this.end == null || this.end.hasNext() || this.currentElement != this.elements.last());
        }

        @Override
        public List<Integer> next() {
            ArrayList<Integer> res = new ArrayList<Integer>();
            if (this.elements.size() == 1) {
                return this.addSoleInteger(res);
            }
            if (this.end == null) {
                this.createChildPermutation();
            }
            if (!this.end.hasNext()) {
                this.changeCurrentAndChild();
            }
            return this.addCurrentAndNextInChild(res);
        }

        private void changeCurrentAndChild() {
            this.currentElement = this.elements.tailSet(this.currentElement + 1).first();
            TreeSet<Integer> endElements = new TreeSet<Integer>();
            for (Integer element : this.elements) {
                if (element.equals(this.currentElement)) continue;
                endElements.add(element);
            }
            this.end = new PermutationComputer(endElements);
        }

        private List<Integer> addCurrentAndNextInChild(List<Integer> res) {
            res.add(this.currentElement);
            res.addAll((Collection<Integer>)this.end.next());
            return res;
        }

        private void createChildPermutation() {
            this.currentElement = this.elements.first();
            SortedSet<Integer> endElements = this.elements.tailSet(this.currentElement + 1);
            this.end = new PermutationComputer(endElements);
        }

        private List<Integer> addSoleInteger(List<Integer> res) {
            this.soleIntegerReturned = true;
            res.add(this.elements.first());
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

