/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.pb.constraints.pb.AutoDivisionStrategy;
import org.sat4j.pb.constraints.pb.ConflictMap;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.IConflictFactory;
import org.sat4j.pb.constraints.pb.IPostProcess;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.pb.constraints.pb.IWeakeningStrategy;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.core.PBSolverStats;

public class ConflictMapRounding
extends ConflictMap {
    public ConflictMapRounding(PBConstr cpb, int level, boolean noRemove, boolean skip, IPostProcess postProcessing, IWeakeningStrategy weakeningStrategy, AutoDivisionStrategy autoDivisionStrategy, PBSolverStats stats) {
        super(cpb, level, noRemove, skip, postProcessing, weakeningStrategy, autoDivisionStrategy, stats);
    }

    public static IConflict createConflict(PBConstr cpb, int level, boolean noRemove, boolean skip, IPostProcess postProcessing, IWeakeningStrategy weakeningStrategy, AutoDivisionStrategy autoDivisionStrategy, PBSolverStats stats) {
        return new ConflictMapRounding(cpb, level, noRemove, skip, postProcessing, weakeningStrategy, autoDivisionStrategy, stats);
    }

    public static IConflictFactory factory() {
        return new IConflictFactory(){

            @Override
            public IConflict createConflict(PBConstr cpb, int level, boolean noRemove, boolean skip, IPostProcess postprocess, IWeakeningStrategy weakeningStrategy, AutoDivisionStrategy autoDivisionStrategy, PBSolverStats stats) {
                return ConflictMapRounding.createConflict(cpb, level, noRemove, skip, postprocess, weakeningStrategy, autoDivisionStrategy, stats);
            }

            public String toString() {
                return "Always round the coefficient of the propagating literal to 1 during conflict analysis.";
            }
        };
    }

    static BigInteger ceildiv(BigInteger p, BigInteger q) {
        return p.add(q).subtract(BigInteger.ONE).divide(q);
    }

    @Override
    protected BigInteger reduceUntilConflict(int x, int xindex, BigInteger[] abc, BigInteger t, IWatchPb xyz) {
        BigInteger a = abc[xindex];
        int n = xyz.size();
        BigInteger sprime = BigInteger.ZERO;
        for (int k = 0; k < n; ++k) {
            if (this.voc.isFalsified(xyz.get(k))) continue;
            sprime = sprime.add(ConflictMapRounding.ceildiv(abc[k], a));
        }
        BigInteger tprime = ConflictMapRounding.ceildiv(t, a);
        sprime = sprime.subtract(tprime);
        BigInteger bigt = t;
        boolean easyRounding = true;
        for (int k = 0; k < n; ++k) {
            if (!(sprime.equals(BigInteger.ZERO) || this.voc.isFalsified(xyz.get(k)) || abc[k].mod(a).equals(BigInteger.ZERO))) {
                bigt = bigt.subtract(abc[k]);
                BigInteger tnewprime = ConflictMapRounding.ceildiv(bigt, a);
                sprime = sprime.add(tprime).subtract(ConflictMapRounding.ceildiv(abc[k], a)).subtract(tnewprime);
                tprime = tnewprime;
                abc[k] = BigInteger.ZERO;
                easyRounding = false;
                continue;
            }
            abc[k] = ConflictMapRounding.ceildiv(abc[k], a);
        }
        tprime = this.saturation(abc, tprime, xyz);
        this.coefMultCons = this.weightedLits.get(x ^ 1);
        this.coefMult = BigInteger.ONE;
        this.stats.incNumberOfRoundingOperations();
        if (easyRounding) {
            this.stats.incNumberOfEasyRoundingOperations();
        }
        return tprime;
    }
}

