/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.pb.constraints.pb.AutoDivisionStrategy;
import org.sat4j.pb.constraints.pb.ConflictMap;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.IConflictFactory;
import org.sat4j.pb.constraints.pb.IPostProcess;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.pb.constraints.pb.IWeakeningStrategy;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.core.PBSolverStats;

public class ConflictMapReduceToCard
extends ConflictMap {
    public static final BigInteger MAXVALUE = BigInteger.valueOf(Long.MAX_VALUE);

    public ConflictMapReduceToCard(PBConstr cpb, int level, boolean noRemove, boolean skip, IPostProcess postprocess, IWeakeningStrategy weakeningStrategy, AutoDivisionStrategy autoDivisionStrategy, PBSolverStats stats) {
        super(cpb, level, noRemove, skip, postprocess, weakeningStrategy, autoDivisionStrategy, stats);
    }

    public static IConflict createConflict(PBConstr cpb, int level, boolean noRemove, boolean skip, IPostProcess postprocess, IWeakeningStrategy weakeningStrategy, AutoDivisionStrategy autoDivisionStrategy, PBSolverStats stats) {
        return new ConflictMapReduceToCard(cpb, level, noRemove, skip, postprocess, weakeningStrategy, autoDivisionStrategy, stats);
    }

    public static IConflictFactory factory() {
        return new IConflictFactory(){

            @Override
            public IConflict createConflict(PBConstr cpb, int level, boolean noRemove, boolean skip, IPostProcess postprocess, IWeakeningStrategy weakeningStrategy, AutoDivisionStrategy autoDivisionStrategy, PBSolverStats stats) {
                return ConflictMapReduceToCard.createConflict(cpb, level, noRemove, skip, postprocess, weakeningStrategy, autoDivisionStrategy, stats);
            }

            public String toString() {
                return "Reduce to cardinality constraint during conflict analysis if necessary";
            }
        };
    }

    @Override
    protected BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, BigInteger degreeReduced, IWatchPb wpb) {
        BigInteger degreeFurtherReduced = this.reduceToCard(ind, wpb, reducedCoefs);
        this.coefMultCons = this.weightedLits.get(litImplied ^ 1);
        this.coefMult = BigInteger.ONE;
        ++this.numberOfReductions;
        return degreeFurtherReduced;
    }

    private BigInteger reduceToCard(int ind, IWatchPb wpb, BigInteger[] reducedCoefs) {
        BigInteger[] tmpCoefs = new BigInteger[reducedCoefs.length];
        BigInteger maxCoef = BigInteger.ZERO;
        for (int i = 0; i < reducedCoefs.length; ++i) {
            if (i == ind || wpb.getVocabulary().isFalsified(wpb.get(i))) {
                tmpCoefs[i] = BigInteger.ONE;
                if (reducedCoefs[i].compareTo(maxCoef) <= 0) continue;
                maxCoef = reducedCoefs[i];
                continue;
            }
            tmpCoefs[i] = BigInteger.ZERO;
        }
        int cpt = 0;
        for (int i = 0; i < reducedCoefs.length; ++i) {
            if (tmpCoefs[i].equals(BigInteger.ZERO) && reducedCoefs[i].compareTo(maxCoef) > 0) {
                reducedCoefs[i] = BigInteger.ONE;
                ++cpt;
                continue;
            }
            reducedCoefs[i] = tmpCoefs[i];
        }
        return BigInteger.valueOf((long)cpt + 1L);
    }
}

