/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.constraints.pb.Pseudos;
import org.sat4j.pb.constraints.pb.PuebloMinWatchPb;
import org.sat4j.specs.Constr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class PuebloPBMinDataStructure
extends AbstractPBDataStructureFactory {
    private static final long serialVersionUID = 1L;

    @Override
    protected PBConstr constraintFactory(int[] literals, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        return PuebloMinWatchPb.normalizedMinWatchPbNew(this.solver, this.getVocabulary(), literals, coefs, degree);
    }

    @Override
    protected PBConstr learntConstraintFactory(IDataStructurePB dspb) {
        return PuebloMinWatchPb.normalizedWatchPbNew(this.getVocabulary(), dspb);
    }

    private Constr learntConstraintFactory(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree, boolean moreThan) {
        int[] lits = new int[literals.size()];
        literals.copyTo(lits);
        BigInteger[] bc = new BigInteger[coefs.size()];
        coefs.copyTo(bc);
        degree = Pseudos.niceCheckedParametersForCompetition(lits, bc, moreThan, degree);
        return PuebloMinWatchPb.normalizedWatchPbNew(this.getVocabulary(), new MapPb(literals, coefs, degree));
    }

    @Override
    protected Constr learntAtLeastConstraintFactory(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        return this.learntConstraintFactory(literals, coefs, degree, true);
    }

    @Override
    protected Constr learntAtMostConstraintFactory(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        return this.learntConstraintFactory(literals, coefs, degree, false);
    }
}

