/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import org.sat4j.annotations.Feature;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.LearnedConstraintsDeletionStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.specs.Constr;
import org.sat4j.specs.IVec;

@Feature(value="deletion", parent="expert")
final class ActivityLCDS
implements LearnedConstraintsDeletionStrategy {
    private static final long serialVersionUID = 1L;
    private final ConflictTimer timer;
    private final Solver<? extends DataStructureFactory> solver;

    ActivityLCDS(Solver<? extends DataStructureFactory> solver, ConflictTimer timer) {
        this.timer = timer;
        this.solver = solver;
    }

    @Override
    public void reduce(IVec<Constr> learnedConstrs) {
        int i;
        learnedConstrs.sort(this.solver.getActivityComparator());
        int j = 0;
        for (i = 0; i < learnedConstrs.size() / 2; ++i) {
            Constr c = learnedConstrs.get(i);
            if (c.locked() || c.size() == 2) {
                learnedConstrs.set(j++, learnedConstrs.get(i));
                continue;
            }
            c.remove(this.solver);
            this.solver.slistener.delete(c);
        }
        while (i < learnedConstrs.size()) {
            learnedConstrs.set(j++, learnedConstrs.get(i));
            ++i;
        }
        if (this.solver.isVerbose()) {
            this.solver.out.log(this.solver.getLogPrefix() + "cleaning " + (learnedConstrs.size() - j) + " clauses out of " + learnedConstrs.size());
        }
        learnedConstrs.shrinkTo(j);
    }

    @Override
    public ConflictTimer getTimer() {
        return this.timer;
    }

    public String toString() {
        return "Activity based learned constraints deletion strategy with timer " + this.timer;
    }

    @Override
    public void init() {
    }

    @Override
    public void onClauseLearning(Constr constr) {
    }

    @Override
    public void onConflictAnalysis(Constr reason) {
        if (reason.learnt()) {
            this.solver.claBumpActivity(reason);
        }
    }

    @Override
    public void onPropagation(Constr from) {
    }
}

