/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.annotations.Feature;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.ILits;
import org.sat4j.specs.Constr;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.Propagatable;
import org.sat4j.specs.UnitPropagationListener;
import org.sat4j.specs.VarMapper;

@Feature(value="constraint")
public abstract class WLClause
implements Propagatable,
Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double activity;
    protected final int[] lits;
    protected final ILits voc;

    public WLClause(IVecInt ps, ILits voc) {
        this.lits = new int[ps.size()];
        ps.moveTo(this.lits);
        assert (ps.size() == 0);
        this.voc = voc;
        this.activity = 0.0;
    }

    @Override
    public void calcReason(int p, IVecInt outReason) {
        int i;
        int[] mylits = this.lits;
        int n = i = p == -1 ? 0 : 1;
        while (i < mylits.length) {
            assert (this.voc.isFalsified(mylits[i]));
            outReason.push(mylits[i] ^ 1);
            ++i;
        }
    }

    @Override
    public void remove(UnitPropagationListener upl) {
        this.voc.watches(this.lits[0] ^ 1).remove(this);
        this.voc.watches(this.lits[1] ^ 1).remove(this);
    }

    @Override
    public boolean simplify() {
        for (int lit : this.lits) {
            if (!this.voc.isSatisfied(lit)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean propagate(UnitPropagationListener s, int p) {
        int[] mylits = this.lits;
        if (mylits[0] == (p ^ 1)) {
            mylits[0] = mylits[1];
            mylits[1] = p ^ 1;
        }
        if (this.voc.isSatisfied(mylits[0])) {
            this.voc.watch(p, this);
            return true;
        }
        int previous = p ^ 1;
        for (int i = 2; i < mylits.length; ++i) {
            if (!this.voc.isFalsified(mylits[i])) {
                mylits[1] = mylits[i];
                mylits[i] = previous;
                this.voc.watch(mylits[1] ^ 1, this);
                return true;
            }
            int tmp = previous;
            previous = mylits[i];
            mylits[i] = tmp;
        }
        System.arraycopy(mylits, 2, mylits, 1, mylits.length - 2);
        mylits[mylits.length - 1] = previous;
        this.voc.watch(p, this);
        return s.enqueue(mylits[0], this);
    }

    @Override
    public boolean locked() {
        return this.voc.getReason(this.lits[0]) == this;
    }

    @Override
    public double getActivity() {
        return this.activity;
    }

    @Override
    public void setActivity(double d) {
        this.activity = d;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder();
        for (int lit : this.lits) {
            stb.append(Lits.toString(lit));
            stb.append("[");
            stb.append(this.voc.valueToString(lit));
            stb.append("]");
            stb.append(" ");
        }
        return stb.toString();
    }

    @Override
    public String toString(VarMapper mapper) {
        if (mapper == null) {
            return this.toString();
        }
        StringBuilder stb = new StringBuilder();
        for (int lit : this.lits) {
            stb.append(mapper.map(LiteralsUtils.toDimacs(lit)));
            stb.append("[");
            stb.append(this.voc.valueToString(lit));
            stb.append("]");
            stb.append(" ");
        }
        return stb.toString();
    }

    @Override
    public int get(int i) {
        return this.lits[i];
    }

    @Override
    public void rescaleBy(double d) {
        this.activity *= d;
    }

    @Override
    public int size() {
        return this.lits.length;
    }

    @Override
    public void assertConstraint(UnitPropagationListener s) {
        boolean ret = s.enqueue(this.lits[0], this);
        assert (ret);
    }

    @Override
    public void assertConstraintIfNeeded(UnitPropagationListener s) {
        if (this.voc.isFalsified(this.lits[1])) {
            boolean ret = s.enqueue(this.lits[0], this);
            assert (ret);
        }
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] tmp = new int[this.size()];
        System.arraycopy(this.lits, 0, tmp, 0, this.size());
        return tmp;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        try {
            WLClause wcl = (WLClause)obj;
            if (this.lits.length != wcl.lits.length) {
                return false;
            }
            for (int lit : this.lits) {
                boolean ok = false;
                for (int lit2 : wcl.lits) {
                    if (lit != lit2) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        long sum = 0L;
        for (int p : this.lits) {
            sum += (long)p;
        }
        return (int)sum / this.lits.length;
    }

    @Override
    public boolean canBePropagatedMultipleTimes() {
        return false;
    }

    @Override
    public Constr toConstraint() {
        return this;
    }

    @Override
    public void calcReasonOnTheFly(int p, IVecInt trail, IVecInt outReason) {
        this.calcReason(p, outReason);
    }

    @Override
    public boolean canBeSatisfiedByCountingLiterals() {
        return true;
    }

    @Override
    public int requiredNumberOfSatisfiedLiterals() {
        return 1;
    }

    @Override
    public boolean isSatisfied() {
        for (int p : this.lits) {
            if (!this.voc.isSatisfied(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getAssertionLevel(IVecInt trail, int decisionLevel) {
        for (int i = trail.size() - 1; i >= 0; --i) {
            if (LiteralsUtils.var(trail.get(i)) != LiteralsUtils.var(this.lits[0])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String dump() {
        StringBuilder stb = new StringBuilder();
        for (int p : this.lits) {
            stb.append(LiteralsUtils.toDimacs(p));
            stb.append(' ');
        }
        stb.append('0');
        return stb.toString();
    }
}

