/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.xml;

import org.sat4j.csp.xml.Element;
import org.sat4j.csp.xml.ICSPCallback;
import org.xml.sax.Attributes;

class Relation
extends Element {
    private StringBuilder allTuples;

    public Relation(ICSPCallback out, String tagName) {
        super(out, tagName);
    }

    @Override
    public void startElement(Attributes att) {
        String semantics;
        int nbTuples = -1;
        String tmpTuples = att.getValue("nbTuples");
        if (tmpTuples != null) {
            nbTuples = Integer.parseInt(tmpTuples);
        }
        boolean isSupport = (semantics = att.getValue("semantics")) != null && semantics.equals("supports");
        int arity = Integer.parseInt(att.getValue("arity"));
        this.getCB().beginRelation(att.getValue("name"), arity, nbTuples, isSupport);
        this.allTuples = new StringBuilder();
    }

    @Override
    public void characters(String allTuples) {
        this.allTuples.append(allTuples);
    }

    @Override
    public void endElement() {
        String[] tuples;
        for (String tuple : tuples = this.allTuples.toString().trim().split("\\|")) {
            if (tuple.equals("")) continue;
            int[] oneTuple = this.toIntArray(tuple.split("\\s+"));
            this.getCB().addRelationTuple(oneTuple);
        }
        this.getCB().endRelation();
    }

    private int[] toIntArray(String[] str) {
        int[] res = new int[str.length];
        for (int i = 0; i < str.length; ++i) {
            res[i] = Integer.parseInt(str[i]);
        }
        return res;
    }
}

