/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.xml;

import org.sat4j.csp.xml.Element;
import org.sat4j.csp.xml.ICSPCallback;
import org.xml.sax.Attributes;

class Domain
extends Element {
    private static final String INTERVAL_SEPARATOR = "..";
    private StringBuilder allValues;

    public Domain(ICSPCallback out, String tagName) {
        super(out, tagName);
    }

    @Override
    public void startElement(Attributes att) {
        int nbValues = -1;
        String tmpValues = att.getValue("nbValues");
        if (tmpValues != null) {
            nbValues = Integer.parseInt(tmpValues);
        }
        this.getCB().beginDomain(att.getValue("name"), nbValues);
        this.allValues = new StringBuilder();
    }

    @Override
    public void endElement() {
        if (this.allValues != null) {
            String[] tokens;
            for (String token : tokens = this.allValues.toString().trim().split("\\s+")) {
                if (token.equals("")) continue;
                int index = token.indexOf(INTERVAL_SEPARATOR);
                if (index > -1) {
                    this.getCB().addDomainValue(Integer.parseInt(token.substring(0, index)), Integer.parseInt(token.substring(index + 2)));
                    continue;
                }
                this.getCB().addDomainValue(Integer.parseInt(token));
            }
        }
        this.getCB().endDomain();
    }

    @Override
    public void characters(String allValues) {
        this.allValues.append(allValues);
    }
}

