/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.intension;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.csp.intension.ICspToSatEncoder;
import org.sat4j.csp.intension.IExpression;
import org.sat4j.csp.intension.IIntensionCtrEncoder;
import org.sat4j.csp.intension.IntegerExpression;
import org.sat4j.csp.intension.OperatorExpression;
import org.sat4j.csp.intension.Parser;
import org.sat4j.csp.intension.VarExpression;
import org.sat4j.pb.ObjectiveFunction;

public class TseitinBasedIntensionCtrEncoder
implements IIntensionCtrEncoder {
    private final ICspToSatEncoder solver;

    public TseitinBasedIntensionCtrEncoder(ICspToSatEncoder solver) {
        this.solver = solver;
    }

    @Override
    public boolean encode(String strExpression) {
        Parser parser = new Parser(strExpression);
        parser.parse();
        IExpression expression = parser.getExpression();
        return this.encodeExpression(expression);
    }

    @Override
    public ObjectiveFunction encodeObj(String expr) {
        Parser parser = new Parser(expr);
        parser.parse();
        IExpression expression = parser.getExpression();
        Map<Integer, Integer> map = this.encodeWithTseitin(expression);
        VecInt vars = new VecInt(map.size());
        Vec<BigInteger> coeffs = new Vec<BigInteger>(map.size());
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            vars.push(entry.getValue());
            coeffs.push(BigInteger.valueOf(entry.getKey().intValue()));
        }
        return new ObjectiveFunction(vars, coeffs);
    }

    private boolean encodeExpression(IExpression expression) {
        Map<Integer, Integer> map = this.encodeWithTseitin(expression);
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            this.solver.addClause(new int[]{entry.getKey().equals(0) ? -entry.getValue().intValue() : entry.getValue()});
        }
        return false;
    }

    private Map<Integer, Integer> encodeWithTseitin(IExpression expression) {
        Map result;
        try {
            String methodBodyName = String.valueOf(expression.typeAsString().substring(0, 1).toUpperCase()) + expression.typeAsString().substring(1);
            Method toCall = this.getClass().getMethod("encode" + methodBodyName + "WithTseitin", IExpression.class);
            result = (Map)toCall.invoke((Object)this, expression);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public Map<Integer, Integer> encodeIntegerWithTseitin(IExpression iexpr) {
        IntegerExpression expr = (IntegerExpression)iexpr;
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        result.put(expr.getValue(), null);
        return result;
    }

    public Map<Integer, Integer> encodeVarWithTseitin(IExpression iexpr) {
        int[] domain;
        VarExpression expr = (VarExpression)iexpr;
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        int[] nArray = domain = this.solver.getCspVarDomain(expr.getVar());
        int n = domain.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            result.put(value, this.solver.getSolverVar(expr.getVar(), value));
            ++n2;
        }
        return result;
    }

    public Map<Integer, Integer> encodeOperatorWithTseitin(IExpression iexpr) {
        Map result;
        OperatorExpression expr = (OperatorExpression)iexpr;
        ArrayList<Map<Integer, Integer>> mappings = new ArrayList<Map<Integer, Integer>>();
        IExpression[] iExpressionArray = expr.getOperands();
        int n = iExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression operand = iExpressionArray[n2];
            mappings.add(this.encodeWithTseitin(operand));
            ++n2;
        }
        try {
            String strOpname = String.valueOf(expr.getOperator().nameAsString().substring(0, 1).toUpperCase()) + expr.getOperator().nameAsString().substring(1);
            Method toCall = this.getClass().getMethod("encodeOperator" + strOpname, List.class);
            result = (Map)toCall.invoke((Object)this, mappings);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public Map<Integer, Integer> encodeOperatorNeg(List<Map<Integer, Integer>> mappings) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : mappings.get(0).entrySet()) {
            ret.put(-entry.getKey().intValue(), entry.getValue());
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorAbs(List<Map<Integer, Integer>> mappings) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : mappings.get(0).entrySet()) {
            ret.put(Math.abs(entry.getKey()), entry.getValue());
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorAdd(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey() + entry2.getKey());
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorSub(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey() - entry2.getKey());
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorMul(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey() * entry2.getKey());
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorDiv(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey() / entry2.getKey());
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorMod(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey() % entry2.getKey());
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorSqr(List<Map<Integer, Integer>> mappings) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : mappings.get(0).entrySet()) {
            ret.put(entry.getKey() * entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorPow(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), (int)Math.pow(entry1.getKey().intValue(), entry2.getKey().intValue()));
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorMin(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), Math.min(entry1.getKey(), entry2.getKey()));
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorMax(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), Math.max(entry1.getKey(), entry2.getKey()));
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorDist(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), Math.abs(entry1.getKey() - entry2.getKey()));
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorLt(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey() < entry2.getKey() ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorLe(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey() <= entry2.getKey() ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorGt(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey() > entry2.getKey() ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorGe(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey() >= entry2.getKey() ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorNe(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), !entry1.getKey().equals(entry2.getKey()) ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorEq(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey().equals(entry2.getKey()) ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorSet(List<Map<Integer, Integer>> mappings) {
        throw new IllegalStateException("this operator must be translated before encoding");
    }

    public Map<Integer, Integer> encodeOperatorIn(List<Map<Integer, Integer>> mappings) {
        throw new IllegalStateException("this operator must be translated before encoding");
    }

    public Map<Integer, Integer> encodeOperatorNot(List<Map<Integer, Integer>> mappings) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : mappings.get(0).entrySet()) {
            ret.put(entry.getKey().equals(0) ? 1 : 0, entry.getValue());
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorAnd(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), !entry1.getKey().equals(0) && !entry2.getKey().equals(0) ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorOr(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), !entry1.getKey().equals(0) || !entry2.getKey().equals(0) ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorXor(List<Map<Integer, Integer>> initMappings) {
        List<Map<Integer, Integer>> mappings;
        if (initMappings.size() > 2) {
            mappings = new ArrayList<Map<Integer, Integer>>();
            mappings.add(this.encodeOperatorXor(initMappings.stream().limit(initMappings.size() >> 1).collect(Collectors.toList())));
            mappings.add(this.encodeOperatorXor(initMappings.stream().skip(initMappings.size() >> 1).collect(Collectors.toList())));
        } else {
            mappings = initMappings;
        }
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), !entry1.getKey().equals(0) ^ !entry2.getKey().equals(0) ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorIff(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), !entry1.getKey().equals(0) == !entry2.getKey().equals(0) ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorImp(List<Map<Integer, Integer>> mappings) {
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        if (mappings.size() > 2) {
            throw new UnsupportedOperationException("use associativity property to build 2-arity operators");
        }
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry1.getKey().equals(0) || !entry2.getKey().equals(0) ? 1 : 0);
            }
        }
        return ret;
    }

    public Map<Integer, Integer> encodeOperatorIte(List<Map<Integer, Integer>> mappings) {
        return this.encodeOperatorIf(mappings);
    }

    public Map<Integer, Integer> encodeOperatorIf(List<Map<Integer, Integer>> mappings) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry1 : mappings.get(0).entrySet()) {
            for (Map.Entry<Integer, Integer> entry2 : mappings.get(1).entrySet()) {
                for (Map.Entry<Integer, Integer> entry3 : mappings.get(2).entrySet()) {
                    this.buildImplVar(ret, entry1.getValue(), entry2.getValue(), entry3.getValue(), !entry1.getKey().equals(0) ? entry2.getKey() : entry3.getKey());
                }
            }
        }
        return ret;
    }

    private void buildImplVar(Map<Integer, Integer> mapping, Integer var1, Integer var2, int value) {
        if (var1 == null) {
            var1 = var2;
            var2 = null;
        }
        if (var1 == null) {
            mapping.put(value, null);
            return;
        }
        Integer implVar = mapping.get(value);
        if (implVar == null) {
            implVar = this.solver.newSatSolverVar();
            mapping.put(value, implVar);
        }
        if (var2 == null) {
            this.solver.addClause(new int[]{-var1.intValue(), implVar});
        } else {
            this.solver.addClause(new int[]{-var1.intValue(), -var2.intValue(), implVar});
        }
    }

    private void buildImplVar(Map<Integer, Integer> mapping, Integer var1, Integer var2, Integer var3, int value) {
        Integer implVar = mapping.get(value);
        if (var1 == null) {
            var1 = var2;
            var2 = null;
        }
        if (var1 == null) {
            var1 = var3;
            var3 = null;
        }
        if (var1 == null) {
            mapping.put(value, null);
            return;
        }
        if (var2 == null) {
            var2 = var3;
            var3 = null;
        }
        if (implVar == null) {
            implVar = this.solver.newSatSolverVar();
            mapping.put(value, implVar);
        }
        if (var2 == null) {
            this.solver.addClause(new int[]{-var1.intValue(), implVar});
        } else if (var3 == null) {
            this.solver.addClause(new int[]{-var1.intValue(), -var2.intValue(), implVar});
        } else {
            this.solver.addClause(new int[]{-var1.intValue(), -var3.intValue(), implVar});
        }
    }

    @Override
    public ICspToSatEncoder getSolver() {
        return this.solver;
    }
}

