/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.intension;

import java.util.ArrayList;
import org.sat4j.csp.intension.EOperator;
import org.sat4j.csp.intension.IExpression;
import org.sat4j.csp.intension.IntegerExpression;
import org.sat4j.csp.intension.OperatorExpression;
import org.sat4j.csp.intension.VarExpression;
import org.sat4j.csp.intension.WrongArityForOperatorException;

public class Parser {
    private static final String NULL_LENGTH_EXPR_MSG_PREFIX = "null length expression at index ";
    private final char[] charArray;
    private int currentCharIndex;
    private IExpression expression;
    private static final char ARGUMENT_LIST_BEGIN = '(';
    private static final char ARGUMENT_LIST_SEP = ',';
    private static final char ARGUMENT_LIST_END = ')';

    public Parser(String strExpression) {
        this.charArray = strExpression.replaceAll(" ", "").toCharArray();
        this.currentCharIndex = 0;
    }

    public void parse() {
        this.expression = this.parseExpression();
    }

    public IExpression getExpression() {
        return this.expression;
    }

    private IExpression parseExpression() {
        StringBuilder exprBuf = new StringBuilder();
        boolean expressionEnded = false;
        while (!expressionEnded && this.currentCharIndex < this.charArray.length) {
            char current = this.charArray[this.currentCharIndex];
            switch (current) {
                case '(': {
                    return this.parseOperatorExpression(exprBuf.toString());
                }
                case ')': 
                case ',': {
                    expressionEnded = true;
                    break;
                }
                default: {
                    exprBuf.append(current);
                    ++this.currentCharIndex;
                }
            }
        }
        String strValue = exprBuf.toString();
        if (strValue.length() == 0) {
            throw new IllegalArgumentException(NULL_LENGTH_EXPR_MSG_PREFIX + this.currentCharIndex);
        }
        Integer intValue = null;
        try {
            intValue = Integer.valueOf(strValue);
        }
        catch (NumberFormatException e) {
            return new VarExpression(strValue);
        }
        return new IntegerExpression(intValue);
    }

    /*
     * Unable to fully structure code
     */
    private IExpression parseOperatorExpression(String operatorName) {
        operator = EOperator.operator(operatorName);
        operandsList = new ArrayList<IExpression>();
        if (this.charArray[this.currentCharIndex] == '(') ** GOTO lbl14
        throw new IllegalArgumentException("Expected character \"(\"");
lbl-1000:
        // 1 sources

        {
            ++this.currentCharIndex;
            try {
                child = this.parseExpression();
                operandsList.add(child);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().startsWith("null length expression at index ")) continue;
                throw e;
            }
lbl14:
            // 3 sources

            ** while (this.charArray[this.currentCharIndex] != ')')
        }
lbl15:
        // 1 sources

        ++this.currentCharIndex;
        if (operandsList.size() < operator.minArity() || operandsList.size() > operator.maxArity()) {
            throw new WrongArityForOperatorException("wrong arity for operator \"" + operator.nameAsString() + "\" at index " + this.currentCharIndex);
        }
        operandsArray = new IExpression[operandsList.size()];
        operandsArray = operandsList.toArray(operandsArray);
        return new OperatorExpression(operator, operandsArray);
    }
}

