/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.intension;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sat4j.csp.intension.EExpressionType;
import org.sat4j.csp.intension.EOperator;
import org.sat4j.csp.intension.IExpression;
import org.sat4j.csp.intension.IntegerExpression;

public class OperatorExpression
implements IExpression {
    private EOperator op;
    private IExpression[] operands;
    private EExpressionType expressionType;
    private final Set<String> involvedVars = new HashSet<String>();

    public OperatorExpression(EOperator op, IExpression[] operands) {
        IExpression[] iExpressionArray = operands;
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression expr = iExpressionArray[n2];
            this.involvedVars.addAll(expr.getInvolvedVars());
            ++n2;
        }
        if (this.handleMembershipCase(op, operands)) {
            return;
        }
        if (this.handleAssociativityCase(op, operands)) {
            return;
        }
        this.op = op;
        this.operands = operands;
        this.expressionType = op.resultType();
    }

    private boolean handleMembershipCase(EOperator op, IExpression[] operands) {
        if (op != EOperator.MEMBERSHIP) {
            return false;
        }
        IExpression[] setMembers = operands[1].getOperands();
        if (setMembers == null) {
            this.updateOpForDotDotMembership(operands);
        } else {
            this.updateOpForSetMembership(operands, setMembers);
        }
        this.handleAssociativityCase(this.op, this.operands);
        return true;
    }

    private void updateOpForSetMembership(IExpression[] operands, IExpression[] setMembers) {
        IExpression[] newOperands = new IExpression[setMembers.length];
        int i = 0;
        while (i < setMembers.length) {
            IExpression inclTest = operands[0];
            newOperands[i] = new OperatorExpression(EOperator.EQUAL_TO, new IExpression[]{inclTest, setMembers[i]});
            ++i;
        }
        this.op = EOperator.LOGICAL_OR;
        this.operands = newOperands;
    }

    private void updateOpForDotDotMembership(IExpression[] operands) {
        String[] bounds = operands[1].toString().split("\\.\\.");
        assert (bounds.length == 2);
        this.op = EOperator.LOGICAL_AND;
        IExpression[] newOperands = new IExpression[2];
        IExpression inclTest = operands[0];
        newOperands[0] = new OperatorExpression(EOperator.GREATER_THAN_OR_EQUAL, new IExpression[]{inclTest, new IntegerExpression(Integer.valueOf(bounds[0]))});
        newOperands[1] = new OperatorExpression(EOperator.LESS_THAN_OR_EQUAL, new IExpression[]{inclTest, new IntegerExpression(Integer.valueOf(bounds[1]))});
        this.operands = newOperands;
    }

    private boolean handleAssociativityCase(EOperator tmpOp, IExpression[] tmpOperands) {
        switch (tmpOp.associtivityState()) {
            case ASSOCIATIVE: {
                if (tmpOperands.length > 2) {
                    this.handleAssociativity(tmpOp, tmpOperands);
                    return true;
                }
                return false;
            }
            case AND_CHAIN_OF_TWO_WITH_FIRST_COMMON: {
                if (tmpOperands.length > 2) {
                    this.handleAndChainOfTwoWithFirstCommon(tmpOp, tmpOperands);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void handleAssociativity(EOperator tmpOp, IExpression[] tmpOperands) {
        IExpression operand1 = null;
        if (tmpOperands.length == 3) {
            operand1 = tmpOperands[0];
        } else {
            IExpression[] subArray1 = new IExpression[tmpOperands.length / 2];
            System.arraycopy(tmpOperands, 0, subArray1, 0, tmpOperands.length / 2);
            operand1 = new OperatorExpression(tmpOp, subArray1);
        }
        int arraySize = tmpOperands.length - tmpOperands.length / 2;
        IExpression[] subArray2 = new IExpression[arraySize];
        System.arraycopy(tmpOperands, tmpOperands.length / 2, subArray2, 0, arraySize);
        OperatorExpression operand2 = new OperatorExpression(tmpOp, subArray2);
        this.op = tmpOp;
        this.operands = new IExpression[]{operand1, operand2};
    }

    private void handleAndChainOfTwoWithFirstCommon(EOperator tmpOp, IExpression[] tmpOperands) {
        IExpression[] andOperands = new IExpression[tmpOperands.length - 1];
        int i = 1;
        while (i < tmpOperands.length) {
            andOperands[i - 1] = new OperatorExpression(tmpOp, new IExpression[]{tmpOperands[0], tmpOperands[i]});
            ++i;
        }
        this.op = EOperator.LOGICAL_AND;
        OperatorExpression tmpExpression = new OperatorExpression(this.op, andOperands);
        this.operands = tmpExpression.operands;
    }

    public EOperator getOperator() {
        return this.op;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(this.op.nameAsString()).append('(');
        if (this.operands.length > 0) {
            sbuf.append(this.operands[0].toString());
        }
        int i = 1;
        while (i < this.operands.length) {
            sbuf.append(',').append(this.operands[i].toString());
            ++i;
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    @Override
    public int compareTo(IExpression o) {
        return this.toString().compareTo(o.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expressionType == null ? 0 : this.expressionType.hashCode());
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 31 * result + Arrays.hashCode(this.operands);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperatorExpression)) {
            return false;
        }
        OperatorExpression other = (OperatorExpression)obj;
        if (this.expressionType != other.expressionType) {
            return false;
        }
        if (this.op != other.op) {
            return false;
        }
        return Arrays.equals(this.operands, other.operands);
    }

    @Override
    public Set<String> getInvolvedVars() {
        return this.involvedVars;
    }

    @Override
    public IExpression[] getOperands() {
        return this.operands;
    }

    @Override
    public String typeAsString() {
        return "operator";
    }
}

