/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.intension;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sat4j.csp.intension.EOperator;
import org.sat4j.csp.intension.ICspToSatEncoder;
import org.sat4j.csp.intension.IExpression;
import org.sat4j.csp.intension.IIntensionCtrEncoder;
import org.sat4j.csp.intension.IntegerExpression;
import org.sat4j.csp.intension.OperatorExpression;
import org.sat4j.csp.intension.Parser;
import org.sat4j.csp.intension.VarExpression;
import org.sat4j.pb.ObjectiveFunction;

public class NogoodBasedIntensionCtrEncoder
implements IIntensionCtrEncoder {
    private final ICspToSatEncoder solver;
    private final Map<String, int[]> domains = new HashMap<String, int[]>();
    private final Map<VarExpression, Integer> lastVarExprEvaluation = new HashMap<VarExpression, Integer>();
    private final Map<OperatorExpression, Integer> lastOpExprEvaluation = new HashMap<OperatorExpression, Integer>();

    public NogoodBasedIntensionCtrEncoder(ICspToSatEncoder solver) {
        this.solver = solver;
    }

    @Override
    public boolean encode(String strExpression) {
        Parser parser = new Parser(strExpression);
        parser.parse();
        IExpression expression = parser.getExpression();
        return this.encodeGlobalExpression(expression);
    }

    private boolean encodeGlobalExpression(IExpression expression) {
        if (expression instanceof OperatorExpression && ((OperatorExpression)expression).getOperator() == EOperator.LOGICAL_AND) {
            return this.encodeGlobalAndExpression(expression);
        }
        Set<String> involved = expression.getInvolvedVars();
        this.extractDomains(involved);
        InstantiationIterator instantiationIterator = new InstantiationIterator(involved, this.domains);
        for (Map<String, Integer> fullInstantiation : instantiationIterator) {
            Map<String, Integer> bindingsChange = instantiationIterator.getInstantiationUpdate();
            int result = this.updateEvaluation(expression, bindingsChange);
            if (result != 0 || !this.encodeNogood(fullInstantiation)) continue;
            return true;
        }
        return false;
    }

    private void extractDomains(Set<String> involved) {
        for (String var : involved) {
            if (this.domains.get(var) != null) continue;
            this.domains.put(var, this.solver.getCspVarDomain(var));
        }
    }

    private boolean encodeGlobalAndExpression(IExpression expression) {
        boolean contradictionFound = false;
        int i = 0;
        while (!contradictionFound && i < expression.getOperands().length) {
            contradictionFound |= this.encodeGlobalExpression(expression.getOperands()[i]);
            ++i;
        }
        return contradictionFound;
    }

    private int updateEvaluation(IExpression expression, Map<String, Integer> bindingsChange) {
        int result;
        try {
            String methodNameSuffix = String.valueOf(expression.typeAsString().substring(0, 1).toUpperCase()) + expression.typeAsString().substring(1);
            Method toCall = this.getClass().getMethod("updateEvaluationFor" + methodNameSuffix, IExpression.class, Map.class);
            result = (Integer)toCall.invoke((Object)this, expression, bindingsChange);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public int updateEvaluationForInteger(IExpression expr, Map<String, Integer> bindingsChange) {
        return ((IntegerExpression)expr).getValue();
    }

    public int updateEvaluationForVar(IExpression iexpr, Map<String, Integer> bindingsChange) {
        VarExpression expr = (VarExpression)iexpr;
        Integer value = bindingsChange.get(expr.getVar());
        if (value == null) {
            return this.lastVarExprEvaluation.get(expr);
        }
        this.lastVarExprEvaluation.put(expr, value);
        return value;
    }

    public int updateEvaluationForOperator(IExpression iexpr, Map<String, Integer> bindingsChange) {
        OperatorExpression expr = (OperatorExpression)iexpr;
        boolean inCache = true;
        for (String var : bindingsChange.keySet()) {
            if (!expr.getInvolvedVars().contains(var)) continue;
            inCache = false;
            break;
        }
        if (inCache) {
            return this.lastOpExprEvaluation.get(expr);
        }
        int value = this.updateEvaluation(expr.getOperator(), expr.getOperands(), bindingsChange);
        this.lastOpExprEvaluation.put(expr, value);
        return value;
    }

    public int updateEvaluation(EOperator operator, IExpression[] operands, Map<String, Integer> bindingsChange) {
        int result;
        int[] childrenEvaluation = new int[operands.length];
        int i = 0;
        while (i < operands.length) {
            childrenEvaluation[i] = this.updateEvaluation(operands[i], bindingsChange);
            ++i;
        }
        try {
            Method toCall = this.getClass().getMethod("evaluateOperator" + operator.nameAsString().substring(0, 1).toUpperCase() + operator.nameAsString().substring(1), int[].class);
            result = (Integer)toCall.invoke((Object)this, new Object[]{childrenEvaluation});
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public int evaluateOperatorNeg(int[] v) {
        return -v[0];
    }

    public int evaluateOperatorAbs(int[] v) {
        return Math.abs(v[0]);
    }

    public int evaluateOperatorAdd(int[] v) {
        int sum = 0;
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            sum += i;
            ++n2;
        }
        return sum;
    }

    public int evaluateOperatorSub(int[] v) {
        return v[0] - v[1];
    }

    public int evaluateOperatorMul(int[] v) {
        int prod = 1;
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            prod *= i;
            ++n2;
        }
        return prod;
    }

    public int evaluateOperatorDiv(int[] v) {
        return v[0] / v[1];
    }

    public int evaluateOperatorMod(int[] v) {
        return v[0] % v[1];
    }

    public int evaluateOperatorSqr(int[] v) {
        return v[0] * v[0];
    }

    public int evaluateOperatorPow(int[] v) {
        return this.internalEvaluate(v[0], v[1]);
    }

    private int internalEvaluate(int a, int b) {
        if (b == 1) {
            return a;
        }
        int halfPow = this.internalEvaluate(a, b / 2);
        if ((b & 1) == 0) {
            return halfPow * halfPow;
        }
        return a * halfPow * halfPow;
    }

    public int evaluateOperatorMin(int[] v) {
        int m = Integer.MAX_VALUE;
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            m = Math.min(m, i);
            ++n2;
        }
        return m;
    }

    public int evaluateOperatorMax(int[] v) {
        int m = Integer.MIN_VALUE;
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            m = Math.max(m, i);
            ++n2;
        }
        return m;
    }

    public int evaluateOperatorDist(int[] v) {
        return Math.abs(v[0] - v[1]);
    }

    public int evaluateOperatorLt(int[] v) {
        return v[0] < v[1] ? 1 : 0;
    }

    public int evaluateOperatorLe(int[] v) {
        return v[0] <= v[1] ? 1 : 0;
    }

    public int evaluateOperatorGt(int[] v) {
        return v[0] > v[1] ? 1 : 0;
    }

    public int evaluateOperatorGe(int[] v) {
        return v[0] >= v[1] ? 1 : 0;
    }

    public int evaluateOperatorNe(int[] v) {
        return v[0] != v[1] ? 1 : 0;
    }

    public int evaluateOperatorEq(int[] v) {
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i != v[0]) {
                return 0;
            }
            ++n2;
        }
        return 1;
    }

    public int evaluateOperatorNot(int[] v) {
        return v[0] == 0 ? 1 : 0;
    }

    public int evaluateOperatorAnd(int[] v) {
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == 0) {
                return 0;
            }
            ++n2;
        }
        return 1;
    }

    public int evaluateOperatorOr(int[] v) {
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i != 0) {
                return 1;
            }
            ++n2;
        }
        return 0;
    }

    public int evaluateOperatorXor(int[] v) {
        return v[0] == 0 && v[1] != 0 ? 1 : (v[0] != 0 && v[1] == 0 ? 1 : 0);
    }

    public int evaluateOperatorIff(int[] v) {
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i != 0 && v[0] == 0 || i == 0 && v[0] != 0) {
                return 0;
            }
            ++n2;
        }
        return 1;
    }

    public int evaluateOperatorImp(int[] v) {
        return v[0] == 0 || v[1] != 0 ? 1 : 0;
    }

    public int evaluateOperatorIf(int[] v) {
        return v[0] != 0 ? v[1] : v[2];
    }

    private boolean encodeNogood(Map<String, Integer> fullInstantiation) {
        int[] clause = new int[fullInstantiation.size()];
        int i = 0;
        for (Map.Entry<String, Integer> assignment : fullInstantiation.entrySet()) {
            clause[i++] = -this.solver.getSolverVar(assignment.getKey(), assignment.getValue());
        }
        return this.solver.addClause(clause);
    }

    @Override
    public ICspToSatEncoder getSolver() {
        return this.solver;
    }

    @Override
    public ObjectiveFunction encodeObj(String expr) {
        throw new UnsupportedOperationException("use another intension constraint encoder");
    }

    private class InstantiationIterator
    implements Iterable<Map<String, Integer>>,
    Iterator<Map<String, Integer>> {
        private final Map<String, int[]> domainMap;
        private final String[] vars;
        private final int[][] domains;
        private final int[] domainSizes;
        private final int[] domainIndexes;
        private Map<String, Integer> fullInstantiation;
        private Map<String, Integer> lastFullInstantiation;
        private Map<String, Integer> lastInstantiationUpdate;
        private Map<String, Integer> instantiationUpdate;

        public InstantiationIterator(Set<String> involved, Map<String, int[]> domainMap) {
            this.domainMap = domainMap;
            int nVars = involved.size();
            if (nVars == 0) {
                throw new IllegalArgumentException("number of involved vars must be higher than zero");
            }
            this.vars = new String[nVars];
            this.domains = new int[nVars][];
            this.domainSizes = new int[nVars];
            this.domainIndexes = new int[nVars];
            this.initDataStructures(involved);
            this.computeFirst();
        }

        private void initDataStructures(Set<String> involved) {
            int i = 0;
            Iterator<String> iterator = involved.iterator();
            while (iterator.hasNext()) {
                String var;
                this.vars[i] = var = iterator.next();
                int[] domain = this.domainMap.get(var);
                this.domains[i] = domain;
                this.domainSizes[i] = domain.length;
                this.domainIndexes[i] = 0;
                ++i;
            }
        }

        @Override
        public Iterator<Map<String, Integer>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.instantiationUpdate != null;
        }

        @Override
        public Map<String, Integer> next() {
            this.lastFullInstantiation = this.fullInstantiation;
            this.lastInstantiationUpdate = this.instantiationUpdate;
            this.computeNext();
            return this.lastFullInstantiation;
        }

        public Map<String, Integer> getInstantiationUpdate() {
            return this.lastInstantiationUpdate;
        }

        private void computeFirst() {
            this.fullInstantiation = new HashMap<String, Integer>();
            this.instantiationUpdate = new HashMap<String, Integer>();
            int i = 0;
            while (i < this.vars.length) {
                this.fullInstantiation.put(this.vars[i], this.domains[i][0]);
                this.instantiationUpdate.put(this.vars[i], this.domains[i][0]);
                ++i;
            }
        }

        private void computeNext() {
            this.fullInstantiation = new HashMap<String, Integer>(this.lastFullInstantiation);
            this.instantiationUpdate = new HashMap<String, Integer>();
            int i = this.vars.length - 1;
            while (i >= 0) {
                if (this.domainIndexes[i] < this.domainSizes[i] - 1) {
                    int n = i;
                    this.domainIndexes[n] = this.domainIndexes[n] + 1;
                    this.fullInstantiation.put(this.vars[i], this.domains[i][this.domainIndexes[i]]);
                    this.instantiationUpdate.put(this.vars[i], this.domains[i][this.domainIndexes[i]]);
                    break;
                }
                this.domainIndexes[i] = 0;
                this.fullInstantiation.put(this.vars[i], this.domains[i][0]);
                this.instantiationUpdate.put(this.vars[i], this.domains[i][0]);
                --i;
            }
            if (i == -1) {
                this.fullInstantiation = null;
                this.instantiationUpdate = null;
            }
        }
    }
}

