/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.intension;

import java.util.HashMap;
import java.util.Map;
import org.sat4j.csp.intension.EExpressionType;

public enum EOperator {
    OPPOSITE("neg", EExpressionType.INTEGER, 1, 1, EAssociativityState.NONE),
    ABSOLUTE_VALUE("abs", EExpressionType.INTEGER, 1, 1, EAssociativityState.NONE),
    ADDITION("add", EExpressionType.INTEGER, 1, Integer.MAX_VALUE, EAssociativityState.ASSOCIATIVE),
    SUBTRACTION("sub", EExpressionType.INTEGER, 2, 2, EAssociativityState.NONE),
    MULTIPLICATION("mul", EExpressionType.INTEGER, 1, Integer.MAX_VALUE, EAssociativityState.ASSOCIATIVE),
    INTEGER_DIVISION("div", EExpressionType.INTEGER, 2, 2, EAssociativityState.NONE),
    REMAINDER("mod", EExpressionType.INTEGER, 2, 2, EAssociativityState.NONE),
    SQUARE("sqr", EExpressionType.INTEGER, 1, 1, EAssociativityState.NONE),
    POWER("pow", EExpressionType.INTEGER, 2, 2, EAssociativityState.NONE),
    MINIMUM("min", EExpressionType.INTEGER, 1, Integer.MAX_VALUE, EAssociativityState.ASSOCIATIVE),
    MAXIMUM("max", EExpressionType.INTEGER, 1, Integer.MAX_VALUE, EAssociativityState.ASSOCIATIVE),
    DISTANCE("dist", EExpressionType.INTEGER, 2, 2, EAssociativityState.NONE),
    LESS_THAN("lt", EExpressionType.BOOLEAN, 2, 2, EAssociativityState.NONE),
    LESS_THAN_OR_EQUAL("le", EExpressionType.BOOLEAN, 2, 2, EAssociativityState.NONE),
    GREATER_THAN("gt", EExpressionType.BOOLEAN, 2, 2, EAssociativityState.NONE),
    GREATER_THAN_OR_EQUAL("ge", EExpressionType.BOOLEAN, 2, 2, EAssociativityState.NONE),
    DIFFERENT_FROM("ne", EExpressionType.BOOLEAN, 2, 2, EAssociativityState.NONE),
    EQUAL_TO("eq", EExpressionType.BOOLEAN, 1, Integer.MAX_VALUE, EAssociativityState.AND_CHAIN_OF_TWO_WITH_FIRST_COMMON),
    SET("set", EExpressionType.SET, 0, Integer.MAX_VALUE, EAssociativityState.NONE),
    MEMBERSHIP("in", EExpressionType.BOOLEAN, 2, 2, EAssociativityState.NONE),
    LOGICAL_NOT("not", EExpressionType.BOOLEAN, 1, 1, EAssociativityState.NONE),
    LOGICAL_AND("and", EExpressionType.BOOLEAN, 1, Integer.MAX_VALUE, EAssociativityState.ASSOCIATIVE),
    LOGICAL_OR("or", EExpressionType.BOOLEAN, 1, Integer.MAX_VALUE, EAssociativityState.ASSOCIATIVE),
    LOGICAL_XOR("xor", EExpressionType.BOOLEAN, 2, Integer.MAX_VALUE, EAssociativityState.NONE),
    LOGICAL_EQUIVALENCE("iff", EExpressionType.BOOLEAN, 1, Integer.MAX_VALUE, EAssociativityState.AND_CHAIN_OF_TWO_WITH_FIRST_COMMON),
    LOGICAL_IMPLICATION("imp", EExpressionType.BOOLEAN, 2, 2, EAssociativityState.NONE),
    ALTERNATIVE("if", EExpressionType.SAME_AS_CHILDREN, 3, 3, EAssociativityState.NONE),
    ALTERNATIVE_ALIAS("ite", EExpressionType.SAME_AS_CHILDREN, 3, 3, EAssociativityState.NONE);

    public static final int INFINITE_ARITY = Integer.MAX_VALUE;
    private final String op;
    private final int minArity;
    private final int maxArity;
    private EExpressionType resultType;
    private final EAssociativityState associativityState;
    private static final Map<String, EOperator> strOpCache;

    static {
        strOpCache = new HashMap<String, EOperator>();
    }

    private EOperator(String op, EExpressionType resultType, int minArity, int maxArity, EAssociativityState associativity) {
        this.op = op;
        this.resultType = resultType;
        this.minArity = minArity;
        this.maxArity = maxArity;
        this.associativityState = associativity;
    }

    public static EOperator operator(String str) {
        EOperator operator = strOpCache.get(str);
        if (operator != null) {
            return operator;
        }
        EOperator[] eOperatorArray = EOperator.values();
        int n = eOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            EOperator op = eOperatorArray[n2];
            if (op.nameAsString().equals(str)) {
                operator = op;
                break;
            }
            ++n2;
        }
        if (operator == null) {
            throw new IllegalArgumentException("\"" + str + "\" is not a valid operator");
        }
        strOpCache.put(str, operator);
        return operator;
    }

    public String nameAsString() {
        return this.op;
    }

    public EExpressionType resultType() {
        return this.resultType;
    }

    public int minArity() {
        return this.minArity;
    }

    public int maxArity() {
        return this.maxArity;
    }

    public EAssociativityState associtivityState() {
        return this.associativityState;
    }

    static enum EAssociativityState {
        NONE,
        ASSOCIATIVE,
        AND_CHAIN_OF_TWO_WITH_FIRST_COMMON;

    }
}

