/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.intension;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.sat4j.core.VecInt;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Domains;
import org.sat4j.csp.Var;
import org.sat4j.csp.constraints3.CtrBuilderUtils;
import org.sat4j.csp.intension.ICspToSatEncoder;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.xcsp.parser.entries.XVariables;

public class CspToPBSolverDecorator
implements ICspToSatEncoder {
    private final IPBSolver solver;
    private final Map<String, Var> varmapping = new LinkedHashMap<String, Var>();
    private final Map<Var, Integer> firstInternalVarMapping = new LinkedHashMap<Var, Integer>();

    public CspToPBSolverDecorator(IPBSolver solver) {
        this.solver = solver;
    }

    @Override
    public int[] getCspVarDomain(String strVar) {
        Var var = this.varmapping.get(strVar);
        if (var == null) {
            return null;
        }
        Domain domain = var.domain();
        int domSize = domain.size();
        int[] domArray = new int[domSize];
        int i = 0;
        while (i < domSize) {
            domArray[i] = domain.get(i);
            ++i;
        }
        return domArray;
    }

    @Override
    public int getSolverVar(String strVar, Integer value) {
        Var var = this.varmapping.get(strVar);
        int solverVar = this.firstInternalVarMapping.get(var);
        Domain domain = var.domain();
        int domSize = domain.size();
        int i = 0;
        while (i < domSize) {
            if (domain.get(i) == value.intValue()) {
                return solverVar;
            }
            ++solverVar;
            ++i;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean addClause(int[] clause) {
        try {
            this.solver.addClause(new VecInt(clause));
        }
        catch (ContradictionException e) {
            return true;
        }
        return false;
    }

    @Override
    public Integer newSatSolverVar() {
        return this.solver.nextFreeVarId(true);
    }

    @Override
    public void newCspVar(XVariables.XVarInteger var, int minDom, int maxDom) {
        Domain dom = Domains.getInstance().getDomain(minDom, maxDom);
        this.newCspVar(var, dom);
    }

    @Override
    public void newCspVar(XVariables.XVarInteger var, int[] domain) {
        Arrays.sort(domain);
        boolean isRange = true;
        int i = 0;
        while (i < domain.length - 1) {
            if (domain[i] != domain[i + 1] - 1) {
                isRange = false;
                break;
            }
            ++i;
        }
        Domain dom = isRange ? Domains.getInstance().getDomain(domain[0], domain[domain.length - 1]) : Domains.getInstance().getDomain(domain);
        this.newCspVar(var, dom);
    }

    private void newCspVar(XVariables.XVarInteger var, Domain dom) {
        Var cspVar = new Var(CtrBuilderUtils.normalizeCspVarName(var.id), dom, this.solver.nextFreeVarId(false) - 1);
        this.firstInternalVarMapping.put(cspVar, this.solver.nextFreeVarId(false));
        int i = 0;
        while (i < dom.size()) {
            this.solver.nextFreeVarId(true);
            ++i;
        }
        try {
            cspVar.toClause(this.solver);
        }
        catch (ContradictionException e) {
            throw new IllegalStateException("cannot occur");
        }
        this.varmapping.put(var.id, cspVar);
    }

    @Override
    public Map<Integer, String> getMapping() {
        TreeMap<Integer, String> mapping = new TreeMap<Integer, String>();
        for (String var : this.varmapping.keySet()) {
            int[] domain = this.getCspVarDomain(var);
            int i = 0;
            while (i < domain.length) {
                int solverVar = this.getSolverVar(var, domain[i]);
                mapping.put(solverVar, String.valueOf(var) + "=" + domain[i]);
                ++i;
            }
        }
        return mapping;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        this.solver.setObjectiveFunction(obj);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.solver.getObjectiveFunction();
    }
}

