/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.encodings;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.sat4j.core.VecInt;
import org.sat4j.csp.Encoding;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

public class GeneralizedSupportEncoding
implements Encoding {
    private final Map<Set<Integer>, IVecInt> supports = new HashMap<Set<Integer>, IVecInt>();
    private static final Encoding INSTANCE = new GeneralizedSupportEncoding();

    private GeneralizedSupportEncoding() {
    }

    public static Encoding instance() {
        return INSTANCE;
    }

    @Override
    public void onFinish(ISolver solver, IVec<Var> scope) throws ContradictionException {
    }

    @Override
    public void onInit(ISolver solver, IVec<Var> scope) {
        this.supports.clear();
        int[] acc = new int[scope.size()];
        this.fill(0, scope, acc, this.supports);
    }

    @Override
    public void onNogood(ISolver solver, IVec<Var> scope, Map<Evaluable, Integer> tuple) throws ContradictionException {
    }

    @Override
    public void onSupport(ISolver solver, IVec<Var> scope, Map<Evaluable, Integer> tuple) throws ContradictionException {
        int i = 0;
        while (i < scope.size()) {
            TreeSet<Integer> set = new TreeSet<Integer>();
            Var vari = scope.get(i);
            int j = 0;
            while (j < scope.size()) {
                if (i != j) {
                    set.add(scope.get(j).translate(tuple.get(vari)));
                }
                ++j;
            }
            IVecInt support = this.supports.get(set);
            assert (support != null);
            support.push(vari.translate(tuple.get(vari)));
            ++i;
        }
    }

    private void fill(int n, IVec<Var> scope, int[] acc, Map<Set<Integer>, IVecInt> theSupports) {
        if (n == scope.size()) {
            int j = 0;
            while (j < acc.length) {
                TreeSet<Integer> set = new TreeSet<Integer>();
                int i = 0;
                while (i < acc.length) {
                    if (i != j) {
                        set.add(scope.get(i).translate(acc[i]));
                    }
                    ++i;
                }
                theSupports.put(set, new VecInt());
                ++j;
            }
        } else {
            IteratorInt iterator = scope.get(n).domain().iterator();
            while (iterator.hasNext()) {
                acc[n] = iterator.next();
                this.fill(n + 1, scope, acc, theSupports);
            }
        }
    }
}

