/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints3;

import java.util.ArrayList;
import java.util.List;
import org.sat4j.csp.Predicate;
import org.sat4j.csp.constraints3.CtrBuilderUtils;
import org.xcsp.common.Condition;

public class StringCondition {
    public static final String LEFT_OPERAND = "__LEFT_OPERAND__";
    private String asString;
    private List<String> vars = new ArrayList<String>();

    public StringCondition(Condition.ConditionVar condition) {
        String varId = condition.x.id();
        this.vars.add(varId);
        this.asString = String.valueOf(condition.operator.name().toLowerCase()) + "(" + LEFT_OPERAND + "," + CtrBuilderUtils.normalizeCspVarName(varId) + ")";
    }

    public StringCondition(Condition.ConditionVal condition) {
        this.asString = String.valueOf(condition.operator.name().toLowerCase()) + "(" + LEFT_OPERAND + "," + Long.toString(condition.k) + ")";
    }

    public StringCondition(Condition.ConditionIntvl condition) {
        this.asString = "and(ge(__LEFT_OPERAND__," + Long.toString(condition.min) + "),le(" + LEFT_OPERAND + "," + Long.toString(condition.max) + "))";
    }

    public StringCondition(String str) {
        this.asString = str;
    }

    public StringCondition(String leftOperandPrefix, String leftOperandSuffix) {
        this(String.valueOf(leftOperandPrefix) + LEFT_OPERAND + leftOperandSuffix);
    }

    public static StringCondition buildStringCondition(Condition condition) {
        if (condition instanceof Condition.ConditionVar) {
            return new StringCondition((Condition.ConditionVar)condition);
        }
        if (condition instanceof Condition.ConditionVal) {
            return new StringCondition((Condition.ConditionVal)condition);
        }
        if (condition instanceof Condition.ConditionIntvl) {
            return new StringCondition((Condition.ConditionIntvl)condition);
        }
        throw new IllegalArgumentException();
    }

    public void addVariable(String var) {
        this.vars.add(var);
    }

    public List<String> getVarIds() {
        return this.vars;
    }

    public boolean hasVariables() {
        return this.vars.size() > 0;
    }

    public String asString(String leftOperand) {
        return this.asString.replaceAll(LEFT_OPERAND, leftOperand);
    }

    public void setPredicateExpression(Predicate p, String leftOperand) {
        this.setPredicateExpression(p, leftOperand, true);
    }

    public void setPredicateExpression(Predicate p, String leftOperand, boolean addVariables) {
        if (addVariables) {
            for (String var : this.vars) {
                if (p.containsVariable(var)) continue;
                p.addVariable(var);
            }
        }
        p.setExpression(this.asString(leftOperand));
    }
}

