/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.sat4j.csp.constraints3.CtrBuilderUtils;
import org.sat4j.csp.constraints3.StringCondition;
import org.sat4j.csp.intension.IIntensionCtrEncoder;
import org.xcsp.common.Condition;
import org.xcsp.parser.entries.XDomains;
import org.xcsp.parser.entries.XVariables;

public class SchedulingCtrBuilder {
    private final IIntensionCtrEncoder intensionEnc;

    public SchedulingCtrBuilder(IIntensionCtrEncoder intensionEnc) {
        this.intensionEnc = intensionEnc;
    }

    public boolean buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax) {
        this.preventVarMultipleOccurrences(list);
        int valueIndex = 0;
        while (valueIndex < values.length) {
            int widthMin = widthsMin[valueIndex];
            int stretchBeginIndex = 0;
            while (stretchBeginIndex < list.length) {
                if (this.preventUnderLength(values[valueIndex], list, stretchBeginIndex, widthMin)) {
                    return true;
                }
                ++stretchBeginIndex;
            }
            int widthMax = widthsMax[valueIndex];
            int stretchBeginIndex2 = 0;
            while (stretchBeginIndex2 < list.length) {
                if (this.preventOverLength(values[valueIndex], list, stretchBeginIndex2, widthMax)) {
                    return true;
                }
                ++stretchBeginIndex2;
            }
            ++valueIndex;
        }
        return false;
    }

    private void preventVarMultipleOccurrences(XVariables.XVarInteger[] list) {
        int i = 0;
        while (i < list.length - 1) {
            int j = i + 1;
            while (j < list.length) {
                if (list[i].id.equals(list[j].id)) {
                    throw new IllegalArgumentException("Variables in //stretch/list may occur only once");
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean preventOverLength(int value, XVariables.XVarInteger[] list, int stretchBeginIndex, int widthMax) {
        if (stretchBeginIndex + widthMax >= list.length) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("imp(");
        if (stretchBeginIndex > 0) {
            sb.append("and(");
        }
        sb.append("eq(").append(CtrBuilderUtils.normalizeCspVarName(list[stretchBeginIndex].id)).append(',').append(value).append(')');
        if (stretchBeginIndex > 0) {
            sb.append(",ne(").append(CtrBuilderUtils.normalizeCspVarName(list[stretchBeginIndex - 1].id)).append(',').append(value).append("))");
        }
        sb.append(',');
        sb.append("or(");
        int i = stretchBeginIndex + 1;
        while (i <= stretchBeginIndex + widthMax) {
            if (i > stretchBeginIndex + 1) {
                sb.append(',');
            }
            sb.append("ne(").append(CtrBuilderUtils.normalizeCspVarName(list[i].id)).append(',').append(value).append(')');
            ++i;
        }
        sb.append("))");
        return this.intensionEnc.encode(sb.toString());
    }

    private boolean preventUnderLength(int value, XVariables.XVarInteger[] list, int stretchBeginIndex, int widthMin) {
        if (widthMin == 1) {
            return false;
        }
        if (list.length - stretchBeginIndex < widthMin) {
            return this.preventUnderLengthDueToBeginIndex(value, list, stretchBeginIndex);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("imp(");
        if (stretchBeginIndex > 0) {
            sb.append("and(");
        }
        sb.append("eq(").append(CtrBuilderUtils.normalizeCspVarName(list[stretchBeginIndex].id)).append(',').append(value).append(')');
        if (stretchBeginIndex > 0) {
            sb.append(",ne(").append(CtrBuilderUtils.normalizeCspVarName(list[stretchBeginIndex - 1].id)).append(',').append(value).append("))");
        }
        sb.append(',');
        sb.append("and(");
        int i = stretchBeginIndex + 1;
        while (i <= stretchBeginIndex + widthMin - 1) {
            if (i > stretchBeginIndex + 1) {
                sb.append(',');
            }
            sb.append("eq(").append(CtrBuilderUtils.normalizeCspVarName(list[i].id)).append(',').append(value).append(')');
            ++i;
        }
        sb.append("))");
        return this.intensionEnc.encode(sb.toString());
    }

    private boolean preventUnderLengthDueToBeginIndex(int value, XVariables.XVarInteger[] list, int stretchBeginIndex) {
        StringBuilder sb = new StringBuilder();
        if (stretchBeginIndex > 0) {
            sb.append("or(");
        }
        sb.append("ne(").append(CtrBuilderUtils.normalizeCspVarName(list[stretchBeginIndex].id)).append(',').append(value).append(')');
        if (stretchBeginIndex > 0) {
            sb.append(",eq(").append(CtrBuilderUtils.normalizeCspVarName(list[stretchBeginIndex - 1].id)).append(',').append(value).append("))");
        }
        return this.intensionEnc.encode(sb.toString());
    }

    public boolean buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        if (this.buildCtrStretch(id, list, values, widthsMin, widthsMax)) {
            return true;
        }
        return this.buildCtrStretchPatterns(list, patterns);
    }

    private boolean buildCtrStretchPatterns(XVariables.XVarInteger[] list, int[][] patterns) {
        int i = 0;
        while (i < list.length - 1) {
            String normVar1 = CtrBuilderUtils.normalizeCspVarName(list[i].id);
            String normVar2 = CtrBuilderUtils.normalizeCspVarName(list[i + 1].id);
            String predExprCond = "ne(" + normVar1 + "," + normVar2 + ")";
            StringBuilder predExprImplBuf = new StringBuilder();
            predExprImplBuf.append("or(");
            predExprImplBuf.append("and(eq(" + normVar1 + "," + Integer.toString(patterns[0][0]) + "),eq(" + normVar2 + "," + Integer.toString(patterns[0][1]) + "))");
            int j = 1;
            while (j < patterns.length) {
                predExprImplBuf.append(',');
                predExprImplBuf.append("and(eq(" + normVar1 + "," + Integer.toString(patterns[j][0]) + "),eq(" + normVar2 + "," + Integer.toString(patterns[j][1]) + "))");
                ++j;
            }
            predExprImplBuf.append(')');
            String predExpr = "iff(" + predExprCond + "," + predExprImplBuf.toString() + ")";
            if (this.intensionEnc.encode(predExpr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, int[] heights, Condition condition) {
        int maxT = this.computeMaxT(origins, lengths);
        int t = 0;
        while (t < maxT) {
            StringBuilder exprBuff = new StringBuilder();
            exprBuff.append("add(");
            this.builtCtrCumulativeHeightComp(origins, 0, lengths, t, heights, exprBuff);
            int i = 1;
            while (i < origins.length) {
                exprBuff.append(',');
                this.builtCtrCumulativeHeightComp(origins, i, lengths, t, heights, exprBuff);
                ++i;
            }
            exprBuff.append(')');
            StringCondition strCond = StringCondition.buildStringCondition(condition);
            if (this.intensionEnc.encode(strCond.asString(exprBuff.toString()))) {
                return true;
            }
            ++t;
        }
        return false;
    }

    private void builtCtrCumulativeHeightComp(XVariables.XVarInteger[] origins, int originIndex, int[] lengths, int t, int[] heights, StringBuilder exprBuff) {
        exprBuff.append("ite(");
        this.buildCtrCumulativeHeightCompCondition(origins, originIndex, lengths, t, exprBuff);
        exprBuff.append(',').append(Integer.toString(heights[originIndex])).append(",0)");
    }

    private void builtCtrCumulativeHeightComp(XVariables.XVarInteger[] origins, int originIndex, int[] lengths, int t, XVariables.XVarInteger[] heights, StringBuilder exprBuff) {
        exprBuff.append("ite(");
        this.buildCtrCumulativeHeightCompCondition(origins, originIndex, lengths, t, exprBuff);
        exprBuff.append(',');
        String normVar = CtrBuilderUtils.normalizeCspVarName(heights[originIndex].id);
        exprBuff.append(normVar);
        exprBuff.append(",0)");
    }

    private void builtCtrCumulativeHeightComp(XVariables.XVarInteger[] origins, int originIndex, XVariables.XVarInteger[] lengths, int t, int[] heights, StringBuilder exprBuff) {
        exprBuff.append("ite(");
        this.buildCtrCumulativeHeightCompCondition(origins, originIndex, lengths, t, exprBuff);
        exprBuff.append(',');
        exprBuff.append(Integer.toString(heights[originIndex]));
        exprBuff.append(",0)");
    }

    private void builtCtrCumulativeHeightComp(XVariables.XVarInteger[] origins, int originIndex, XVariables.XVarInteger[] lengths, int t, XVariables.XVarInteger[] heights, StringBuilder exprBuff) {
        exprBuff.append("ite(");
        this.buildCtrCumulativeHeightCompCondition(origins, originIndex, lengths, t, exprBuff);
        exprBuff.append(',');
        String normVar = CtrBuilderUtils.normalizeCspVarName(heights[originIndex].id);
        exprBuff.append(normVar);
        exprBuff.append(",0)");
    }

    private void buildCtrCumulativeHeightCompCondition(XVariables.XVarInteger[] origins, int originIndex, int[] lengths, int t, StringBuilder exprBuff) {
        exprBuff.append("and(le(");
        String normVar = CtrBuilderUtils.normalizeCspVarName(origins[originIndex].id);
        exprBuff.append(normVar).append(',').append(Integer.toString(t)).append("),gt(add(").append(normVar).append(',').append(Integer.toString(lengths[originIndex])).append("),").append(Integer.toString(t)).append("))");
    }

    private void buildCtrCumulativeHeightCompCondition(XVariables.XVarInteger[] origins, int originIndex, XVariables.XVarInteger[] lengths, int t, StringBuilder exprBuff) {
        exprBuff.append("and(le(");
        String normVar = CtrBuilderUtils.normalizeCspVarName(origins[originIndex].id);
        exprBuff.append(normVar).append(',').append(Integer.toString(t)).append("),gt(add(").append(normVar).append(',');
        String normLength = CtrBuilderUtils.normalizeCspVarName(lengths[originIndex].id);
        exprBuff.append(normLength);
        exprBuff.append("),").append(Integer.toString(t)).append("))");
    }

    private int computeMaxT(XVariables.XVarInteger[] origins, int[] heights) {
        int maxT = Integer.MIN_VALUE;
        int i = 0;
        while (i < origins.length) {
            maxT = (int)Math.max((long)maxT, ((XDomains.XDomInteger)origins[i].dom).lastValue() + (long)heights[i]);
            ++i;
        }
        return maxT;
    }

    private int computeMaxT(XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths) {
        int maxT = Integer.MIN_VALUE;
        int i = 0;
        while (i < origins.length) {
            maxT = (int)Math.max((long)maxT, ((XDomains.XDomInteger)origins[i].dom).lastValue() + ((XDomains.XDomInteger)lengths[i].dom).lastValue());
            ++i;
        }
        return maxT;
    }

    public boolean buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        int maxT = this.computeMaxT(origins, lengths);
        int t = 0;
        while (t < maxT) {
            StringBuilder exprBuff = new StringBuilder();
            exprBuff.append("add(");
            this.builtCtrCumulativeHeightComp(origins, 0, lengths, t, heights, exprBuff);
            int i = 1;
            while (i < origins.length) {
                exprBuff.append(',');
                this.builtCtrCumulativeHeightComp(origins, i, lengths, t, heights, exprBuff);
                ++i;
            }
            exprBuff.append(')');
            StringCondition strCond = StringCondition.buildStringCondition(condition);
            if (this.intensionEnc.encode(strCond.asString(exprBuff.toString()))) {
                return true;
            }
            ++t;
        }
        return false;
    }

    public boolean buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, int[] heights, Condition condition) {
        int maxT = this.computeMaxT(origins, lengths);
        int t = 0;
        while (t < maxT) {
            StringBuilder exprBuff = new StringBuilder();
            exprBuff.append("add(");
            this.builtCtrCumulativeHeightComp(origins, 0, lengths, t, heights, exprBuff);
            int i = 1;
            while (i < origins.length) {
                exprBuff.append(',');
                this.builtCtrCumulativeHeightComp(origins, i, lengths, t, heights, exprBuff);
                ++i;
            }
            exprBuff.append(')');
            StringCondition strCond = StringCondition.buildStringCondition(condition);
            if (this.intensionEnc.encode(strCond.asString(exprBuff.toString()))) {
                return true;
            }
            ++t;
        }
        return false;
    }

    public boolean buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        int maxT = this.computeMaxT(origins, lengths);
        int t = 0;
        while (t < maxT) {
            StringBuilder exprBuff = new StringBuilder();
            exprBuff.append("add(");
            this.builtCtrCumulativeHeightComp(origins, 0, lengths, t, heights, exprBuff);
            int i = 1;
            while (i < origins.length) {
                exprBuff.append(',');
                this.builtCtrCumulativeHeightComp(origins, i, lengths, t, heights, exprBuff);
                ++i;
            }
            exprBuff.append(')');
            StringCondition strCond = StringCondition.buildStringCondition(condition);
            if (this.intensionEnc.encode(strCond.asString(exprBuff.toString()))) {
                return true;
            }
            ++t;
        }
        return false;
    }

    public boolean buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        if (this.buildCtrCumulative(id, origins, lengths, heights, condition)) {
            return true;
        }
        return this.buildCtrCumulativeEnds(origins, lengths, ends);
    }

    private boolean buildCtrCumulativeEnds(XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends) {
        int i = 0;
        while (i < origins.length) {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("eq(add(");
            String normVar = CtrBuilderUtils.normalizeCspVarName(origins[i].id);
            sbuff.append(normVar).append(',').append(Integer.toString(lengths[i])).append("),");
            String normEnd = CtrBuilderUtils.normalizeCspVarName(ends[i].id);
            sbuff.append(normEnd).append(')');
            if (this.intensionEnc.encode(sbuff.toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean buildCtrCumulativeEnds(XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends) {
        int i = 0;
        while (i < origins.length) {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("eq(add(");
            String normVar = CtrBuilderUtils.normalizeCspVarName(origins[i].id);
            sbuff.append(normVar).append(',');
            String normLength = CtrBuilderUtils.normalizeCspVarName(lengths[i].id);
            sbuff.append(normLength).append("),");
            String normEnd = CtrBuilderUtils.normalizeCspVarName(ends[i].id);
            sbuff.append(normEnd).append(')');
            if (this.intensionEnc.encode(sbuff.toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        if (this.buildCtrCumulative(id, origins, lengths, heights, condition)) {
            return true;
        }
        return this.buildCtrCumulativeEnds(origins, lengths, ends);
    }

    public boolean buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        if (this.buildCtrCumulative(id, origins, lengths, heights, condition)) {
            return true;
        }
        return this.buildCtrCumulativeEnds(origins, lengths, ends);
    }

    public boolean buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        if (this.buildCtrCumulative(id, origins, lengths, heights, condition)) {
            return true;
        }
        return this.buildCtrCumulativeEnds(origins, lengths, ends);
    }

    public boolean buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, int[] lengths, boolean zeroIgnored) {
        int arrLen = origins.length;
        XVariables.XVarInteger[][] originsArr = new XVariables.XVarInteger[arrLen][];
        int[][] lengthsArr = new int[arrLen][];
        int i = 0;
        while (i < arrLen) {
            originsArr[i] = new XVariables.XVarInteger[]{origins[i]};
            lengthsArr[i] = new int[]{lengths[i]};
            ++i;
        }
        return this.buildCtrNoOverlap(id, originsArr, lengthsArr, zeroIgnored);
    }

    private boolean isZeroLengthBox(int[] lengths) {
        int i = 0;
        while (i < lengths.length) {
            if (lengths[i] > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, int[][] lengths, boolean zeroIgnored) {
        int oi1 = 0;
        while (oi1 < origins.length - 1) {
            XVariables.XVarInteger[] origins1 = origins[oi1];
            int[] lengths1 = lengths[oi1];
            if (!zeroIgnored || !this.isZeroLengthBox(lengths1)) {
                ArrayList<String> strOrigins1 = new ArrayList<String>();
                XVariables.XVarInteger[] xVarIntegerArray = origins1;
                int n = origins1.length;
                int n2 = 0;
                while (n2 < n) {
                    XVariables.XVarInteger var = xVarIntegerArray[n2];
                    strOrigins1.add(CtrBuilderUtils.normalizeCspVarName(var.id));
                    ++n2;
                }
                ArrayList<String> strLengths1 = new ArrayList<String>();
                int[] nArray = lengths1;
                int n3 = lengths1.length;
                n = 0;
                while (n < n3) {
                    Integer length = nArray[n];
                    strLengths1.add(Integer.toString(length));
                    ++n;
                }
                int oi2 = oi1 + 1;
                while (oi2 < origins.length) {
                    XVariables.XVarInteger[] origins2 = origins[oi2];
                    int[] lengths2 = lengths[oi2];
                    if (!zeroIgnored || !this.isZeroLengthBox(lengths2)) {
                        ArrayList<String> strOrigins2 = new ArrayList<String>();
                        XVariables.XVarInteger[] xVarIntegerArray2 = origins2;
                        int n4 = origins2.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            XVariables.XVarInteger var = xVarIntegerArray2[n5];
                            strOrigins2.add(CtrBuilderUtils.normalizeCspVarName(var.id));
                            ++n5;
                        }
                        ArrayList<String> strLengths2 = new ArrayList<String>();
                        int[] nArray2 = lengths2;
                        int n6 = lengths2.length;
                        n4 = 0;
                        while (n4 < n6) {
                            Integer length = nArray2[n4];
                            strLengths2.add(Integer.toString(length));
                            ++n4;
                        }
                        String expr = this.buildCtrNoOverlapStr(strOrigins1, strLengths1, strOrigins2, strLengths2, false);
                        if (this.intensionEnc.encode(expr)) {
                            return true;
                        }
                    }
                    ++oi2;
                }
            }
            ++oi1;
        }
        return false;
    }

    private String buildCtrNoOverlapStr(List<String> strOrigins1, List<String> strLengths1, List<String> strOrigins2, List<String> strLengths2, boolean zeroIgn) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("or(");
        sbuf.append("le(add(").append(strOrigins1.get(0)).append(',').append(strLengths1.get(0)).append(')').append(',').append(strOrigins2.get(0)).append(')');
        sbuf.append(",le(add(").append(strOrigins2.get(0)).append(',').append(strLengths2.get(0)).append(')').append(',').append(strOrigins1.get(0)).append(')');
        int i = 1;
        while (i < strOrigins1.size()) {
            sbuf.append(",le(add(").append(strOrigins1.get(i)).append(',').append(strLengths1.get(i)).append(')').append(',').append(strOrigins2.get(i)).append(')');
            sbuf.append(",le(add(").append(strOrigins2.get(i)).append(',').append(strLengths2.get(i)).append(')').append(',').append(strOrigins1.get(i)).append(')');
            ++i;
        }
        if (zeroIgn) {
            sbuf.append(',').append(this.zeroLengthCtr(strLengths1));
            sbuf.append(',').append(this.zeroLengthCtr(strLengths2));
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    private String zeroLengthCtr(List<String> strLengths) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("and(eq(0,").append(strLengths.get(0)).append(')');
        int i = 1;
        while (i < strLengths.size()) {
            sbuf.append(',').append("eq(0,").append(strLengths.get(0)).append(')');
            ++i;
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    public boolean buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, boolean zeroIgnored) {
        int arrLen = origins.length;
        XVariables.XVarInteger[][] originsArr = new XVariables.XVarInteger[arrLen][];
        XVariables.XVarInteger[][] lengthsArr = new XVariables.XVarInteger[arrLen][];
        int i = 0;
        while (i < arrLen) {
            originsArr[i] = new XVariables.XVarInteger[]{origins[i]};
            lengthsArr[i] = new XVariables.XVarInteger[]{lengths[i]};
            ++i;
        }
        return this.buildCtrNoOverlap(id, originsArr, lengthsArr, zeroIgnored);
    }

    public boolean buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, XVariables.XVarInteger[][] lengths, boolean zeroIgnored) {
        int oi1 = 0;
        while (oi1 < origins.length - 1) {
            XVariables.XVarInteger[] origins1 = origins[oi1];
            XVariables.XVarInteger[] lengths1 = lengths[oi1];
            ArrayList<String> strOrigins1 = new ArrayList<String>();
            XVariables.XVarInteger[] xVarIntegerArray = origins1;
            int n = origins1.length;
            int n2 = 0;
            while (n2 < n) {
                XVariables.XVarInteger var = xVarIntegerArray[n2];
                strOrigins1.add(CtrBuilderUtils.normalizeCspVarName(var.id));
                ++n2;
            }
            ArrayList<String> strLengths1 = new ArrayList<String>();
            XVariables.XVarInteger[] xVarIntegerArray2 = lengths1;
            int n3 = lengths1.length;
            n = 0;
            while (n < n3) {
                XVariables.XVarInteger length = xVarIntegerArray2[n];
                strLengths1.add(CtrBuilderUtils.normalizeCspVarName(length.id));
                ++n;
            }
            int oi2 = oi1 + 1;
            while (oi2 < origins.length) {
                XVariables.XVarInteger[] origins2 = origins[oi2];
                XVariables.XVarInteger[] lengths2 = lengths[oi2];
                ArrayList<String> strOrigins2 = new ArrayList<String>();
                XVariables.XVarInteger[] xVarIntegerArray3 = origins2;
                int n4 = origins2.length;
                int n5 = 0;
                while (n5 < n4) {
                    XVariables.XVarInteger var = xVarIntegerArray3[n5];
                    strOrigins2.add(CtrBuilderUtils.normalizeCspVarName(var.id));
                    ++n5;
                }
                ArrayList<String> strLengths2 = new ArrayList<String>();
                XVariables.XVarInteger[] xVarIntegerArray4 = lengths2;
                int n6 = lengths2.length;
                n4 = 0;
                while (n4 < n6) {
                    XVariables.XVarInteger length = xVarIntegerArray4[n4];
                    strLengths2.add(CtrBuilderUtils.normalizeCspVarName(length.id));
                    ++n4;
                }
                String expr = this.buildCtrNoOverlapStr(strOrigins1, strLengths1, strOrigins2, strLengths2, zeroIgnored);
                if (this.intensionEnc.encode(expr)) {
                    return true;
                }
                ++oi2;
            }
            ++oi1;
        }
        return false;
    }

    public boolean buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex) {
        List<List<Integer>> circuits = this.buildCircuits(new int[list.length], 0);
        String[] circuitsExprs = new String[circuits.size()];
        int i = 0;
        while (i < circuits.size()) {
            List<Integer> circuit = circuits.get(i);
            String[] eqExprs = new String[circuit.size()];
            int j = 0;
            while (j < circuit.size()) {
                String norm = CtrBuilderUtils.normalizeCspVarName(list[j].id);
                eqExprs[j] = "eq(" + norm + "," + (circuit.get(j) + startIndex) + ")";
                ++j;
            }
            circuitsExprs[i] = CtrBuilderUtils.chainExpressionsForAssociativeOp(eqExprs, "and");
            ++i;
        }
        String expr = CtrBuilderUtils.chainExpressionsForAssociativeOp(circuitsExprs, "or");
        return this.intensionEnc.encode(expr);
    }

    private List<List<Integer>> buildCircuits(int[] circuit, int length) {
        if (length == circuit.length) {
            return this.returnIfCircuit(circuit);
        }
        ArrayList<List<Integer>> circuits = new ArrayList<List<Integer>>();
        int i = 0;
        while (i < circuit.length) {
            boolean mustContinue = false;
            int j = 0;
            while (j < length) {
                if (circuit[j] == i) {
                    mustContinue = true;
                    break;
                }
                ++j;
            }
            if (!mustContinue) {
                circuit[length] = i;
                circuits.addAll(this.buildCircuits(circuit, length + 1));
            }
            ++i;
        }
        return circuits;
    }

    private List<List<Integer>> returnIfCircuit(int[] circuit) {
        HashSet<Integer> visited = new HashSet<Integer>();
        int i = 0;
        while (i < circuit.length && circuit[i] == i) {
            visited.add(circuit[i]);
            ++i;
        }
        if (i < circuit.length) {
            int start = i;
            visited.add(i);
            i = circuit[i];
            while (i != start) {
                visited.add(i);
                i = circuit[i];
            }
            i = start;
        }
        while (i < circuit.length) {
            if (circuit[i] == i) {
                visited.add(i);
            }
            ++i;
        }
        ArrayList<List<Integer>> circuits = new ArrayList<List<Integer>>();
        if (visited.size() == circuit.length) {
            ArrayList circuitAsList = new ArrayList();
            Arrays.stream(circuit).forEach(x -> {
                boolean bl = circuitAsList.add(x);
            });
            circuits.add(circuitAsList);
        }
        return circuits;
    }

    public boolean buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger size) {
        return false;
    }

    public boolean buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex, int size) {
        return false;
    }
}

