/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints3;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.csp.constraints3.CtrBuilderUtils;
import org.sat4j.csp.intension.ICspToSatEncoder;
import org.sat4j.csp.intension.IIntensionCtrEncoder;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.tools.LexicoDecoratorPB;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.entries.XDomains;
import org.xcsp.parser.entries.XVariables;

public class ObjBuilder {
    private final ICspToSatEncoder cspToSatEncoder;
    private IIntensionCtrEncoder intensionEnc;
    private Types.TypeCombination objCombination;
    private final List<ObjectiveFunction> objectives = new ArrayList<ObjectiveFunction>();
    private final IPBSolver solver;

    public ObjBuilder(IPBSolver solver, IIntensionCtrEncoder intensionEnc) {
        this.solver = solver;
        this.intensionEnc = intensionEnc;
        this.cspToSatEncoder = intensionEnc.getSolver();
    }

    public void setCombination(Types.TypeCombination objCombination) {
        this.objCombination = objCombination;
    }

    private void addObjectiveFunction(ObjectiveFunction obj) {
        this.objectives.add(obj);
    }

    public IPBSolver composeObjectives() {
        ObjectiveComposer oc = ObjectiveComposer.retrieveByTypeCombination(this.objCombination);
        return oc.compose(this.solver, this.objectives);
    }

    public void buildObjToMinimize(String id, XVariables.XVarInteger x) {
        ObjectiveFunction obj = this.buildObjForVar(x);
        this.addObjectiveFunction(obj);
    }

    private ObjectiveFunction buildObjForVar(XVariables.XVarInteger x) {
        String varId = x.id;
        int[] domain = this.cspToSatEncoder.getCspVarDomain(varId);
        VecInt literals = new VecInt(domain.length);
        Vec<BigInteger> coeffs = new Vec<BigInteger>(domain.length);
        int[] nArray = domain;
        int n = domain.length;
        int n2 = 0;
        while (n2 < n) {
            Integer val = nArray[n2];
            literals.push(this.cspToSatEncoder.getSolverVar(varId, val));
            coeffs.push(BigInteger.valueOf(val.intValue()));
            ++n2;
        }
        ObjectiveFunction obj = new ObjectiveFunction(literals, coeffs);
        return obj;
    }

    public void buildObjToMaximize(String id, XVariables.XVarInteger x) {
        ObjectiveFunction obj = this.buildObjForVar(x).negate();
        obj.setCorrectionFactor(BigInteger.ONE.negate());
        this.addObjectiveFunction(obj);
    }

    private String opExpr(String op, XVariables.XVarInteger[] xlist, int[] xcoeffs) {
        StringBuilder sb = new StringBuilder();
        sb.append(op);
        sb.append('(');
        sb.append(this.chainObjVars(xlist, xcoeffs));
        sb.append(')');
        return sb.toString();
    }

    private String chainObjVars(XVariables.XVarInteger[] xlist, int[] xcoeffs) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < xlist.length) {
            if (i > 0) {
                sb.append(',');
            }
            if (xcoeffs[i] == 1) {
                sb.append(CtrBuilderUtils.normalizeCspVarName(xlist[i].id));
            } else {
                sb.append("mul(");
                sb.append(CtrBuilderUtils.normalizeCspVarName(xlist[i].id));
                sb.append(',');
                sb.append(xcoeffs[i]);
                sb.append(")");
            }
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] xlist, int[] xcoeffs) {
        this.buildObjToMinimize(id, type, xlist, xcoeffs, false);
    }

    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] xlist, int[] xcoeffs, boolean negate) {
        ObjectiveFunction obj = null;
        switch (type) {
            case SUM: {
                obj = this.buildSumObjToMinimize(xlist, xcoeffs);
                break;
            }
            case PRODUCT: {
                obj = this.buildExprObjToMinimize(this.opExpr("mul", xlist, xcoeffs));
                break;
            }
            case MAXIMUM: {
                obj = this.buildExprObjToMinimize(this.opExpr("max", xlist, xcoeffs));
                break;
            }
            case MINIMUM: {
                obj = this.buildExprObjToMinimize(this.opExpr("min", xlist, xcoeffs));
                break;
            }
            case NVALUES: {
                obj = this.buildExprObjToMinimize(this.nValuesExpr(xlist, xcoeffs));
                break;
            }
            case LEX: {
                obj = this.buildLexObjToMinimize(xlist, xcoeffs);
                break;
            }
            case EXPRESSION: {
                throw new UnsupportedOperationException();
            }
        }
        if (negate) {
            obj.setCorrectionFactor(BigInteger.ONE.negate());
            obj.negate();
        }
        this.addObjectiveFunction(obj);
    }

    private String nValuesExpr(XVariables.XVarInteger[] list, int[] coeffs) {
        StringBuilder sbuf = new StringBuilder();
        boolean firstAddMember = true;
        sbuf.append("add(");
        int i = 0;
        while (i < list.length) {
            if (!firstAddMember) {
                sbuf.append(',');
            }
            if (i == 0) {
                sbuf.append('1');
                firstAddMember = false;
            } else {
                String normVar = coeffs[i] == 1 ? CtrBuilderUtils.normalizeCspVarName(list[i].id) : "mul(" + CtrBuilderUtils.normalizeCspVarName(list[i].id) + "," + coeffs[i] + ")";
                sbuf.append("if(and(");
                boolean firstAndMember = true;
                int j = 0;
                while (j < i) {
                    if (!firstAndMember) {
                        sbuf.append(',');
                        firstAndMember = false;
                    }
                    String normOtherVar = coeffs[j] == 1 ? CtrBuilderUtils.normalizeCspVarName(list[j].id) : "mul(" + CtrBuilderUtils.normalizeCspVarName(list[j].id) + "," + coeffs[j] + ")";
                    sbuf.append("ne(").append(normVar).append(',').append(normOtherVar).append(')');
                    firstAndMember = false;
                    ++j;
                }
                sbuf.append("),1,0)");
                firstAddMember = false;
            }
            ++i;
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] xlist, int[] xcoeffs) {
        this.buildObjToMinimize(id, type, xlist, xcoeffs, true);
    }

    private ObjectiveFunction buildLexObjToMinimize(XVariables.XVarInteger[] xlist, int[] xcoeffs) {
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        int i = 0;
        while (i < xlist.length) {
            max = Math.max(max, ((XDomains.XDomInteger)xlist[i].dom).lastValue());
            min = Math.min(max, ((XDomains.XDomInteger)xlist[i].dom).lastValue());
            ++i;
        }
        if (min < 0L) {
            throw new UnsupportedOperationException("negative coeff");
        }
        ObjectiveFunction obj = new ObjectiveFunction();
        BigInteger step = BigInteger.valueOf(max + 1L);
        BigInteger fact = BigInteger.ONE;
        int i2 = xlist.length;
        while (i2 >= 0) {
            obj.add(this.buildObjForVar(xlist[i2]).multiply(fact));
            fact = fact.multiply(step);
            --i2;
        }
        return obj;
    }

    private ObjectiveFunction buildExprObjToMinimize(String expr) {
        return this.buildExprObjToMinimize(expr, false);
    }

    private ObjectiveFunction buildExprObjToMinimize(String expr, boolean negate) {
        ObjectiveFunction obj = this.intensionEnc.encodeObj(expr);
        if (negate) {
            obj.negate();
            obj.setCorrectionFactor(BigInteger.ONE.negate());
        }
        return obj;
    }

    private ObjectiveFunction buildSumObjToMinimize(XVariables.XVarInteger[] xlist, int[] xcoeffs) {
        ObjectiveFunction obj = new ObjectiveFunction();
        int size = xlist.length;
        int i = 0;
        while (i < size) {
            obj.add(this.buildObjForVar(xlist[i]).multiply(BigInteger.valueOf(xcoeffs[i])));
            ++i;
        }
        return obj;
    }

    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        int[] coeffs = new int[list.length];
        Arrays.fill(coeffs, 1);
        this.buildObjToMinimize(id, type, list, coeffs);
    }

    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        int[] coeffs = new int[list.length];
        Arrays.fill(coeffs, 1);
        this.buildObjToMaximize(id, type, list, coeffs);
    }

    public void buildObjToMinimize(String id, XNodeParent<XVariables.XVarInteger> syntaxTreeRoot) {
        ObjectiveFunction obj = this.buildExprObjToMinimize(CtrBuilderUtils.syntaxTreeRootToString(syntaxTreeRoot));
        this.addObjectiveFunction(obj);
    }

    public void buildObjToMaximize(String id, XNodeParent<XVariables.XVarInteger> syntaxTreeRoot) {
        ObjectiveFunction obj = this.buildExprObjToMinimize(CtrBuilderUtils.syntaxTreeRootToString(syntaxTreeRoot), true);
        this.addObjectiveFunction(obj);
    }

    protected static enum ObjectiveComposer {
        LEXICO(Types.TypeCombination.LEXICO, "composeForLexico"),
        PARETO(Types.TypeCombination.PARETO, "composeForPareto");

        private Types.TypeCombination typeCombination;
        private Method compositionMethod;

        private ObjectiveComposer(Types.TypeCombination typeCombination, String compositionMethodName) {
            this.typeCombination = typeCombination;
            try {
                this.compositionMethod = ((Object)((Object)this)).getClass().getMethod(compositionMethodName, IPBSolver.class, List.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException(e);
            }
        }

        protected static ObjectiveComposer retrieveByTypeCombination(Types.TypeCombination tc) {
            if (tc == null) {
                return LEXICO;
            }
            ObjectiveComposer[] objectiveComposerArray = ObjectiveComposer.values();
            int n = objectiveComposerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectiveComposer oc = objectiveComposerArray[n2];
                if (oc.typeCombination == tc) {
                    return oc;
                }
                ++n2;
            }
            throw new IllegalArgumentException();
        }

        protected IPBSolver compose(IPBSolver solver, List<ObjectiveFunction> objectives) {
            switch (objectives.size()) {
                case 0: {
                    return solver;
                }
                case 1: {
                    solver.setObjectiveFunction(objectives.get(0));
                    return solver;
                }
            }
            try {
                return (IPBSolver)this.compositionMethod.invoke((Object)solver, objectives);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException();
            }
        }

        public IPBSolver composeForLexico(IPBSolver solver, List<ObjectiveFunction> objectives) {
            LexicoDecoratorPB lexicoDecorator = new LexicoDecoratorPB(solver);
            for (ObjectiveFunction obj : objectives) {
                lexicoDecorator.addCriterion(obj);
            }
            return lexicoDecorator;
        }

        public IPBSolver composeForPareto(IPBSolver solver, List<ObjectiveFunction> objectives) {
            throw new UnsupportedOperationException();
        }
    }
}

