/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints3;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.sat4j.csp.constraints3.CtrBuilderUtils;
import org.sat4j.csp.intension.ICspToSatEncoder;
import org.sat4j.csp.intension.IIntensionCtrEncoder;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.entries.XDomains;
import org.xcsp.parser.entries.XValues;
import org.xcsp.parser.entries.XVariables;

public class GenericCtrBuilder {
    private final IIntensionCtrEncoder intensionCtrEnc;
    private final ICspToSatEncoder cspToSatSolver;
    private final BigInteger STARRED_TUPLE_MAX_COMB = BigInteger.ONE.shiftLeft(8);

    public GenericCtrBuilder(IIntensionCtrEncoder intensionEnc) {
        this.intensionCtrEnc = intensionEnc;
        this.cspToSatSolver = intensionEnc.getSolver();
    }

    public boolean buildCtrIntension(String id, XVariables.XVarInteger[] xscope, XNodeParent<XVariables.XVarInteger> syntaxTreeRoot) {
        String expr = CtrBuilderUtils.syntaxTreeRootToString(syntaxTreeRoot);
        this.intensionCtrEnc.encode(expr);
        return false;
    }

    public boolean buildCtrExtension(String id, XVariables.XVarInteger x, int[] values, boolean positive, Set<Types.TypeFlag> flags) {
        XVariables.XVarInteger[] xArr = new XVariables.XVarInteger[]{x};
        int nVals = values.length;
        int[][] tuples = new int[nVals][];
        int i = 0;
        while (i < nVals) {
            tuples[i] = new int[]{values[i]};
            ++i;
        }
        return this.buildCtrExtension(id, xArr, tuples, positive, flags);
    }

    public boolean buildCtrExtension(String id, XVariables.XVarInteger[] list, int[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        if (flags.contains((Object)Types.TypeFlag.STARRED_TUPLES)) {
            BigInteger maxCombinations = Arrays.stream(tuples).map(t -> IntStream.range(0, ((int[])t).length).mapToObj(i -> t[i] != 0x7FFFFFFE ? BigInteger.ONE : BigInteger.valueOf(((XDomains.XDomInteger)xVarIntegerArray[i].dom).nValues())).reduce(BigInteger.ONE, (a, b) -> a.multiply((BigInteger)b))).reduce(BigInteger.ZERO, (a, b) -> a.compareTo((BigInteger)b) > 0 ? a : b);
            if (maxCombinations.compareTo(this.STARRED_TUPLE_MAX_COMB) >= 0) {
                return this.buildCtrExtensionStarredUsingIntension(list, tuples, positive);
            }
            tuples = this.unfoldStarredTuples(list, tuples);
        }
        HashSet<String> vars = new HashSet<String>();
        int i = 0;
        while (i < list.length) {
            vars.add(list[i].id);
            ++i;
        }
        if (vars.size() != list.length && (tuples = this.removeUnsatTuples(list, tuples)).length == 0) {
            return positive;
        }
        return positive ? this.buildCtrSupports(list, tuples) : this.buildCtrNogoods(list, tuples);
    }

    private boolean buildCtrExtensionStarredUsingIntension(XVariables.XVarInteger[] list, int[][] tuples, boolean positive) {
        ArrayList<String> tupleCstrs = new ArrayList<String>();
        int[][] nArray = tuples;
        int n = tuples.length;
        int n2 = 0;
        while (n2 < n) {
            int[] tuple = nArray[n2];
            ArrayList<XVariables.XVarInteger> vars = new ArrayList<XVariables.XVarInteger>();
            ArrayList<Integer> values = new ArrayList<Integer>();
            int i2 = 0;
            while (i2 < list.length) {
                if (tuple[i2] != 0x7FFFFFFE) {
                    vars.add(list[i2]);
                    values.add(tuple[i2]);
                }
                ++i2;
            }
            String eqChain = IntStream.range(0, vars.size()).mapToObj(i -> "eq(" + ((XVariables.XVarInteger)list.get((int)i)).id + "," + values.get(i) + ")").reduce("", (a, b) -> String.valueOf(a) + "," + b);
            tupleCstrs.add("and(" + eqChain + ")");
            ++n2;
        }
        if (positive) {
            String cstr = "or(" + tupleCstrs.stream().reduce("", (a, b) -> String.valueOf(a) + "," + b) + ")";
            return this.intensionCtrEnc.encode(cstr);
        }
        return tupleCstrs.stream().map(s -> "not(" + s + ")").map(this.intensionCtrEnc::encode).anyMatch(b -> b);
    }

    private int[][] unfoldStarredTuples(XVariables.XVarInteger[] list, int[][] tuples) {
        ArrayList<int[]> newTuples = new ArrayList<int[]>();
        int i = 0;
        while (i < tuples.length) {
            ArrayList<XVariables.XVarInteger> starredVars = new ArrayList<XVariables.XVarInteger>();
            LinkedList<Integer> starredIndexes = new LinkedList<Integer>();
            int j = 0;
            while (j < tuples[i].length) {
                if (tuples[i][j] == 0x7FFFFFFE) {
                    starredVars.add(list[j]);
                    starredIndexes.add(j);
                }
                ++j;
            }
            if (starredVars.isEmpty()) {
                newTuples.add(tuples[i]);
            } else {
                newTuples.addAll(this.unfoldStarredTuple(list, tuples[i], starredVars, starredIndexes));
            }
            ++i;
        }
        int[][] newTuplesArray = new int[newTuples.size()][];
        int i2 = 0;
        while (i2 < newTuples.size()) {
            newTuplesArray[i2] = (int[])newTuples.get(i2);
            ++i2;
        }
        return newTuplesArray;
    }

    private Collection<int[]> unfoldStarredTuple(XVariables.XVarInteger[] list, int[] tuple, List<XVariables.XVarInteger> starredVars, List<Integer> starredIndexes) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        ArrayList<Integer> firstStarredVarDomValues = new ArrayList<Integer>();
        XDomains.XDomInteger domain = (XDomains.XDomInteger)starredVars.get((int)0).dom;
        Object[] objectArray = domain.values;
        int n = domain.values.length;
        int n2 = 0;
        while (n2 < n) {
            Object objIntegerEntity = objectArray[n2];
            XValues.IntegerEntity intEntity = (XValues.IntegerEntity)objIntegerEntity;
            if (intEntity.isSingleton()) {
                firstStarredVarDomValues.add((int)intEntity.greatest());
            } else {
                int i = (int)intEntity.smallest();
                while (i <= (int)intEntity.greatest()) {
                    firstStarredVarDomValues.add(i);
                    ++i;
                }
            }
            ++n2;
        }
        int starredIndex = starredIndexes.remove(0);
        starredVars.remove(0);
        int i = 0;
        while (i < firstStarredVarDomValues.size()) {
            int[] newTuple = new int[tuple.length];
            System.arraycopy(tuple, 0, newTuple, 0, tuple.length);
            newTuple[starredIndex] = (Integer)firstStarredVarDomValues.get(i);
            if (starredVars.isEmpty()) {
                result.add(newTuple);
            } else {
                result.addAll(this.unfoldStarredTuple(list, newTuple, new ArrayList<XVariables.XVarInteger>(starredVars), new ArrayList<Integer>(starredIndexes)));
            }
            ++i;
        }
        return result;
    }

    private int[][] removeUnsatTuples(XVariables.XVarInteger[] list, int[][] tuples) {
        int i = 0;
        while (i < list.length - 1) {
            int j = i + 1;
            while (j < list.length) {
                if (list[i].id.equals(list[j].id) && (tuples = this.removeUnsatTuplesForVar(tuples, i, j)).length == 0) {
                    return tuples;
                }
                ++j;
            }
            ++i;
        }
        return tuples;
    }

    private int[][] removeUnsatTuplesForVar(int[][] tuples, int varIndex1, int varIndex2) {
        ArrayList<int[]> tuplesList = new ArrayList<int[]>();
        int i = 0;
        while (i < tuples.length) {
            if (tuples[i][varIndex1] == tuples[i][varIndex2]) {
                tuplesList.add(tuples[i]);
            }
            ++i;
        }
        int[][] tuplesArray = new int[tuplesList.size()][];
        return (int[][])tuplesList.toArray((T[])tuplesArray);
    }

    private boolean buildCtrNogoods(XVariables.XVarInteger[] list, int[][] tuples) {
        int[][] nArray = tuples;
        int n = tuples.length;
        int n2 = 0;
        while (n2 < n) {
            int[] tuple = nArray[n2];
            int[] clause = new int[tuple.length];
            int i = 0;
            while (i < tuple.length) {
                clause[i] = -this.cspToSatSolver.getSolverVar(list[i].id, tuple[i]);
                ++i;
            }
            if (this.cspToSatSolver.addClause(clause)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean buildCtrSupports(XVariables.XVarInteger[] list, int[][] tuples) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("or(");
        boolean firstTuple = true;
        int[][] nArray = tuples;
        int n = tuples.length;
        int n2 = 0;
        while (n2 < n) {
            int[] tuple = nArray[n2];
            if (firstTuple) {
                firstTuple = false;
            } else {
                sbuf.append(',');
            }
            sbuf.append("and(").append("eq(").append(list[0].id).append(',').append(tuple[0]).append(')');
            int i = 1;
            while (i < tuple.length) {
                sbuf.append(",eq(").append(list[i].id).append(',').append(tuple[i]).append(')');
                ++i;
            }
            sbuf.append(')');
            ++n2;
        }
        sbuf.append(")");
        return this.intensionCtrEnc.encode(sbuf.toString());
    }
}

