/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints3;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.sat4j.csp.intension.ICspToSatEncoder;
import org.sat4j.csp.intension.IIntensionCtrEncoder;
import org.xcsp.parser.entries.XVariables;

public class ElementaryCtrBuilder {
    private final IIntensionCtrEncoder intensionEncoder;

    public ElementaryCtrBuilder(IIntensionCtrEncoder intensionEnc) {
        this.intensionEncoder = intensionEnc;
    }

    public boolean buildCtrInstantiation(String id, XVariables.XVarInteger[] list, int[] values) {
        ICspToSatEncoder solver = this.intensionEncoder.getSolver();
        int i = 0;
        while (i < list.length) {
            int[] unitCl = new int[]{solver.getSolverVar(list[i].id, values[i])};
            if (solver.addClause(unitCl)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean buildCtrClause(String id, XVariables.XVarInteger[] pos, XVariables.XVarInteger[] neg) {
        ICspToSatEncoder solver = this.intensionEncoder.getSolver();
        int[] lits = Stream.of(Arrays.stream(pos).mapToInt(v -> solver.getSolverVar(v.id, 1)).toArray(), Arrays.stream(neg).mapToInt(v -> solver.getSolverVar(v.id, 0)).toArray()).flatMapToInt(nArray -> IntStream.of(nArray)).toArray();
        return solver.addClause(lits);
    }
}

