/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints3;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sat4j.core.Vec;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Predicate;
import org.sat4j.csp.Var;
import org.sat4j.pb.IPBSolver;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.entries.XVariables;

public class CtrBuilderUtils {
    public static XVariables.XVarInteger[][] transposeMatrix(XVariables.XVarInteger[][] matrix) {
        XVariables.XVarInteger[][] tMatrix = new XVariables.XVarInteger[matrix[0].length][matrix.length];
        int i = 0;
        while (i < matrix[0].length) {
            int j = 0;
            while (j < matrix.length) {
                tMatrix[i][j] = matrix[j][i];
                ++j;
            }
            ++i;
        }
        return tMatrix;
    }

    public static String normalizeCspVarName(String name) {
        return name;
    }

    public static IVec<Var> toVarVec(Collection<Var> vars) {
        Vec<Var> vec = new Vec<Var>(vars.size());
        for (Var v : vars) {
            vec.push(v);
        }
        return vec;
    }

    public static IVec<Evaluable> toEvaluableVec(Collection<Var> vars) {
        Vec<Evaluable> vec = new Vec<Evaluable>(vars.size());
        for (Var v : vars) {
            vec.push(v);
        }
        return vec;
    }

    public static String chainExpressionsForAssociativeOp(String[] exprs, String op) {
        StringBuilder exprBuf = new StringBuilder();
        exprBuf.append(op).append('(').append(exprs[0]);
        int i = 1;
        while (i < exprs.length) {
            exprBuf.append(',').append(exprs[i]);
            ++i;
        }
        exprBuf.append(')');
        return exprBuf.toString();
    }

    public static String chainExpressionsAssociative(String[] exprs, String op) {
        StringBuilder exprBuff = new StringBuilder();
        exprBuff.append(exprs[0]);
        int i = 1;
        while (i < exprs.length) {
            exprBuff.append(op);
            exprBuff.append(exprs[i]);
            ++i;
        }
        return exprBuff.toString();
    }

    public static boolean buildSumEqOneCstr(IPBSolver solver, Map<String, Var> varmapping, XVariables.XVarInteger[] list) {
        Predicate p = new Predicate();
        Vec<Var> scope = new Vec<Var>(list.length);
        Vec<Evaluable> vars = new Vec<Evaluable>(list.length);
        String[] toChain = new String[list.length];
        int i = 0;
        while (i < list.length) {
            XVariables.XVarInteger var = list[i];
            scope.push(varmapping.get(var.id));
            vars.push(varmapping.get(var.id));
            String norm = CtrBuilderUtils.normalizeCspVarName(var.id);
            p.addVariable(norm);
            toChain[i] = norm;
            ++i;
        }
        p.setExpression("eq(" + CtrBuilderUtils.chainExpressionsForAssociativeOp(toChain, "add") + ",1)");
        try {
            p.toClause(solver, scope, vars);
        }
        catch (ContradictionException e) {
            Logger.getLogger("org.sat4j.csp").log(Level.INFO, "Trivial inconsistency", e);
            return true;
        }
        return false;
    }

    public static Types.TypeOperatorRel strictTypeOperator(Types.TypeOperatorRel op) {
        switch (op) {
            case GE: {
                return Types.TypeOperatorRel.GT;
            }
            case LE: {
                return Types.TypeOperatorRel.LT;
            }
        }
        return op;
    }

    public static String syntaxTreeRootToString(XNodeParent<XVariables.XVarInteger> syntaxTreeRoot) {
        StringBuilder treeToString = new StringBuilder();
        CtrBuilderUtils.fillSyntacticStrBuffer(syntaxTreeRoot, treeToString);
        return treeToString.toString();
    }

    private static void fillSyntacticStrBuffer(XNode<XVariables.XVarInteger> child, StringBuilder treeToString) {
        if (child instanceof XNodeLeaf) {
            treeToString.append(CtrBuilderUtils.normalizeCspVarName(child.toString()));
            return;
        }
        treeToString.append(child.getType().toString().toLowerCase());
        XNode[] sons = ((XNodeParent)child).sons;
        treeToString.append('(');
        CtrBuilderUtils.fillSyntacticStrBuffer(sons[0], treeToString);
        int i = 1;
        while (i < sons.length) {
            treeToString.append(',');
            CtrBuilderUtils.fillSyntacticStrBuffer(sons[i], treeToString);
            ++i;
        }
        treeToString.append(')');
    }
}

