/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints3;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.sat4j.csp.constraints3.CtrBuilderUtils;
import org.sat4j.csp.constraints3.StringCondition;
import org.sat4j.csp.intension.IIntensionCtrEncoder;
import org.xcsp.common.Condition;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.entries.XVariables;

public class CountingCtrBuilder {
    private final IIntensionCtrEncoder intensionCtrEnc;

    public CountingCtrBuilder(IIntensionCtrEncoder intensionEnc) {
        this.intensionCtrEnc = intensionEnc;
    }

    public boolean buildCtrSum(String id, XVariables.XVarInteger[] list, Condition condition) {
        int[] coeffs = new int[list.length];
        Arrays.fill(coeffs, 1);
        return this.buildCtrSum(id, list, coeffs, condition);
    }

    public boolean buildCtrSum(String id, XVariables.XVarInteger[] list, int[] coeffs, Condition condition) {
        String varId;
        StringBuilder exprBuf = new StringBuilder();
        if (condition instanceof Condition.ConditionRel) {
            exprBuf.append(((Condition.ConditionRel)condition).operator.toString().toLowerCase());
        } else if (condition instanceof Condition.ConditionIntvl) {
            exprBuf.append(((Condition.ConditionIntvl)condition).operator.toString().toLowerCase());
        }
        exprBuf.append('(');
        int i = 0;
        while (i < list.length - 1) {
            exprBuf.append("add(");
            if (coeffs[i] != 1) {
                exprBuf.append("mul(").append(coeffs[i]).append(',');
            }
            varId = list[i].id;
            exprBuf.append(CtrBuilderUtils.normalizeCspVarName(varId));
            if (coeffs[i] != 1) {
                exprBuf.append(')');
            }
            exprBuf.append(',');
            ++i;
        }
        varId = list[list.length - 1].id;
        int lastCoeff = coeffs[list.length - 1];
        String normName = CtrBuilderUtils.normalizeCspVarName(varId);
        exprBuf.append(lastCoeff == 1 ? normName : "mul(" + lastCoeff + "," + normName + ")");
        int i2 = 0;
        while (i2 < list.length - 1) {
            exprBuf.append(')');
            ++i2;
        }
        exprBuf.append(',');
        if (condition instanceof Condition.ConditionVar) {
            varId = ((Condition.ConditionVar)condition).x.id();
            exprBuf.append(CtrBuilderUtils.normalizeCspVarName(varId));
        } else if (condition instanceof Condition.ConditionVal) {
            exprBuf.append(((Condition.ConditionVal)condition).k);
        } else if (condition instanceof Condition.ConditionIntvl) {
            Condition.ConditionIntvl cond = (Condition.ConditionIntvl)condition;
            exprBuf.append(cond.min).append("..").append(cond.max);
        } else {
            throw new UnsupportedOperationException("this kind of condition is not supported yet.");
        }
        exprBuf.append(')');
        String expr = exprBuf.toString();
        return this.intensionCtrEnc.encode(expr);
    }

    public boolean buildCtrSum(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] coeffs, Condition condition) {
        String varId;
        StringBuilder exprBuf = new StringBuilder();
        if (condition instanceof Condition.ConditionRel) {
            exprBuf.append(((Condition.ConditionRel)condition).operator.toString().toLowerCase());
        } else if (condition instanceof Condition.ConditionIntvl) {
            exprBuf.append(((Condition.ConditionIntvl)condition).operator.toString().toLowerCase());
        } else {
            throw new UnsupportedOperationException();
        }
        exprBuf.append('(');
        int i = 0;
        while (i < list.length - 1) {
            exprBuf.append("add(");
            exprBuf.append("mul(").append(CtrBuilderUtils.normalizeCspVarName(coeffs[i].id)).append(',');
            varId = list[i].id;
            exprBuf.append(CtrBuilderUtils.normalizeCspVarName(varId));
            exprBuf.append(')');
            exprBuf.append(',');
            ++i;
        }
        varId = list[list.length - 1].id;
        String normName = CtrBuilderUtils.normalizeCspVarName(varId);
        exprBuf.append("mul(" + CtrBuilderUtils.normalizeCspVarName(coeffs[list.length - 1].id) + "," + normName + ")");
        int i2 = 0;
        while (i2 < list.length - 1) {
            exprBuf.append(')');
            ++i2;
        }
        exprBuf.append(',');
        if (condition instanceof Condition.ConditionVar) {
            varId = ((Condition.ConditionVar)condition).x.id();
            exprBuf.append(CtrBuilderUtils.normalizeCspVarName(varId));
        } else if (condition instanceof Condition.ConditionVal) {
            exprBuf.append(((Condition.ConditionVal)condition).k);
        } else if (condition instanceof Condition.ConditionIntvl) {
            Condition.ConditionIntvl cond = (Condition.ConditionIntvl)condition;
            exprBuf.append(cond.min).append("..").append(cond.max);
        } else {
            throw new UnsupportedOperationException("this kind of condition is not supported yet.");
        }
        exprBuf.append(')');
        String expr = exprBuf.toString();
        return this.intensionCtrEnc.encode(expr);
    }

    public boolean buildCtrCount(String id, XVariables.XVarInteger[] list, int[] values, Condition condition) {
        return this.buildCtrCount(id, list, values, StringCondition.buildStringCondition(condition));
    }

    private boolean buildCtrCount(String id, XVariables.XVarInteger[] list, int[] values, StringCondition condition) {
        StringBuilder inExprBuf = new StringBuilder();
        inExprBuf.append("set(").append(Integer.toString(values[0]));
        int i = 1;
        while (i < values.length) {
            inExprBuf.append(',');
            inExprBuf.append(Integer.toString(values[i]));
            ++i;
        }
        inExprBuf.append(')');
        String inExpr = inExprBuf.toString();
        String[] sumExprs = new String[list.length];
        int i2 = 0;
        while (i2 < list.length) {
            String normVar = CtrBuilderUtils.normalizeCspVarName(list[i2].id);
            sumExprs[i2] = "if(in(" + normVar + "," + inExpr + "),1,0)";
            ++i2;
        }
        String sumExpr = CtrBuilderUtils.chainExpressionsForAssociativeOp(sumExprs, "add");
        return this.intensionCtrEnc.encode(condition.asString(sumExpr));
    }

    public boolean buildCtrCount(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] values, Condition condition) {
        return this.buildCtrCount(id, list, values, StringCondition.buildStringCondition(condition));
    }

    private boolean buildCtrCount(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] values, StringCondition condition) {
        int listLength = list.length;
        StringBuilder inExprBuf = new StringBuilder();
        inExprBuf.append("set(").append(CtrBuilderUtils.normalizeCspVarName(values[0].id));
        int i = 1;
        while (i < values.length) {
            inExprBuf.append(',');
            inExprBuf.append(CtrBuilderUtils.normalizeCspVarName(values[i].id));
            ++i;
        }
        inExprBuf.append(')');
        String inExpr = inExprBuf.toString();
        String[] sumExprs = new String[listLength];
        int i2 = 0;
        while (i2 < listLength) {
            String normVar = CtrBuilderUtils.normalizeCspVarName(list[i2].id);
            sumExprs[i2] = "if(in(" + normVar + "," + inExpr + "),1,0)";
            ++i2;
        }
        String sumExpr = CtrBuilderUtils.chainExpressionsForAssociativeOp(sumExprs, "add");
        return this.intensionCtrEnc.encode(condition.asString(sumExpr));
    }

    public boolean buildCtrAtLeast(String id, XVariables.XVarInteger[] list, int value, int k) {
        return this.buildCtrCount(id, list, new int[]{value}, new StringCondition("ge(", "," + Integer.toString(k) + ")"));
    }

    public boolean buildCtrAtMost(String id, XVariables.XVarInteger[] list, int value, int k) {
        return this.buildCtrCount(id, list, new int[]{value}, new StringCondition("le(", "," + Integer.toString(k) + ")"));
    }

    public boolean buildCtrExactly(String id, XVariables.XVarInteger[] list, int value, int k) {
        return this.buildCtrCount(id, list, new int[]{value}, new StringCondition("eq(", "," + Integer.toString(k) + ")"));
    }

    public boolean buildCtrExactly(String id, XVariables.XVarInteger[] list, int value, XVariables.XVarInteger k) {
        String normVar = CtrBuilderUtils.normalizeCspVarName(k.id);
        StringCondition strCond = new StringCondition("eq(", "," + normVar + ")");
        strCond.addVariable(normVar);
        return this.buildCtrCount(id, list, new int[]{value}, strCond);
    }

    public boolean buildCtrAmong(String id, XVariables.XVarInteger[] list, int[] values, int k) {
        return this.buildCtrCount(id, list, values, new StringCondition("eq(", "," + Integer.toString(k) + ")"));
    }

    public boolean buildCtrAmong(String id, XVariables.XVarInteger[] list, int[] values, XVariables.XVarInteger k) {
        String normVar = CtrBuilderUtils.normalizeCspVarName(k.id);
        StringCondition strCond = new StringCondition("eq(", "," + normVar + ")");
        strCond.addVariable(normVar);
        return this.buildCtrCount(id, list, values, strCond);
    }

    public boolean buildCtrNValues(String id, XVariables.XVarInteger[] list, Condition condition) {
        return this.buildCtrNValuesExcept(id, list, new int[0], condition);
    }

    public boolean buildCtrNValues(String id, XVariables.XVarInteger[] list, StringCondition condition) {
        return this.buildCtrNValuesExcept(id, list, new int[0], condition);
    }

    public boolean buildCtrNValuesExcept(String id, XVariables.XVarInteger[] list, int[] except, Condition condition) {
        return this.buildCtrNValuesExcept(id, list, except, StringCondition.buildStringCondition(condition));
    }

    private boolean buildCtrNValuesExcept(String id, XVariables.XVarInteger[] list, int[] except, StringCondition strCond) {
        StringBuilder sbuf = new StringBuilder();
        boolean firstAddMember = true;
        sbuf.append("add(");
        int i = 0;
        while (i < list.length) {
            if (!firstAddMember) {
                sbuf.append(',');
            }
            if (i == 0 && except.length == 0) {
                sbuf.append('1');
                firstAddMember = false;
            } else {
                String normVar = CtrBuilderUtils.normalizeCspVarName(list[i].id);
                sbuf.append("if(and(");
                boolean firstAndMember = true;
                int j = 0;
                while (j < except.length) {
                    if (!firstAndMember) {
                        sbuf.append(',');
                        firstAndMember = false;
                    }
                    sbuf.append("ne(").append(normVar).append(',').append(except[j]).append(')');
                    firstAndMember = false;
                    ++j;
                }
                j = 0;
                while (j < i) {
                    if (!firstAndMember) {
                        sbuf.append(',');
                        firstAndMember = false;
                    }
                    sbuf.append("ne(").append(normVar).append(',').append(CtrBuilderUtils.normalizeCspVarName(list[j].id)).append(')');
                    firstAndMember = false;
                    ++j;
                }
                sbuf.append("),1,0)");
                firstAddMember = false;
            }
            ++i;
        }
        sbuf.append(')');
        return this.intensionCtrEnc.encode(strCond.asString(sbuf.toString()));
    }

    public boolean buildCtrNotAllEqual(String id, XVariables.XVarInteger[] list) {
        return this.buildCtrNValues(id, list, new StringCondition("ne(", ",1)"));
    }

    public boolean buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, XVariables.XVarInteger[] occurs) {
        boolean contradictionFound = this.manageClosedCardinality(id, list, closed, values);
        int i = 0;
        while (i < values.length && !contradictionFound) {
            this.buildCtrExactly(id, list, values[i], occurs[i]);
            ++i;
        }
        return contradictionFound;
    }

    private boolean manageClosedCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values) {
        if (!closed) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            String normVar = CtrBuilderUtils.normalizeCspVarName(list[i].id);
            StringBuilder exprBuff = new StringBuilder();
            exprBuff.append("or(eq(").append(normVar).append(',').append(values[0]).append(')');
            int j = 1;
            while (j < values.length) {
                exprBuff.append(",eq(").append(normVar).append(',').append(values[j]).append(')');
                ++j;
            }
            exprBuff.append(')');
            if (this.intensionCtrEnc.encode(exprBuff.toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occurs) {
        return this.buildCtrCardinality(id, list, closed, values, occurs, occurs);
    }

    public boolean buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occursMin, int[] occursMax) {
        boolean contradictionFound = this.manageClosedCardinality(id, list, closed, values);
        int i = 0;
        while (i < values.length) {
            if (occursMin[i] == occursMax[i]) {
                contradictionFound |= this.buildCtrExactly(id, list, values[i], occursMin[i]);
            } else {
                contradictionFound |= this.buildCtrAtLeast(id, list, values[i], occursMin[i]);
                contradictionFound |= this.buildCtrAtMost(id, list, values[i], occursMax[i]);
            }
            ++i;
        }
        return contradictionFound;
    }

    public boolean buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, XVariables.XVarInteger[] occurs) {
        boolean contradictionFound = this.manageClosedCardinality(id, list, closed, values);
        int i = 0;
        while (i < values.length && !contradictionFound) {
            String norm = CtrBuilderUtils.normalizeCspVarName(occurs[i].id);
            StringCondition stringCond = new StringCondition("eq(", "," + norm + ")");
            stringCond.addVariable(norm);
            contradictionFound |= this.buildCtrCount(id, new XVariables.XVarInteger[]{values[i]}, list, stringCond);
            ++i;
        }
        return contradictionFound;
    }

    private boolean manageClosedCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values) {
        boolean contradictionFound = false;
        if (closed) {
            int i = 0;
            while (i < list.length && !contradictionFound) {
                contradictionFound |= this.buildCtrCount(id, new XVariables.XVarInteger[]{list[i]}, values, new StringCondition("eq(", ",1"));
                ++i;
            }
        }
        return contradictionFound;
    }

    public boolean buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occurs) {
        return this.buildCtrCardinality(id, list, closed, values, occurs, occurs);
    }

    public boolean buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occursMin, int[] occursMax) {
        boolean contradictionFound = false;
        int i = 0;
        while (i < values.length && !contradictionFound) {
            if (occursMin[i] == occursMax[i]) {
                contradictionFound |= this.buildCtrCount(id, new XVariables.XVarInteger[]{values[i]}, list, new StringCondition("eq(", "," + Integer.toString(occursMin[i]) + ")"));
            } else {
                contradictionFound |= this.buildCtrCount(id, new XVariables.XVarInteger[]{values[i]}, list, new StringCondition("ge(", "," + Integer.toString(occursMin[i]) + ")"));
                contradictionFound |= this.buildCtrCount(id, new XVariables.XVarInteger[]{values[i]}, list, new StringCondition("le(", "," + Integer.toString(occursMax[i]) + ")"));
            }
            ++i;
        }
        return contradictionFound;
    }

    public boolean buildCtrSum(String id, XNodeParent<XVariables.XVarInteger>[] trees, int[] coeffs, Condition condition) {
        String[] strTrees = (String[])Arrays.stream(trees).map(CtrBuilderUtils::syntaxTreeRootToString).toArray(String[]::new);
        String strSum = "add(" + IntStream.range(0, trees.length).mapToObj(i -> "mul(" + coeffs[i] + "," + strTrees[i] + ")").reduce((s1, s2) -> String.valueOf(s1) + "," + s2).orElseThrow(IllegalArgumentException::new) + ")";
        String conditionOp = ((Condition.ConditionRel)condition).operator.toString().toLowerCase();
        assert (condition instanceof Condition.ConditionVar || condition instanceof Condition.ConditionVal);
        String conditionArg = condition instanceof Condition.ConditionVar ? CtrBuilderUtils.normalizeCspVarName(((Condition.ConditionVar)condition).x.id()) : Long.toString(((Condition.ConditionVal)condition).k);
        String expr = String.valueOf(conditionOp) + "(" + strSum + "," + conditionArg + ")";
        return this.intensionCtrEnc.encode(expr);
    }
}

