/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints3;

import org.sat4j.csp.constraints3.CtrBuilderUtils;
import org.sat4j.csp.constraints3.StringCondition;
import org.sat4j.csp.intension.IIntensionCtrEncoder;
import org.xcsp.common.Condition;
import org.xcsp.common.Types;
import org.xcsp.parser.entries.XDomains;
import org.xcsp.parser.entries.XVariables;

public class ConnectionCtrBuilder {
    private final IIntensionCtrEncoder intensionCtrEncoder;

    public ConnectionCtrBuilder(IIntensionCtrEncoder intensionEnc) {
        this.intensionCtrEncoder = intensionEnc;
    }

    public boolean buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger value) {
        int i = 0;
        while (i < list.length) {
            String[] andParts = new String[list.length];
            int j = 0;
            while (j < list.length) {
                String normJ = CtrBuilderUtils.normalizeCspVarName(list[j].id);
                andParts[j] = "eq(" + normJ + "," + (i == j ? 1 : 0) + ")";
                ++j;
            }
            String andExpr = CtrBuilderUtils.chainExpressionsForAssociativeOp(andParts, "and");
            String expr = "imp(eq(" + CtrBuilderUtils.normalizeCspVarName(value.id) + "," + (i + startIndex) + ")," + andExpr + ")";
            if (this.intensionCtrEncoder.encode(expr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean buildCtrChannel(String id, XVariables.XVarInteger[] list1, int startIndex1, XVariables.XVarInteger[] list2, int startIndex2) {
        if (list1.length != list2.length) {
            throw new IllegalArgumentException("lists of different sizes provided as arguments of channel constraint");
        }
        this.checkChannelPrerequisites(list1, startIndex2);
        this.checkChannelPrerequisites(list2, startIndex1);
        boolean contradictionFound = false;
        contradictionFound |= this.buildListCtrChannel(list2, startIndex2, list1, startIndex1);
        return contradictionFound |= this.buildListCtrChannel(list1, startIndex1, list2, startIndex2);
    }

    public boolean buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex) {
        this.checkChannelPrerequisites(list, startIndex);
        return this.buildListCtrChannel(list, startIndex, list, startIndex);
    }

    private void checkChannelPrerequisites(XVariables.XVarInteger[] list, int startIndex) {
        if (startIndex < 0) {
            throw new IllegalArgumentException("negative startIndex (" + startIndex + ") given for channel constraint");
        }
    }

    private boolean buildListCtrChannel(XVariables.XVarInteger[] list1, int startIndex1, XVariables.XVarInteger[] list2, int startIndex2) {
        boolean contradictionFound = false;
        int i = 0;
        while (i < list2.length) {
            XVariables.XVarInteger var = list2[i];
            XDomains.XDomInteger domain = (XDomains.XDomInteger)var.dom;
            long j = domain.firstValue();
            while (j <= Math.min(domain.firstValue(), (long)(list1.length + startIndex1 - 1))) {
                if (domain.contains(j)) {
                    contradictionFound |= this.buildChannelImplCstr(var, i + startIndex2, list1[(int)j - startIndex1], (int)j);
                }
                ++j;
            }
            ++i;
        }
        return contradictionFound;
    }

    private boolean buildChannelImplCstr(XVariables.XVarInteger v1, int v1Index, XVariables.XVarInteger v2, int v2Index) {
        String norm1 = CtrBuilderUtils.normalizeCspVarName(v1.id);
        String norm2 = CtrBuilderUtils.normalizeCspVarName(v2.id);
        String expr = "or(not(eq(" + norm1 + "," + v2Index + ")),eq(" + norm2 + "," + v1Index + "))";
        this.intensionCtrEncoder.encode(expr);
        return false;
    }

    public boolean buildCtrMaximum(String id, XVariables.XVarInteger[] list, Condition condition) {
        return this.buildCtrMinOrMax(list, condition, true);
    }

    private boolean buildCtrMinOrMax(XVariables.XVarInteger[] list, Condition condition, boolean isMax) {
        StringBuilder leftOpBuf = new StringBuilder();
        leftOpBuf.append(isMax ? "max(" : "min(");
        String norm = CtrBuilderUtils.normalizeCspVarName(list[0].id);
        leftOpBuf.append(norm);
        int i = 1;
        while (i < list.length) {
            norm = CtrBuilderUtils.normalizeCspVarName(list[i].id);
            leftOpBuf.append(',').append(norm);
            ++i;
        }
        leftOpBuf.append(")");
        StringCondition strCond = StringCondition.buildStringCondition(condition);
        String expr = strCond.asString(leftOpBuf.toString());
        return this.intensionCtrEncoder.encode(expr);
    }

    public boolean buildCtrMinimum(String id, XVariables.XVarInteger[] list, Condition condition) {
        return this.buildCtrMinOrMax(list, condition, false);
    }

    public boolean buildCtrElement(String id, XVariables.XVarInteger[] list, int value) {
        return this.buildCtrElementAnyIndex(list, value);
    }

    public boolean buildCtrMaximum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        if (condition != null && this.buildCtrMaximum(id, list, condition)) {
            return true;
        }
        if (this.buildCtrMinOrMaxAtIndex(list, index, startIndex, true)) {
            return true;
        }
        return rank == Types.TypeRank.FIRST ? this.buildCtrNotMinOrMaxBeforeIndex(list, index, startIndex, true) : rank == Types.TypeRank.LAST && this.buildCtrNotMaxAfterIndex(list, index, startIndex, true);
    }

    public boolean buildCtrMinimum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        if (condition != null && this.buildCtrMinimum(id, list, condition)) {
            return true;
        }
        if (this.buildCtrMinOrMaxAtIndex(list, index, startIndex, false)) {
            return true;
        }
        return rank == Types.TypeRank.FIRST ? this.buildCtrNotMinOrMaxBeforeIndex(list, index, startIndex, false) : rank == Types.TypeRank.LAST && this.buildCtrNotMaxAfterIndex(list, index, startIndex, false);
    }

    private boolean buildCtrMinOrMaxAtIndex(XVariables.XVarInteger[] list, XVariables.XVarInteger index, int startIndex, boolean isMax) {
        String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
        StringBuilder maxExprBuf = new StringBuilder();
        maxExprBuf.append(isMax ? "max(" : "min(");
        int i = 0;
        while (i < list.length) {
            String normVar = CtrBuilderUtils.normalizeCspVarName(list[i].id);
            if (i > 0) {
                maxExprBuf.append(',');
            }
            maxExprBuf.append(normVar);
            ++i;
        }
        maxExprBuf.append(')');
        String maxExpr = maxExprBuf.toString();
        int i2 = startIndex;
        while (i2 < startIndex + list.length) {
            String expr = "or(ne(" + normIndex + "," + i2 + "),eq(" + maxExpr + "," + CtrBuilderUtils.normalizeCspVarName(list[i2 - startIndex].id) + "))";
            this.intensionCtrEncoder.encode(expr);
            ++i2;
        }
        return false;
    }

    private boolean buildCtrNotMinOrMaxBeforeIndex(XVariables.XVarInteger[] list, XVariables.XVarInteger index, int startIndex, boolean isMax) {
        int i = 1 + startIndex;
        while (i < startIndex + list.length) {
            String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
            String normMax = CtrBuilderUtils.normalizeCspVarName(list[i - startIndex].id);
            StringBuilder andExprBuf = new StringBuilder();
            andExprBuf.append("and(");
            int j = 0;
            while (j < i - startIndex) {
                String normCurVar = CtrBuilderUtils.normalizeCspVarName(list[j].id);
                if (j > 0) {
                    andExprBuf.append(',');
                }
                andExprBuf.append(isMax ? "lt(" : "gt(").append(normCurVar).append(',').append(normMax).append(')');
                ++j;
            }
            andExprBuf.append(')');
            String expr = "or(ne(" + normIndex + "," + i + ")," + andExprBuf.toString() + ")";
            this.intensionCtrEncoder.encode(expr);
            ++i;
        }
        return false;
    }

    private boolean buildCtrNotMaxAfterIndex(XVariables.XVarInteger[] list, XVariables.XVarInteger index, int startIndex, boolean isMax) {
        int i = startIndex;
        while (i < startIndex + list.length - 1) {
            String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
            String normMax = CtrBuilderUtils.normalizeCspVarName(list[i - startIndex].id);
            StringBuilder andExprBuf = new StringBuilder();
            andExprBuf.append("and(");
            int j = i - startIndex + 1;
            while (j < list.length) {
                String normCurVar = CtrBuilderUtils.normalizeCspVarName(list[j].id);
                if (j > i - startIndex + 1) {
                    andExprBuf.append(',');
                }
                andExprBuf.append(isMax ? "lt(" : "gt(").append(normCurVar).append(',').append(normMax).append(')');
                ++j;
            }
            andExprBuf.append(')');
            String expr = "or(ne(" + normIndex + "," + i + ")," + andExprBuf.toString() + ")";
            this.intensionCtrEncoder.encode(expr);
            ++i;
        }
        return false;
    }

    public boolean buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, int value) {
        if (rank == Types.TypeRank.ANY) {
            return this.buildCtrElementForceIndex(list, startIndex, index, value);
        }
        if (rank == Types.TypeRank.FIRST) {
            return this.buildCtrElementNotAnyIndex(list, startIndex, index, value, true);
        }
        if (rank == Types.TypeRank.LAST) {
            return this.buildCtrElementNotAnyIndex(list, startIndex, index, value, false);
        }
        throw new IllegalArgumentException();
    }

    private boolean buildCtrElementAnyIndex(XVariables.XVarInteger[] list, int value) {
        int len = list.length;
        String[] subExprs = new String[len];
        String strValue = Integer.toString(value);
        int i = 0;
        while (i < len) {
            String normVar = CtrBuilderUtils.normalizeCspVarName(list[i].id);
            subExprs[i] = "eq(" + normVar + "," + strValue + ")";
            ++i;
        }
        this.intensionCtrEncoder.encode(CtrBuilderUtils.chainExpressionsForAssociativeOp(subExprs, "or"));
        return false;
    }

    private boolean buildCtrElementForceIndex(XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, int value) {
        int len = list.length;
        String[] subexprs = new String[list.length];
        String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
        int i = 0;
        while (i < len) {
            String lImpl = "eq(" + Integer.toString(i + startIndex) + "," + normIndex + ")";
            String rImpl = "eq(" + value + "," + CtrBuilderUtils.normalizeCspVarName(list[i].id) + ")";
            subexprs[i] = "imp(" + lImpl + "," + rImpl + ")";
            ++i;
        }
        String expr = CtrBuilderUtils.chainExpressionsForAssociativeOp(subexprs, "and");
        this.intensionCtrEncoder.encode(expr);
        return false;
    }

    private boolean buildCtrElementNotAnyIndex(XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, int value, boolean isFirst) {
        int len = list.length;
        String[] subExprs = new String[len];
        String strValue = Integer.toString(value);
        String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
        int i = 0;
        while (i < len) {
            String normVar = CtrBuilderUtils.normalizeCspVarName(list[i].id);
            String firstOp = isFirst ? "le" : "ge";
            String lowerIndexCase = "and(" + firstOp + "(" + Integer.toString(i + startIndex) + "," + normIndex + "),ne(" + normVar + "," + strValue + "))";
            String rightIndexCase = "and(eq(" + Integer.toString(i + startIndex) + "," + normIndex + "),eq(" + normVar + "," + strValue + "))";
            String lastOp = isFirst ? "ge" : "le";
            String higherIndexCase = String.valueOf(lastOp) + "(" + Integer.toString(i + startIndex) + "," + normIndex + ")";
            subExprs[i] = "or(" + lowerIndexCase + "," + rightIndexCase + "," + higherIndexCase + ")";
            ++i;
        }
        this.intensionCtrEncoder.encode(CtrBuilderUtils.chainExpressionsForAssociativeOp(subExprs, "and"));
        return false;
    }

    public boolean buildCtrElement(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger value) {
        return this.buildCtrElementAnyIndex(list, value);
    }

    public boolean buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        if (rank == Types.TypeRank.ANY) {
            return this.buildCtrElementForceIndex(list, startIndex, index, value);
        }
        if (rank == Types.TypeRank.FIRST) {
            return this.buildCtrElementFirstIndex(list, startIndex, index, value);
        }
        if (rank == Types.TypeRank.LAST) {
            return this.buildCtrElementLastIndex(list, startIndex, index, value);
        }
        throw new IllegalArgumentException();
    }

    private boolean buildCtrElementForceIndex(XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, XVariables.XVarInteger value) {
        int len = list.length;
        String[] subexprs = new String[list.length];
        String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
        String normValue = CtrBuilderUtils.normalizeCspVarName(value.id);
        int i = 0;
        while (i < len) {
            String lImpl = "eq(" + Integer.toString(i + startIndex) + "," + normIndex + ")";
            String rImpl = "eq(" + normValue + "," + CtrBuilderUtils.normalizeCspVarName(list[i].id) + ")";
            subexprs[i] = "imp(" + lImpl + "," + rImpl + ")";
            ++i;
        }
        String expr = CtrBuilderUtils.chainExpressionsForAssociativeOp(subexprs, "and");
        this.intensionCtrEncoder.encode(expr);
        return false;
    }

    private boolean buildCtrElementAnyIndex(XVariables.XVarInteger[] list, XVariables.XVarInteger value) {
        int len = list.length;
        String[] subExprs = new String[len];
        String normValue = CtrBuilderUtils.normalizeCspVarName(value.id);
        int i = 0;
        while (i < len) {
            String normVar = CtrBuilderUtils.normalizeCspVarName(list[i].id);
            subExprs[i] = "eq(" + normVar + "," + normValue + ")";
            ++i;
        }
        String expr = CtrBuilderUtils.chainExpressionsForAssociativeOp(subExprs, "or");
        this.intensionCtrEncoder.encode(expr);
        return false;
    }

    private boolean buildCtrElementFirstIndex(XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, XVariables.XVarInteger value) {
        int i = 0;
        while (i < list.length) {
            String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
            String normValue = CtrBuilderUtils.normalizeCspVarName(value.id);
            StringBuilder sbuf = new StringBuilder();
            sbuf.append("or(ne(").append(i + startIndex).append(',').append(normIndex).append("),and(eq(").append(i + startIndex).append(',').append(normIndex).append("),eq(").append(CtrBuilderUtils.normalizeCspVarName(list[i].id)).append(',').append(normValue).append(')');
            int j = 0;
            while (j < i) {
                sbuf.append(",ne(").append(CtrBuilderUtils.normalizeCspVarName(list[j].id)).append(',').append(normValue).append(')');
                ++j;
            }
            sbuf.append("))");
            this.intensionCtrEncoder.encode(sbuf.toString());
            ++i;
        }
        return false;
    }

    private boolean buildCtrElementLastIndex(XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, XVariables.XVarInteger value) {
        int i = 0;
        while (i < list.length) {
            String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
            String normValue = CtrBuilderUtils.normalizeCspVarName(value.id);
            StringBuilder sbuf = new StringBuilder();
            sbuf.append("or(ne(").append(i + startIndex).append(',').append(normIndex).append("),and(eq(").append(i + startIndex).append(',').append(normIndex).append("),eq(").append(CtrBuilderUtils.normalizeCspVarName(list[i].id)).append(',').append(normValue).append(')');
            int j = i + 1;
            while (j < list.length) {
                sbuf.append(",ne(").append(CtrBuilderUtils.normalizeCspVarName(list[j].id)).append(',').append(normValue).append(')');
                ++j;
            }
            sbuf.append("))");
            this.intensionCtrEncoder.encode(sbuf.toString());
            ++i;
        }
        return false;
    }

    public boolean buildCtrElement(String id, int[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        if (rank == Types.TypeRank.ANY) {
            return this.buildCtrElementForceIndex(list, startIndex, index, value);
        }
        if (rank == Types.TypeRank.FIRST) {
            return this.buildCtrElementFirstIndex(list, startIndex, index, value);
        }
        if (rank == Types.TypeRank.LAST) {
            return this.buildCtrElementLastIndex(list, startIndex, index, value);
        }
        throw new IllegalArgumentException();
    }

    private boolean buildCtrElementForceIndex(int[] list, int startIndex, XVariables.XVarInteger index, XVariables.XVarInteger value) {
        int len = list.length;
        String[] subexprs = new String[list.length];
        String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
        String normValue = CtrBuilderUtils.normalizeCspVarName(value.id);
        int i = 0;
        while (i < len) {
            String lImpl = "eq(" + Integer.toString(i + startIndex) + "," + normIndex + ")";
            String rImpl = "eq(" + normValue + "," + Integer.toString(list[i]) + ")";
            subexprs[i] = "imp(" + lImpl + "," + rImpl + ")";
            ++i;
        }
        String expr = CtrBuilderUtils.chainExpressionsForAssociativeOp(subexprs, "and");
        this.intensionCtrEncoder.encode(expr);
        return false;
    }

    private boolean buildCtrElementFirstIndex(int[] list, int startIndex, XVariables.XVarInteger index, XVariables.XVarInteger value) {
        int i = 0;
        while (i < list.length) {
            String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
            String normValue = CtrBuilderUtils.normalizeCspVarName(value.id);
            StringBuilder sbuf = new StringBuilder();
            sbuf.append("or(ne(").append(i + startIndex).append(',').append(normIndex).append("),and(eq(").append(i + startIndex).append(',').append(normIndex).append("),eq(").append(Integer.toString(list[i])).append(',').append(normValue).append(')');
            int j = 0;
            while (j < i) {
                sbuf.append(",ne(").append(Integer.toString(list[j])).append(',').append(normValue).append(')');
                ++j;
            }
            sbuf.append("))");
            this.intensionCtrEncoder.encode(sbuf.toString());
            ++i;
        }
        return false;
    }

    private boolean buildCtrElementLastIndex(int[] list, int startIndex, XVariables.XVarInteger index, XVariables.XVarInteger value) {
        int i = 0;
        while (i < list.length) {
            String normIndex = CtrBuilderUtils.normalizeCspVarName(index.id);
            String normValue = CtrBuilderUtils.normalizeCspVarName(value.id);
            StringBuilder sbuf = new StringBuilder();
            sbuf.append("or(ne(").append(i + startIndex).append(',').append(normIndex).append("),and(eq(").append(i + startIndex).append(',').append(normIndex).append("),eq(").append(Integer.toString(list[i])).append(',').append(normValue).append(')');
            int j = i + 1;
            while (j < list.length) {
                sbuf.append(",ne(").append(Integer.toString(list[j])).append(',').append(normValue).append(')');
                ++j;
            }
            sbuf.append("))");
            this.intensionCtrEncoder.encode(sbuf.toString());
            ++i;
        }
        return false;
    }
}

