/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints3;

import java.util.TreeSet;
import org.sat4j.csp.constraints3.CtrBuilderUtils;
import org.sat4j.csp.intension.ICspToSatEncoder;
import org.sat4j.csp.intension.IIntensionCtrEncoder;
import org.xcsp.common.Types;
import org.xcsp.parser.entries.XVariables;

public class ComparisonCtrBuilder {
    private final IIntensionCtrEncoder intensionCtrEncoder;

    public ComparisonCtrBuilder(IIntensionCtrEncoder intensionEnc) {
        this.intensionCtrEncoder = intensionEnc;
    }

    public boolean buildCtrAllDifferent(XVariables.XVarInteger[] list) {
        ICspToSatEncoder solver = this.intensionCtrEncoder.getSolver();
        int i = 0;
        while (i < list.length - 1) {
            int[] d1 = solver.getCspVarDomain(list[i].id);
            int j = i + 1;
            while (j < list.length) {
                int[] d2 = solver.getCspVarDomain(list[j].id);
                int[] nArray = d1;
                int n = d1.length;
                int n2 = 0;
                while (n2 < n) {
                    int v1 = nArray[n2];
                    int[] nArray2 = d2;
                    int n3 = d2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int v2 = nArray2[n4];
                        if (v1 == v2) {
                            solver.addClause(new int[]{-solver.getSolverVar(list[i].id, v1), -solver.getSolverVar(list[j].id, v2)});
                        }
                        ++n4;
                    }
                    ++n2;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean buildCtrAllDifferentExcept(String id, XVariables.XVarInteger[] list, int[] except) {
        TreeSet<XVariables.XVarInteger> varSet = new TreeSet<XVariables.XVarInteger>((o1, o2) -> o1.id.compareTo(o2.id));
        int i = 0;
        while (i < list.length) {
            varSet.add(list[i]);
            ++i;
        }
        XVariables.XVarInteger[] cleanList = new XVariables.XVarInteger[varSet.size()];
        cleanList = varSet.toArray(cleanList);
        if (except.length == 0) {
            return this.buildCtrAllDifferent(cleanList);
        }
        if (cleanList.length < 2) {
            return false;
        }
        String exceptBase = "eq(X," + except[0] + ")";
        int i2 = 1;
        while (i2 < except.length) {
            exceptBase = "or(" + exceptBase + ",eq(X," + except[i2] + "))";
            ++i2;
        }
        String[] exprs = new String[cleanList.length - 1];
        int i3 = 0;
        while (i3 < cleanList.length - 1) {
            String normalizedCurVar = CtrBuilderUtils.normalizeCspVarName(cleanList[i3].id);
            String exceptExpr = exceptBase.replaceAll("X", normalizedCurVar);
            String neExpr = "ne(" + normalizedCurVar + "," + CtrBuilderUtils.normalizeCspVarName(cleanList[i3 + 1].id) + ")";
            int j = i3 + 2;
            while (j < cleanList.length) {
                neExpr = "and(" + neExpr + ",ne(" + normalizedCurVar + "," + CtrBuilderUtils.normalizeCspVarName(cleanList[j].id) + "))";
                ++j;
            }
            exprs[i3] = "or(" + exceptExpr + "," + neExpr + ")";
            ++i3;
        }
        return this.intensionCtrEncoder.encode(CtrBuilderUtils.chainExpressionsForAssociativeOp(exprs, "and"));
    }

    public boolean buildCtrAllDifferentList(String id, XVariables.XVarInteger[][] lists) {
        int i = 0;
        while (i < lists.length - 1) {
            int j = i + 1;
            while (j < lists.length) {
                StringBuilder sbufExpr = new StringBuilder();
                sbufExpr.append("or(");
                this.buildCtrAllDifferentListAux(lists, i, j, sbufExpr, 0);
                int k = 1;
                while (k < lists[i].length) {
                    sbufExpr.append(',');
                    this.buildCtrAllDifferentListAux(lists, i, j, sbufExpr, k);
                    ++k;
                }
                sbufExpr.append(')');
                if (this.intensionCtrEncoder.encode(sbufExpr.toString())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void buildCtrAllDifferentListAux(XVariables.XVarInteger[][] lists, int i, int j, StringBuilder sbufExpr, int k) {
        sbufExpr.append("ne(");
        String var1Id = lists[i][k].id;
        String normVar1 = CtrBuilderUtils.normalizeCspVarName(var1Id);
        sbufExpr.append(normVar1).append(',');
        String var2Id = lists[j][k].id;
        String normVar2 = CtrBuilderUtils.normalizeCspVarName(var2Id);
        sbufExpr.append(normVar2).append(')');
    }

    public boolean buildCtrAllDifferentMatrix(String id, XVariables.XVarInteger[][] matrix) {
        boolean contradictionFound = false;
        XVariables.XVarInteger[][] tMatrix = CtrBuilderUtils.transposeMatrix(matrix);
        int i = 0;
        while (i < matrix.length) {
            contradictionFound |= this.buildCtrAllDifferent(matrix[i]);
            ++i;
        }
        i = 0;
        while (i < tMatrix.length) {
            contradictionFound |= this.buildCtrAllDifferent(tMatrix[i]);
            ++i;
        }
        return contradictionFound;
    }

    public boolean buildCtrAllEqual(String id, XVariables.XVarInteger[] list) {
        int i = 0;
        while (i < list.length - 1) {
            String norm1 = CtrBuilderUtils.normalizeCspVarName(list[i].id);
            String norm2 = CtrBuilderUtils.normalizeCspVarName(list[i + 1].id);
            if (this.intensionCtrEncoder.encode("eq(" + norm1 + "," + norm2 + ")")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean buildCtrOrdered(String id, XVariables.XVarInteger[] list, Types.TypeOperatorRel operator) {
        int i = 0;
        while (i < list.length - 1) {
            String normalized1 = CtrBuilderUtils.normalizeCspVarName(list[i].id);
            String normalized2 = CtrBuilderUtils.normalizeCspVarName(list[i + 1].id);
            String expr = String.valueOf(operator.name().toLowerCase()) + "(" + normalized1 + "," + normalized2 + ")";
            if (this.intensionCtrEncoder.encode(expr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean buildCtrLex(String id, XVariables.XVarInteger[][] lists, Types.TypeOperatorRel operator) {
        boolean contradictionFound = false;
        int i = 0;
        while (i < lists.length - 1) {
            contradictionFound |= this.buildCtrLex(id, lists[i], lists[i + 1], operator);
            ++i;
        }
        return contradictionFound;
    }

    public boolean buildCtrLexMatrix(String id, XVariables.XVarInteger[][] matrix, Types.TypeOperatorRel operator) {
        boolean contradictionFound = false;
        contradictionFound |= this.buildCtrLex(id, matrix, operator);
        XVariables.XVarInteger[][] tMatrix = CtrBuilderUtils.transposeMatrix(matrix);
        return contradictionFound |= this.buildCtrLex(id, tMatrix, operator);
    }

    private boolean buildCtrLex(String id, XVariables.XVarInteger[] list1, XVariables.XVarInteger[] list2, Types.TypeOperatorRel operator) {
        Types.TypeOperatorRel strictOp = CtrBuilderUtils.strictTypeOperator(operator);
        String[] chains = new String[list1.length];
        String id01 = list1[0].id;
        String id02 = list2[0].id;
        chains[0] = list1.length == 1 ? String.valueOf(operator.name().toLowerCase()) + "(" + CtrBuilderUtils.normalizeCspVarName(id01) + "," + CtrBuilderUtils.normalizeCspVarName(id02) + ")" : String.valueOf(strictOp.name().toLowerCase()) + "(" + CtrBuilderUtils.normalizeCspVarName(id01) + "," + CtrBuilderUtils.normalizeCspVarName(id02) + ")";
        int i = 1;
        while (i < list1.length) {
            String eqChain = "eq(" + CtrBuilderUtils.normalizeCspVarName(id01) + "," + CtrBuilderUtils.normalizeCspVarName(id02) + ")";
            int j = 1;
            while (j < i) {
                String idj1 = list1[j].id;
                String idj2 = list2[j].id;
                eqChain = "and(" + eqChain + ",eq(" + CtrBuilderUtils.normalizeCspVarName(idj1) + "," + CtrBuilderUtils.normalizeCspVarName(idj2) + "))";
                ++j;
            }
            String idi1 = list1[i].id;
            String idi2 = list2[i].id;
            String finalMember = i == list1.length - 1 ? String.valueOf(operator.name().toLowerCase()) + "(" + CtrBuilderUtils.normalizeCspVarName(idi1) + "," + CtrBuilderUtils.normalizeCspVarName(idi2) + ")" : String.valueOf(strictOp.name().toLowerCase()) + "(" + CtrBuilderUtils.normalizeCspVarName(idi1) + "," + CtrBuilderUtils.normalizeCspVarName(idi2) + ")";
            chains[i] = "and(" + eqChain + "," + finalMember + ")";
            ++i;
        }
        return this.intensionCtrEncoder.encode(CtrBuilderUtils.chainExpressionsForAssociativeOp(chains, "or"));
    }
}

