/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints;

import org.sat4j.core.VecInt;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.csp.constraints.AllDiff;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IteratorInt;

public class AllDiffCard
extends AllDiff {
    @Override
    public void toClause(ISolver solver, IVec<Var> scope, IVec<Evaluable> vars) throws ContradictionException {
        int n = scope.size();
        Domain domain = scope.get(0).domain();
        int i = 1;
        while (i < n) {
            if (scope.get(i).domain() != domain) {
                super.toClause(solver, scope, vars);
                return;
            }
            ++i;
        }
        VecInt clause = new VecInt();
        IteratorInt it = domain.iterator();
        while (it.hasNext()) {
            int value = it.next();
            int i2 = 0;
            while (i2 < n) {
                clause.push(scope.get(i2).translate(value));
                ++i2;
            }
            solver.addAtMost(clause, 1);
            clause.clear();
        }
    }

    @Override
    public String toString() {
        return "AllDiff encoding using cardinality constraints";
    }
}

