/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints;

import org.sat4j.core.VecInt;
import org.sat4j.csp.Clausifiable;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IteratorInt;

public class AllDiff
implements Clausifiable {
    @Override
    public void toClause(ISolver solver, IVec<Var> scope, IVec<Evaluable> vars) throws ContradictionException {
        int n = scope.size();
        VecInt clause = new VecInt();
        int i = 0;
        while (i < n) {
            Var vi = scope.get(i);
            int j = i + 1;
            while (j < n) {
                Var vj = scope.get(j);
                IteratorInt iti = vi.domain().iterator();
                while (iti.hasNext()) {
                    int vali = iti.next();
                    IteratorInt itj = vj.domain().iterator();
                    while (itj.hasNext()) {
                        int valj = itj.next();
                        if (vali != valj) continue;
                        clause.push(-vi.translate(vali));
                        clause.push(-vj.translate(valj));
                        solver.addClause(clause);
                        clause.clear();
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public String toString() {
        return "AllDiff encoding using binary clauses";
    }
}

