/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.sat4j.core.ASolverFactory;
import org.sat4j.csp.CspSatSolverDecorator;
import org.sat4j.csp.ICspPBSatSolver;
import org.sat4j.minisat.constraints.MixedDataStructureDanielWL;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.pb.tools.PBAdapter;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.DimacsStringSolver;

public class SolverFactory
extends ASolverFactory<ISolver> {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    @Override
    public ICspPBSatSolver createSolverByName(String solvername) {
        try {
            Class[] paramtypes = new Class[]{};
            Method m = this.getClass().getMethod("new" + solvername, paramtypes);
            return (ICspPBSatSolver)m.invoke(null, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.err.println(e.getLocalizedMessage());
            return null;
        }
    }

    public static <L extends ILits> Solver<DataStructureFactory> newMiniSAT(DataStructureFactory dsf) {
        MiniSATLearning learning = new MiniSATLearning();
        Solver<DataStructureFactory> solver = new Solver<DataStructureFactory>(learning, dsf, new VarOrderHeap(), new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newDefault() {
        return SolverFactory.newSAT();
    }

    public static ICspPBSatSolver newSAT() {
        return new CspSatSolverDecorator(org.sat4j.pb.SolverFactory.newSAT());
    }

    public static ICspPBSatSolver newUNSAT() {
        return new CspSatSolverDecorator(org.sat4j.pb.SolverFactory.newUNSAT());
    }

    public static ICspPBSatSolver newCuttingPlanes() {
        return new CspSatSolverDecorator(org.sat4j.pb.SolverFactory.newCuttingPlanes());
    }

    @Override
    public ISolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public static ICspPBSatSolver newLight() {
        return new CspSatSolverDecorator(new PBAdapter(SolverFactory.newMiniSAT(new MixedDataStructureDanielWL())));
    }

    @Override
    public ICspPBSatSolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static ICspPBSatSolver newDimacsOutputPB() {
        CspSatSolverDecorator solver = new CspSatSolverDecorator(new PBAdapter(new DimacsStringSolver()));
        solver.setShouldOnlyDisplayEncoding(true);
        return solver;
    }
}

