/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.sat4j.core.Vec;
import org.sat4j.csp.Clausifiable;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Encoding;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.csp.encodings.BinarySupportEncoding;
import org.sat4j.csp.encodings.DirectEncoding;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

public class Predicate
implements Clausifiable {
    private String expr;
    private Encoding encoding;
    private final IVec<String> variables = new Vec<String>();
    private static Context cx = Context.enter();
    private static Scriptable scope = cx.initStandardObjects();
    private final Map<Evaluable, Integer> valuemapping = new HashMap<Evaluable, Integer>();
    private Script myscript;

    static {
        try {
            URL url = Predicate.class.getResource("predefinedfunctions.js");
            cx.evaluateReader(scope, new InputStreamReader(url.openStream()), "predefinedfunctions.js", 1, null);
        }
        catch (IOException e) {
            Logger.getLogger("org.sat4j.csp").log(Level.SEVERE, "Problem with javascript file", e);
        }
    }

    public void setExpression(String expr) {
        this.expr = expr.replaceAll("if\\(", "ite(").replaceAll("([^m])in\\(", "$1inSet(").replaceAll("^in\\(", "inSet(");
    }

    public void addVariable(String name) {
        this.variables.push(name);
    }

    public boolean containsVariable(String name) {
        int i = 0;
        while (i < this.variables.size()) {
            if (this.variables.get(i).equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean evaluate(int[] values) {
        assert (values.length == this.variables.size());
        int i = 0;
        while (i < this.variables.size()) {
            scope.put(this.variables.get(i), scope, (Object)values[i]);
            ++i;
        }
        Object result = this.myscript.exec(cx, scope);
        return Context.toBoolean(result);
    }

    @Override
    public void toClause(ISolver solver, IVec<Var> vscope, IVec<Evaluable> vars) throws ContradictionException {
        if (this.myscript == null) {
            this.myscript = cx.compileString(this.expr, "rhino.log", 1, null);
        }
        this.encoding = vscope.size() == 2 ? BinarySupportEncoding.instance() : DirectEncoding.instance();
        this.encoding.onInit(solver, vscope);
        int[] tuple = new int[vars.size()];
        this.valuemapping.clear();
        this.find(tuple, 0, vscope, vars, solver);
        this.encoding.onFinish(solver, vscope);
    }

    private void find(int[] tuple, int n, IVec<Var> theScope, IVec<Evaluable> vars, ISolver solver) throws ContradictionException {
        if (this.valuemapping.size() == theScope.size()) {
            int i = 0;
            while (i < tuple.length) {
                Evaluable ev = vars.get(i);
                Integer value = this.valuemapping.get(ev);
                tuple[i] = value == null ? ev.domain().get(0) : value.intValue();
                ++i;
            }
            if (this.evaluate(tuple)) {
                this.encoding.onSupport(solver, theScope, this.valuemapping);
            } else {
                this.encoding.onNogood(solver, theScope, this.valuemapping);
            }
        } else {
            Var var = theScope.get(n);
            Domain domain = var.domain();
            int i = 0;
            while (i < domain.size()) {
                this.valuemapping.put(var, domain.get(i));
                this.find(tuple, n + 1, theScope, vars, solver);
                ++i;
            }
            this.valuemapping.remove(var);
        }
    }
}

