/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.csp.Domain;
import org.sat4j.csp.EnumeratedDomain;
import org.sat4j.csp.RangeDomain;

public class Domains {
    private static Domains instance;
    private Map<Integer, Map<Integer, Domain>> fullDomains = new HashMap<Integer, Map<Integer, Domain>>();
    private Map<Integer, Domain> enumDomains = new HashMap<Integer, Domain>();

    private Domains() {
    }

    public static Domains getInstance() {
        if (instance == null) {
            instance = new Domains();
        }
        return instance;
    }

    public Domain getDomain(int minValue, int maxValue) {
        Domain dom;
        Map<Integer, Domain> fromMin = this.fullDomains.get(minValue);
        if (fromMin == null) {
            fromMin = new HashMap<Integer, Domain>();
            this.fullDomains.put(minValue, fromMin);
        }
        if ((dom = fromMin.get(maxValue)) == null) {
            dom = new RangeDomain(minValue, maxValue);
            fromMin.put(maxValue, dom);
        }
        return dom;
    }

    public Domain getDomain(int[] values) {
        Arrays.sort(values);
        int hashCode = Arrays.hashCode(values);
        Domain dom = this.enumDomains.get(hashCode);
        if (dom == null) {
            dom = new EnumeratedDomain(values);
            this.enumDomains.put(hashCode, dom);
        }
        return dom;
    }
}

