/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import java.io.IOException;
import java.util.Map;
import org.sat4j.AbstractLauncher;
import org.sat4j.ILauncherMode;
import org.sat4j.csp.CspSatSolverDecorator;
import org.sat4j.csp.ICspPBSatSolver;
import org.sat4j.csp.SolverFactory;
import org.sat4j.reader.ECSPFormat;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class CSPLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    private boolean shouldOnlyDisplayEncoding = false;

    public CSPLauncher() {
        if (System.getProperty("CompetitionOutput") != null) {
            this.bufferizeLog();
        }
    }

    @Override
    protected ISolver configureSolver(String[] args) {
        ICspPBSatSolver asolver = args.length == 2 ? SolverFactory.instance().createSolverByName(args[0]) : new CspSatSolverDecorator(org.sat4j.pb.SolverFactory.newDefault());
        this.log(asolver.toString("c "));
        this.shouldOnlyDisplayEncoding = asolver.shouldOnlyDisplayEncoding();
        return asolver;
    }

    @Override
    protected Reader createReader(ISolver aSolver, String problemname) {
        ECSPFormat cspFormat = ECSPFormat.inferInstanceType(problemname);
        this.out = cspFormat.decoratePrintWriter(this.shouldOnlyDisplayEncoding, this.out);
        this.flushLog();
        Reader aReader = cspFormat.getReader(this, aSolver);
        this.setLauncherMode(cspFormat.isOptimizationModeRequired() ? ILauncherMode.OPTIMIZATION : ILauncherMode.DECISION);
        if (System.getProperty("verbose") != null) {
            this.log("verbose mode on");
            aReader.setVerbosity(true);
            aSolver.setVerbose(true);
        } else {
            aSolver.setVerbose(false);
        }
        return aReader;
    }

    @Override
    protected IProblem readProblem(String problemname) throws ParseFormatException, IOException, ContradictionException {
        this.setSilent(false);
        IProblem problem = super.readProblem(problemname);
        if (this.shouldOnlyDisplayEncoding) {
            this.displayEncoding();
        }
        this.displayEncoding();
        return problem;
    }

    private void displayEncoding() {
        if (this.reader.hasAMapping()) {
            this.out.write("c CSP to SAT var mapping:\n");
            Map<Integer, String> mapping = this.reader.getMapping();
            for (Map.Entry<Integer, String> entry : mapping.entrySet()) {
                this.out.write("c " + entry.getValue() + ";" + entry.getKey() + "\n");
            }
            this.out.write("c SAT4J may mention a timeout; ignore it\n");
        }
    }

    public static void main(String[] args) {
        CSPLauncher lanceur = new CSPLauncher();
        if (args.length > 2 || args.length == 0) {
            ((AbstractLauncher)lanceur).usage();
            return;
        }
        try {
            lanceur.run(args);
        }
        catch (IllegalArgumentException e) {
            lanceur.log(">>>> " + e.getMessage() + " <<<<");
        }
    }

    @Override
    public void displayLicense() {
        super.displayLicense();
        this.log("That software uses the Rhino library from the Mozilla project.");
    }

    @Override
    public void usage() {
        System.out.println("Please provide a CSP instance file!");
    }

    @Override
    protected String getInstanceName(String[] args) {
        if (args.length == 1) {
            return args[0];
        }
        return args[1];
    }

    @Override
    protected void displayResult() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.displayResult();
    }
}

