
#define MAX_EXTRA_CLAUSES 10000
#define MAX_EXTRA_UNITS 1000
#define AIMD_A 0.125
#define AIMD_B 8
#define THROUGHPUT 0.5
#define PERIOD 10000
Cooperation::Cooperation(int n, int l, int d){
	nbThreads = n;
	limitExportClauses = l;
	solvers = new Solver [nbThreads];


        //Control-based clause sharing  
	e                        = new double *[nbThreads];
	quality                  = new double *[nbThreads];
        average_e                = new double *[nbThreads];
        nb_compute_e             = new double [nbThreads];
        a                        = AIMD_A;
        b                        = AIMD_B;
        B                        = THROUGHPUT;
        periodic_Estimate_Length = PERIOD;

	aimd                     = d;


	permitWrite        = new bool[nbThreads];
	getFromPrecedentCore = new bool[nbThreads];
	


	for(int t = 0; t < nbThreads; t++){
	  permitWrite[t]         = true;
	  getFromPrecedentCore[t]= false;
	  
	  e[t]                      = new double[nbThreads];
	  quality[t]                = new double[nbThreads];
	  average_e[t]              = new double[nbThreads];
	  
            for(int i = 0; i < nbThreads; i++){
	      nb_compute_e[t]        = 0;
	      average_e[t][i]        = 0;
	      e[t][i]                = l;
	      quality[t][i]          = 0;
            }
        }

	//units, extraUnits[send][recv][nbExtraUnits[send][recv]] = unit
	extraUnits = new Lit** [nbThreads];
	headExtraUnits = new int* [nbThreads];
	tailExtraUnits = new int* [nbThreads];
	
	for(int t = 0; t < nbThreads; t++){
	  extraUnits[t] = new Lit* [nbThreads];
	  headExtraUnits[t] = new int [nbThreads];
	  tailExtraUnits[t] = new int [nbThreads];
	  //extraUnits[t] = 0;
	  
	  for(int k = 0; k < nbThreads; k++){
	    extraUnits[t][k] = new Lit [MAX_EXTRA_UNITS];
	    headExtraUnits[t][k] = 0;
	    tailExtraUnits[t][k] = 0;
	  }
	}

	//clauses, extraClauses[send][recv][nbExtraClauses[send][recv]] = clause
	extraClauses = new Lit*** [nbThreads];
	headExtraClauses = new int* [nbThreads];
	tailExtraClauses = new int* [nbThreads];

	for(int t = 0; t < nbThreads; t++){
	  extraClauses[t] = new Lit** [nbThreads];
	  headExtraClauses[t] = new int [nbThreads];
	  tailExtraClauses[t] = new int [nbThreads];
 
	  for(int k = 0; k < nbThreads; k++){
	    extraClauses[t][k] = new Lit* [MAX_EXTRA_CLAUSES];
	    headExtraClauses[t][k] = 0;
	    tailExtraClauses[t][k] = 0;
	  }
	}

	End = false;
}


void Cooperation::exportUnit(Solver* s, Lit unit){
  int id = s->threadId;
  for(int t = 0; t < nbThreads; t++)
    if(t != id){
      int ind = tailExtraUnits[id][t];
      if(((ind+1)%MAX_EXTRA_UNITS) == headExtraUnits[id][t]){
	//printf("\n%d FULL", id);
	break;
      }
      extraUnits[id][t][ind++].x = unit.x;
      //printf("\n%d EXPORT unit.", id);

      if(ind == MAX_EXTRA_UNITS)
	ind = 0;

      tailExtraUnits[id][t] = ind;
    }
  s->nbExportedUnits++;
}

void Cooperation::importUnits(Solver* s){ 
  int id = s->threadId;

  for(int t = 0; t < nbThreads; t++)
   if(t != id){
     int head = headExtraUnits[t][id];
     int tail = tailExtraUnits[t][id];
     
     if(head == tail) break;

     int end = tail; 

     if(tail < head) end = MAX_EXTRA_UNITS;

     for(int i = head; i < end; i++)
       if(s->value(extraUnits[t][id][i]) == l_Undef)
	 s->uncheckedEnqueue(extraUnits[t][id][i]);
     
     if(tail < head)
       for(int i = 0; i < tail; i++)
	 if(s->value(extraUnits[t][id][i]) == l_Undef)
	   s->uncheckedEnqueue(extraUnits[t][id][i]);

     head = tail;
     if(head == MAX_EXTRA_UNITS) head = 0;
     headExtraUnits[t][id] = head;
   }
}

void Cooperation::exportClauseTo(Solver* s, vec<Lit>& learnt){

  int id = s->threadId;
  int t = (id +1) % nbThreads;
  
  
  int ind = tailExtraClauses[id][t];
  if(((ind+1)%MAX_EXTRA_CLAUSES) == headExtraClauses[id][t]) return;
  
  
  extraClauses[id][t][ind] = new Lit [learnt.size() + 1];
  extraClauses[id][t][ind][0] = Lit(learnt.size());
  
  for(int j = 0; j < learnt.size(); j++)
    extraClauses[id][t][ind][j + 1] = learnt[j];
  
  ind++;
  
  if(ind == MAX_EXTRA_CLAUSES) ind = 0;
  
  tailExtraClauses[id][t] = ind;
  
  s->nbExportedClauses++; 
}		      


void Cooperation::exportClause(Solver* s, vec<Lit>& learnt){

  int id = s->threadId;

  for(int t = 0; t < nbThreads; t++)
    
    if(t != id){
      if(1)/* ((id <= 3) && ((t < 4)  || (t % 4 == id))) || ((id >= 3) && (id % 4 == t))*/{
	
	if(learnt.size() <= e[id][t]){
	  int ind = tailExtraClauses[id][t];
	  if(((ind+1)%MAX_EXTRA_CLAUSES) == headExtraClauses[id][t]){
	    break;
	  }
	  
	  extraClauses[id][t][ind] = new Lit [learnt.size() + 1];
	  extraClauses[id][t][ind][0] = Lit(learnt.size());
	  
	  for(int j = 0; j < learnt.size(); j++)
	    extraClauses[id][t][ind][j + 1] = learnt[j];
	  
	  ind++;
	  
	  if(ind == MAX_EXTRA_CLAUSES) ind = 0;
	  
	  tailExtraClauses[id][t] = ind;
	}
	}	
    }

  s->nbExportedClauses++; 
}		      
	
void Cooperation::addC(Solver* s, Lit* lt, int sender){
  s->nbExp++;
  vec<Lit> l;
  int size = var(lt[0]);
  int nbactiv=0;
  for(int j = 1; j < size+1; j++){
     l.push(lt[j]);
     if((aimd >= 2) && (s->activity[var(lt[j])] > s->max_act/2))
       nbactiv++;
  }
  Clause* c2 = Clause_new(l, true, s->threadId);
  s->learnts.push(c2);
  s->attachClause(*c2);
  s->claBumpActivity(*c2);
  

  switch (aimd){
  case 1:{
    s->receivedFrom[sender]++;
  }
  case 2:{
    s->receivedFrom[sender]++;
    if(nbactiv >= (double)size/3)
      s->keepedFrom[sender]++;
  }
  }

  
  delete [] lt;
  
}		      


void Cooperation::importClauses(Solver* s){
  int id = s->threadId;
  for(int t = 0; t < nbThreads; t++)
   if(t != id){
     int head = headExtraClauses[t][id];
     int tail = tailExtraClauses[t][id];
     
     if(head != tail) {

     int end = tail; 

     if(tail < head) end = MAX_EXTRA_CLAUSES;

     for(int i = head; i < end; i++)
       addC(s, extraClauses[t][id][i], t);
     
     if(tail < head)
      for(int i = 0; i < tail; i++)
	addC(s, extraClauses[t][id][i], t);
     
     head = tail;
     if(head == MAX_EXTRA_CLAUSES) head = 0;
     headExtraClauses[t][id] = head;
   }
   }
}
void Solver::Clauses_shared_Control(Cooperation * coop){

  coop->nb_compute_e[threadId]++;
  
  int receivedFromAll = 0;
  for(int i = 0; i < coop->nbThreads;i++)
    receivedFromAll += receivedFrom[i];
  
  if((double)receivedFromAll > coop->B * nbConf)
    {
      
      for(int i = 0;i < coop->nbThreads;i++)
        if(i != threadId)
	  {
	    coop->quality[i][threadId]          = (double) 100* (keepedFrom[i]+1)/(receivedFrom[i]+1) ;
	    //double              Q               = coop->quality[i][threadId];
	    coop->e[i][threadId]               -= coop->a * coop->e[i][threadId];
	    coop->average_e[i][threadId]       +=  coop->e[i][threadId];
	  }
    }
  else
    {
      for(int i = 0;i < coop->nbThreads;i++)
        if(i != threadId)
	  {
	    coop->quality[i][threadId]          = (double) 100* (keepedFrom[i]+1)/(receivedFrom[i]+1) ;
	    //double              Q               = coop->quality[i][threadId];
	    coop->e[i][threadId]              +=   coop->b / coop->e[i][threadId];
	    coop->average_e[i][threadId]      +=  coop->e[i][threadId];
	  }
    }

  if(verbosity >= 1 && threadId == 0){
    for(int i = 0; i < coop->nbThreads;i++)
      if(i != threadId)
        printf("\t e%d%d = [%2.2f] (%2.2f %4d -- %4d)", i,threadId, coop->e[i][threadId], coop->quality[i][threadId], keepedFrom[i], receivedFrom[i]);
    printf("\n");
  }

  for(int i = 0; i < coop->nbThreads;i++)
    {receivedFrom[i] = 0;}
  
}



void Solver::Clauses_shared_Control_Q(Cooperation * coop){

  coop->nb_compute_e[threadId]++;
  
  int receivedFromAll = 0;
  for(int i = 0; i < coop->nbThreads;i++)
    if(i != threadId)
      receivedFromAll += receivedFrom[i];

  if((double)receivedFromAll > coop->B * nbConf)
    {
      
      for(int i = 0;i < coop->nbThreads;i++)
        if(i != threadId){
	  coop->quality[i][threadId]          = (double) 100* (keepedFrom[i]+1)/(receivedFrom[i]+1) ;
	  double              Q               = coop->quality[i][threadId];
	  coop->e[i][threadId]               -=   coop->a *(1 - Q/100) * coop->e[i][threadId];
	  coop->average_e[i][threadId]      +=  coop->e[i][threadId];
	}
    }
  else
    {
      for(int i = 0;i < coop->nbThreads;i++)
        if(i != threadId){
	  coop->quality[i][threadId]          = (double) 100* (keepedFrom[i]+1)/(receivedFrom[i]+1) ;
	  double              Q               = coop->quality[i][threadId];
	  coop->e[i][threadId]              +=   (Q/100)*coop->b / coop->e[i][threadId];
	  coop->average_e[i][threadId]      +=  coop->e[i][threadId];
	}
    }
  
  if(verbosity >= 1 && threadId == 0  && coop->nbThreads > 1){
    for(int i = 0; i < coop->nbThreads;i++)
      if(i != threadId)
        printf("c e%d%d = [%2.2f] (%2.2f %4d -- %4d)", i,threadId, coop->e[i][threadId], coop->quality[i][threadId], keepedFrom[i], receivedFrom[i]);
    printf("\n");
  }
  
  for(int i = 0; i < coop->nbThreads;i++)
    {receivedFrom[i] = 0;keepedFrom[i] = 0;}
}



void Cooperation::print(){
  int sumExportUnits = 0;
  int sumExportClauses = 0;
 
 for(int t = 0; t < nbThreads; t++){
    sumExportUnits += solvers[t].totNbExportedUnits;
    sumExportClauses += solvers[t].totNbExportedClauses;
  }
  printf("\nc #exported units = %d, #exported clauses (<= %d) = %d", sumExportUnits, limitExportClauses, 
	 sumExportClauses);


  double sum = 0;
  int nb     = 0;
  for(int i = 0; i < nbThreads;i++)
    {
      for(int j = 0; j < nbThreads;j++)
        if(i != j){
          //  printf("m%d%d=%2.2f    ",j,i,average_e[j][i]/nb_compute_e[i]); 
          nb++;
          sum += average_e[j][i]/nb_compute_e[i];
	  //if(nb_compute_e[i] == 0){exit(0);}
        }
      //printf("\n");
    }
  if(nb == 0) nb = 1;

  if(aimd)
    printf("\nc aimd = %d (a = %g, b = %g, period = %i, throughput = %g), e-bar = %f", aimd, a, b, periodic_Estimate_Length, B, sum/nb);


}




void Cooperation::sendCurrentInt(Solver* s, int id){

  if(solvers[id].interpretation.size() > 0) return;
  
  s->gClause.copyTo(solvers[id].interpretation);
  
   
  permitWrite[id] = false;
}
