/****************************************************************************************[Solver.C]
ManySAT1.0 -- Copyright (c) 2008-2009, based on Minisat2.0

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
associated documentation files (the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or
substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT
OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
**************************************************************************************************/

static double maxCut1 = 1200;
static double maxCut2 = 1200;

	
void Solver::NewVarBump(Lit assert_lit){
  vec<Lit> resolution;
if(decisionLevel() > 1 && reason[var(conflict_lit)] != NULL && 
	   (conflict_lit != lit_Undef) && (reason[var(assert_lit)] != NULL)){
	  
	  seen[var(conflict_lit)] = 1;
	  analyze_toclear.push(conflict_lit);
	  resolution.clear();
	  
	  resolution.push(conflict_lit);
	  varBumpActivity(var(conflict_lit));
	  
	  do {
	    Lit enCours = resolution.last();resolution.pop();
	    Clause &rEC = *(reason[var(enCours)]);
	    
	    for(int i = 1;i< rEC.size();i++) {
	      Lit aa = rEC[i];
	      if(!seen[var(aa)]) {
		analyze_toclear.push(aa);
		seen[var(aa)] = 1;
		if((reason[var(aa)]!=NULL) && (level[var(aa)] == decisionLevel())) {
		  varBumpActivity(var(aa));
		  resolution.push(aa);
		}
	      }
	    }
	  } while(resolution.size() > 0);
	  
	  
	  for(int i = 0; i < analyze_toclear.size();i++){
	    seen[var(analyze_toclear[i])] = 0;
	  }
	  analyze_toclear.clear();
	}
}




bool Solver::searchReasonFromSuccess(vec<Lit>& out_learnt,int & out_btlevel, vec<Lit>& learned) {
  
  if(trail.size()==0)  return false;
  if(decisionLevel()==0) return false;

  Lit next = ~learned[1];
  
  bool top = true;
  for(int i = 2; i< learned.size();i++){
    if(level[var(learned[i])] == out_btlevel){
      top = false;
      break;
    }
  }
  if(!top) return false;
  
  for(int i = 0; i < Graph_Lit.size(); i++){
    seen2[var(Graph_Lit[i])] = 1;
    analyze_toclear.push(Graph_Lit[i]);
  }
  

  int nbseen = 0;
  
  if(next==lit_Undef) return false;
  vec<Lit> toto;
  
  for(int j = 0; j < learned.size();j++){
    seen3[var(learned[j])] = 1;
    toto.push(learned[j]);
  }
  bool ok_f = false;
  bool ok3 = false;bool okIci = false;
  
  vec<Clause*>&  wsa  = watches[toInt(~next)];
  
  for (int z = 0;z < wsa.size();z++){
    ok3 = false;okIci = false;
    Clause& ca = *(wsa[z]);assert(ca.size() > 1);
     if(ca.size()< 25){
       okIci = true;
     }
     if(okIci) {
       ok3 = true;
       nbseen = 0;
       for(int t = 0;t < ca.size();t++) {
	 if(var(ca[t]) != var(next)){

	   if(seen2[var(ca[t])]) nbseen++;
	   
	   if((value(ca[t])!=l_False)) {
	     ok3 = false; break;
	   }
	   if(!seen2[var(ca[t])]){
	     if(level[var(ca[t])] >= level[var(next)]){
	       ok3 = false; break;
	     }
	   }
	 }
       }
       
       
       if(nbseen == 0)
	 ok3 = false;
       
       if(ok3) {
	 
	 for(int i = 0; i < out_learnt.size();i++){
	   if(!seen3[var(out_learnt[i])]){
	     varBumpActivity(var(out_learnt[i]));
	     seen3[var(out_learnt[i])] = 1;
	     toto.push(out_learnt[i]);
	   }
	 }
	 bool ok5 = true;
	 out_learnt.clear();
	 vec<Lit> resolution;
	 seen[var(learned[0])] = 1;
	 analyze_toclear.push(learned[0]);
	 
	 for(int t = 0; t < learned.size(); t++){
	   if(t!=1){
	     out_learnt.push(learned[t]);
	     seen[var(learned[t])] = 1;
	     analyze_toclear.push(learned[t]);
	   }
	 }
	 
	 for(int i = 0; i < ca.size(); i++){
	   if(!seen[var(ca[i])]){
	     if((reason[var(ca[i])] != NULL) && (level[var(ca[i])] == decisionLevel())){
	       assert(seen2[var(ca[i])]);
	       resolution.push(ca[i]);
	     }
	     else{
	       if((level[var(ca[i])] > 0) && (level[var(ca[i])] < level[var(next)])){
		 out_learnt.push(ca[i]);
		 seen[var(ca[i])] = 1;
		 analyze_toclear.push(ca[i]);
	       }
	     }
	   }
	 }
	 if(resolution.size()== 0){
	   for(int j = 0; j < analyze_toclear.size(); j++)
	     seen[var(analyze_toclear[j])] = 0;
	   
	   int  lev = 0, r0 = 1;
	   Lit qb;
	   
	   for(int k = 1; k < out_learnt.size();k++){
	     if(level[var(out_learnt[k])] > lev){
	       lev = level[var(out_learnt[k])];
	       r0 = k;
	     }
	   }
	   qb = out_learnt[1];
	   out_learnt[1] = out_learnt[r0];
	   out_learnt[r0] = qb;
	   out_btlevel = lev;
	   assert(lev < level[var(next)]);
	   ok_f = true;
	   break;
	 }
	 
	 if(resolution.size() > 0){
	   do {
	     Lit enCours = resolution.last();resolution.pop();
	     Clause &rEC = *(reason[var(enCours)]);
	     
	     for(int i = 1;i<rEC.size();i++) {
	       Lit aa = rEC[i];
	       if(!seen[var(aa)]) {
		 analyze_toclear.push(aa);
		 seen[var(aa)] = 1;
		 if( !seen2[var(aa)] || (reason[var(aa)]==NULL) || (level[var(aa)]!= decisionLevel())) {
		   
		   if(level[var(aa)] > 0)
		     out_learnt.push(aa);
		   if((level[var(aa)] ==level[var(next)]) ){
		     ok5 = false;
		   }
		 } else {
		   resolution.push(aa);
		 }
	       }
	     }
	   } while(resolution.size() > 0);
	   
	   for(int j = 0; j < analyze_toclear.size(); j++)
	     seen[var(analyze_toclear[j])] = 0;
	   
	   if(ok5){
	     int lev = 0;
	     int u = 1;
	     Lit pp;
	     
	     for(int t = 1; t < out_learnt.size(); t++){
	       if(level[var(out_learnt[t])] > lev){
		 lev =  level[var(out_learnt[t])];
		 u = t;
	       }
	     }
	     pp = out_learnt[1];
	     out_learnt[1] = out_learnt[u];
	     out_learnt[u] = pp;
	     
	     if((out_learnt.size() < (learned.size()+30)) && (lev < level[var(next)])){
	       out_btlevel = lev;
	       ok_f = true;
	       break;
	     }
	   }
	 }
	 
	 for(int j = 0; j < analyze_toclear.size(); j++)
	   seen[var(analyze_toclear[j])] = 0;
       }
     }
  }
  for(int j = 0; j < toto.size();j++)
    seen3[var(toto[j])] = 0;
  
  for(int j = 0; j < analyze_toclear.size(); j++){
    seen2[var(analyze_toclear[j])] = 0;
    seen[var(analyze_toclear[j])] = 0;
  }
  analyze_toclear.clear();
  return ok_f;  
}





void Solver::init(){
  
  backT         = new double[2];
  treeWidth     = new double[2];
  backT    [1]  = 0;
  backT    [0]  = 0;
  treeWidth[1]  = 0;
  treeWidth[0]  = 0;
  nbstFix       = 30;
  nbst          = 0;
  tottreeWidth  = 0;
  totbackT      = 0;

}

double abs(double x, double y){
  if(x < y) return y;
  return x;
}


void Solver::ChooseRestart(int conflictC){

  switch (threadId)
    {
    case 2 : {
      return;
    }
    default :
      {
	
	treeWidth [1] = (double)tottreeWidth/conflictC;
	backT     [1] = (double)totbackT    /conflictC;
	
	treeWidth[0] = treeWidth[0] > 0 ? treeWidth[0] : treeWidth[1];
	backT    [0] = backT    [0] > 0 ? backT    [0] : backT[1]    ;
	
	double diff = backT[1] - backT[0];
	
	if(abs(diff) < 0.7)
	  nbst++;
	if(nbst >= nbstFix){
	  reduceDB();
	  nbst = 0;
	  nbstFix  = (int)(1.2*nbstFix); 
	  
	  for(int i = 0;i < nVars();i++) activity[i] = 0;
	  
	}
      }
    }
  
  switch(threadId) 
    {
    case 0 :{
      if(backT[1] > backT[0])
	restart_inc = maxCut1/backT[1]*cos(1-backT[0]/backT[1]);
      else
	restart_inc = maxCut2/backT[1]*cos(1-backT[1]/backT[0]); 
      break;
    }
    case 1 : {
      if(backT[1] > backT[0])
	restart_inc = maxCut1/backT[1]*cos(1+backT[0]/backT[1]);
      else
	restart_inc = maxCut2/backT[1]*cos(1+backT[1]/backT[0]);
      break;
    }
    case 3 : {
      if(backT[1] > backT[0])
	restart_inc = maxCut1/backT[1]*cos(1-backT[0]/backT[1]);
      else
	restart_inc = maxCut2/backT[1]*cos(1-backT[1]/backT[0]); 
      break;
    }
    }
  
  backT    [0] = backT    [1];
  treeWidth[0] = treeWidth[1];
  tottreeWidth = 0; 
  totbackT     = 0;
  
  if(restart_inc < 0) restart_inc = -restart_inc;
  
  }


//Luby

int get_luby(int i, int luby_unit)
{ 
  if(i==1){return luby_unit;}  
  double k = log((double)i+1)/log(2.0);
  
  if(k==round(k)){
    return (int)(pow(2,k-1))*luby_unit;
  }else{
    k = (int)floor(k);
    return get_luby(i-(int)pow(2,k)+1, luby_unit);
  }
}
